/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestQueueMappings {
    private static final Logger LOG = LoggerFactory.getLogger(TestQueueMappings.class);
    private static final String Q1 = "q1";
    private static final String Q2 = "q2";
    private static final String Q1_PATH = "root.q1";
    private static final String Q2_PATH = "root.q2";
    private static final QueuePath ROOT = new QueuePath("root");
    private static final QueuePath Q1_QUEUE_PATH = new QueuePath("root.q1");
    private static final QueuePath Q2_QUEUE_PATH = new QueuePath("root.q2");
    private CapacityScheduler cs;
    private YarnConfiguration conf;

    @Before
    public void setup() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs = new CapacityScheduler();
        RMContext rmContext = TestUtils.getMockRMContext();
        this.cs.setConf((Configuration)this.conf);
        this.cs.setRMContext(rmContext);
        this.cs.init((Configuration)this.conf);
        this.cs.start();
    }

    @After
    public void tearDown() {
        if (this.cs != null) {
            this.cs.stop();
        }
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{Q1, Q2});
        conf.setCapacity(Q1_QUEUE_PATH, 10.0f);
        conf.setCapacity(Q2_QUEUE_PATH, 90.0f);
        LOG.info("Setup top-level queues q1 and q2");
    }

    @Test
    public void testQueueMappingSpecifyingNotExistedQueue() {
        this.conf.set("yarn.scheduler.capacity.queue-mappings", "u:user:non_existent_queue");
        boolean fail = false;
        try {
            this.cs.reinitialize((Configuration)this.conf, null);
        }
        catch (IOException ioex) {
            fail = true;
        }
        Assert.assertTrue((String)"queue initialization failed for non-existent q", (boolean)fail);
    }

    @Test
    public void testQueueMappingTrimSpaces() throws IOException {
        this.conf.set("yarn.scheduler.capacity.queue-mappings", "    u : a : q1");
        this.cs.reinitialize((Configuration)this.conf, null);
        List rules = this.cs.getConfiguration().getMappingRules();
        String ruleStr = ((MappingRule)rules.get(0)).toString();
        assert (ruleStr.contains("variable='%user'"));
        assert (ruleStr.contains("value='a'"));
        assert (ruleStr.contains("queueName='q1'"));
    }

    @Test
    public void testQueueMappingPathParsing() {
        QueueMapping leafOnly = QueueMapping.QueueMappingBuilder.create().parsePathString("leaf").build();
        Assert.assertEquals((Object)"leaf", (Object)leafOnly.getQueue());
        Assert.assertEquals(null, (Object)leafOnly.getParentQueue());
        Assert.assertEquals((Object)"leaf", (Object)leafOnly.getFullPath());
        QueueMapping twoLevels = QueueMapping.QueueMappingBuilder.create().parsePathString("root.leaf").build();
        Assert.assertEquals((Object)"leaf", (Object)twoLevels.getQueue());
        Assert.assertEquals((Object)"root", (Object)twoLevels.getParentQueue());
        Assert.assertEquals((Object)"root.leaf", (Object)twoLevels.getFullPath());
        QueueMapping deep = QueueMapping.QueueMappingBuilder.create().parsePathString("root.a.b.c.d.e.leaf").build();
        Assert.assertEquals((Object)"leaf", (Object)deep.getQueue());
        Assert.assertEquals((Object)"root.a.b.c.d.e", (Object)deep.getParentQueue());
        Assert.assertEquals((Object)"root.a.b.c.d.e.leaf", (Object)deep.getFullPath());
    }

    @Test(timeout=60000L)
    public void testQueueMappingParsingInvalidCases() throws Exception {
        this.checkInvalidQMapping(this.conf, this.cs, "x:a:b", "invalid specifier");
        this.checkInvalidQMapping(this.conf, this.cs, "u:a", "no queue specified");
        this.checkInvalidQMapping(this.conf, this.cs, "g:a", "no queue specified");
        this.checkInvalidQMapping(this.conf, this.cs, "u:a:b,g:a", "multiple mappings with invalid mapping");
        this.checkInvalidQMapping(this.conf, this.cs, "u:a:b,g:a:d:e", "too many path segments");
        this.checkInvalidQMapping(this.conf, this.cs, "u::", "empty source and queue");
        this.checkInvalidQMapping(this.conf, this.cs, "u:", "missing source missing queue");
        this.checkInvalidQMapping(this.conf, this.cs, "u:a:", "empty source missing q");
    }

    private void checkInvalidQMapping(YarnConfiguration conf, CapacityScheduler cs, String mapping, String reason) throws IOException {
        boolean fail = false;
        try {
            conf.set("yarn.scheduler.capacity.queue-mappings", mapping);
            cs.reinitialize((Configuration)conf, null);
        }
        catch (IOException ex) {
            fail = true;
        }
        Assert.assertTrue((String)("invalid mapping did not throw exception for " + reason), (boolean)fail);
    }
}

