/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.CustomResourceTypesConfigurationProvider;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContainerAllocation {
    private static final Logger LOG = LoggerFactory.getLogger(TestContainerAllocation.class);
    public static final String DEFAULT_PATH = "root.default";
    public static final String A_PATH = "root.a";
    public static final String B_PATH = "root.b";
    public static final String C_PATH = "root.c";
    public static final String C1_PATH = "root.c.c1";
    public static final String C2_PATH = "root.c.c2";
    private static final QueuePath ROOT = new QueuePath("root");
    private static final QueuePath DEFAULT = new QueuePath("root.default");
    private static final QueuePath A = new QueuePath("root.a");
    private static final QueuePath B = new QueuePath("root.b");
    private static final QueuePath C = new QueuePath("root.c");
    private static final QueuePath C1 = new QueuePath("root.c.c1");
    private static final QueuePath C2 = new QueuePath("root.c.c2");
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;
    private volatile int numRetries = 0;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @Test(timeout=60000L)
    public void testExcessReservationThanNodeManagerCapacity() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 2048, 4);
        MockNM nm2 = rm.registerNode("127.0.0.1:2234", 3072, 4);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        int waitCount = 20;
        int size = rm.getRMContext().getRMNodes().size();
        while ((size = rm.getRMContext().getRMNodes().size()) != 2 && waitCount-- > 0) {
            LOG.info("Waiting for node managers to register : " + size);
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)rm.getRMContext().getRMNodes().size());
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(128L, rm);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        LOG.info("sending container requests ");
        am1.addRequests(new String[]{"*"}, 2048, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        int waitCounter = 20;
        LOG.info("heartbeating nm1");
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info("Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info("received container : " + alloc1Response.getAllocatedContainers().size());
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
        LOG.info("heartbeating nm2");
        waitCounter = 20;
        nm2.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info("Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info("received container : " + alloc1Response.getAllocatedContainers().size());
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 1 ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testContainerTokenGeneratedOnPullRequest() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        RMContainer container = rm1.getResourceScheduler().getRMContainer(containerId2);
        Assert.assertEquals((Object)containerId2, (Object)container.getContainerId());
        Assert.assertNull((Object)container.getContainer().getContainerToken());
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((Object)containerId2, (Object)((Container)containers.get(0)).getId());
        Assert.assertNotNull((Object)((Container)containers.get(0)).getContainerToken());
        rm1.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalContainerAllocationWhenDNSUnavailable() throws Exception {
        List containers;
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        try {
            containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            Assert.assertEquals((long)0L, (long)containers.size());
        }
        finally {
            SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        }
        containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)containers.size());
        rm1.stop();
    }

    @Test
    public void testLogAggregationContextPassedIntoContainerToken() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        MockNM nm2 = rm1.registerNode("127.0.0.1:2345", 8000);
        Assert.assertNull((Object)this.getLogAggregationContextFromContainerToken(rm1, nm1, null));
        LogAggregationContext logAggregationContext = LogAggregationContext.newInstance((String)"includePattern", (String)"excludePattern", (String)"rolledLogsIncludePattern", (String)"rolledLogsExcludePattern", (String)"policyClass", (String)"policyParameters");
        LogAggregationContext returned = this.getLogAggregationContextFromContainerToken(rm1, nm2, logAggregationContext);
        Assert.assertEquals((Object)"includePattern", (Object)returned.getIncludePattern());
        Assert.assertEquals((Object)"excludePattern", (Object)returned.getExcludePattern());
        Assert.assertEquals((Object)"rolledLogsIncludePattern", (Object)returned.getRolledLogsIncludePattern());
        Assert.assertEquals((Object)"rolledLogsExcludePattern", (Object)returned.getRolledLogsExcludePattern());
        Assert.assertEquals((Object)"policyClass", (Object)returned.getLogAggregationPolicyClassName());
        Assert.assertEquals((Object)"policyParameters", (Object)returned.getLogAggregationPolicyParameters());
        rm1.stop();
    }

    private LogAggregationContext getLogAggregationContextFromContainerToken(MockRM rm1, MockNM nm1, LogAggregationContext logAggregationContext) throws Exception {
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withLogAggregationContext(logAggregationContext).build());
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        nm1.nodeHeartbeat(true);
        am2.allocate("127.0.0.1", 512, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED);
        List containers = am2.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((Object)containerId, (Object)((Container)containers.get(0)).getId());
        Assert.assertNotNull((Object)((Container)containers.get(0)).getContainerToken());
        ContainerTokenIdentifier token = BuilderUtils.newContainerTokenIdentifier((Token)((Container)containers.get(0)).getContainerToken());
        return token.getLogAggregationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAMContainerAllocationWhenDNSUnavailable() throws Exception {
        RMApp app1;
        MockRM rm1 = new MockRM((Configuration)this.conf){

            protected RMSecretManagerService createRMSecretManagerService() {
                return new TestRMSecretManagerService((Configuration)TestContainerAllocation.this.conf, this.rmContext);
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        try {
            SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
            app1 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
            RMAppAttempt attempt = app1.getCurrentAppAttempt();
            nm1.nodeHeartbeat(true);
            while (this.numRetries <= 5) {
                nm1.nodeHeartbeat(true);
                Thread.sleep(1000L);
                Assert.assertEquals((Object)RMAppAttemptState.SCHEDULED, (Object)attempt.getAppAttemptState());
                System.out.println("Waiting for am container to be allocated.");
            }
        }
        finally {
            SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        }
        MockRM.launchAndRegisterAM(app1, rm1, nm1);
        rm1.stop();
    }

    @Test(timeout=60000L)
    public void testExcessReservationWillBeUnreserved() throws Exception {
        MockRM rm1 = new MockRM();
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        am2.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("default");
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertTrue((schedulerApp2.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getNode(nm1.getNodeId()).getUnallocatedResource().getMemorySize());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)10240L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)4096L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)4096L, (long)leafQueue.getQueueResourceUsage().getReserved().getMemorySize());
        am2.allocate("*", 4096, 0, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertTrue((schedulerApp2.getReservedContainers().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getNode(nm1.getNodeId()).getUnallocatedResource().getMemorySize());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)6144L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved().getMemorySize());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testAllocationForReservedContainer() throws Exception {
        MockRM rm1 = new MockRM();
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        am2.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("default");
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertTrue((schedulerApp2.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getNode(nm1.getNodeId()).getUnallocatedResource().getMemorySize());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)10240L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)4096L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)4096L, (long)leafQueue.getQueueResourceUsage().getReserved().getMemorySize());
        for (RMContainer container : schedulerApp1.getLiveContainers()) {
            if (container.isAMContainer()) continue;
            cs.markContainerForKillable(container);
        }
        am1.allocate("*", 4096, 0, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertFalse((schedulerApp2.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getNode(nm1.getNodeId()).getUnallocatedResource().getMemorySize());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)6144L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved().getMemorySize());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testReservedContainerMetricsOnDecommisionedNode() throws Exception {
        MockRM rm1 = new MockRM();
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        am2.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("default");
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertTrue((schedulerApp2.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getNode(nm1.getNodeId()).getUnallocatedResource().getMemorySize());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)10240L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)4096L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)4096L, (long)leafQueue.getQueueResourceUsage().getReserved().getMemorySize());
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(rmNode1));
        Assert.assertEquals((long)0L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertFalse((schedulerApp2.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved().getMemorySize());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testAssignMultipleOffswitchContainers() throws Exception {
        MockRM rm1 = new MockRM();
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 81920);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        CapacitySchedulerConfiguration newCSConf = new CapacitySchedulerConfiguration();
        newCSConf.setInt("yarn.scheduler.capacity.per-node-heartbeat.maximum-offswitch-assignments", 3);
        cs.reinitialize((Configuration)newCSConf, rm1.getRMContext());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)5L, (long)schedulerApp1.getLiveContainers().size());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testContinuousReservationLookingWhenUsedEqualsMax() throws Exception {
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setMaximumCapacity(A, 10.0f);
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 92160);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 4096, 2, null);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)schedulerApp1.getReservedContainers().size());
        rm1.close();
    }

    @Test
    public void testPendingResourcesConsideringUserLimit() throws Exception {
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        newConf.setUserLimitFactor(DEFAULT, 0.5f);
        newConf.setMaximumAMResourcePercentPerPartition(DEFAULT, "", 1.0f);
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("u1").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(4096L, rm1).withAppName("app").withUser("u2").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 3072, 1, null);
        am2.allocate("*", 5120, 4, null);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        Assert.assertEquals((long)2048L, (long)schedulerApp1.getAppAttemptResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)3072L, (long)schedulerApp1.getAppAttemptResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)3072L, (long)schedulerApp1.getAppAttemptResourceUsage().getPending().getMemorySize());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)4096L, (long)schedulerApp2.getAppAttemptResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)schedulerApp2.getAppAttemptResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)20480L, (long)schedulerApp2.getAppAttemptResourceUsage().getPending().getMemorySize());
        LeafQueue lq = (LeafQueue)cs.getQueue("default");
        Assert.assertEquals((long)7168L, (long)lq.getTotalPendingResourcesConsideringUserLimit(Resources.createResource((int)20480), "", false).getMemorySize());
        Assert.assertEquals((long)4096L, (long)lq.getTotalPendingResourcesConsideringUserLimit(Resources.createResource((int)20480), "", true).getMemorySize());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testQueuePriorityOrdering() throws Exception {
        int i;
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setQueueOrderingPolicy(ROOT, "priority-utilization");
        newConf.setMaximumCapacity(A, 20.0f);
        newConf.setQueuePriority(C, 1);
        newConf.setQueuePriority(B, 2);
        newConf.setQueuePriority(A, 3);
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 102400);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        am1.allocate("*", 5120, 10, null);
        am2.allocate("*", 5120, 10, null);
        am3.allocate("*", 5120, 10, null);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp3 = cs.getApplicationAttempt(am3.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp3.getLiveContainers().size());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp3.getLiveContainers().size());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp3.getLiveContainers().size());
        for (i = 0; i < 3; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)5L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp3.getLiveContainers().size());
        for (i = 0; i < 10; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)5L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)11L, (long)schedulerApp3.getLiveContainers().size());
        for (i = 0; i < 20; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)4L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)6L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)11L, (long)schedulerApp3.getLiveContainers().size());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testUserLimitAllocationMultipleContainers() throws Exception {
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.set("yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments", "-1");
        newConf.setUserLimit(C, 50.0f);
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 1024000);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user1").withAcls(null).withQueue("c").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app").withUser("user2").withAcls(null).withQueue("c").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 5120, 1000, null);
        am1.allocate("h1", 5120, 1000, null);
        am1.allocate("/default-rack", 5120, 1000, null);
        am2.allocate("*", 5120, 1000, null);
        am2.allocate("h1", 5120, 1000, null);
        am2.allocate("/default-rack", 5120, 1000, null);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)101L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)100L, (long)schedulerApp2.getLiveContainers().size());
        rm1.close();
    }

    @Test
    public void testActiveUsersWithOnlyPendingApps() throws Exception {
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        newConf.setMaximumAMResourcePercentPerPartition(DEFAULT, "", 0.2f);
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("u1").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data3);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("u2").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("u3").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("u4").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app4 = MockRMAppSubmitter.submit(rm1, data);
        am1.allocate("*", 1024, 50, null);
        am2.allocate("*", 1024, 50, null);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        for (int i = 0; i < 10; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
            Thread.sleep(1000L);
        }
        LeafQueue lq = (LeafQueue)cs.getQueue("default");
        UsersManager um = (UsersManager)lq.getAbstractUsersManager();
        Assert.assertEquals((long)4L, (long)um.getNumActiveUsers());
        Assert.assertEquals((long)2L, (long)um.getNumActiveUsersWithOnlyPendingApps());
        Assert.assertEquals((long)2L, (long)lq.getMetrics().getAppsPending());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testUnreserveWhenClusterResourceHasEmptyResourceType() throws Exception {
        CustomResourceTypesConfigurationProvider.initResourceTypes((String[])new String[]{"resource1"});
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        newConf.setBoolean("yarn.test.reset-resource-types", false);
        newConf.setMaximumCapacity(A, 50.0f);
        MockRM rm1 = new MockRM((Configuration)newConf);
        NullRMNodeLabelsManager nodeLabelsManager = new NullRMNodeLabelsManager();
        nodeLabelsManager.init((Configuration)newConf);
        rm1.getRMContext().setNodeLabelManager((RMNodeLabelsManager)nodeLabelsManager);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 7168, 2, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)schedulerApp1.getReservedContainers().size());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testAllocationCannotBeBlockedWhenFormerQueueReachedItsLimit() throws Exception {
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setQueues(C, new String[]{"c1", "c2"});
        newConf.setCapacity(C1, 10.0f);
        newConf.setMaximumCapacity(C1, 10.0f);
        newConf.setCapacity(C2, 90.0f);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        MockRM rm1 = new MockRM((Configuration)newConf);
        NullRMNodeLabelsManager nodeLabelsManager = new NullRMNodeLabelsManager();
        nodeLabelsManager.init((Configuration)newConf);
        rm1.getRMContext().setNodeLabelManager((RMNodeLabelsManager)nodeLabelsManager);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 2048, 1, new ArrayList<ContainerId>());
        am2.allocate("*", 2048, 1, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        rm1.drainEvents();
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)schedulerApp2.getLiveContainers().size());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testContainerRejectionWhenAskBeyondDynamicMax() throws Exception {
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        newConf.set(QueuePrefixes.getQueuePrefix((QueuePath)A) + "maximum-allocation-mb", "4096");
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.start();
        boolean submitFailed = false;
        MockNM nm1 = rm1.registerNode("h1:1234", 2048, 1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        try {
            am1.allocate("*", 5120, 1, null);
        }
        catch (InvalidResourceRequestException e) {
            submitFailed = true;
        }
        Assert.assertTrue((boolean)submitFailed);
        am1.allocate("*", 4096, 1, null);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        cs.getNodeTracker().setForceConfiguredMaxAllocation(false);
        rm1.registerNode("h2:1234", 3072, 1);
        submitFailed = false;
        try {
            am1.allocate("*", 4096, 1, null);
        }
        catch (InvalidResourceRequestException e) {
            submitFailed = true;
        }
        Assert.assertTrue((boolean)submitFailed);
        am1.allocate("*", 3072, 1, null);
        rm1.close();
    }

    private class TestRMSecretManagerService
    extends RMSecretManagerService {
        public TestRMSecretManagerService(Configuration conf, RMContextImpl rmContext) {
            super(conf, rmContext);
        }

        protected RMContainerTokenSecretManager createContainerTokenSecretManager(Configuration conf) {
            return new RMContainerTokenSecretManager(conf){

                public Token createContainerToken(ContainerId containerId, int containerVersion, NodeId nodeId, String appSubmitter, Resource capability, Priority priority2, long createTime, LogAggregationContext logAggregationContext, String nodeLabelExp, ContainerType containerType, ExecutionType executionType, long allocationRequestId, Set<String> allocationTags) {
                    ++TestContainerAllocation.this.numRetries;
                    return super.createContainerToken(containerId, containerVersion, nodeId, appSubmitter, capability, priority2, createTime, logAggregationContext, nodeLabelExp, containerType, executionType, allocationRequestId, allocationTags);
                }
            };
        }
    }
}

