/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueHelpers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.WorkflowPriorityMappingsManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacitySchedulerWorkflowPriorityMapping {
    private MockRM mockRM = null;

    @After
    public void tearDown() {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
    }

    private static void setWorkFlowPriorityMappings(CapacitySchedulerConfiguration conf) {
        conf.setQueues(CapacitySchedulerQueueHelpers.ROOT, new String[]{"a", "b"});
        conf.setCapacity(CapacitySchedulerQueueHelpers.A, 10.5f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.B, 89.5f);
        conf.setQueues(CapacitySchedulerQueueHelpers.A, new String[]{"a1", "a2"});
        conf.setCapacity(CapacitySchedulerQueueHelpers.A1, 30.0f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.A2, 70.0f);
        conf.setQueues(CapacitySchedulerQueueHelpers.B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(CapacitySchedulerQueueHelpers.B1, 79.2f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.B2, 0.8f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.B3, 20.0f);
        List<WorkflowPriorityMappingsManager.WorkflowPriorityMapping> mappings = Arrays.asList(new WorkflowPriorityMappingsManager.WorkflowPriorityMapping("workflow1", CapacitySchedulerQueueHelpers.B.getFullPath(), Priority.newInstance((int)2)), new WorkflowPriorityMappingsManager.WorkflowPriorityMapping("workflow2", CapacitySchedulerQueueHelpers.A1.getFullPath(), Priority.newInstance((int)3)), new WorkflowPriorityMappingsManager.WorkflowPriorityMapping("Workflow3", CapacitySchedulerQueueHelpers.A.getFullPath(), Priority.newInstance((int)4)));
        conf.setWorkflowPriorityMappings(mappings);
    }

    @Test
    public void testWorkflowPriorityMappings() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.scheduler.capacity.workflow-priority-mappings-override.enable", true);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        TestCapacitySchedulerWorkflowPriorityMapping.setWorkFlowPriorityMappings(conf);
        this.mockRM = new MockRM((Configuration)conf);
        CapacityScheduler cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.mockRM.start();
        cs.start();
        ImmutableMap expected = ImmutableMap.of((Object)CapacitySchedulerQueueHelpers.A.getFullPath(), (Object)ImmutableMap.of((Object)"workflow3", (Object)Priority.newInstance((int)4)), (Object)CapacitySchedulerQueueHelpers.B.getFullPath(), (Object)ImmutableMap.of((Object)"workflow1", (Object)Priority.newInstance((int)2)), (Object)CapacitySchedulerQueueHelpers.A1.getFullPath(), (Object)ImmutableMap.of((Object)"workflow2", (Object)Priority.newInstance((int)3)));
        Assert.assertEquals((Object)expected, (Object)cs.getWorkflowPriorityMappingsManager().getWorkflowPriorityMappings());
        MockRMAppSubmitter.submit(this.mockRM, MockRMAppSubmissionData.Builder.createWithMemory(1L, this.mockRM).withQueue("a2").withApplicationId(ApplicationId.newInstance((long)0L, (int)1)).withAppPriority(Priority.newInstance((int)0)).withApplicationTags((Set<String>)ImmutableSet.of((Object)"workflowid:workflow3")).build());
        RMApp app = (RMApp)this.mockRM.getRMContext().getRMApps().get(ApplicationId.newInstance((long)0L, (int)1));
        Assert.assertEquals((long)4L, (long)app.getApplicationSubmissionContext().getPriority().getPriority());
        MockRMAppSubmitter.submit(this.mockRM, MockRMAppSubmissionData.Builder.createWithMemory(1L, this.mockRM).withQueue("a1").withApplicationId(ApplicationId.newInstance((long)0L, (int)2)).withAppPriority(Priority.newInstance((int)6)).withApplicationTags((Set<String>)ImmutableSet.of((Object)"workflowid:workflow1")).build());
        app = (RMApp)this.mockRM.getRMContext().getRMApps().get(ApplicationId.newInstance((long)0L, (int)2));
        Assert.assertEquals((long)6L, (long)app.getApplicationSubmissionContext().getPriority().getPriority());
        MockRMAppSubmitter.submit(this.mockRM, MockRMAppSubmissionData.Builder.createWithMemory(1L, this.mockRM).withQueue("a1").withApplicationId(ApplicationId.newInstance((long)0L, (int)3)).withAppPriority(Priority.newInstance((int)0)).withApplicationTags((Set<String>)ImmutableSet.of((Object)"workflowid:workflow2")).build());
        app = (RMApp)this.mockRM.getRMContext().getRMApps().get(ApplicationId.newInstance((long)0L, (int)3));
        Assert.assertEquals((long)3L, (long)app.getApplicationSubmissionContext().getPriority().getPriority());
        MockRMAppSubmitter.submit(this.mockRM, MockRMAppSubmissionData.Builder.createWithMemory(1L, this.mockRM).withQueue("b3").withApplicationId(ApplicationId.newInstance((long)0L, (int)4)).withAppPriority(Priority.newInstance((int)0)).withApplicationTags((Set<String>)ImmutableSet.of((Object)"workflowid:workflow1")).build());
        app = (RMApp)this.mockRM.getRMContext().getRMApps().get(ApplicationId.newInstance((long)0L, (int)4));
        Assert.assertEquals((long)2L, (long)app.getApplicationSubmissionContext().getPriority().getPriority());
        conf.setBoolean("yarn.scheduler.capacity.workflow-priority-mappings-override.enable", false);
        cs.reinitialize((Configuration)conf, this.mockRM.getRMContext());
        MockRMAppSubmitter.submit(this.mockRM, MockRMAppSubmissionData.Builder.createWithMemory(1L, this.mockRM).withQueue("a2").withApplicationId(ApplicationId.newInstance((long)0L, (int)5)).withAppPriority(Priority.newInstance((int)0)).withApplicationTags((Set<String>)ImmutableSet.of((Object)"workflowid:workflow3")).build());
        app = (RMApp)this.mockRM.getRMContext().getRMApps().get(ApplicationId.newInstance((long)0L, (int)5));
        Assert.assertEquals((long)0L, (long)app.getApplicationSubmissionContext().getPriority().getPriority());
    }
}

