/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCapacitySchedulerWeightMode {
    private static final String DEFAULT_PATH = "root.default";
    private static final String A_PATH = "root.a";
    private static final String B_PATH = "root.b";
    private static final String A1_PATH = "root.a.a1";
    private static final String B1_PATH = "root.b.b1";
    private static final String B2_PATH = "root.b.b2";
    private static final QueuePath ROOT = new QueuePath("root");
    private static final QueuePath DEFAULT = new QueuePath("root.default");
    private static final QueuePath A = new QueuePath("root.a");
    private static final QueuePath B = new QueuePath("root.b");
    private static final QueuePath A1 = new QueuePath("root.a.a1");
    private static final QueuePath B1 = new QueuePath("root.b.b1");
    private static final QueuePath B2 = new QueuePath("root.b.b2");
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    public static <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    public static CapacitySchedulerConfiguration getConfigWithInheritedAccessibleNodeLabel(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues(ROOT, new String[]{"a"});
        conf.setCapacityByLabel(A, "", 100.0f);
        conf.setCapacityByLabel(A, "newLabel", 100.0f);
        conf.setAccessibleNodeLabels(A, TestCapacitySchedulerWeightMode.toSet("newLabel"));
        conf.setAllowZeroCapacitySum(A, true);
        conf.setQueues(A, new String[]{"a1"});
        conf.setCapacityByLabel(A1, "", 100.0f);
        return conf;
    }

    public static Configuration getCSConfWithQueueLabelsWeightOnly(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setLabeledQueueWeight(ROOT, "x", 100.0f);
        conf.setLabeledQueueWeight(ROOT, "y", 100.0f);
        conf.setLabeledQueueWeight(ROOT, "z", 100.0f);
        conf.setLabeledQueueWeight(A, "", 1.0f);
        conf.setMaximumCapacity(A, 10.0f);
        conf.setAccessibleNodeLabels(A, TestCapacitySchedulerWeightMode.toSet("x", "y"));
        conf.setLabeledQueueWeight(A, "x", 100.0f);
        conf.setLabeledQueueWeight(A, "y", 50.0f);
        conf.setLabeledQueueWeight(B, "", 9.0f);
        conf.setMaximumCapacity(B, 100.0f);
        conf.setAccessibleNodeLabels(B, TestCapacitySchedulerWeightMode.toSet("y", "z"));
        conf.setLabeledQueueWeight(B, "y", 50.0f);
        conf.setLabeledQueueWeight(B, "z", 100.0f);
        conf.setQueues(A, new String[]{"a1"});
        conf.setLabeledQueueWeight(A1, "", 100.0f);
        conf.setMaximumCapacity(A1, 100.0f);
        conf.setAccessibleNodeLabels(A1, TestCapacitySchedulerWeightMode.toSet("x", "y"));
        conf.setDefaultNodeLabelExpression(A1, "x");
        conf.setLabeledQueueWeight(A1, "x", 100.0f);
        conf.setLabeledQueueWeight(A1, "y", 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2"});
        conf.setLabeledQueueWeight(B1, "", 50.0f);
        conf.setMaximumCapacity(B1, 50.0f);
        conf.setAccessibleNodeLabels(B1, RMNodeLabelsManager.EMPTY_STRING_SET);
        conf.setLabeledQueueWeight(B2, "", 50.0f);
        conf.setMaximumCapacity(B2, 50.0f);
        conf.setAccessibleNodeLabels(B2, TestCapacitySchedulerWeightMode.toSet("y", "z"));
        conf.setLabeledQueueWeight(B2, "y", 100.0f);
        conf.setLabeledQueueWeight(B2, "z", 100.0f);
        return conf;
    }

    public static Configuration getCSConfWithLabelsParentUseWeightChildUsePct(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setLabeledQueueWeight(ROOT, "x", 100.0f);
        conf.setLabeledQueueWeight(ROOT, "y", 100.0f);
        conf.setLabeledQueueWeight(ROOT, "z", 100.0f);
        conf.setLabeledQueueWeight(A, "", 1.0f);
        conf.setMaximumCapacity(A, 10.0f);
        conf.setAccessibleNodeLabels(A, TestCapacitySchedulerWeightMode.toSet("x", "y"));
        conf.setLabeledQueueWeight(A, "x", 100.0f);
        conf.setLabeledQueueWeight(A, "y", 50.0f);
        conf.setLabeledQueueWeight(B, "", 9.0f);
        conf.setMaximumCapacity(B, 100.0f);
        conf.setAccessibleNodeLabels(B, TestCapacitySchedulerWeightMode.toSet("y", "z"));
        conf.setLabeledQueueWeight(B, "y", 50.0f);
        conf.setLabeledQueueWeight(B, "z", 100.0f);
        conf.setQueues(A, new String[]{"a1"});
        conf.setCapacityByLabel(A1, "", 100.0f);
        conf.setMaximumCapacity(A1, 100.0f);
        conf.setAccessibleNodeLabels(A1, TestCapacitySchedulerWeightMode.toSet("x", "y"));
        conf.setDefaultNodeLabelExpression(A1, "x");
        conf.setCapacityByLabel(A1, "x", 100.0f);
        conf.setCapacityByLabel(A1, "y", 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2"});
        conf.setCapacityByLabel(B1, "", 50.0f);
        conf.setMaximumCapacity(B1, 50.0f);
        conf.setAccessibleNodeLabels(B1, RMNodeLabelsManager.EMPTY_STRING_SET);
        conf.setCapacityByLabel(B2, "", 50.0f);
        conf.setMaximumCapacity(B2, 50.0f);
        conf.setAccessibleNodeLabels(B2, TestCapacitySchedulerWeightMode.toSet("y", "z"));
        conf.setCapacityByLabel(B2, "y", 100.0f);
        conf.setCapacityByLabel(B2, "z", 100.0f);
        return conf;
    }

    public static Configuration getCSConfWithLabelsParentUsePctChildUseWeight(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacityByLabel(ROOT, "x", 100.0f);
        conf.setCapacityByLabel(ROOT, "y", 100.0f);
        conf.setCapacityByLabel(ROOT, "z", 100.0f);
        conf.setCapacityByLabel(A, "", 10.0f);
        conf.setMaximumCapacity(A, 10.0f);
        conf.setAccessibleNodeLabels(A, TestCapacitySchedulerWeightMode.toSet("x", "y"));
        conf.setCapacityByLabel(A, "x", 100.0f);
        conf.setCapacityByLabel(A, "y", 50.0f);
        conf.setCapacityByLabel(B, "", 90.0f);
        conf.setMaximumCapacity(B, 100.0f);
        conf.setAccessibleNodeLabels(B, TestCapacitySchedulerWeightMode.toSet("y", "z"));
        conf.setCapacityByLabel(B, "y", 50.0f);
        conf.setCapacityByLabel(B, "z", 100.0f);
        conf.setQueues(A, new String[]{"a1"});
        conf.setLabeledQueueWeight(A1, "", 1.0f);
        conf.setMaximumCapacity(A1, 100.0f);
        conf.setAccessibleNodeLabels(A1, TestCapacitySchedulerWeightMode.toSet("x", "y"));
        conf.setDefaultNodeLabelExpression(A1, "x");
        conf.setLabeledQueueWeight(A1, "x", 1.0f);
        conf.setLabeledQueueWeight(A1, "y", 1.0f);
        conf.setQueues(B, new String[]{"b1", "b2"});
        conf.setLabeledQueueWeight(B1, "", 1.0f);
        conf.setMaximumCapacity(B1, 50.0f);
        conf.setAccessibleNodeLabels(B1, RMNodeLabelsManager.EMPTY_STRING_SET);
        conf.setLabeledQueueWeight(B2, "", 1.0f);
        conf.setMaximumCapacity(B2, 50.0f);
        conf.setAccessibleNodeLabels(B2, TestCapacitySchedulerWeightMode.toSet("y", "z"));
        conf.setLabeledQueueWeight(B2, "y", 1.0f);
        conf.setLabeledQueueWeight(B2, "z", 1.0f);
        return conf;
    }

    @Test(timeout=300000L)
    public void testContainerAllocateWithComplexLabelsWeightOnly() throws Exception {
        this.internalTestContainerAllocationWithNodeLabel(TestCapacitySchedulerWeightMode.getCSConfWithQueueLabelsWeightOnly((Configuration)this.conf));
    }

    @Test(timeout=300000L)
    public void testContainerAllocateWithComplexLabelsWeightAndPercentMixed1() throws Exception {
        this.internalTestContainerAllocationWithNodeLabel(TestCapacitySchedulerWeightMode.getCSConfWithLabelsParentUseWeightChildUsePct((Configuration)this.conf));
    }

    @Test(timeout=300000L)
    public void testContainerAllocateWithComplexLabelsWeightAndPercentMixed2() throws Exception {
        this.internalTestContainerAllocationWithNodeLabel(TestCapacitySchedulerWeightMode.getCSConfWithLabelsParentUsePctChildUseWeight((Configuration)this.conf));
    }

    @Test(timeout=300000L)
    public void testGetCapacityOrWeightStringUsingWeights() throws IOException {
        try (MockRM rm = new MockRM(TestCapacitySchedulerWeightMode.getCSConfWithQueueLabelsWeightOnly((Configuration)this.conf));){
            rm.start();
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            String capacityOrWeightString = ((ParentQueue)cs.getQueue(A.getFullPath())).getCapacityOrWeightString();
            this.validateCapacityOrWeightString(capacityOrWeightString, true);
            capacityOrWeightString = ((LeafQueue)cs.getQueue(A1.getFullPath())).getCapacityOrWeightString();
            this.validateCapacityOrWeightString(capacityOrWeightString, true);
            capacityOrWeightString = ((LeafQueue)cs.getQueue(A1.getFullPath())).getExtendedCapacityOrWeightString();
            this.validateCapacityOrWeightString(capacityOrWeightString, true);
        }
    }

    @Test(timeout=300000L)
    public void testGetCapacityOrWeightStringParentPctLeafWeights() throws IOException {
        try (MockRM rm = new MockRM(TestCapacitySchedulerWeightMode.getCSConfWithLabelsParentUseWeightChildUsePct((Configuration)this.conf));){
            rm.start();
            CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
            String capacityOrWeightString = ((ParentQueue)cs.getQueue(A.getFullPath())).getCapacityOrWeightString();
            this.validateCapacityOrWeightString(capacityOrWeightString, true);
            capacityOrWeightString = ((LeafQueue)cs.getQueue(A1.getFullPath())).getCapacityOrWeightString();
            this.validateCapacityOrWeightString(capacityOrWeightString, false);
            capacityOrWeightString = ((LeafQueue)cs.getQueue(A1.getFullPath())).getExtendedCapacityOrWeightString();
            this.validateCapacityOrWeightString(capacityOrWeightString, false);
        }
    }

    @Test
    public void testChildAccessibleNodeLabelsWeightMode() throws Exception {
        MockRM rm = new MockRM(TestCapacitySchedulerWeightMode.getCSConfWithQueueLabelsWeightOnly((Configuration)this.conf));
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        LeafQueue b1 = (LeafQueue)cs.getQueue(B1.getFullPath());
        Assert.assertNotNull((Object)b1);
        Assert.assertTrue((boolean)b1.getAccessibleNodeLabels().isEmpty());
        Set b1ExistingNodeLabels = b1.getQueueCapacities().getExistingNodeLabels();
        Assert.assertEquals((long)1L, (long)b1ExistingNodeLabels.size());
        Assert.assertEquals((Object)"", b1ExistingNodeLabels.iterator().next());
        rm.close();
    }

    @Test
    public void testAccessibleNodeLabelsInheritanceNoWeightMode() throws IOException {
        CapacitySchedulerConfiguration newConf = TestCapacitySchedulerWeightMode.getConfigWithInheritedAccessibleNodeLabel((Configuration)this.conf);
        MockRM rm = new MockRM((Configuration)newConf);
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        Resource clusterResource = Resource.newInstance((int)1024, (int)2);
        cs.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        try {
            cs.reinitialize((Configuration)newConf, rm.getRMContext());
        }
        catch (Exception e) {
            Assert.fail((String)("Reinitialization failed with " + e));
        }
    }

    @Test
    public void testQueueInfoWeight() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.init((Configuration)this.conf);
        rm.start();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues(ROOT, new String[]{"a", "b", "default"});
        csConf.setNonLabeledQueueWeight(A, 1.0f);
        csConf.setNonLabeledQueueWeight(B, 2.0f);
        csConf.setNonLabeledQueueWeight(DEFAULT, 3.0f);
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        cs.reinitialize((Configuration)csConf, rm.getRMContext());
        LeafQueue a = (LeafQueue)cs.getQueue(A_PATH);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((double)a.getQueueCapacities().getWeight(), (double)a.getQueueInfo(false, false).getWeight(), (double)1.0E-6);
        LeafQueue b = (LeafQueue)cs.getQueue(B_PATH);
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((double)b.getQueueCapacities().getWeight(), (double)b.getQueueInfo(false, false).getWeight(), (double)1.0E-6);
        rm.close();
    }

    private void internalTestContainerAllocationWithNodeLabel(Configuration csConf) throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), TestCapacitySchedulerWeightMode.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), TestCapacitySchedulerWeightMode.toSet("y"), (Object)NodeId.newInstance((String)"h3", (int)0), TestCapacitySchedulerWeightMode.toSet("y"), (Object)NodeId.newInstance((String)"h4", (int)0), TestCapacitySchedulerWeightMode.toSet("z"), (Object)NodeId.newInstance((String)"h5", (int)0), (Object)RMNodeLabelsManager.EMPTY_STRING_SET));
        MockRM rm1 = new MockRM(csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerWeightMode.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 2048);
        MockNM nm2 = rm1.registerNode("h2:1234", 2048);
        MockNM nm3 = rm1.registerNode("h3:1234", 2048);
        MockNM nm4 = rm1.registerNode("h4:1234", 2048);
        MockNM nm5 = rm1.registerNode("h5:1234", 2048);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm5);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED));
        Assert.assertFalse((boolean)rm1.waitForState(nm5, containerId, RMContainerState.ALLOCATED));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm5);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "z");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h4");
        rm1.close();
    }

    private void checkTaskContainersHost(ApplicationAttemptId attemptId, ContainerId containerId, ResourceManager rm, String host) {
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        SchedulerAppReport appReport = scheduler.getSchedulerAppInfo(attemptId);
        Assert.assertTrue((appReport.getLiveContainers().size() > 0 ? 1 : 0) != 0);
        for (RMContainer c : appReport.getLiveContainers()) {
            if (!c.getContainerId().equals((Object)containerId)) continue;
            Assert.assertEquals((Object)host, (Object)c.getAllocatedNode().getHost());
        }
    }

    private void validateCapacityOrWeightString(String capacityOrWeightString, boolean shouldContainWeight) {
        Assert.assertEquals((Object)shouldContainWeight, (Object)capacityOrWeightString.contains("weight"));
        Assert.assertEquals((Object)shouldContainWeight, (Object)capacityOrWeightString.contains("normalizedWeight"));
        Assert.assertEquals((Object)(!shouldContainWeight ? 1 : 0), (Object)capacityOrWeightString.contains("capacity"));
    }
}

