/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueHelpers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacitySchedulerQueues {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacitySchedulerQueues.class);
    private MockRM rm;
    private NullRMNodeLabelsManager mgr;
    private CapacitySchedulerConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(this.conf);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
        this.rm = new MockRM((Configuration)this.conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return TestCapacitySchedulerQueues.this.mgr;
            }
        };
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        Resource clusterResource = Resource.newInstance((int)131072, (int)128);
        this.mgr.setResourceForLabel("", clusterResource);
        cs.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
    }

    @After
    public void tearDown() throws Exception {
        if (this.rm != null) {
            this.rm.stop();
        }
        if (this.mgr != null) {
            this.mgr.close();
        }
    }

    @Test(expected=IOException.class)
    public void testParseQueue() throws IOException {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        this.conf.setQueues(CapacitySchedulerQueueHelpers.A1, new String[]{"b1"});
        this.conf.setCapacity(CapacitySchedulerQueueHelpers.A1_B1, 100.0f);
        this.conf.setUserLimitFactor(CapacitySchedulerQueueHelpers.A1_B1, 100.0f);
        cs.reinitialize((Configuration)this.conf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)this.conf), new NMTokenSecretManagerInRM((Configuration)this.conf), new ClientToAMTokenSecretManagerInRM(), null));
        cs.stop();
    }

    @Test
    public void testRefreshQueues() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(this.conf);
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        this.conf.setCapacity(CapacitySchedulerQueueHelpers.A, 80.0f);
        this.conf.setCapacity(CapacitySchedulerQueueHelpers.B, 20.0f);
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs, CapacitySchedulerQueueHelpers.getDefaultCapacities(0.8f, 0.2f));
        cs.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshQueuesWithNewQueue() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        String b4Path = CapacitySchedulerQueueHelpers.B + ".b4";
        QueuePath b4 = new QueuePath(b4Path);
        float b4Capacity = 10.0f;
        float modifiedB3Capacity = 10.0f;
        try {
            this.conf.setCapacity(CapacitySchedulerQueueHelpers.A, 80.0f);
            this.conf.setCapacity(CapacitySchedulerQueueHelpers.B, 20.0f);
            this.conf.setQueues(CapacitySchedulerQueueHelpers.B, new String[]{"b1", "b2", "b3", "b4"});
            this.conf.setCapacity(CapacitySchedulerQueueHelpers.B1, 79.2f);
            this.conf.setCapacity(CapacitySchedulerQueueHelpers.B2, 0.8f);
            this.conf.setCapacity(CapacitySchedulerQueueHelpers.B3, 10.0f);
            this.conf.setCapacity(b4, 10.0f);
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            float capA = 0.8f;
            float capB = 0.2f;
            Map<String, CapacitySchedulerQueueHelpers.ExpectedCapacities> expectedCapacities = CapacitySchedulerQueueHelpers.getDefaultCapacities(0.8f, 0.2f);
            expectedCapacities.put(CapacitySchedulerQueueHelpers.B3.getFullPath(), new CapacitySchedulerQueueHelpers.ExpectedCapacities(0.1f, 0.2f));
            expectedCapacities.put(b4Path, new CapacitySchedulerQueueHelpers.ExpectedCapacities(0.1f, 0.2f));
            CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs, expectedCapacities);
            CSQueue rootQueue = cs.getRootQueue();
            CSQueue queueB = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.B.getFullPath());
            CSQueue queueB4 = CapacitySchedulerQueueHelpers.findQueue(queueB, b4Path);
            Assert.assertEquals((Object)queueB, (Object)queueB4.getParent());
        }
        finally {
            cs.stop();
        }
    }

    @Test
    public void testRefreshQueuesMaxAllocationRefresh() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        Assert.assertEquals((String)"max allocation in CS", (long)8192L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max allocation for A1", (Object)Resources.none(), (Object)this.conf.getQueueMaximumAllocation(CapacitySchedulerQueueHelpers.A1));
        Assert.assertEquals((String)"max allocation", (long)8192L, (long)ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf).getMemorySize());
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.A.getFullPath());
        CSQueue queueA1 = CapacitySchedulerQueueHelpers.findQueue(queueA, CapacitySchedulerQueueHelpers.A1.getFullPath());
        Assert.assertEquals((String)"queue max allocation", (long)((LeafQueue)queueA1).getMaximumAllocation().getMemorySize(), (long)8192L);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.A1, 4096);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"should have thrown exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.A1, 8192);
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores(this.conf, CapacitySchedulerQueueHelpers.A1, 3);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"should have thrown exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        cs.stop();
    }

    @Test
    public void testRefreshQueuesMaxAllocationPerQueueLarge() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.B3, 10240);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"should have thrown exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"maximum allocation exception", (boolean)e.getCause().getMessage().contains("maximum allocation"));
        }
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.B3, 8192);
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores(this.conf, CapacitySchedulerQueueHelpers.B3, 5);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"should have thrown exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"maximum allocation exception", (boolean)e.getCause().getMessage().contains("maximum allocation"));
        }
        cs.stop();
    }

    @Test
    public void testRefreshQueuesMaxAllocationRefreshLarger() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 8192);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)this.conf, 4);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.A1, 4096);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores(this.conf, CapacitySchedulerQueueHelpers.A1, 2);
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.A.getFullPath());
        CSQueue queueA1 = CapacitySchedulerQueueHelpers.findQueue(queueA, CapacitySchedulerQueueHelpers.A1.getFullPath());
        Assert.assertEquals((String)"max capability MB in CS", (long)8192L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max capability vcores in CS", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB A1", (long)4096L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores A1", (long)2L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"cluster max allocation MB", (long)8192L, (long)ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf).getMemorySize());
        Assert.assertEquals((String)"cluster max allocation vcores", (long)4L, (long)ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf).getVirtualCores());
        Assert.assertEquals((String)"queue max allocation", (long)4096L, (long)queueA1.getMaximumAllocation().getMemorySize());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.A1, 6144);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores(this.conf, CapacitySchedulerQueueHelpers.A1, 3);
        cs.reinitialize((Configuration)this.conf, null);
        Assert.assertEquals((String)"max allocation MB A1", (long)6144L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores A1", (long)3L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB cluster", (long)8192L, (long)ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf).getMemorySize());
        Assert.assertEquals((String)"max allocation vcores cluster", (long)4L, (long)ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf).getVirtualCores());
        Assert.assertEquals((String)"queue max allocation MB", (long)6144L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"queue max allocation vcores", (long)3L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max capability MB cluster", (long)8192L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"cluster max capability vcores", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        cs.stop();
    }

    @Test
    public void testRefreshQueuesMaxAllocationCSError() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 10240);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)this.conf, 10);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.A1, 4096);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores(this.conf, CapacitySchedulerQueueHelpers.A1, 4);
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        Assert.assertEquals((String)"max allocation MB in CS", (long)10240L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores in CS", (long)10L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 6144);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"should have thrown exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 10240);
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)this.conf, 8);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"should have thrown exception");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"max allocation exception", (boolean)e.getCause().toString().contains("not be decreased"));
        }
        cs.stop();
    }

    @Test
    public void testRefreshQueuesMaxAllocationCSLarger() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 10240);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)this.conf, 10);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb(this.conf, CapacitySchedulerQueueHelpers.A1, 4096);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores(this.conf, CapacitySchedulerQueueHelpers.A1, 4);
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        Assert.assertEquals((String)"max allocation MB in CS", (long)10240L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores in CS", (long)10L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.A.getFullPath());
        CSQueue queueB = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.B.getFullPath());
        CSQueue queueA1 = CapacitySchedulerQueueHelpers.findQueue(queueA, CapacitySchedulerQueueHelpers.A1.getFullPath());
        CSQueue queueA2 = CapacitySchedulerQueueHelpers.findQueue(queueA, CapacitySchedulerQueueHelpers.A2.getFullPath());
        CSQueue queueB2 = CapacitySchedulerQueueHelpers.findQueue(queueB, CapacitySchedulerQueueHelpers.B2.getFullPath());
        Assert.assertEquals((String)"queue A1 max allocation MB", (long)4096L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"queue A1 max allocation vcores", (long)4L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue A2 max allocation MB", (long)10240L, (long)queueA2.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"queue A2 max allocation vcores", (long)10L, (long)queueA2.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue B2 max allocation MB", (long)10240L, (long)queueB2.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"queue B2 max allocation vcores", (long)10L, (long)queueB2.getMaximumAllocation().getVirtualCores());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 12288);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)this.conf, 12);
        cs.reinitialize((Configuration)this.conf, null);
        Assert.assertEquals((String)"max allocation MB in CS", (long)12288L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores in CS", (long)12L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"queue A1 max MB allocation", (long)4096L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"queue A1 max vcores allocation", (long)4L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue A2 max MB allocation", (long)12288L, (long)queueA2.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"queue A2 max vcores allocation", (long)12L, (long)queueA2.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"queue B2 max MB allocation", (long)12288L, (long)queueB2.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"queue B2 max vcores allocation", (long)12L, (long)queueB2.getMaximumAllocation().getVirtualCores());
        cs.stop();
    }

    @Test
    public void testRefreshQueuesWithQueueDelete() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        Map queues = cs.getCapacitySchedulerQueueManager().getShortNameQueues();
        String b1QTobeDeleted = "b1";
        LeafQueue csB1Queue = (LeafQueue)Mockito.spy((Object)((LeafQueue)queues.get(b1QTobeDeleted)));
        Mockito.when((Object)csB1Queue.getState()).thenReturn((Object)QueueState.DRAINING).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue(b1QTobeDeleted, (CSQueue)csB1Queue);
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfigurationWithoutB1(this.conf);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"Expected to throw exception when refresh queue tries to delete a queue with running apps");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfigurationWithoutB1(this.conf);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        }
        catch (IOException e) {
            LOG.error("Expected to NOT throw exception when refresh queue tries to delete a queue WITHOUT running apps", (Throwable)e);
            Assert.fail((String)"Expected to NOT throw exception when refresh queue tries to delete a queue WITHOUT running apps");
        }
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueB = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.B.getFullPath());
        CSQueue queueB3 = CapacitySchedulerQueueHelpers.findQueue(queueB, CapacitySchedulerQueueHelpers.B1.getFullPath());
        Assert.assertNull((String)"Refresh needs to support delete of leaf queue ", (Object)queueB3);
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(this.conf);
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        queues = cs.getCapacitySchedulerQueueManager().getShortNameQueues();
        CSQueue bQueue = (CSQueue)Mockito.spy((Object)((ParentQueue)queues.get("b")));
        Mockito.when((Object)bQueue.getState()).thenReturn((Object)QueueState.DRAINING).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue("b", bQueue);
        bQueue = (CSQueue)Mockito.spy((Object)((LeafQueue)queues.get("b1")));
        Mockito.when((Object)bQueue.getState()).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue("b1", bQueue);
        bQueue = (CSQueue)Mockito.spy((Object)((LeafQueue)queues.get("b2")));
        Mockito.when((Object)bQueue.getState()).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue("b2", bQueue);
        bQueue = (CSQueue)Mockito.spy((Object)((LeafQueue)queues.get("b3")));
        Mockito.when((Object)bQueue.getState()).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue("b3", bQueue);
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfigurationWithoutB(this.conf);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"Expected to throw exception when refresh queue tries to delete a parent queue with running apps in children queue");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfigurationWithoutB(this.conf);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        }
        catch (IOException e) {
            Assert.fail((String)"Expected to not throw exception when refresh queue tries to delete a queue without running apps");
        }
        rootQueue = cs.getRootQueue();
        queueB = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.B.getFullPath());
        String message = "Refresh needs to support delete of Parent queue and its children.";
        Assert.assertNull((String)message, (Object)queueB);
        Assert.assertNull((String)message, cs.getCapacitySchedulerQueueManager().getQueues().get("b"));
        Assert.assertNull((String)message, cs.getCapacitySchedulerQueueManager().getQueues().get("b1"));
        Assert.assertNull((String)message, cs.getCapacitySchedulerQueueManager().getQueues().get("b2"));
        cs.stop();
    }

    @Test
    public void testRefreshQueuesWithAllChildQueuesDeleted() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        Map queues = cs.getCapacitySchedulerQueueManager().getShortNameQueues();
        CSQueue bQueue = (CSQueue)Mockito.spy((Object)((LeafQueue)queues.get("b1")));
        Mockito.when((Object)bQueue.getState()).thenReturn((Object)QueueState.RUNNING).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue("b1", bQueue);
        bQueue = (CSQueue)Mockito.spy((Object)((LeafQueue)queues.get("b2")));
        Mockito.when((Object)bQueue.getState()).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue("b2", bQueue);
        bQueue = (CSQueue)Mockito.spy((Object)((LeafQueue)queues.get("b3")));
        Mockito.when((Object)bQueue.getState()).thenReturn((Object)QueueState.STOPPED);
        cs.getCapacitySchedulerQueueManager().addQueue("b3", bQueue);
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfWithoutChildrenOfB(this.conf);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"Expected to throw exception when refresh queue tries to make parent queue a child queue when one of its children is still running.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected to NOT throw exception when refresh queue tries to delete all children of a parent queue(without running apps).");
        }
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueB = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.B.getFullPath());
        Assert.assertNotNull((String)"Parent Queue B should not be deleted", (Object)queueB);
        Assert.assertTrue((String)"As Queue'B children are not deleted", (boolean)(queueB instanceof LeafQueue));
        String message = "Refresh needs to support delete of all children of Parent queue.";
        Assert.assertNull((String)message, cs.getCapacitySchedulerQueueManager().getQueues().get("b3"));
        Assert.assertNull((String)message, cs.getCapacitySchedulerQueueManager().getQueues().get("b1"));
        Assert.assertNull((String)message, cs.getCapacitySchedulerQueueManager().getQueues().get("b2"));
        cs.stop();
    }

    @Test(timeout=10000L)
    public void testConvertLeafQueueToParentQueue() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        String targetQueue = "b1";
        CSQueue b1 = cs.getQueue(targetQueue);
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)b1.getState());
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfigurationWithB1AsParentQueue(this.conf);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"Expected to throw exception when refresh queue tries to convert a child queue to a parent queue.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(this.conf);
        this.conf.set("yarn.scheduler.capacity.root.b.b1.state", "STOPPED");
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)b1.getState());
        this.conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfigurationWithB1AsParentQueue(this.conf);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        }
        catch (IOException e) {
            Assert.fail((String)"Expected to NOT throw exception when refresh queue tries to convert a leaf queue WITHOUT running apps");
        }
        b1 = cs.getQueue(targetQueue);
        Assert.assertTrue((boolean)(b1 instanceof AbstractParentQueue));
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)b1.getState());
        Assert.assertTrue((!b1.getChildQueues().isEmpty() ? 1 : 0) != 0);
        cs.stop();
    }

    @Test
    public void testQueuesMaxAllocationInheritance() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 8192);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)this.conf, 4);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.ROOT, "memory-mb=4096,vcores=2");
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A1, "memory-mb=6144,vcores=2");
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.B, "memory-mb=5120, vcores=2");
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.B2, "memory-mb=1024, vcores=2");
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        CSQueue rootQueue = cs.getRootQueue();
        CSQueue queueA = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.A.getFullPath());
        CSQueue queueB = CapacitySchedulerQueueHelpers.findQueue(rootQueue, CapacitySchedulerQueueHelpers.B.getFullPath());
        CSQueue queueA1 = CapacitySchedulerQueueHelpers.findQueue(queueA, CapacitySchedulerQueueHelpers.A1.getFullPath());
        CSQueue queueA2 = CapacitySchedulerQueueHelpers.findQueue(queueA, CapacitySchedulerQueueHelpers.A2.getFullPath());
        CSQueue queueB1 = CapacitySchedulerQueueHelpers.findQueue(queueB, CapacitySchedulerQueueHelpers.B1.getFullPath());
        CSQueue queueB2 = CapacitySchedulerQueueHelpers.findQueue(queueB, CapacitySchedulerQueueHelpers.B2.getFullPath());
        Assert.assertEquals((String)"max capability MB in CS", (long)8192L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max capability vcores in CS", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB A1", (long)6144L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores A1", (long)2L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB A2", (long)4096L, (long)queueA2.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores A2", (long)2L, (long)queueA2.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB B", (long)5120L, (long)queueB.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation MB B1", (long)5120L, (long)queueB1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation MB B2", (long)1024L, (long)queueB2.getMaximumAllocation().getMemorySize());
        CapacitySchedulerConfigGeneratorForTest.unsetMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A1);
        CapacitySchedulerConfigGeneratorForTest.unsetMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.B);
        CapacitySchedulerConfigGeneratorForTest.unsetMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.B1);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.ROOT, "memory-mb=6144,vcores=2");
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A, "memory-mb=8192,vcores=2");
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        Assert.assertEquals((String)"max capability MB in CS", (long)8192L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max capability vcores in CS", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB A1", (long)8192L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores A1", (long)2L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB B1", (long)6144L, (long)queueB1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores B1", (long)2L, (long)queueB1.getMaximumAllocation().getVirtualCores());
        CapacitySchedulerConfigGeneratorForTest.unsetMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.ROOT);
        CapacitySchedulerConfigGeneratorForTest.unsetMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A);
        CapacitySchedulerConfigGeneratorForTest.unsetMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A1);
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        Assert.assertEquals((String)"max capability MB in CS", (long)8192L, (long)cs.getMaximumResourceCapability().getMemorySize());
        Assert.assertEquals((String)"max capability vcores in CS", (long)4L, (long)cs.getMaximumResourceCapability().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB A1", (long)8192L, (long)queueA1.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores A1", (long)4L, (long)queueA1.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((String)"max allocation MB A2", (long)8192L, (long)queueA2.getMaximumAllocation().getMemorySize());
        Assert.assertEquals((String)"max allocation vcores A2", (long)4L, (long)queueA2.getMaximumAllocation().getVirtualCores());
        cs.stop();
    }

    @Test
    public void testVerifyQueuesMaxAllocationConf() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.rm.getRMContext());
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocMb((Configuration)this.conf, 8192);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocVcores((Configuration)this.conf, 4);
        long largerMem = 9216L;
        long largerVcores = 14L;
        cs.init((Configuration)this.conf);
        cs.start();
        cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.ROOT, "memory-mb=" + largerMem + ",vcores=2");
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"Queue Root maximum allocation can't exceed the cluster setting");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"maximum allocation exception", (boolean)e.getCause().getMessage().contains("maximum allocation"));
        }
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.ROOT, "memory-mb=4096,vcores=2");
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A, "memory-mb=6144,vcores=2");
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A1, "memory-mb=" + largerMem + ",vcores=2");
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"Queue A1 maximum allocation can't exceed the cluster setting");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"maximum allocation exception", (boolean)e.getCause().getMessage().contains("maximum allocation"));
        }
        CapacitySchedulerConfigGeneratorForTest.setMaxAllocation(this.conf, CapacitySchedulerQueueHelpers.A1, "memory-mb=8192,vcores=" + largerVcores);
        try {
            cs.reinitialize((Configuration)this.conf, this.rm.getRMContext());
            Assert.fail((String)"Queue A1 maximum allocation can't exceed the cluster setting");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"maximum allocation exception", (boolean)e.getCause().getMessage().contains("maximum allocation"));
        }
        cs.stop();
    }
}

