/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.QueueACLsTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCapacitySchedulerQueueACLs
extends QueueACLsTestBase {
    @Override
    protected Configuration createConfiguration() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues(ROOT, new String[]{"queueA", "queueB"});
        this.setQueueCapacity(csConf, 50.0f, A_QUEUE_PATH);
        this.setQueueCapacity(csConf, 50.0f, B_QUEUE_PATH);
        HashMap<QueueACL, AccessControlList> aclsOnQueueA = new HashMap<QueueACL, AccessControlList>();
        AccessControlList submitACLonQueueA = new AccessControlList("queueA_user");
        submitACLonQueueA.addUser("common_user");
        AccessControlList adminACLonQueueA = new AccessControlList("queueA_admin");
        aclsOnQueueA.put(QueueACL.SUBMIT_APPLICATIONS, submitACLonQueueA);
        aclsOnQueueA.put(QueueACL.ADMINISTER_QUEUE, adminACLonQueueA);
        csConf.setAcls(A_QUEUE_PATH, aclsOnQueueA);
        HashMap<QueueACL, AccessControlList> aclsOnQueueB = new HashMap<QueueACL, AccessControlList>();
        AccessControlList submitACLonQueueB = new AccessControlList("queueB_user");
        submitACLonQueueB.addUser("common_user");
        AccessControlList adminACLonQueueB = new AccessControlList("queueB_admin");
        aclsOnQueueB.put(QueueACL.SUBMIT_APPLICATIONS, submitACLonQueueB);
        aclsOnQueueB.put(QueueACL.ADMINISTER_QUEUE, adminACLonQueueB);
        csConf.setAcls(B_QUEUE_PATH, aclsOnQueueB);
        HashMap<QueueACL, AccessControlList> aclsOnRootQueue = new HashMap<QueueACL, AccessControlList>();
        AccessControlList submitACLonRoot = new AccessControlList("");
        AccessControlList adminACLonRoot = new AccessControlList("root_admin");
        aclsOnRootQueue.put(QueueACL.SUBMIT_APPLICATIONS, submitACLonRoot);
        aclsOnRootQueue.put(QueueACL.ADMINISTER_QUEUE, adminACLonRoot);
        csConf.setAcls(ROOT, aclsOnRootQueue);
        csConf.setBoolean("yarn.acl.enable", true);
        csConf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        return csConf;
    }

    @Override
    public String getQueueD() {
        return "D";
    }

    @Override
    public String getQueueD1() {
        return "D1";
    }

    @Override
    public void updateConfigWithDAndD1Queues(String rootAcl, String queueDAcl, String queueD1Acl) throws IOException {
        CapacitySchedulerConfiguration csConf = (CapacitySchedulerConfiguration)this.getConf();
        csConf.clear();
        csConf.setQueues(ROOT, new String[]{"D", "queueA", "queueB"});
        String dPath = "root.D";
        String d1Path = dPath + ".D1";
        QueuePath dQueuePath = new QueuePath(dPath);
        QueuePath d1QueuePath = new QueuePath(d1Path);
        csConf.setQueues(dQueuePath, new String[]{"D1"});
        this.setQueueCapacity(csConf, 100.0f, d1QueuePath);
        this.setQueueCapacity(csConf, 30.0f, A_QUEUE_PATH);
        this.setQueueCapacity(csConf, 50.0f, B_QUEUE_PATH);
        this.setQueueCapacity(csConf, 20.0f, dQueuePath);
        if (rootAcl != null) {
            this.setAdminAndSubmitACL(csConf, rootAcl, ROOT);
        }
        if (queueDAcl != null) {
            this.setAdminAndSubmitACL(csConf, queueDAcl, dQueuePath);
        }
        if (queueD1Acl != null) {
            this.setAdminAndSubmitACL(csConf, queueD1Acl, d1QueuePath);
        }
        this.resourceManager.getResourceScheduler().reinitialize((Configuration)csConf, this.resourceManager.getRMContext());
    }

    private void setQueueCapacity(CapacitySchedulerConfiguration csConf, float capacity, QueuePath queuePath) {
        csConf.setCapacity(queuePath, capacity);
    }

    private void setAdminAndSubmitACL(CapacitySchedulerConfiguration csConf, String queueAcl, QueuePath queuePath) {
        csConf.setAcl(queuePath, QueueACL.ADMINISTER_QUEUE, queueAcl);
        csConf.setAcl(queuePath, QueueACL.SUBMIT_APPLICATIONS, queueAcl);
    }

    @Test
    public void testCheckAccessForUserWithOnlyLeafNameProvided() {
        this.testCheckAccess(false, "dynamicQueue");
    }

    @Test
    public void testCheckAccessForUserWithFullPathProvided() {
        this.testCheckAccess(true, "root.users.dynamicQueue");
    }

    @Test
    public void testCheckAccessForRootQueue() {
        this.testCheckAccess(false, "root");
    }

    private void testCheckAccess(boolean expectedResult, String queueName) {
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        CSQueue root = (CSQueue)Mockito.mock(ParentQueue.class);
        CSQueue users = (CSQueue)Mockito.mock(ManagedParentQueue.class);
        Mockito.when((Object)qm.getQueue("root")).thenReturn((Object)root);
        Mockito.when((Object)qm.getQueue("root.users")).thenReturn((Object)users);
        Mockito.when((Object)users.hasAccess((QueueACL)ArgumentMatchers.any(QueueACL.class), (UserGroupInformation)ArgumentMatchers.any(UserGroupInformation.class))).thenReturn((Object)true);
        UserGroupInformation mockUGI = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        CapacityScheduler cs = (CapacityScheduler)this.resourceManager.getResourceScheduler();
        cs.setQueueManager(qm);
        Assert.assertEquals((String)"checkAccess() failed", (Object)expectedResult, (Object)cs.checkAccess(mockUGI, QueueACL.ADMINISTER_QUEUE, queueName));
    }
}

