/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCapacitySchedulerNewQueueAutoCreationWithCapacityVectors
extends TestCapacitySchedulerAutoCreatedQueueBase {
    public static final int GB = 1024;
    private static final String NL = "";
    private MockRM mockRM = null;
    private CapacityScheduler cs;
    private CapacitySchedulerConfiguration csConf;
    private CapacitySchedulerQueueManager autoQueueHandler;

    public CapacityScheduler getCs() {
        return this.cs;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.csConf = new CapacitySchedulerConfiguration();
        this.csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.csConf.setLegacyQueueModeEnabled(false);
    }

    @Override
    @After
    public void tearDown() {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
    }

    protected void startScheduler() throws Exception {
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)this.csConf);
        this.mockRM = new MockRM((Configuration)this.csConf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.cs.updatePlacementRules();
        this.mockRM.start();
        this.cs.start();
        this.autoQueueHandler = this.cs.getCapacitySchedulerQueueManager();
        this.mockRM.registerNode("h1:1234", 32000, 32);
    }

    private void createPercentageConfig() {
        this.csConf.setQueues(ROOT, new String[]{"a"});
        this.csConf.setCapacity(A, 25.0f);
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, true);
        this.csConf.setAutoQueueCreationV2Enabled(A, true);
        this.csConf.set(this.getTemplateKey(ROOT, "capacity"), "6.25");
        this.csConf.set(this.getLeafTemplateKey(A, "capacity"), "[memory=25%, vcores=50%]");
    }

    private void createAbsoluteConfig() {
        this.csConf.setQueues(ROOT, new String[]{"a"});
        this.csConf.setCapacity(A, "[memory=8000, vcores=8]");
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, true);
        this.csConf.setAutoQueueCreationV2Enabled(A, true);
        this.csConf.set(this.getTemplateKey(ROOT, "capacity"), "[memory=2000mb, vcores=2]");
        this.csConf.set(this.getLeafTemplateKey(A, "capacity"), "[memory=2000, vcores=4]");
    }

    private void createMixedConfig() {
        this.csConf.setQueues(ROOT, new String[]{"a", "b", "d"});
        this.csConf.setCapacityVector(A, NL, "[memory=10%, vcores=2]");
        this.csConf.setCapacityVector(B, NL, "[memory=2000, vcores=10%]");
        this.csConf.setCapacityVector(D, NL, "[memory=10%, vcores=10%]");
        this.csConf.setQueues(A, new String[]{"a1"});
        this.csConf.setCapacityVector(A1, NL, "[memory=100%, vcores=100%]");
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, true);
        this.csConf.setAutoQueueCreationV2Enabled(A, true);
        this.csConf.setAutoQueueCreationV2Enabled(D, true);
        this.csConf.set(this.getTemplateKey(ROOT, "capacity"), "[memory=2w, vcores=5w]");
        this.csConf.set(this.getParentTemplateKey(ROOT, "capacity"), "[memory=2w, vcores=10]");
        this.csConf.set(this.getLeafTemplateKey(new QueuePath("root.*"), "capacity"), "[memory=2000, vcores=2]");
        this.csConf.set(this.getLeafTemplateKey(D, "capacity"), "[memory=1000, vcores=1]");
    }

    @Test
    public void testBasicPercentageConfiguration() throws Exception {
        this.createPercentageConfig();
        this.startScheduler();
        this.validateBasicConfiguration();
    }

    @Test
    public void testBasicAbsoluteConfiguration() throws Exception {
        this.createAbsoluteConfig();
        this.startScheduler();
        this.validateBasicConfiguration();
    }

    private void validateBasicConfiguration() throws Exception {
        CSQueue a = this.cs.getQueue("root.a");
        Assert.assertEquals((float)0.25f, (float)a.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)a.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)8000L, (long)a.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)8L, (long)a.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        this.createQueue("root.b-auto");
        CSQueue bAuto = this.cs.getQueue("root.b-auto");
        Assert.assertEquals((float)0.0625f, (float)bAuto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)bAuto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)2000L, (long)bAuto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)bAuto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        Assert.assertEquals((float)((LeafQueue)bAuto).getUserLimitFactor(), (float)-1.0f, (float)0.001f);
        Assert.assertEquals((float)((LeafQueue)bAuto).getMaxAMResourcePerQueuePercent(), (float)1.0f, (float)0.001f);
        this.createQueue("root.a.a1-auto");
        CSQueue a1Auto = this.cs.getQueue("root.a.a1-auto");
        Assert.assertEquals((float)0.0625f, (float)a1Auto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)a1Auto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)2000L, (long)a1Auto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)4L, (long)a1Auto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        Assert.assertEquals((float)((LeafQueue)a1Auto).getUserLimitFactor(), (float)-1.0f, (float)0.001f);
        Assert.assertEquals((float)((LeafQueue)a1Auto).getMaxAMResourcePerQueuePercent(), (float)1.0f, (float)0.001f);
    }

    @Test
    public void testMixedFlexibleConfiguration() throws Exception {
        this.createMixedConfig();
        this.startScheduler();
        this.createQueue("root.c-auto");
        CSQueue cAuto = this.cs.getQueue("root.c-auto");
        Assert.assertEquals((float)0.75f, (float)cAuto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)cAuto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)24000L, (long)cAuto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)24L, (long)cAuto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        Assert.assertEquals((float)((LeafQueue)cAuto).getUserLimitFactor(), (float)-1.0f, (float)0.001f);
        Assert.assertEquals((float)((LeafQueue)cAuto).getMaxAMResourcePerQueuePercent(), (float)1.0f, (float)0.001f);
        this.createQueue("root.d.d1-auto");
        CSQueue dAuto = this.cs.getQueue("root.d.d1-auto");
        Assert.assertEquals((float)0.03125f, (float)dAuto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)dAuto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)1000L, (long)dAuto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)1L, (long)dAuto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        this.createQueue("root.a.a2-auto");
        CSQueue a2Auto = this.cs.getQueue("root.a.a2-auto");
        Assert.assertEquals((float)0.0625f, (float)a2Auto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)a2Auto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)2000L, (long)a2Auto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)a2Auto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        CSQueue a1 = this.cs.getQueue("root.a.a1");
        Assert.assertEquals((long)1000L, (long)a1.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)a1.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        this.createQueue("root.e-auto.e1-auto");
        CSQueue eAuto = this.cs.getQueue("root.e-auto");
        Assert.assertEquals((float)0.375f, (float)eAuto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)eAuto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)12000L, (long)eAuto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)10L, (long)eAuto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        Assert.assertEquals((float)0.375f, (float)cAuto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)cAuto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)12000L, (long)cAuto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)16L, (long)cAuto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
        CSQueue e1Auto = this.cs.getQueue("root.e-auto.e1-auto");
        Assert.assertEquals((float)0.0625f, (float)e1Auto.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)e1Auto.getQueueCapacities().getWeight(), (float)0.001f);
        Assert.assertEquals((long)2000L, (long)e1Auto.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)e1Auto.getQueueResourceQuotas().getEffectiveMinResource().getVirtualCores());
    }

    protected AbstractLeafQueue createQueue(String queuePath) throws YarnException, IOException {
        return this.autoQueueHandler.createQueue(new QueuePath(queuePath));
    }

    private String getTemplateKey(QueuePath queuePath, String entryKey) {
        return QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "auto-queue-creation-v2.template." + entryKey;
    }

    private String getParentTemplateKey(QueuePath queuePath, String entryKey) {
        return QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "auto-queue-creation-v2.parent-template." + entryKey;
    }

    private String getLeafTemplateKey(QueuePath queuePath, String entryKey) {
        return QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "auto-queue-creation-v2.leaf-template." + entryKey;
    }
}

