/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueDeletionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueTemplate;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacitySchedulerNewQueueAutoCreation
extends TestCapacitySchedulerAutoCreatedQueueBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacitySchedulerAutoCreatedQueueBase.class);
    private static final QueuePath EMPTY_AUTO_PARENT = new QueuePath("root.empty-auto-parent");
    private static final QueuePath A_A2_AUTO = new QueuePath("root.a.a2-auto");
    private static final QueuePath E_AUTO = new QueuePath("root.e-auto");
    private static final QueuePath E_E1 = new QueuePath("root.e.e1");
    private static final QueuePath A_A_AUTO_A2 = new QueuePath("root.a.a-auto.a2");
    private static final QueuePath A_A1_AUTO_A2_AUTO = new QueuePath("root.a.a1-auto.a2-auto");
    public static final int GB = 1024;
    public static final int MAX_MEMORY = 1200;
    private MockRM mockRM = null;
    private CapacityScheduler cs;
    private CapacitySchedulerConfiguration csConf;
    private CapacitySchedulerQueueManager autoQueueHandler;
    private AutoCreatedQueueDeletionPolicy policy = new AutoCreatedQueueDeletionPolicy();

    public CapacityScheduler getCs() {
        return this.cs;
    }

    public AutoCreatedQueueDeletionPolicy getPolicy() {
        return this.policy;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.csConf = new CapacitySchedulerConfiguration();
        this.csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.csConf.setQueues(ROOT, new String[]{"a", "b"});
        this.csConf.setNonLabeledQueueWeight(ROOT, 1.0f);
        this.csConf.setNonLabeledQueueWeight(A, 1.0f);
        this.csConf.setNonLabeledQueueWeight(B, 1.0f);
        this.csConf.setQueues(A, new String[]{"a1"});
        this.csConf.setNonLabeledQueueWeight(A1, 1.0f);
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, true);
        this.csConf.setAutoQueueCreationV2Enabled(A, true);
        this.csConf.setAutoQueueCreationV2Enabled(E, true);
        this.csConf.setAutoQueueCreationV2Enabled(new QueuePath("c"), true);
        this.csConf.setAutoExpiredDeletionTime(1L);
    }

    @Override
    @After
    public void tearDown() {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
    }

    protected void startScheduler() throws Exception {
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)this.csConf);
        this.mockRM = new MockRM((Configuration)this.csConf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.cs.updatePlacementRules();
        this.policy.init((Configuration)this.cs.getConfiguration(), this.cs.getRMContext(), (ResourceScheduler)this.cs);
        this.mockRM.start();
        this.cs.start();
        this.autoQueueHandler = this.cs.getCapacitySchedulerQueueManager();
        this.mockRM.registerNode("h1:1234", 1228800);
    }

    private void createBasicQueueStructureAndValidate() throws Exception {
        MockNM nm1 = this.mockRM.registerNode("h1:1234", 1228800);
        this.createQueue("root.c-auto");
        CSQueue c = this.cs.getQueue("root.c-auto");
        Assert.assertEquals((double)0.3333333432674408, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)c.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)409600L, (long)c.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((double)((LeafQueue)c).getUserLimitFactor(), (double)-1.0, (double)1.0E-6);
        Assert.assertEquals((double)((LeafQueue)c).getMaxAMResourcePerQueuePercent(), (double)1.0, (double)1.0E-6);
        this.createQueue("root.d-auto");
        CSQueue d = this.cs.getQueue("root.d-auto");
        Assert.assertEquals((double)0.25, (double)d.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)d.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)307200L, (long)d.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((double)0.25, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)c.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)307200L, (long)c.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        this.createQueue("root.a.a2-auto");
        CSQueue a2 = this.cs.getQueue("root.a.a2-auto");
        Assert.assertEquals((double)0.125, (double)a2.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)a2.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)153600L, (long)a2.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        this.createQueue("root.e-auto.e1-auto");
        CSQueue e = this.cs.getQueue("root.e-auto");
        Assert.assertEquals((double)0.2f, (double)e.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)e.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)245760L, (long)e.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        CSQueue e1 = this.cs.getQueue("root.e-auto.e1-auto");
        Assert.assertEquals((double)0.2f, (double)e1.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)e1.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)245760L, (long)e1.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
    }

    @Test
    public void testAutoCreateQueueWithSiblingsUnderRoot() throws Exception {
        this.startScheduler();
        this.createQueue("root.c-auto");
        CSQueue c = this.cs.getQueue("root.c-auto");
        Assert.assertEquals((double)0.3333333432674408, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)c.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)409600L, (long)c.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        this.createQueue("root.d-auto");
        CSQueue d = this.cs.getQueue("root.d-auto");
        Assert.assertEquals((double)0.25, (double)d.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)d.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)307200L, (long)d.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((double)0.25, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)c.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)307200L, (long)c.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
    }

    @Test
    public void testAutoCreateQueueStaticParentOneLevel() throws Exception {
        this.startScheduler();
        this.createQueue("root.a.a2-auto");
        CSQueue a2 = this.cs.getQueue("root.a.a2-auto");
        Assert.assertEquals((double)0.25, (double)a2.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)a2.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((double)307200.0, (double)a2.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize(), (double)1.0E-6);
    }

    @Test
    public void testAutoCreateQueueAutoParentTwoLevelsWithSiblings() throws Exception {
        this.startScheduler();
        this.csConf.setAutoQueueCreationV2Enabled(A_A2_AUTO, true);
        this.createQueue("root.a.a2-auto.a3-auto");
        CSQueue a3 = this.cs.getQueue("root.a.a2-auto.a3-auto");
        Assert.assertEquals((double)0.25, (double)a3.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)a3.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((double)307200.0, (double)a3.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize(), (double)1.0E-6);
        this.createQueue("root.a.a2-auto.a4-auto");
        CSQueue a4 = this.cs.getQueue("root.a.a2-auto.a4-auto");
        Assert.assertEquals((double)0.125, (double)a3.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)a3.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((double)153600.0, (double)a4.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize(), (double)1.0E-6);
    }

    @Test(expected=SchedulerDynamicEditException.class)
    public void testAutoCreateQueueShouldFailWhenNonParentQueue() throws Exception {
        this.startScheduler();
        this.createQueue("root.a.a1.a2-auto");
    }

    @Test(expected=SchedulerDynamicEditException.class)
    public void testAutoCreateQueueWhenSiblingsNotInWeightMode() throws Exception {
        this.startScheduler();
        Assume.assumeThat((Object)this.csConf.isLegacyQueueMode(), (Matcher)CoreMatchers.is((Object)true));
        this.csConf.setCapacity(A, 50.0f);
        this.csConf.setCapacity(B, 50.0f);
        this.csConf.setCapacity(A1, 100.0f);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        this.createQueue("root.a.a2-auto");
    }

    @Test
    public void testAutoCreateMaximumQueueDepth() throws Exception {
        this.startScheduler();
        Assert.assertThrows(SchedulerDynamicEditException.class, () -> this.createQueue("root.a.a3-auto.a4-auto.a5-auto"));
        this.csConf.setMaximumAutoCreatedQueueDepth(A, 3);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        try {
            this.createQueue("root.a.a3-auto.a4-auto.a5-auto");
        }
        catch (SchedulerDynamicEditException sde) {
            LOG.error("%s", (Throwable)sde);
            Assert.fail((String)"Depth is set for root.a, exception should not be thrown");
        }
        this.csConf.setMaximumAutoCreatedQueueDepth(3);
        this.csConf.unset(QueuePrefixes.getQueuePrefix((QueuePath)A) + "auto-queue-creation-v2.maximum-queue-depth");
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        try {
            this.createQueue("root.a.a6-auto.a7-auto.a8-auto");
        }
        catch (SchedulerDynamicEditException sde) {
            LOG.error("%s", (Throwable)sde);
            Assert.fail((String)"Depth is set globally, exception should not be thrown");
        }
        this.csConf.setMaximumAutoCreatedQueueDepth(new QueuePath("root.a.a6-auto.a7-auto.a8-auto"), 10);
        Assert.assertThrows(SchedulerDynamicEditException.class, () -> this.createQueue("root.a.a6-auto.a7-auto.a8-auto.a9-auto.a10-auto.a11-auto"));
    }

    @Test(expected=SchedulerDynamicEditException.class)
    public void testAutoCreateQueueShouldFailIfNotEnabledForParent() throws Exception {
        this.startScheduler();
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, false);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        this.createQueue("root.c-auto");
    }

    @Test
    public void testAutoCreateQueueRefresh() throws Exception {
        this.startScheduler();
        this.createBasicQueueStructureAndValidate();
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((long)5L, (long)this.cs.getQueue("root").getChildQueues().size());
        Assert.assertNotNull((Object)this.cs.getQueue("root.c-auto"));
    }

    @Test
    public void testConvertDynamicToStaticQueue() throws Exception {
        this.startScheduler();
        this.createBasicQueueStructureAndValidate();
        this.csConf.setNonLabeledQueueWeight(new QueuePath("root.a"), 6.0f);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((long)5L, (long)this.cs.getQueue("root").getChildQueues().size());
        CSQueue a = this.cs.getQueue("root.a");
        Assert.assertEquals((double)0.6f, (double)a.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((long)737280L, (long)a.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((double)6.0, (double)a.getQueueCapacities().getWeight(), (double)1.0E-6);
        this.csConf.setQueues(ROOT, new String[]{"a", "b", "c-auto"});
        this.csConf.setNonLabeledQueueWeight(new QueuePath("root.c-auto"), 6.0f);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        CSQueue c = this.cs.getQueue("root.c-auto");
        Assert.assertEquals((double)0.4f, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((long)491520L, (long)c.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        Assert.assertEquals((double)6.0, (double)c.getQueueCapacities().getWeight(), (double)1.0E-6);
        this.createQueue("root.e-auto.e2-auto");
        this.csConf.setQueues(ROOT, new String[]{"a", "b", "c-auto", "e-auto"});
        this.csConf.setNonLabeledQueueWeight(new QueuePath("root.e-auto"), 6.0f);
        this.csConf.setQueues(E_AUTO, new String[]{"e1-auto"});
        this.csConf.setNonLabeledQueueWeight(new QueuePath("root.e-auto.e1-auto"), 6.0f);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        CSQueue e1 = this.cs.getQueue("root.e-auto.e1-auto");
        float e1NormalizedWeight = 0.25714287f;
        Assert.assertEquals((double)e1NormalizedWeight, (double)e1.getAbsoluteCapacity(), (double)1.0E-6);
        this.assertQueueMinResource(e1, 1200.0f * e1NormalizedWeight);
        Assert.assertEquals((double)6.0, (double)e1.getQueueCapacities().getWeight(), (double)1.0E-6);
    }

    @Test
    public void testConvertDynamicParentToStaticParent() throws Exception {
        this.startScheduler();
        this.createQueue("root.d-auto.d1-auto");
        this.csConf.setQueues(ROOT, new String[]{"a", "b", "d-auto"});
        this.csConf.setNonLabeledQueueWeight(new QueuePath("root.a"), 6.0f);
        this.csConf.setNonLabeledQueueWeight(new QueuePath("root.d-auto"), 1.0f);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        CSQueue d = this.cs.getQueue("root.d-auto");
        Assert.assertEquals((double)0.125, (double)d.getAbsoluteCapacity(), (double)1.0E-6);
        this.assertQueueMinResource(d, 150.0f);
        Assert.assertEquals((double)1.0, (double)d.getQueueCapacities().getWeight(), (double)1.0E-6);
        CSQueue d1 = this.cs.getQueue("root.d-auto.d1-auto");
        Assert.assertEquals((double)0.125, (double)d1.getAbsoluteCapacity(), (double)1.0E-6);
        this.assertQueueMinResource(d1, 150.0f);
        Assert.assertEquals((double)1.0, (double)d1.getQueueCapacities().getWeight(), (double)1.0E-6);
    }

    @Test
    public void testAutoQueueCreationOnAppSubmission() throws Exception {
        this.startScheduler();
        this.submitApp(this.cs, "user_0", "user_0", "root.e-auto");
        AbstractCSQueue e = (AbstractCSQueue)this.cs.getQueue("root.e-auto");
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.isDynamicQueue());
        AbstractCSQueue user0 = (AbstractCSQueue)this.cs.getQueue("root.e-auto.user_0");
        Assert.assertNotNull((Object)user0);
        Assert.assertTrue((boolean)user0.isDynamicQueue());
    }

    @Test
    public void testChildlessParentQueueWhenAutoQueueCreationEnabled() throws Exception {
        this.startScheduler();
        this.csConf.setQueues(ROOT, new String[]{"a", "b", "empty-auto-parent"});
        this.csConf.setNonLabeledQueueWeight(ROOT, 1.0f);
        this.csConf.setNonLabeledQueueWeight(A, 1.0f);
        this.csConf.setNonLabeledQueueWeight(B, 1.0f);
        this.csConf.setQueues(A, new String[]{"a1"});
        this.csConf.setNonLabeledQueueWeight(A1, 1.0f);
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, true);
        this.csConf.setAutoQueueCreationV2Enabled(A, true);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        CSQueue empty = this.cs.getQueue("root.empty-auto-parent");
        Assert.assertTrue((String)"empty-auto-parent is not a LeafQueue", (boolean)(empty instanceof LeafQueue));
        empty.stopQueue();
        this.csConf.setQueues(ROOT, new String[]{"a", "b", "empty-auto-parent"});
        this.csConf.setNonLabeledQueueWeight(ROOT, 1.0f);
        this.csConf.setNonLabeledQueueWeight(A, 1.0f);
        this.csConf.setNonLabeledQueueWeight(B, 1.0f);
        this.csConf.setQueues(A, new String[]{"a1"});
        this.csConf.setNonLabeledQueueWeight(A1, 1.0f);
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, true);
        this.csConf.setAutoQueueCreationV2Enabled(A, true);
        this.csConf.setAutoQueueCreationV2Enabled(EMPTY_AUTO_PARENT, true);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        empty = this.cs.getQueue("root.empty-auto-parent");
        Assert.assertTrue((String)"empty-auto-parent is not a ParentQueue", (boolean)(empty instanceof AbstractParentQueue));
        Assert.assertEquals((String)"empty-auto-parent has children", (long)0L, (long)empty.getChildQueues().size());
        Assert.assertTrue((String)"empty-auto-parent is not eligible for auto queue creation", (boolean)((AbstractParentQueue)empty).isEligibleForAutoQueueCreation());
    }

    @Test
    public void testAutoQueueCreationWithDisabledMappingRules() throws Exception {
        this.startScheduler();
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "root.a.a1-auto.a2-auto", "user_0", null);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        this.cs.handle((SchedulerEvent)addAppEvent);
        this.cs.handle((SchedulerEvent)addAttemptEvent);
        CSQueue a2Auto = this.cs.getQueue("root.a.a1-auto.a2-auto");
        Assert.assertNotNull((Object)a2Auto);
    }

    @Test
    public void testAutoCreateQueueUserLimitDisabled() throws Exception {
        this.startScheduler();
        this.createBasicQueueStructureAndValidate();
        this.submitApp(this.cs, "user_0", "user_0", "root.e-auto");
        AbstractCSQueue e = (AbstractCSQueue)this.cs.getQueue("root.e-auto");
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.isDynamicQueue());
        AbstractCSQueue user0 = (AbstractCSQueue)this.cs.getQueue("root.e-auto.user_0");
        Assert.assertNotNull((Object)user0);
        Assert.assertTrue((boolean)user0.isDynamicQueue());
        Assert.assertTrue((boolean)(user0 instanceof LeafQueue));
        LeafQueue user0LeafQueue = (LeafQueue)user0;
        Assert.assertTrue((user0LeafQueue.getUserLimitFactor() == -1.0f ? 1 : 0) != 0);
        Assert.assertEquals((long)user0LeafQueue.getMaxApplicationsPerUser(), (long)user0LeafQueue.getMaxApplications());
        Assert.assertEquals((double)user0LeafQueue.getAMResourceLimit().getMemorySize(), (double)(user0LeafQueue.getMaxAMResourcePerQueuePercent() * 1200.0f * 1024.0f), (double)1.0E-6);
        Assert.assertEquals((double)1228800.0, (double)user0LeafQueue.getEffectiveMaxCapacityDown("", user0LeafQueue.getMinimumAllocation()).getMemorySize(), (double)1.0E-6);
    }

    @Test
    public void testAutoQueueCreationMaxAppUpdate() throws Exception {
        this.startScheduler();
        LeafQueue a1 = (LeafQueue)this.cs.getQueue("root.a.a1");
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((float)((float)this.csConf.getMaximumSystemApplications() * a1.getAbsoluteCapacity()), (float)a1.getMaxApplications(), (float)1.0f);
        LeafQueue b = (LeafQueue)this.cs.getQueue("root.b");
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((float)((float)this.csConf.getMaximumSystemApplications() * b.getAbsoluteCapacity()), (float)b.getMaxApplications(), (float)1.0f);
        this.createQueue("root.e");
        LeafQueue e = (LeafQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((float)((float)this.csConf.getMaximumSystemApplications() * e.getAbsoluteCapacity()), (float)e.getMaxApplications(), (float)1.0f);
        a1 = (LeafQueue)this.cs.getQueue("root.a.a1");
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((float)((float)this.csConf.getMaximumSystemApplications() * a1.getAbsoluteCapacity()), (float)a1.getMaxApplications(), (float)1.0f);
        b = (LeafQueue)this.cs.getQueue("root.b");
        Assert.assertNotNull((Object)b);
        Assert.assertEquals((float)((float)this.csConf.getMaximumSystemApplications() * b.getAbsoluteCapacity()), (float)b.getMaxApplications(), (float)1.0f);
        this.csConf.setGlobalMaximumApplicationsPerQueue(1000);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((long)1000L, (long)b.getMaxApplications());
        Assert.assertEquals((long)1000L, (long)a1.getMaxApplications());
        Assert.assertEquals((long)1000L, (long)e.getMaxApplications());
        this.csConf.setMaximumApplicationsPerQueue(new QueuePath("root.e1"), 50);
        this.createQueue("root.e1");
        LeafQueue e1 = (LeafQueue)this.cs.getQueue("root.e1");
        Assert.assertNotNull((Object)e1);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((long)50L, (long)e1.getMaxApplications());
    }

    @Test(expected=SchedulerDynamicEditException.class)
    public void testAutoCreateQueueWithAmbiguousNonFullPathParentName() throws Exception {
        this.startScheduler();
        this.createQueue("root.a.a");
        this.createQueue("a.a");
    }

    @Test
    public void testAutoCreateQueueIfFirstExistingParentQueueIsNotStatic() throws Exception {
        this.startScheduler();
        this.createQueue("root.a.a-parent-auto.a1-leaf-auto");
        Assert.assertNotNull((Object)this.cs.getQueue("root.a.a-parent-auto"));
        this.createQueue("root.a.a-parent-auto.a2-leaf-auto");
        CSQueue a2Leaf = this.cs.getQueue("a2-leaf-auto");
        Assert.assertEquals((Object)"root.a.a-parent-auto", (Object)a2Leaf.getParent().getQueuePath());
    }

    @Test
    public void testAutoCreateQueueIfAmbiguousQueueNames() throws Exception {
        this.startScheduler();
        AbstractCSQueue b = (AbstractCSQueue)this.cs.getQueue("root.b");
        Assert.assertFalse((boolean)b.isDynamicQueue());
        this.createQueue("root.a.b.b");
        AbstractCSQueue bAutoParent = (AbstractCSQueue)this.cs.getQueue("root.a.b");
        Assert.assertTrue((boolean)bAutoParent.isDynamicQueue());
        Assert.assertTrue((boolean)bAutoParent.hasChildQueues());
        AbstractCSQueue bAutoLeafQueue = (AbstractCSQueue)this.cs.getQueue("root.a.b.b");
        Assert.assertTrue((boolean)bAutoLeafQueue.isDynamicQueue());
        Assert.assertFalse((boolean)bAutoLeafQueue.hasChildQueues());
    }

    @Test
    public void testAutoCreateQueueMaxQueuesLimit() throws Exception {
        this.startScheduler();
        this.csConf.setAutoCreatedQueuesV2MaxChildQueuesLimit(E, 5);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        for (int i = 0; i < 5; ++i) {
            this.createQueue("root.e.q_" + i);
        }
        try {
            this.createQueue("root.e.q_6");
            Assert.fail((String)"Can't exceed max queue limit.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof SchedulerDynamicEditException));
        }
    }

    @Test
    public void testAutoCreatedQueueTemplateConfig() throws Exception {
        this.startScheduler();
        QueuePath childQueuesOfA = new QueuePath("root.a.*");
        QueuePath aQueuePath = new QueuePath("root.a");
        QueuePath cQueuePath = new QueuePath("root.c");
        this.csConf.set(AutoCreatedQueueTemplate.getAutoQueueTemplatePrefix((QueuePath)childQueuesOfA) + "capacity", "6w");
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        AbstractLeafQueue a2 = this.createQueue("root.a.a-auto.a2");
        Assert.assertEquals((String)"weight is not set by template", (double)6.0, (double)a2.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((String)"user limit factor should be disabled with dynamic queues", (double)-1.0, (double)a2.getUserLimitFactor(), (double)1.0E-6);
        Assert.assertEquals((String)"maximum AM resource percent should be 1 with dynamic queues", (double)1.0, (double)a2.getMaxAMResourcePerQueuePercent(), (double)1.0E-6);
        this.csConf.set(AutoCreatedQueueTemplate.getAutoQueueTemplatePrefix((QueuePath)childQueuesOfA) + "user-limit-factor", "10");
        this.csConf.set(AutoCreatedQueueTemplate.getAutoQueueTemplatePrefix((QueuePath)childQueuesOfA) + "maximum-am-resource-percent", "0.8");
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        a2 = (LeafQueue)this.cs.getQueue("root.a.a-auto.a2");
        Assert.assertEquals((String)"weight is overridden", (double)6.0, (double)a2.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((String)"user limit factor should be modified by templates", (double)10.0, (double)a2.getUserLimitFactor(), (double)1.0E-6);
        Assert.assertEquals((String)"maximum AM resource percent should be modified by templates", (double)0.8f, (double)a2.getMaxAMResourcePerQueuePercent(), (double)1.0E-6);
        this.csConf.setNonLabeledQueueWeight(new QueuePath("root.a.a-auto.a2"), 4.0f);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((String)"weight is not explicitly set", (double)4.0, (double)a2.getQueueCapacities().getWeight(), (double)1.0E-6);
        this.csConf.setBoolean(AutoCreatedQueueTemplate.getAutoQueueTemplatePrefix((QueuePath)aQueuePath) + "auto-queue-creation-v2.queue-auto-removal.enable", false);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        AbstractLeafQueue a3 = this.createQueue("root.a.a3");
        Assert.assertFalse((String)"auto queue deletion should be turned off on a3", (boolean)a3.isEligibleForAutoDeletion());
        this.csConf.set(AutoCreatedQueueTemplate.getAutoQueueTemplatePrefix((QueuePath)cQueuePath) + "accessible-node-labels.TEST.capacity", "6w");
        this.csConf.setQueues(ROOT, new String[]{"a", "b", "c"});
        this.csConf.setAutoQueueCreationV2Enabled(C, true);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        AbstractLeafQueue c1 = this.createQueue("root.c.c1");
        Assert.assertEquals((String)"weight is not set for label TEST", (double)6.0, (double)c1.getQueueCapacities().getWeight("TEST"), (double)1.0E-6);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        c1 = (AbstractLeafQueue)this.cs.getQueue("root.c.c1");
        Assert.assertEquals((String)"weight is not set for label TEST", (double)6.0, (double)c1.getQueueCapacities().getWeight("TEST"), (double)1.0E-6);
    }

    @Test
    public void testAutoCreatedQueueConfigChange() throws Exception {
        this.startScheduler();
        AbstractLeafQueue a2 = this.createQueue("root.a.a-auto.a2");
        this.csConf.setNonLabeledQueueWeight(a2.getQueuePathObject(), 4.0f);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((String)"weight is not explicitly set", (double)4.0, (double)a2.getQueueCapacities().getWeight(), (double)1.0E-6);
        a2 = (AbstractLeafQueue)this.cs.getQueue("root.a.a-auto.a2");
        this.csConf.setState(A_A_AUTO_A2, QueueState.STOPPED);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((String)"root.a.a-auto.a2 has not been stopped", (Object)QueueState.STOPPED, (Object)a2.getState());
        this.csConf.setState(A_A_AUTO_A2, QueueState.RUNNING);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((String)"root.a.a-auto.a2 is not running", (Object)QueueState.RUNNING, (Object)a2.getState());
    }

    @Test
    public void testAutoCreateQueueState() throws Exception {
        this.startScheduler();
        this.createQueue("root.e.e1");
        this.csConf.setState(E, QueueState.STOPPED);
        this.csConf.setState(E_E1, QueueState.STOPPED);
        this.csConf.setState(A, QueueState.STOPPED);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((Object)this.cs.getQueue("root.a").getState(), (Object)QueueState.STOPPED);
        Assert.assertEquals((Object)this.cs.getQueue("root.a.a1").getState(), (Object)QueueState.STOPPED);
        Assert.assertEquals((Object)this.cs.getQueue("root.e").getState(), (Object)QueueState.STOPPED);
        Assert.assertEquals((Object)this.cs.getQueue("root.e.e1").getState(), (Object)QueueState.STOPPED);
        this.csConf.setState(E, QueueState.RUNNING);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((Object)this.cs.getQueue("root.e.e1").getState(), (Object)QueueState.STOPPED);
        this.csConf.setState(E_E1, QueueState.RUNNING);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        Assert.assertEquals((Object)this.cs.getQueue("root.e.e1").getState(), (Object)QueueState.RUNNING);
    }

    @Test
    public void testAutoQueueCreationDepthLimitFromStaticParent() throws Exception {
        this.startScheduler();
        this.createQueue("root.a.a-auto.a1-auto");
        Assert.assertNotNull((Object)this.cs.getQueue("root.a.a-auto.a1-auto"));
        try {
            this.createQueue("root.a.a-auto.a2-auto.a3-auto");
            Assert.fail((String)"Queue creation should not succeed because the distance from the first static parent is above limit");
        }
        catch (SchedulerDynamicEditException schedulerDynamicEditException) {
            // empty catch block
        }
    }

    @Test
    public void testCapacitySchedulerAutoQueueDeletion() throws Exception {
        this.startScheduler();
        this.csConf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        this.csConf.set("yarn.resourcemanager.scheduler.monitor.policies", AutoCreatedQueueDeletionPolicy.class.getCanonicalName());
        this.csConf.setAutoExpiredDeletionTime(1L);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        HashSet<String> policies = new HashSet<String>();
        policies.add(AutoCreatedQueueDeletionPolicy.class.getCanonicalName());
        Assert.assertTrue((String)"No AutoCreatedQueueDeletionPolicy is present in running monitors", (boolean)this.cs.getSchedulingMonitorManager().isSameConfiguredPolicies(policies));
        ApplicationAttemptId a2App = this.submitApp(this.cs, "user_0", "a2-auto", "root.a.a1-auto");
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.a.a1-auto.a2-auto") != null, (long)100L, (long)2000L);
        AbstractCSQueue a1 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
        Assert.assertNotNull((String)"a1 is not present", (Object)a1);
        AbstractCSQueue a2 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
        Assert.assertNotNull((String)"a2 is not present", (Object)a2);
        Assert.assertTrue((String)"a2 is not a dynamic queue", (boolean)a2.isDynamicQueue());
        Assert.assertEquals((long)1L, (long)a2.getNumApplications());
        long l1 = a2.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l1) / 1000L;
            return duration > this.csConf.getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        a2 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
        Assert.assertNotNull((String)"a2 is not present", (Object)a2);
        AppAttemptRemovedSchedulerEvent event = new AppAttemptRemovedSchedulerEvent(a2App, RMAppAttemptState.FINISHED, false);
        this.cs.handle((SchedulerEvent)event);
        AppRemovedSchedulerEvent rEvent = new AppRemovedSchedulerEvent(a2App.getApplicationId(), RMAppState.FINISHED);
        this.cs.handle((SchedulerEvent)rEvent);
        Assert.assertEquals((long)0L, (long)a2.getNumApplications());
        GenericTestUtils.waitFor(() -> {
            AbstractCSQueue a2Tmp = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
            return a2Tmp == null;
        }, (long)100L, (long)3000L);
        a2 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
        Assert.assertNull((String)"a2 is not deleted", (Object)a2);
        a1 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
        Assert.assertNotNull((String)"a1 is not present", (Object)a1);
        GenericTestUtils.waitFor(() -> {
            AbstractCSQueue a1Tmp = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
            return a1Tmp == null;
        }, (long)100L, (long)3000L);
        a1 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
        Assert.assertNull((String)"a1 is not deleted", (Object)a1);
    }

    @Test
    public void testCapacitySchedulerAutoQueueDeletionDisabled() throws Exception {
        this.startScheduler();
        this.csConf.setAutoExpiredDeletionEnabled(A_A1_AUTO_A2_AUTO, false);
        this.csConf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        this.csConf.set("yarn.resourcemanager.scheduler.monitor.policies", AutoCreatedQueueDeletionPolicy.class.getCanonicalName());
        this.csConf.setAutoExpiredDeletionTime(1L);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        HashSet<String> policies = new HashSet<String>();
        policies.add(AutoCreatedQueueDeletionPolicy.class.getCanonicalName());
        Assert.assertTrue((String)"No AutoCreatedQueueDeletionPolicy is present in running monitors", (boolean)this.cs.getSchedulingMonitorManager().isSameConfiguredPolicies(policies));
        ApplicationAttemptId a2App = this.submitApp(this.cs, "user_0", "a2-auto", "root.a.a1-auto");
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.a.a1-auto.a2-auto") != null, (long)100L, (long)2000L);
        AbstractCSQueue a1 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
        Assert.assertNotNull((String)"a1 is not present", (Object)a1);
        AbstractCSQueue a2 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
        Assert.assertNotNull((String)"a2 is not present", (Object)a2);
        Assert.assertTrue((String)"a2 is not a dynamic queue", (boolean)a2.isDynamicQueue());
        AppAttemptRemovedSchedulerEvent event = new AppAttemptRemovedSchedulerEvent(a2App, RMAppAttemptState.FINISHED, false);
        this.cs.handle((SchedulerEvent)event);
        AppRemovedSchedulerEvent rEvent = new AppRemovedSchedulerEvent(a2App.getApplicationId(), RMAppState.FINISHED);
        this.cs.handle((SchedulerEvent)rEvent);
        Assert.assertEquals((long)0L, (long)a2.getNumApplications());
        long l1 = a2.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l1) / 1000L;
            return duration > this.csConf.getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        a1 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
        Assert.assertNotNull((String)"a1 is not present", (Object)a1);
        a2 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
        Assert.assertNotNull((String)"a2 is not present", (Object)a2);
        Assert.assertTrue((String)"a2 is not a dynamic queue", (boolean)a2.isDynamicQueue());
        this.csConf.setAutoExpiredDeletionEnabled(A_A1_AUTO_A2_AUTO, true);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        GenericTestUtils.waitFor(() -> {
            AbstractCSQueue a2Tmp = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
            return a2Tmp == null;
        }, (long)100L, (long)3000L);
        a2 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto.a2-auto");
        Assert.assertNull((String)"a2 is not deleted", (Object)a2);
        a1 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
        Assert.assertNotNull((String)"a1 is not present", (Object)a1);
        GenericTestUtils.waitFor(() -> {
            AbstractCSQueue a1Tmp = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
            return a1Tmp == null;
        }, (long)100L, (long)3000L);
        a1 = (AbstractCSQueue)this.cs.getQueue("root.a.a1-auto");
        Assert.assertNull((String)"a1 is not deleted", (Object)a1);
    }

    @Test
    public void testAutoCreateQueueAfterRemoval() throws Exception {
        this.startScheduler();
        this.createBasicQueueStructureAndValidate();
        CSQueue e1 = this.cs.getQueue("root.e-auto.e1-auto");
        Assert.assertEquals((double)0.2f, (double)e1.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)e1.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)245760L, (long)e1.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        this.cs.removeQueue(e1);
        CSQueue e = this.cs.getQueue("root.e-auto");
        Assert.assertEquals((double)0.2f, (double)e.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)e.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)245760L, (long)e.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        this.cs.removeQueue(e);
        CSQueue d = this.cs.getQueue("root.d-auto");
        Assert.assertEquals((double)0.25, (double)d.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)d.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)307200L, (long)d.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        this.cs.removeQueue(d);
        CSQueue c = this.cs.getQueue("root.c-auto");
        Assert.assertEquals((double)0.3333333432674408, (double)c.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)c.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)409600L, (long)c.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        this.cs.removeQueue(c);
        CSQueue b = this.cs.getQueue("root.b");
        Assert.assertEquals((double)0.5, (double)b.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)b.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)614400L, (long)b.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
        try {
            this.cs.removeQueue(b);
            Assert.fail((String)"Can't remove static queue b!");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof SchedulerDynamicEditException));
        }
        CSQueue a = this.cs.getQueue("root.a");
        Assert.assertEquals((double)0.5, (double)a.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)a.getQueueCapacities().getWeight(), (double)1.0E-6);
        Assert.assertEquals((long)614400L, (long)b.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize());
    }

    @Test
    public void testQueueInfoIfAmbiguousQueueNames() throws Exception {
        this.startScheduler();
        AbstractCSQueue b = (AbstractCSQueue)this.cs.getQueue("root.b");
        Assert.assertFalse((boolean)b.isDynamicQueue());
        Assert.assertEquals((Object)"root.b", (Object)b.getQueueInfo().getQueuePath());
        this.createQueue("root.a.b.b");
        AbstractCSQueue bAutoParent = (AbstractCSQueue)this.cs.getQueue("root.a.b");
        Assert.assertTrue((boolean)bAutoParent.isDynamicQueue());
        Assert.assertTrue((boolean)bAutoParent.hasChildQueues());
        Assert.assertEquals((Object)"root.a.b", (Object)bAutoParent.getQueueInfo().getQueuePath());
        AbstractCSQueue bAutoLeafQueue = (AbstractCSQueue)this.cs.getQueue("root.a.b.b");
        Assert.assertTrue((boolean)bAutoLeafQueue.isDynamicQueue());
        Assert.assertFalse((boolean)bAutoLeafQueue.hasChildQueues());
        Assert.assertEquals((Object)"root.a.b.b", (Object)bAutoLeafQueue.getQueueInfo().getQueuePath());
        Assert.assertEquals((Object)"b", (Object)b.getQueueInfo().getQueueName());
        Assert.assertEquals((Object)"b", (Object)bAutoParent.getQueueInfo().getQueueName());
        Assert.assertEquals((Object)"b", (Object)bAutoLeafQueue.getQueueInfo().getQueueName());
    }

    @Test
    public void testRemoveDanglingAutoCreatedQueuesOnReinit() throws Exception {
        this.startScheduler();
        this.createQueue("root.a.a-auto");
        AbstractCSQueue aAuto = (AbstractCSQueue)this.cs.getQueue("root.a.a-auto");
        Assert.assertTrue((boolean)aAuto.isDynamicQueue());
        this.csConf.setState(A, QueueState.STOPPED);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        aAuto = (AbstractCSQueue)this.cs.getQueue("root.a.a-auto");
        Assert.assertEquals((String)"root.a.a-auto is not in STOPPED state", (Object)QueueState.STOPPED, (Object)aAuto.getState());
        this.csConf.setQueues(ROOT, new String[]{"b"});
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        CSQueue aAutoNew = this.cs.getQueue("root.a.a-auto");
        Assert.assertNull((Object)aAutoNew);
        this.submitApp(this.cs, "user_0", "a-auto", "root.a");
        aAutoNew = this.cs.getQueue("root.a.a-auto");
        Assert.assertNotNull((Object)aAutoNew);
        this.csConf.setQueues(ROOT, new String[]{"a", "b"});
        this.csConf.setQueues(A, new String[]{"a1"});
        this.csConf.setAutoQueueCreationV2Enabled(A1, true);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        this.createQueue("root.a.a1.a1-auto");
        CSQueue a1Auto = this.cs.getQueue("root.a.a1.a1-auto");
        Assert.assertNotNull((String)"a1-auto should exist", (Object)a1Auto);
        this.csConf.setQueues(ROOT, new String[]{"b"});
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        a1Auto = this.cs.getQueue("root.a.a1.a1-auto");
        Assert.assertNull((String)"a1-auto has no parent and should not exist", (Object)a1Auto);
        this.csConf.setState(B, QueueState.STOPPED);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        this.csConf.setAutoQueueCreationV2Enabled(B, true);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        this.createQueue("root.b.b-auto-parent.b-auto-leaf");
        CSQueue bAutoParent = this.cs.getQueue("root.b.b-auto-parent");
        Assert.assertNotNull((String)"b-auto-parent should exist", (Object)bAutoParent);
        ParentQueue b = (ParentQueue)this.cs.getQueue("root.b");
        b.removeChildQueue(bAutoParent);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        bAutoParent = this.cs.getQueue("root.b.b-auto-parent");
        Assert.assertNull((String)"b-auto-parent should not exist ", (Object)bAutoParent);
        CSQueue bAutoLeaf = this.cs.getQueue("root.b.b-auto-parent.b-auto-leaf");
        Assert.assertNull((String)"b-auto-leaf should not exist when its dynamic parent is removed", (Object)bAutoLeaf);
    }

    @Test
    public void testParentQueueDynamicChildRemoval() throws Exception {
        this.startScheduler();
        this.createQueue("root.a.a-auto");
        this.createQueue("root.a.a-auto");
        AbstractCSQueue aAuto = (AbstractCSQueue)this.cs.getQueue("root.a.a-auto");
        Assert.assertTrue((boolean)aAuto.isDynamicQueue());
        ParentQueue a = (ParentQueue)this.cs.getQueue("root.a");
        this.createQueue("root.e.e1-auto");
        AbstractCSQueue eAuto = (AbstractCSQueue)this.cs.getQueue("root.e.e1-auto");
        Assert.assertTrue((boolean)eAuto.isDynamicQueue());
        ParentQueue e = (ParentQueue)this.cs.getQueue("root.e");
        try {
            a.removeChildQueue(this.cs.getQueue("root.a.a1"));
            Assert.fail((String)"root.a.a1 is a static queue and should not be removed at runtime");
        }
        catch (SchedulerDynamicEditException schedulerDynamicEditException) {
            // empty catch block
        }
        try {
            a.removeChildQueue((CSQueue)eAuto);
            Assert.fail((String)"root.a should not be able to remove root.e.e1-auto");
        }
        catch (SchedulerDynamicEditException schedulerDynamicEditException) {
            // empty catch block
        }
        a.removeChildQueue((CSQueue)aAuto);
        e.removeChildQueue((CSQueue)eAuto);
        aAuto = (AbstractCSQueue)this.cs.getQueue("root.a.a-auto");
        eAuto = (AbstractCSQueue)this.cs.getQueue("root.e.e1-auto");
        Assert.assertNull((String)"root.a.a-auto should have been removed", (Object)aAuto);
        Assert.assertNull((String)"root.e.e1-auto should have been removed", (Object)eAuto);
    }

    @Test
    public void testAutoCreateInvalidParent() throws Exception {
        this.startScheduler();
        Assert.assertThrows(SchedulerDynamicEditException.class, () -> this.createQueue("invalid.queue"));
        Assert.assertThrows(SchedulerDynamicEditException.class, () -> this.createQueue("invalid.queue.longer"));
        Assert.assertThrows(SchedulerDynamicEditException.class, () -> this.createQueue("invalidQueue"));
    }

    protected AbstractLeafQueue createQueue(String queuePath) throws YarnException, IOException {
        return this.autoQueueHandler.createQueue(new QueuePath(queuePath));
    }

    private void assertQueueMinResource(CSQueue queue, float expected) {
        Assert.assertEquals((double)Math.round(expected * 1024.0f), (double)queue.getQueueResourceQuotas().getEffectiveMinResource().getMemorySize(), (double)1.0E-6);
    }
}

