/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterators;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerTestUtilities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSorter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.MultiNodeSortingManager;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacitySchedulerMultiNodes {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacitySchedulerMultiNodes.class);
    private static final QueuePath DEFAULT = new QueuePath("root.default");
    private CapacitySchedulerConfiguration conf;
    private static final String POLICY_CLASS_NAME = "org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.ResourceUsageMultiNodeLookupPolicy";

    @Before
    public void setUp() {
        CapacitySchedulerConfiguration config = new CapacitySchedulerConfiguration();
        config.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        this.conf = new CapacitySchedulerConfiguration((Configuration)config);
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.set("yarn.scheduler.capacity.multi-node-sorting.policy.names", "resource-based");
        this.conf.set("yarn.scheduler.capacity.multi-node-sorting.policy", "resource-based");
        String policyName = "yarn.scheduler.capacity.multi-node-sorting.policy.resource-based.class";
        this.conf.set(policyName, POLICY_CLASS_NAME);
        this.conf.setBoolean("yarn.scheduler.capacity.multi-node-placement-enabled", true);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 512);
        this.conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
    }

    @Test
    public void testMultiNodeSorterForScheduling() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 10240);
        rm.registerNode("127.0.0.1:1235", 10240);
        rm.registerNode("127.0.0.1:1236", 10240);
        rm.registerNode("127.0.0.1:1237", 10240);
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        CapacitySchedulerTestUtilities.waitforNMRegistered(scheduler, 4, 5);
        MultiNodeSortingManager mns = rm.getRMContext().getMultiNodeSortingManager();
        MultiNodeSorter sorter = mns.getMultiNodePolicy(POLICY_CLASS_NAME);
        sorter.reSortClusterNodes();
        Set nodes = sorter.getMultiNodeLookupPolicy().getNodesPerPartition("");
        Assert.assertEquals((long)4L, (long)nodes.size());
        rm.stop();
    }

    @Test
    public void testMultiNodeSorterForSchedulingWithOrdering() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 10240, 10);
        MockNM nm2 = rm.registerNode("127.0.0.2:1235", 10240, 10);
        MockNM nm3 = rm.registerNode("127.0.0.3:1236", 10240, 10);
        MockNM nm4 = rm.registerNode("127.0.0.4:1237", 10240, 10);
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        CapacitySchedulerTestUtilities.waitforNMRegistered(scheduler, 4, 5);
        MultiNodeSortingManager mns = rm.getRMContext().getMultiNodeSortingManager();
        MultiNodeSorter sorter = mns.getMultiNodePolicy(POLICY_CLASS_NAME);
        sorter.reSortClusterNodes();
        Set nodes = sorter.getMultiNodeLookupPolicy().getNodesPerPartition("");
        Assert.assertEquals((long)4L, (long)nodes.size());
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).withAppName("app-1").withUser("user1").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        SchedulerNodeReport reportNm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)8192L, (long)reportNm1.getAvailableResource().getMemorySize());
        sorter.reSortClusterNodes();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app-2").withUser("user2").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        SchedulerNodeReport reportNm2 = rm.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)1024L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)9216L, (long)reportNm2.getAvailableResource().getMemorySize());
        sorter.reSortClusterNodes();
        nodes = sorter.getMultiNodeLookupPolicy().getNodesPerPartition("");
        ArrayList<NodeId> currentNodes = new ArrayList<NodeId>();
        currentNodes.add(nm3.getNodeId());
        currentNodes.add(nm4.getNodeId());
        currentNodes.add(nm2.getNodeId());
        currentNodes.add(nm1.getNodeId());
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            SchedulerNode current = (SchedulerNode)it.next();
            Assert.assertEquals((Object)current.getNodeID(), currentNodes.get(i++));
        }
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testExcessReservationWillBeUnreserved() throws Exception {
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        newConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        newConf.setInt("yarn.scheduler.capacity.multi-node-sorting.policy.resource-based.sorting-interval.ms", 0);
        newConf.setMaximumApplicationMasterResourcePerQueuePercent(DEFAULT, 1.0f);
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(5120L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(5120L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("default");
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        am1.allocate("*", 6144, 1, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        Assert.assertNotNull((Object)cs.getNode(nm2.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        am1.allocate("*", 6144, 0, new ArrayList<ContainerId>());
        am2.allocate("*", 2048, 1, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)schedulerApp1.getReservedContainers().size());
        Assert.assertEquals((long)2L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)7168L, (long)cs.getNode(nm1.getNodeId()).getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)12288L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved().getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved().getMemorySize());
        rm1.close();
    }

    @Test(timeout=30000L)
    public void testAllocateForReservedContainer() throws Exception {
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        newConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        newConf.setInt("yarn.scheduler.capacity.multi-node-sorting.policy.resource-based.sorting-interval.ms", 0);
        newConf.setMaximumApplicationMasterResourcePerQueuePercent(DEFAULT, 1.0f);
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(5120L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(5120L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        am2.allocate("*", 6144, 1, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertNotNull((Object)cs.getNode(nm2.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getReservedContainers().size());
        rm1.killApp(app1.getApplicationId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)2L, (long)schedulerApp2.getLiveContainers().size());
        rm1.close();
    }

    @Test(timeout=30000L)
    public void testAllocateOfReservedContainerFromAnotherNode() throws Exception {
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        newConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        newConf.setInt("yarn.scheduler.capacity.multi-node-sorting.policy.resource-based.sorting-interval.ms", 0);
        newConf.setMaximumApplicationMasterResourcePerQueuePercent(DEFAULT, 1.0f);
        final MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.start();
        final MockNM nm1 = rm1.registerNode("h1:1234", 12288, 2);
        MockNM nm2 = rm1.registerNode("h2:1234", 12288, 2);
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(8192L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(8192L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        final RMApp app3 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(8192L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        final AtomicBoolean result = new AtomicBoolean(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
                    result.set(true);
                }
                catch (Exception e) {
                    Assert.fail((String)"Failed to allocate the reserved container");
                }
            }
        };
        t.start();
        Thread.sleep(1000L);
        FiCaSchedulerApp schedulerApp = cs.getApplicationAttempt(app3.getCurrentAppAttempt().getAppAttemptId());
        Assert.assertEquals((String)"App3 failed to get reserved container", (long)1L, (long)schedulerApp.getReservedContainers().size());
        if (cs.getNode(rmNode1.getNodeID()).getReservedContainer() != null) {
            rm1.killApp(app2.getApplicationId());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        } else {
            rm1.killApp(app1.getApplicationId());
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        while (!result.get()) {
            Thread.sleep(100L);
        }
        schedulerApp = cs.getApplicationAttempt(app3.getCurrentAppAttempt().getAppAttemptId());
        Assert.assertEquals((String)"App3 failed to release Reserved container", (long)0L, (long)schedulerApp.getReservedContainers().size());
        Assert.assertNull((Object)cs.getNode(rmNode1.getNodeID()).getReservedContainer());
        Assert.assertNull((Object)cs.getNode(rmNode2.getNodeID()).getReservedContainer());
        rm1.close();
    }

    @Test
    public void testMultiNodeSorterAfterHeartbeatInterval() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 10240);
        rm.registerNode("127.0.0.2:1234", 10240);
        rm.registerNode("127.0.0.3:1234", 10240);
        rm.registerNode("127.0.0.4:1234", 10240);
        HashSet nodes = new HashSet();
        String partition = "";
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        CapacitySchedulerTestUtilities.waitforNMRegistered(scheduler, 4, 5);
        MultiNodeSortingManager mns = rm.getRMContext().getMultiNodeSortingManager();
        MultiNodeSorter sorter = mns.getMultiNodePolicy(POLICY_CLASS_NAME);
        sorter.reSortClusterNodes();
        Iterator nodeIterator = mns.getMultiNodeSortIterator(nodes, partition, POLICY_CLASS_NAME);
        Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)nodeIterator));
        Thread.sleep(3000L);
        nodeIterator = mns.getMultiNodeSortIterator(nodes, partition, POLICY_CLASS_NAME);
        Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)nodeIterator));
        rm.stop();
    }

    @Test(timeout=30000L)
    public void testSkipAllocationOnNodeReservedByAnotherApp() throws Exception {
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        newConf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        newConf.setInt("yarn.scheduler.capacity.multi-node-sorting.policy.resource-based.sorting-interval.ms", 0);
        newConf.setMaximumApplicationMasterResourcePerQueuePercent(DEFAULT, 1.0f);
        newConf.set("yarn.scheduler.capacity.skip-allocate-on-nodes-with-reserved-containers", "true");
        MockRM rm1 = new MockRM((Configuration)newConf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8192);
        MockNM nm2 = rm1.registerNode("127.0.0.2:1235", 8192);
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(5120L, rm1).withAppName("app").withUser("user").withQueue("default").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(5120L, rm1).withAppName("app").withUser("user").withQueue("default").build());
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Set<RMNode> reservedContainers = TestCapacitySchedulerMultiNodes.checkReservedContainers(cs, rm1.getRMContext().getRMNodes(), 1);
        Assert.assertEquals((long)1L, (long)reservedContainers.size());
        RMNode nodeWithReservedContainer = reservedContainers.iterator().next();
        LOG.debug("Reserved container on: {}", (Object)nodeWithReservedContainer);
        if (nodeWithReservedContainer.getNodeID().getHost().startsWith("127.0.0.2")) {
            TestCapacitySchedulerMultiNodes.moveReservation(cs, rm1, nm1, nm2, am1);
        }
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertNull((Object)cs.getNode(nm2.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        MockNM nm3 = rm1.registerNode("127.0.0.3:1235", 3072);
        am2.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertNotNull((Object)cs.getNode(nm2.getNodeId()).getReservedContainer());
        rm1.close();
    }

    private static void moveReservation(CapacityScheduler cs, MockRM rm1, MockNM nm1, MockNM nm2, MockAM am1) {
        FiCaSchedulerApp firstSchedulerAppAttempt;
        RMNode sourceNode = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        RMNode targetNode = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp app = firstSchedulerAppAttempt = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        RMContainer reservedContainer = cs.getNode(sourceNode.getNodeID()).getReservedContainer();
        LOG.debug("Moving reservation");
        app.moveReservation(reservedContainer, cs.getNode(sourceNode.getNodeID()), cs.getNode(targetNode.getNodeID()));
    }

    private static Set<RMNode> checkReservedContainers(CapacityScheduler cs, ConcurrentMap<NodeId, RMNode> rmNodes, int expectedNumberOfContainers) {
        HashSet<RMNode> result = new HashSet<RMNode>();
        for (Map.Entry entry : rmNodes.entrySet()) {
            if (cs.getNode((NodeId)entry.getKey()).getReservedContainer() == null) continue;
            result.add((RMNode)entry.getValue());
        }
        Assert.assertEquals((long)expectedNumberOfContainers, (long)result.size());
        return result;
    }
}

