/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueHelpers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacitySchedulerDynamicBehavior {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacitySchedulerDynamicBehavior.class);
    private int GB = 1024;
    private MockRM rm;

    @Before
    public void setUp() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        this.setupPlanQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.reservation-system.enable", false);
        this.rm = new MockRM((Configuration)conf);
        this.rm.start();
        this.rm.registerNode("n1:1234", 64 * this.GB, 64);
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testRefreshQueuesWithReservations() throws Exception {
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        ((ReservationQueue)cs.getQueue("a-default")).setEntitlement(new QueueEntitlement(0.0f, 1.0f));
        ReservationQueue a1 = new ReservationQueue(cs.getQueueContext(), "a1", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a1);
        a1.setEntitlement(new QueueEntitlement(0.3f, 1.0f));
        ReservationQueue a2 = new ReservationQueue(cs.getQueueContext(), "a2", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a2);
        cs.setEntitlement("a2", new QueueEntitlement(0.7f, 1.0f));
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        CapacitySchedulerConfiguration conf = cs.getConfiguration();
        conf.setCapacity(CapacitySchedulerQueueHelpers.A, 80.0f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.B, 20.0f);
        cs.reinitialize((Configuration)conf, this.rm.getRMContext());
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs, CapacitySchedulerQueueHelpers.getDefaultCapacities(0.8f, 0.2f));
    }

    @Test
    public void testAddQueueFailCases() throws Exception {
        ReservationQueue a12;
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        try {
            a12 = new ReservationQueue(cs.getQueueContext(), "a1", (PlanQueue)cs.getQueue("a"));
            a12.setEntitlement(new QueueEntitlement(0.3f, 1.0f));
            cs.addQueue((Queue)a12);
            Assert.fail();
        }
        catch (Exception a12) {
            // empty catch block
        }
        a12 = new ReservationQueue(cs.getQueueContext(), "a1", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a12);
        ((ReservationQueue)cs.getQueue("a-default")).setEntitlement(new QueueEntitlement(0.0f, 1.0f));
        a12.setEntitlement(new QueueEntitlement(0.3f, 1.0f));
        ReservationQueue a2 = new ReservationQueue(cs.getQueueContext(), "a2", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a2);
        try {
            cs.setEntitlement("a2", new QueueEntitlement(0.8f, 1.0f));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        cs.setEntitlement("a2", new QueueEntitlement(0.7f, 1.0f));
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs);
        cs.stop();
    }

    @Test
    public void testRemoveQueue() throws Exception {
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        ReservationQueue a1 = new ReservationQueue(cs.getQueueContext(), "a1", (PlanQueue)cs.getQueue("a"));
        cs.addQueue((Queue)a1);
        a1.setEntitlement(new QueueEntitlement(0.3f, 1.0f));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(this.GB, this.rm).withAppName("test-move-1").withUser("user_0").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(this.rm, data);
        List appsInA1 = cs.getAppsInQueue("a1");
        Assert.assertEquals((long)1L, (long)appsInA1.size());
        try {
            cs.removeQueue("a1");
            Assert.fail();
        }
        catch (SchedulerDynamicEditException schedulerDynamicEditException) {
            // empty catch block
        }
        cs.killAllAppsInQueue("a1");
        this.rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        try {
            cs.removeQueue("a1");
            Assert.fail();
        }
        catch (SchedulerDynamicEditException schedulerDynamicEditException) {
            // empty catch block
        }
        cs.setEntitlement("a1", new QueueEntitlement(0.0f, 0.0f));
        cs.removeQueue("a1");
        Assert.assertTrue((cs.getQueue("a1") == null ? 1 : 0) != 0);
    }

    @Test
    public void testMoveAppToPlanQueue() throws Exception {
        CapacityScheduler scheduler = (CapacityScheduler)this.rm.getResourceScheduler();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(this.GB, this.rm).withAppName("test-move-1").withUser("user_0").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(this.rm, data);
        ApplicationAttemptId appAttemptId = this.rm.getApplicationReport(app.getApplicationId()).getCurrentApplicationAttemptId();
        List appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertEquals((long)1L, (long)appsInB1.size());
        List appsInB = scheduler.getAppsInQueue("b");
        Assert.assertEquals((long)1L, (long)appsInB.size());
        Assert.assertTrue((boolean)appsInB.contains(appAttemptId));
        List appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.isEmpty());
        String queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInB1.get(0)).getQueue().getQueueName();
        Assert.assertEquals((Object)"b1", (Object)queue);
        List appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        String defQName = "a-default";
        ReservationQueue defQ = new ReservationQueue(scheduler.getQueueContext(), defQName, (PlanQueue)scheduler.getQueue("a"));
        scheduler.addQueue((Queue)defQ);
        defQ.setEntitlement(new QueueEntitlement(1.0f, 1.0f));
        List appsInDefQ = scheduler.getAppsInQueue(defQName);
        Assert.assertTrue((boolean)appsInDefQ.isEmpty());
        scheduler.moveApplication(app.getApplicationId(), "a");
        appsInDefQ = scheduler.getAppsInQueue(defQName);
        Assert.assertEquals((long)1L, (long)appsInDefQ.size());
        queue = scheduler.getApplicationAttempt((ApplicationAttemptId)appsInDefQ.get(0)).getQueue().getQueueName();
        Assert.assertTrue((boolean)queue.equals(defQName));
        appsInA = scheduler.getAppsInQueue("a");
        Assert.assertTrue((boolean)appsInA.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInA.size());
        appsInRoot = scheduler.getAppsInQueue("root");
        Assert.assertTrue((boolean)appsInRoot.contains(appAttemptId));
        Assert.assertEquals((long)1L, (long)appsInRoot.size());
        appsInB1 = scheduler.getAppsInQueue("b1");
        Assert.assertTrue((boolean)appsInB1.isEmpty());
        appsInB = scheduler.getAppsInQueue("b");
        Assert.assertTrue((boolean)appsInB.isEmpty());
    }

    private void setupPlanQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(CapacitySchedulerQueueHelpers.ROOT, new String[]{"a", "b"});
        conf.setCapacity(CapacitySchedulerQueueHelpers.A, 10.5f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.B, 89.5f);
        conf.setQueues(CapacitySchedulerQueueHelpers.B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(CapacitySchedulerQueueHelpers.B1, 79.2f);
        conf.setUserLimitFactor(CapacitySchedulerQueueHelpers.B1, 100.0f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.B2, 0.8f);
        conf.setUserLimitFactor(CapacitySchedulerQueueHelpers.B2, 100.0f);
        conf.setCapacity(CapacitySchedulerQueueHelpers.B3, 20.0f);
        conf.setUserLimitFactor(CapacitySchedulerQueueHelpers.B3, 100.0f);
        conf.setReservable(CapacitySchedulerQueueHelpers.A, true);
        conf.setReservationWindow(CapacitySchedulerQueueHelpers.A, 86400000L);
        conf.setAverageCapacity(CapacitySchedulerQueueHelpers.A, 1.0f);
        LOG.info("Setup a as a plan queue");
    }
}

