/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacitySchedulerConfiguration {
    private static final String ROOT_TEST_PATH = "root.test";
    private static final QueuePath ROOT_TEST = new QueuePath("root.test");
    private static final QueuePath ROOT = new QueuePath("root");
    private static final String EMPTY_ACL = "";
    private static final String SPACE_ACL = " ";
    private static final String USER1 = "user1";
    private static final String USER2 = "user2";
    private static final String GROUP1 = "group1";
    private static final String GROUP2 = "group2";
    public static final String ONE_USER_ONE_GROUP_ACL = "user1 group1";
    public static final String TWO_USERS_TWO_GROUPS_ACL = "user1,user2 group1, group2";

    private CapacitySchedulerConfiguration createDefaultCsConf() {
        return new CapacitySchedulerConfiguration(new Configuration(false), false);
    }

    private AccessControlList getSubmitAcl(CapacitySchedulerConfiguration csConf, QueuePath queue) {
        return csConf.getAcl(queue, QueueACL.SUBMIT_APPLICATIONS);
    }

    private void setSubmitAppsConfig(CapacitySchedulerConfiguration csConf, QueuePath queue, String value) {
        csConf.set(this.getSubmitAppsConfigKey(queue), value);
    }

    private String getSubmitAppsConfigKey(QueuePath queue) {
        return QueuePrefixes.getQueuePrefix((QueuePath)queue) + "acl_submit_applications";
    }

    private void testWithGivenAclNoOneHasAccess(QueuePath queue, String aclValue) {
        this.testWithGivenAclNoOneHasAccessInternal(queue, queue, aclValue);
    }

    private void testWithGivenAclNoOneHasAccess(QueuePath queueToSet, QueuePath queueToVerify, String aclValue) {
        this.testWithGivenAclNoOneHasAccessInternal(queueToSet, queueToVerify, aclValue);
    }

    private void testWithGivenAclNoOneHasAccessInternal(QueuePath queueToSet, QueuePath queueToVerify, String aclValue) {
        CapacitySchedulerConfiguration csConf = this.createDefaultCsConf();
        this.setSubmitAppsConfig(csConf, queueToSet, aclValue);
        AccessControlList acl = this.getSubmitAcl(csConf, queueToVerify);
        Assert.assertTrue((boolean)acl.getUsers().isEmpty());
        Assert.assertTrue((boolean)acl.getGroups().isEmpty());
        Assert.assertFalse((boolean)acl.isAllAllowed());
    }

    private void testWithGivenAclCorrectUserAndGroupHasAccess(QueuePath queue, String aclValue, Set<String> expectedUsers, Set<String> expectedGroups) {
        this.testWithGivenAclCorrectUserAndGroupHasAccessInternal(queue, queue, aclValue, expectedUsers, expectedGroups);
    }

    private void testWithGivenAclCorrectUserAndGroupHasAccessInternal(QueuePath queueToSet, QueuePath queueToVerify, String aclValue, Set<String> expectedUsers, Set<String> expectedGroups) {
        CapacitySchedulerConfiguration csConf = this.createDefaultCsConf();
        this.setSubmitAppsConfig(csConf, queueToSet, aclValue);
        AccessControlList acl = this.getSubmitAcl(csConf, queueToVerify);
        Assert.assertFalse((boolean)acl.getUsers().isEmpty());
        Assert.assertFalse((boolean)acl.getGroups().isEmpty());
        Assert.assertEquals(expectedUsers, (Object)acl.getUsers());
        Assert.assertEquals(expectedGroups, (Object)acl.getGroups());
        Assert.assertFalse((boolean)acl.isAllAllowed());
    }

    @Test
    public void testDefaultSubmitACLForRootAllAllowed() {
        CapacitySchedulerConfiguration csConf = this.createDefaultCsConf();
        AccessControlList acl = this.getSubmitAcl(csConf, ROOT);
        Assert.assertTrue((boolean)acl.getUsers().isEmpty());
        Assert.assertTrue((boolean)acl.getGroups().isEmpty());
        Assert.assertTrue((boolean)acl.isAllAllowed());
    }

    @Test
    public void testDefaultSubmitACLForRootChildNoneAllowed() {
        CapacitySchedulerConfiguration csConf = this.createDefaultCsConf();
        AccessControlList acl = this.getSubmitAcl(csConf, ROOT_TEST);
        Assert.assertTrue((boolean)acl.getUsers().isEmpty());
        Assert.assertTrue((boolean)acl.getGroups().isEmpty());
        Assert.assertFalse((boolean)acl.isAllAllowed());
    }

    @Test
    public void testSpecifiedEmptySubmitACLForRoot() {
        this.testWithGivenAclNoOneHasAccess(ROOT, EMPTY_ACL);
    }

    @Test
    public void testSpecifiedEmptySubmitACLForRootIsNotInherited() {
        this.testWithGivenAclNoOneHasAccess(ROOT, ROOT_TEST, EMPTY_ACL);
    }

    @Test
    public void testSpecifiedSpaceSubmitACLForRoot() {
        this.testWithGivenAclNoOneHasAccess(ROOT, SPACE_ACL);
    }

    @Test
    public void testSpecifiedSpaceSubmitACLForRootIsNotInherited() {
        this.testWithGivenAclNoOneHasAccess(ROOT, ROOT_TEST, SPACE_ACL);
    }

    @Test
    public void testSpecifiedSubmitACLForRoot() {
        HashSet expectedUsers = Sets.newHashSet((Object[])new String[]{USER1});
        HashSet expectedGroups = Sets.newHashSet((Object[])new String[]{GROUP1});
        this.testWithGivenAclCorrectUserAndGroupHasAccess(ROOT, ONE_USER_ONE_GROUP_ACL, expectedUsers, expectedGroups);
    }

    @Test
    public void testSpecifiedSubmitACLForRootIsNotInherited() {
        this.testWithGivenAclNoOneHasAccess(ROOT, ROOT_TEST, ONE_USER_ONE_GROUP_ACL);
    }

    @Test
    public void testSpecifiedSubmitACLTwoUsersTwoGroupsForRoot() {
        HashSet expectedUsers = Sets.newHashSet((Object[])new String[]{USER1, USER2});
        HashSet expectedGroups = Sets.newHashSet((Object[])new String[]{GROUP1, GROUP2});
        this.testWithGivenAclCorrectUserAndGroupHasAccess(ROOT, TWO_USERS_TWO_GROUPS_ACL, expectedUsers, expectedGroups);
    }
}

