/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerSurgicalPreemption;
import org.junit.Before;
import org.junit.Test;

public class TestCapacitySchedulerAutoCreatedQueuePreemption
extends TestCapacitySchedulerSurgicalPreemption {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public static CapacitySchedulerConfiguration setupQueueConfigurationForSimpleSurgicalPreemption(CapacitySchedulerConfiguration conf) {
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "c", true, new int[]{1, 2});
        conf.setQueues(TestCapacitySchedulerAutoCreatedQueueBase.ROOT, new String[]{"c"});
        conf.setCapacity(TestCapacitySchedulerAutoCreatedQueueBase.C, 100.0f);
        conf.setUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.C, 1.0f);
        conf.setAutoCreateChildQueueEnabled(TestCapacitySchedulerAutoCreatedQueueBase.C, true);
        conf.setAutoCreatedLeafQueueConfigCapacity(TestCapacitySchedulerAutoCreatedQueueBase.C, 30.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(TestCapacitySchedulerAutoCreatedQueueBase.C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(TestCapacitySchedulerAutoCreatedQueueBase.C, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.C, 3.0f);
        return conf;
    }

    protected CapacitySchedulerConfiguration setupQueueConfigurationForPriorityBasedPreemption(CapacitySchedulerConfiguration conf) {
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "c", true, new int[]{1, 2});
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "d", true, new int[]{3, 4});
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, "e", true, new int[]{0});
        conf.setQueues(TestCapacitySchedulerAutoCreatedQueueBase.ROOT, new String[]{"c", "d", "e"});
        conf.setCapacity(TestCapacitySchedulerAutoCreatedQueueBase.C, 45.0f);
        conf.setCapacity(TestCapacitySchedulerAutoCreatedQueueBase.D, 45.0f);
        conf.setCapacity(TestCapacitySchedulerAutoCreatedQueueBase.E, 10.0f);
        conf.setUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.E, 3.0f);
        conf.setUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.C, 3.0f);
        conf.setUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.D, 3.0f);
        conf.setAutoCreateChildQueueEnabled(TestCapacitySchedulerAutoCreatedQueueBase.C, true);
        conf.setAutoCreateChildQueueEnabled(TestCapacitySchedulerAutoCreatedQueueBase.D, true);
        conf.setAutoCreateChildQueueEnabled(TestCapacitySchedulerAutoCreatedQueueBase.E, true);
        conf.setAutoCreatedLeafQueueConfigCapacity(TestCapacitySchedulerAutoCreatedQueueBase.C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(TestCapacitySchedulerAutoCreatedQueueBase.C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(TestCapacitySchedulerAutoCreatedQueueBase.C, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.C, 3.0f);
        conf.setAutoCreatedLeafQueueConfigCapacity(TestCapacitySchedulerAutoCreatedQueueBase.D, 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(TestCapacitySchedulerAutoCreatedQueueBase.D, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(TestCapacitySchedulerAutoCreatedQueueBase.D, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.D, 3.0f);
        conf.setAutoCreatedLeafQueueConfigCapacity(TestCapacitySchedulerAutoCreatedQueueBase.E, 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(TestCapacitySchedulerAutoCreatedQueueBase.E, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(TestCapacitySchedulerAutoCreatedQueueBase.E, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(TestCapacitySchedulerAutoCreatedQueueBase.E, 3.0f);
        conf.setQueuePriority(TestCapacitySchedulerAutoCreatedQueueBase.C, 1);
        conf.setQueuePriority(TestCapacitySchedulerAutoCreatedQueueBase.D, 2);
        return conf;
    }

    @Test(timeout=60000L)
    public void testSimpleSurgicalPreemptionOnAutoCreatedLeafQueues() throws Exception {
        TestCapacitySchedulerAutoCreatedQueuePreemption.setupQueueConfigurationForSimpleSurgicalPreemption(this.conf);
        this.testSimpleSurgicalPreemption("user_1", "user_2", "user_1", "user_2");
    }

    @Test(timeout=600000L)
    public void testPreemptionFromHighestPriorityManagedParentQueueAndOldestContainer() throws Exception {
        this.setupQueueConfigurationForPriorityBasedPreemption(this.conf);
        this.testPriorityPreemptionFromHighestPriorityQueueAndOldestContainer(new String[]{"user_1", "user_3", "user_0"}, new String[]{"user_1", "user_3", "user_0"});
    }
}

