/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.TestGroupsCaching;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.GuaranteedOrZeroCapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCapacitySchedulerAutoCreatedQueueBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestCapacitySchedulerAutoCreatedQueueBase.class);
    public static final int GB = 1024;
    public static final ContainerUpdates NULL_UPDATE_REQUESTS = new ContainerUpdates();
    public static final String DEFAULT_PATH = "root.default";
    public static final String A_PATH = "root.a";
    public static final String B_PATH = "root.b";
    public static final String C_PATH = "root.c";
    public static final String D_PATH = "root.d";
    public static final String E_PATH = "root.e";
    public static final QueuePath ROOT = new QueuePath("root");
    public static final QueuePath DEFAULT = new QueuePath("root.default");
    public static final QueuePath A = new QueuePath("root.a");
    public static final QueuePath B = new QueuePath("root.b");
    public static final QueuePath C = new QueuePath("root.c");
    public static final QueuePath D = new QueuePath("root.d");
    public static final QueuePath E = new QueuePath("root.e");
    public static final String ESUBGROUP1_PATH = "root.esubgroup1";
    public static final String FGROUP_PATH = "root.fgroup";
    public static final String A1_PATH = "root.a.a1";
    public static final String A2_PATH = "root.a.a2";
    public static final String B1_PATH = "root.b.b1";
    public static final String B2_PATH = "root.b.b2";
    public static final String B3_PATH = "root.b.b3";
    public static final String B4_PATH = "root.b.b4subgroup1";
    public static final String ESUBGROUP1_A_PATH = "root.esubgroup1.e";
    public static final String FGROUP_F_PATH = "root.fgroup.f";
    public static final QueuePath A1 = new QueuePath("root.a.a1");
    public static final QueuePath A2 = new QueuePath("root.a.a2");
    public static final QueuePath B1 = new QueuePath("root.b.b1");
    public static final QueuePath B2 = new QueuePath("root.b.b2");
    public static final QueuePath B3 = new QueuePath("root.b.b3");
    public static final QueuePath B4 = new QueuePath("root.b.b4subgroup1");
    public static final QueuePath E_GROUP = new QueuePath("root.esubgroup1");
    public static final QueuePath F_GROUP = new QueuePath("root.fgroup");
    public static final QueuePath E_SG = new QueuePath("root.esubgroup1.e");
    public static final QueuePath F_SG = new QueuePath("root.fgroup.f");
    public static final float A_CAPACITY = 20.0f;
    public static final float B_CAPACITY = 20.0f;
    public static final float C_CAPACITY = 20.0f;
    public static final float D_CAPACITY = 20.0f;
    public static final float ESUBGROUP1_CAPACITY = 10.0f;
    public static final float FGROUP_CAPACITY = 10.0f;
    public static final float A1_CAPACITY = 30.0f;
    public static final float A2_CAPACITY = 70.0f;
    public static final float B1_CAPACITY = 60.0f;
    public static final float B2_CAPACITY = 20.0f;
    public static final float B3_CAPACITY = 10.0f;
    public static final float B4_CAPACITY = 10.0f;
    public static final int NODE_MEMORY = 16;
    public static final int NODE1_VCORES = 16;
    public static final int NODE2_VCORES = 32;
    public static final int NODE3_VCORES = 48;
    public static final String TEST_GROUP = "testusergroup";
    public static final String TEST_GROUPUSER = "testuser";
    public static final String TEST_GROUP1 = "testusergroup1";
    public static final String TEST_GROUPUSER1 = "testuser1";
    public static final String TEST_GROUP2 = "testusergroup2";
    public static final String TEST_GROUPUSER2 = "testuser2";
    public static final String USER = "user_";
    public static final String USER0 = "user_0";
    public static final String USER1 = "user_1";
    public static final String USER2 = "user_2";
    public static final String USER3 = "user_3";
    public static final String PARENT_QUEUE = "c";
    public static final QueuePath PARENT_QUEUE_PATH = new QueuePath("c");
    public static final Set<String> accessibleNodeLabelsOnC = new HashSet<String>();
    public static final String NODEL_LABEL_GPU = "GPU";
    public static final String NODEL_LABEL_SSD = "SSD";
    public static final float NODE_LABEL_GPU_TEMPLATE_CAPACITY = 30.0f;
    public static final float NODEL_LABEL_SSD_TEMPLATE_CAPACITY = 40.0f;
    public static final ImmutableSet<String> RESOURCE_TYPES = ImmutableSet.of((Object)"memory", (Object)"vcores");
    protected MockRM mockRM = null;
    protected MockNM nm1 = null;
    protected MockNM nm2 = null;
    protected MockNM nm3 = null;
    protected CapacityScheduler cs;
    protected SpyDispatcher dispatcher;
    private static EventHandler<Event> rmAppEventEventHandler;

    @Before
    public void setUp() throws Exception {
        QueueMetrics.clearQueueMetrics();
        CapacitySchedulerConfiguration conf = this.setupSchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, PARENT_QUEUE, true, new int[]{0, 1, 2, 3});
        this.dispatcher = new SpyDispatcher();
        rmAppEventEventHandler = new SpyDispatcher.SpyRMAppEventHandler();
        this.dispatcher.register(RMAppEventType.class, rmAppEventEventHandler);
        final RMNodeLabelsManager mgr = this.setupNodeLabelManager(conf);
        this.mockRM = new MockRM((Configuration)conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.cs.updatePlacementRules();
        this.mockRM.start();
        this.cs.start();
        this.setupNodes(this.mockRM);
    }

    protected void setupNodes(MockRM newMockRM) throws Exception {
        final NodeLabel ssdLabel = (NodeLabel)Records.newRecord(NodeLabel.class);
        ssdLabel.setName(NODEL_LABEL_SSD);
        ssdLabel.setExclusivity(true);
        this.nm1 = new MockNM("h1:1234", Resource.newInstance((int)16384, (int)16), newMockRM.getResourceTrackerService(), YarnVersionInfo.getVersion(), (Set<NodeLabel>)new HashSet<NodeLabel>(){
            {
                this.add(ssdLabel);
            }
        });
        this.nm1.registerNode();
        final NodeLabel gpuLabel = (NodeLabel)Records.newRecord(NodeLabel.class);
        gpuLabel.setName(NODEL_LABEL_GPU);
        gpuLabel.setExclusivity(true);
        this.nm2 = new MockNM("h2:1234", Resource.newInstance((int)16384, (int)32), newMockRM.getResourceTrackerService(), YarnVersionInfo.getVersion(), (Set<NodeLabel>)new HashSet<NodeLabel>(){
            {
                this.add(gpuLabel);
            }
        });
        this.nm2.registerNode();
        this.nm3 = new MockNM("h3:1234", 16384, 48, newMockRM.getResourceTrackerService());
        this.nm3.registerNode();
    }

    public static CapacitySchedulerConfiguration setupQueueMappings(CapacitySchedulerConfiguration conf, String parentQueue, boolean overrideWithQueueMappings, int[] userIds) {
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add("user-group");
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappings = conf.getQueueMappings();
        ArrayList<QueueMapping> queueMappings = new ArrayList<QueueMapping>();
        for (int i = 0; i < userIds.length; ++i) {
            QueueMapping userQueueMapping = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source(USER + userIds[i]).queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, USER + userIds[i])).build();
            queueMappings.add(userQueueMapping);
        }
        existingMappings.addAll(queueMappings);
        conf.setQueueMappings(existingMappings);
        conf.setOverrideWithQueueMappings(overrideWithQueueMappings);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupGroupQueueMappings(String parentQueue, CapacitySchedulerConfiguration conf, String leafQueueName) {
        List existingMappings = conf.getQueueMappings();
        ArrayList<QueueMapping> queueMappings = new ArrayList<QueueMapping>();
        conf.setClass("hadoop.security.group.mapping", TestGroupsCaching.FakeunPrivilegedGroupMapping.class, ShellBasedUnixGroupsMapping.class);
        conf.set("hadoop.user.group.static.mapping.overrides", "testuser=testusergroup;testuser1=testusergroup1;testuser2=testusergroup2;invalid_user=invalid_group");
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf);
        QueueMapping userQueueMapping = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source(TEST_GROUP).queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, leafQueueName)).build();
        QueueMapping userQueueMapping1 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source(TEST_GROUP1).queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, leafQueueName)).build();
        QueueMapping userQueueMapping2 = QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source(TEST_GROUP2).queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, leafQueueName)).build();
        queueMappings.add(userQueueMapping);
        queueMappings.add(userQueueMapping1);
        queueMappings.add(userQueueMapping2);
        existingMappings.addAll(queueMappings);
        conf.setQueueMappings(existingMappings);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b", PARENT_QUEUE, "d", "esubgroup1", "esubgroup2", "fgroup", "a1group", "ggroup", "g"});
        conf.setCapacity(A, 20.0f);
        conf.setCapacity(B, 20.0f);
        conf.setCapacity(C, 20.0f);
        conf.setCapacity(D, 20.0f);
        conf.setCapacity(E_GROUP, 10.0f);
        conf.setCapacity(F_GROUP, 10.0f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3", "b4subgroup1"});
        conf.setCapacity(B1, 60.0f);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, 20.0f);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, 10.0f);
        conf.setUserLimitFactor(B3, 100.0f);
        conf.setCapacity(B4, 10.0f);
        conf.setUserLimitFactor(B4, 100.0f);
        conf.setQueues(E_GROUP, new String[]{"e"});
        conf.setCapacity(E_SG, 100.0f);
        conf.setUserLimitFactor(E_SG, 100.0f);
        conf.setQueues(F_GROUP, new String[]{"f"});
        conf.setCapacity(F_SG, 100.0f);
        conf.setUserLimitFactor(F_SG, 100.0f);
        conf.setUserLimitFactor(C, 1.0f);
        conf.setAutoCreateChildQueueEnabled(C, true);
        conf.setAutoCreatedLeafQueueConfigCapacity(C, 50.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(C, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(C, 3.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(C, 3.0f);
        conf.setAutoCreatedLeafQueueConfigMaximumAllocation(C, "memory-mb=10240,vcores=6");
        conf.setAutoCreatedLeafQueueTemplateCapacityByLabel(C, NODEL_LABEL_GPU, 30.0f);
        conf.setAutoCreatedLeafQueueTemplateMaxCapacity(C, NODEL_LABEL_GPU, 100.0f);
        conf.setAutoCreatedLeafQueueTemplateCapacityByLabel(C, NODEL_LABEL_SSD, 40.0f);
        conf.setAutoCreatedLeafQueueTemplateMaxCapacity(C, NODEL_LABEL_SSD, 100.0f);
        conf.setDefaultNodeLabelExpression(C, NODEL_LABEL_GPU);
        conf.setAutoCreatedLeafQueueConfigDefaultNodeLabelExpression(C, NODEL_LABEL_SSD);
        LOG.info("Setup " + D + " as an auto leaf creation enabled parent queue");
        conf.setUserLimitFactor(D, 1.0f);
        conf.setAutoCreateChildQueueEnabled(D, true);
        conf.setUserLimit(D, 100.0f);
        conf.setUserLimitFactor(D, 3.0f);
        conf.setAutoCreatedLeafQueueConfigCapacity(D, 10.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(D, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(D, 3);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(D, 100.0f);
        conf.set("yarn.scheduler.capacity." + C + ".leaf-queue-template.ordering-policy", "fair");
        accessibleNodeLabelsOnC.add(NODEL_LABEL_GPU);
        accessibleNodeLabelsOnC.add(NODEL_LABEL_SSD);
        accessibleNodeLabelsOnC.add("");
        conf.setAccessibleNodeLabels(C, accessibleNodeLabelsOnC);
        conf.setAccessibleNodeLabels(ROOT, accessibleNodeLabelsOnC);
        conf.setCapacityByLabel(ROOT, NODEL_LABEL_GPU, 100.0f);
        conf.setCapacityByLabel(ROOT, NODEL_LABEL_SSD, 100.0f);
        conf.setAccessibleNodeLabels(C, accessibleNodeLabelsOnC);
        conf.setCapacityByLabel(C, NODEL_LABEL_GPU, 100.0f);
        conf.setCapacityByLabel(C, NODEL_LABEL_SSD, 100.0f);
        LOG.info("Setup " + D + " as an auto leaf creation enabled parent queue");
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfigurationForSingleAutoCreatedLeafQueue(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{PARENT_QUEUE});
        conf.setCapacity(C, 100.0f);
        conf.setUserLimitFactor(C, 1.0f);
        conf.setAutoCreateChildQueueEnabled(C, true);
        conf.setAutoCreatedLeafQueueConfigCapacity(C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(C, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(C, 3.0f);
        return conf;
    }

    public static void setupQueueConfigurationForSingleFlexibleAutoCreatedLeafQueue(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{PARENT_QUEUE});
        conf.setCapacity(C, 100.0f);
        conf.setUserLimitFactor(C, 1.0f);
        conf.setAutoQueueCreationV2Enabled(C, true);
    }

    @After
    public void tearDown() throws Exception {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
    }

    protected void validateCapacities(AutoCreatedLeafQueue autoCreatedLeafQueue, float capacity, float absCapacity, float maxCapacity, float absMaxCapacity) {
        Assert.assertEquals((float)capacity, (float)autoCreatedLeafQueue.getCapacity(), (float)0.001f);
        Assert.assertEquals((float)absCapacity, (float)autoCreatedLeafQueue.getAbsoluteCapacity(), (float)0.001f);
        Assert.assertEquals((float)maxCapacity, (float)autoCreatedLeafQueue.getMaximumCapacity(), (float)0.001f);
        Assert.assertEquals((float)absMaxCapacity, (float)autoCreatedLeafQueue.getAbsoluteMaximumCapacity(), (float)0.001f);
    }

    protected void cleanupQueue(String queueName) throws YarnException {
        AutoCreatedLeafQueue queue = (AutoCreatedLeafQueue)this.cs.getQueue(queueName);
        if (queue != null) {
            this.setEntitlement(queue, new QueueEntitlement(0.0f, 0.0f));
            ((ManagedParentQueue)queue.getParent()).removeChildQueue(queue.getQueuePath());
            this.cs.getCapacitySchedulerQueueManager().removeQueue(queue.getQueuePath());
        }
    }

    protected ApplicationId submitApp(MockRM rm, CSQueue parentQueue, String leafQueueName, String user, int expectedNumAppsInParentQueue, int expectedNumAppsInLeafQueue) throws Exception {
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("test-auto-queue-activation").withUser(user).withAcls(null).withQueue(leafQueueName).withUnmanagedAM(false).build();
        RMApp rmApp = MockRMAppSubmitter.submit(rm, data);
        List appsInParentQueue = capacityScheduler.getAppsInQueue(parentQueue.getQueuePath());
        Assert.assertEquals((long)expectedNumAppsInParentQueue, (long)appsInParentQueue.size());
        List appsInLeafQueue = capacityScheduler.getAppsInQueue(leafQueueName);
        Assert.assertEquals((long)expectedNumAppsInLeafQueue, (long)appsInLeafQueue.size());
        return rmApp.getApplicationId();
    }

    protected List<QueueMapping> setupQueueMapping(CapacityScheduler newCS, String user, String parentQueue, String queue) {
        ArrayList<QueueMapping> queueMappings = new ArrayList<QueueMapping>();
        queueMappings.add(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source(user).queue(TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, queue)).build());
        newCS.getConfiguration().setQueueMappings(queueMappings);
        return queueMappings;
    }

    protected CapacitySchedulerConfiguration setupSchedulerConfiguration() {
        Configuration schedConf = new Configuration();
        schedConf.setInt("yarn.resource-types.vcores.minimum-allocation", 1);
        schedConf.setInt("yarn.resource-types.vcores.maximum-allocation", 8);
        schedConf.setInt("yarn.resource-types.memory-mb.minimum-allocation", 1024);
        schedConf.setInt("yarn.resource-types.memory-mb.maximum-allocation", 16384);
        return new CapacitySchedulerConfiguration(schedConf);
    }

    protected void setSchedulerMinMaxAllocation(CapacitySchedulerConfiguration conf) {
        this.unsetMinMaxAllocation(conf);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 8);
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 1024);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 18384);
    }

    private void unsetMinMaxAllocation(CapacitySchedulerConfiguration conf) {
        conf.unset("yarn.resource-types.vcores.minimum-allocation");
        conf.unset("yarn.resource-types.vcores.maximum-allocation");
        conf.unset("yarn.resource-types.memory-mb.minimum-allocation");
        conf.unset("yarn.resource-types.memory-mb.maximum-allocation");
    }

    protected MockRM setupSchedulerInstance() throws Exception {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
        CapacitySchedulerConfiguration conf = this.setupSchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, PARENT_QUEUE, true, new int[]{0, 1, 2, 3});
        final RMNodeLabelsManager mgr = this.setupNodeLabelManager(conf);
        MockRM newMockRM = new MockRM((Configuration)conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        newMockRM.start();
        ((CapacityScheduler)newMockRM.getResourceScheduler()).start();
        this.setupNodes(newMockRM);
        return newMockRM;
    }

    static String getQueueMapping(String parentQueue, String leafQueue) {
        return parentQueue + "." + leafQueue;
    }

    protected RMNodeLabelsManager setupNodeLabelManager(CapacitySchedulerConfiguration conf) throws IOException {
        NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)NODEL_LABEL_SSD, (Object)NODEL_LABEL_GPU));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), TestUtils.toSet(NODEL_LABEL_SSD)));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), TestUtils.toSet(NODEL_LABEL_GPU)));
        return mgr;
    }

    protected ApplicationAttemptId submitApp(CapacityScheduler newCS, String user, String queue, String parentQueue) {
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, queue, user, new ApplicationPlacementContext(queue, parentQueue));
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        newCS.handle((SchedulerEvent)addAppEvent);
        newCS.handle((SchedulerEvent)addAttemptEvent);
        return appAttemptId;
    }

    protected RMApp submitApp(String user, String queue, String nodeLabel) throws Exception {
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.mockRM).withAppName("test-auto-queue-creation" + RandomUtils.nextInt((int)0, (int)100)).withUser(user).withAcls(null).withQueue(queue).withAmLabel(nodeLabel).build();
        RMApp app = MockRMAppSubmitter.submit(this.mockRM, data);
        Assert.assertEquals((Object)app.getAmNodeLabelExpression(), (Object)nodeLabel);
        List appsInC = this.cs.getAppsInQueue(PARENT_QUEUE);
        Assert.assertEquals((long)1L, (long)appsInC.size());
        Assert.assertNotNull((Object)this.cs.getQueue(queue));
        return app;
    }

    void setEntitlement(AutoCreatedLeafQueue queue, QueueEntitlement entitlement) {
        queue.setCapacity(entitlement.getCapacity());
        queue.setAbsoluteCapacity(queue.getParent().getAbsoluteCapacity() * entitlement.getCapacity());
        queue.setMaxCapacity(entitlement.getMaxCapacity());
    }

    protected void validateUserAndAppLimits(AutoCreatedLeafQueue autoCreatedLeafQueue, int maxApps, int maxAppsPerUser) {
        Assert.assertEquals((long)maxApps, (long)autoCreatedLeafQueue.getMaxApplications());
        Assert.assertEquals((long)maxAppsPerUser, (long)autoCreatedLeafQueue.getMaxApplicationsPerUser());
    }

    protected void validateContainerLimits(AutoCreatedLeafQueue autoCreatedLeafQueue, int vCoreLimit, long memorySize) {
        Assert.assertEquals((long)vCoreLimit, (long)autoCreatedLeafQueue.getMaximumAllocation().getVirtualCores());
        Assert.assertEquals((long)memorySize, (long)autoCreatedLeafQueue.getMaximumAllocation().getMemorySize());
    }

    protected void validateInitialQueueEntitlement(CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacityByLabel, Set<String> nodeLabels) throws SchedulerDynamicEditException, InterruptedException {
        this.validateInitialQueueEntitlement(this.mockRM, this.cs, parentQueue, leafQueueName, expectedTotalChildQueueAbsCapacityByLabel, nodeLabels);
    }

    protected void validateInitialQueueEntitlement(ResourceManager rm, CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacityByLabel, Set<String> nodeLabels) throws SchedulerDynamicEditException, InterruptedException {
        this.validateInitialQueueEntitlement(rm, (CapacityScheduler)rm.getResourceScheduler(), parentQueue, leafQueueName, expectedTotalChildQueueAbsCapacityByLabel, nodeLabels);
    }

    protected void validateInitialQueueEntitlement(ResourceManager rm, CapacityScheduler capacityScheduler, CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacityByLabel, Set<String> nodeLabels) throws SchedulerDynamicEditException, InterruptedException {
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        GuaranteedOrZeroCapacityOverTimePolicy policy = (GuaranteedOrZeroCapacityOverTimePolicy)autoCreateEnabledParentQueue.getAutoCreatedQueueManagementPolicy();
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)capacityScheduler.getQueue(leafQueueName);
        HashMap<String, QueueEntitlement> expectedEntitlements = new HashMap<String, QueueEntitlement>();
        QueueCapacities cap = autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities();
        for (String label : nodeLabels) {
            this.validateCapacitiesByLabel(autoCreateEnabledParentQueue, leafQueue, label);
            Assert.assertEquals((Object)true, (Object)policy.isActive(leafQueue, label));
            Assert.assertEquals((float)expectedTotalChildQueueAbsCapacityByLabel.get(label).floatValue(), (float)policy.getAbsoluteActivatedChildQueueCapacity(label), (float)0.001f);
            QueueEntitlement expectedEntitlement = new QueueEntitlement(cap.getCapacity(label), cap.getMaximumCapacity(label));
            expectedEntitlements.put(label, expectedEntitlement);
            this.validateEffectiveMinResource(rm, capacityScheduler, (CSQueue)leafQueue, label, expectedEntitlements);
        }
    }

    protected void validateCapacitiesByLabel(ManagedParentQueue autoCreateEnabledParentQueue, AutoCreatedLeafQueue leafQueue, String label) throws InterruptedException {
        Assert.assertEquals((float)autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities().getCapacity(label), (float)leafQueue.getQueueCapacities().getCapacity(label), (float)0.001f);
        Assert.assertEquals((float)autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities().getMaximumCapacity(label), (float)leafQueue.getQueueCapacities().getMaximumCapacity(label), (float)0.001f);
    }

    protected void validateEffectiveMinResource(ResourceManager rm, CapacityScheduler cs, CSQueue leafQueue, String label, Map<String, QueueEntitlement> expectedQueueEntitlements) {
        ManagedParentQueue parentQueue = (ManagedParentQueue)leafQueue.getParent();
        Resource resourceByLabel = rm.getRMContext().getNodeLabelManager().getResourceByLabel(label, cs.getClusterResource());
        Resource effMinCapacity = Resources.multiply((Resource)resourceByLabel, (double)(expectedQueueEntitlements.get(label).getCapacity() * parentQueue.getQueueCapacities().getAbsoluteCapacity(label)));
        Assert.assertEquals((Object)effMinCapacity, (Object)Resources.multiply((Resource)resourceByLabel, (double)leafQueue.getQueueCapacities().getAbsoluteCapacity(label)));
        if (expectedQueueEntitlements.get(label).getCapacity() > 0.001f) {
            if (leafQueue.getCapacityConfigType().equals((Object)AbstractCSQueue.CapacityConfigType.ABSOLUTE_RESOURCE)) {
                QueuePath templatePrefix = QueuePrefixes.getAutoCreatedQueueObjectTemplateConfPrefix((QueuePath)parentQueue.getQueuePathObject());
                Resource resourceTemplate = parentQueue.getLeafQueueTemplate().getLeafQueueConfigs().getMinimumResourceRequirement(label, templatePrefix, RESOURCE_TYPES);
                Assert.assertEquals((Object)resourceTemplate, (Object)leafQueue.getEffectiveCapacity(label));
            } else {
                Assert.assertEquals((Object)effMinCapacity, (Object)leafQueue.getEffectiveCapacity(label));
            }
        } else {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)leafQueue.getEffectiveCapacity(label));
        }
        if (leafQueue.getQueueCapacities().getAbsoluteCapacity(label) > 0.0f) {
            Assert.assertTrue((boolean)Resources.greaterThan((ResourceCalculator)cs.getResourceCalculator(), (Resource)cs.getClusterResource(), (Resource)effMinCapacity, (Resource)Resources.none()));
        } else {
            Assert.assertTrue((boolean)Resources.equals((Resource)effMinCapacity, (Resource)Resources.none()));
        }
    }

    protected void validateActivatedQueueEntitlement(CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacity, List<QueueManagementChange> queueManagementChanges, Set<String> expectedNodeLabels) throws SchedulerDynamicEditException {
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        GuaranteedOrZeroCapacityOverTimePolicy policy = (GuaranteedOrZeroCapacityOverTimePolicy)autoCreateEnabledParentQueue.getAutoCreatedQueueManagementPolicy();
        QueueCapacities cap = autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities();
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.cs.getQueue(leafQueueName);
        HashMap<String, QueueEntitlement> expectedEntitlements = new HashMap<String, QueueEntitlement>();
        for (String label : expectedNodeLabels) {
            Assert.assertEquals((Object)true, (Object)policy.isActive(leafQueue, label));
            QueueEntitlement expectedEntitlement = new QueueEntitlement(cap.getCapacity(label), cap.getMaximumCapacity(label));
            Assert.assertEquals((float)expectedTotalChildQueueAbsCapacity.get(label).floatValue(), (float)policy.getAbsoluteActivatedChildQueueCapacity(label), (float)0.001f);
            expectedEntitlements.put(label, expectedEntitlement);
        }
        this.validateQueueEntitlements(leafQueueName, expectedEntitlements, queueManagementChanges, expectedNodeLabels);
    }

    protected void validateDeactivatedQueueEntitlement(CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacity, List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException {
        QueueEntitlement expectedEntitlement = new QueueEntitlement(0.0f, 1.0f);
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.cs.getQueue(leafQueueName);
        GuaranteedOrZeroCapacityOverTimePolicy policy = (GuaranteedOrZeroCapacityOverTimePolicy)autoCreateEnabledParentQueue.getAutoCreatedQueueManagementPolicy();
        HashMap<String, QueueEntitlement> expectedEntitlements = new HashMap<String, QueueEntitlement>();
        for (String label : accessibleNodeLabelsOnC) {
            LOG.info("Validating label " + label);
            Assert.assertEquals((float)expectedTotalChildQueueAbsCapacity.get(label).floatValue(), (float)policy.getAbsoluteActivatedChildQueueCapacity(label), (float)0.001f);
            Assert.assertEquals((Object)false, (Object)policy.isActive(leafQueue, label));
            expectedEntitlements.put(label, expectedEntitlement);
        }
        this.validateQueueEntitlements(leafQueueName, expectedEntitlements, queueManagementChanges, accessibleNodeLabelsOnC);
    }

    void validateQueueEntitlements(String leafQueueName, Map<String, QueueEntitlement> expectedEntitlements, List<QueueManagementChange> queueEntitlementChanges, Set<String> expectedNodeLabels) {
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.cs.getQueue(leafQueueName);
        this.validateQueueEntitlementChanges(leafQueue, expectedEntitlements, queueEntitlementChanges, expectedNodeLabels);
    }

    private void validateQueueEntitlementChanges(AutoCreatedLeafQueue leafQueue, Map<String, QueueEntitlement> expectedQueueEntitlements, List<QueueManagementChange> queueEntitlementChanges, Set<String> expectedNodeLabels) {
        boolean found = false;
        for (QueueManagementChange entitlementChange : queueEntitlementChanges) {
            if (!leafQueue.getQueuePath().equals(entitlementChange.getQueue().getQueuePath())) continue;
            AutoCreatedLeafQueueConfig updatedQueueTemplate = entitlementChange.getUpdatedQueueTemplate();
            for (String label : expectedNodeLabels) {
                QueueEntitlement newEntitlement = new QueueEntitlement(updatedQueueTemplate.getQueueCapacities().getCapacity(label), updatedQueueTemplate.getQueueCapacities().getMaximumCapacity(label));
                Assert.assertEquals((Object)expectedQueueEntitlements.get(label), (Object)newEntitlement);
                this.validateEffectiveMinResource(this.mockRM, this.cs, (CSQueue)leafQueue, label, expectedQueueEntitlements);
            }
            found = true;
            break;
        }
        if (!found) {
            Assert.fail((String)("Could not find the specified leaf queue in entitlement changes : " + leafQueue.getQueuePath()));
        }
    }

    protected Map<String, Float> populateExpectedAbsCapacityByLabelForParentQueue(int numLeafQueues) {
        HashMap<String, Float> expectedChildQueueAbsCapacity = new HashMap<String, Float>();
        expectedChildQueueAbsCapacity.put(NODEL_LABEL_GPU, Float.valueOf(0.3f * (float)numLeafQueues));
        expectedChildQueueAbsCapacity.put(NODEL_LABEL_SSD, Float.valueOf(0.4f * (float)numLeafQueues));
        expectedChildQueueAbsCapacity.put("", Float.valueOf(0.1f * (float)numLeafQueues));
        return expectedChildQueueAbsCapacity;
    }

    public static class SpyDispatcher
    extends AsyncDispatcher {
        public static BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>();

        protected void dispatch(Event event) {
            eventQueue.add(event);
        }

        public EventHandler<Event> getEventHandler() {
            return rmAppEventEventHandler;
        }

        void spyOnNextEvent(Event expectedEvent, long timeout) throws InterruptedException {
            Event event = eventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)expectedEvent.getType(), (Object)event.getType());
            Assert.assertEquals(expectedEvent.getClass(), event.getClass());
        }

        public static class SpyRMAppEventHandler
        implements EventHandler<Event> {
            public void handle(Event event) {
                eventQueue.add(event);
            }
        }
    }
}

