/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Test;

public class TestCapacitySchedulerAmbiguousLeafs {
    int appId = 0;
    private static final QueuePath ROOT = new QueuePath("root");
    private static final QueuePath DEFAULT = new QueuePath("root.default");
    private static final QueuePath A = new QueuePath("root.a");
    private static final QueuePath B = new QueuePath("root.b");
    private static final QueuePath A_UNIQUE = new QueuePath("root.a.unique");
    private static final QueuePath A_AMBI = new QueuePath("root.a.ambi");
    private static final QueuePath B_AMBI = new QueuePath("root.b.ambi");

    private ApplicationId submitApplication(MockRM rm, String queue) throws IOException, YarnException {
        ApplicationAttemptId appAttemptId = TestUtils.getMockApplicationAttemptId(this.appId++, 1);
        Resource resource = Resources.createResource((int)1024);
        ContainerLaunchContext amContainerSpec = ContainerLaunchContext.newInstance(null, null, null, null, null, null);
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance((ApplicationId)appAttemptId.getApplicationId(), (String)"Test application", (String)queue, null, (ContainerLaunchContext)amContainerSpec, (boolean)false, (boolean)true, (int)1, (Resource)resource, (String)"applicationType");
        SubmitApplicationRequest req = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)asc);
        rm.getClientRMService().submitApplication(req);
        return appAttemptId.getApplicationId();
    }

    @Test
    public void testAmbiguousSubmissionWithACL() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        conf.setBoolean("yarn.acl.enable", true);
        MockRM rm = new MockRM((Configuration)conf);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CapacitySchedulerConfiguration schedulerConf = cs.getConfiguration();
        schedulerConf.setQueues(ROOT, new String[]{"a", "b", "default"});
        schedulerConf.setAcl(ROOT, QueueACL.SUBMIT_APPLICATIONS, " ");
        schedulerConf.setAcl(ROOT, QueueACL.ADMINISTER_QUEUE, "forbidden forbidden");
        schedulerConf.setQueues(A, new String[]{"unique", "ambi"});
        schedulerConf.setAcl(A, QueueACL.SUBMIT_APPLICATIONS, "forbidden forbidden");
        schedulerConf.setCapacity(A, 45.0f);
        schedulerConf.setQueues(B, new String[]{"ambi"});
        schedulerConf.setCapacity(B, 45.0f);
        schedulerConf.setCapacity(DEFAULT, 10.0f);
        schedulerConf.setCapacity(A_UNIQUE, 50.0f);
        schedulerConf.setAcl(A_UNIQUE, QueueACL.SUBMIT_APPLICATIONS, "* *");
        schedulerConf.setCapacity(A_AMBI, 50.0f);
        schedulerConf.setAcl(A_AMBI, QueueACL.SUBMIT_APPLICATIONS, "* *");
        schedulerConf.setCapacity(B_AMBI, 100.0f);
        schedulerConf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        schedulerConf.set("yarn.scheduler.capacity.mapping-rule-json", "{\"rules\" : [{\"type\": \"user\", \"policy\" : \"specified\", \"fallbackResult\" : \"skip\", \"matches\" : \"*\"}]}");
        schedulerConf.setOverrideWithQueueMappings(true);
        rm.start();
        cs.reinitialize((Configuration)schedulerConf, rm.getRMContext());
        ApplicationId id = this.submitApplication(rm, "root.a.unique");
        rm.waitForState(id, RMAppState.ACCEPTED);
        id = this.submitApplication(rm, "unique");
        rm.waitForState(id, RMAppState.ACCEPTED);
        id = this.submitApplication(rm, "ambi");
        rm.waitForState(id, RMAppState.FAILED);
        id = this.submitApplication(rm, "root.a.ambi");
        rm.waitForState(id, RMAppState.ACCEPTED);
        rm.stop();
    }
}

