/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueTemplate;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAutoCreatedQueueTemplate {
    private static final QueuePath TEST_QUEUE_ABC = new QueuePath("root.a.b.c");
    private static final QueuePath TEST_QUEUE_AB = new QueuePath("root.a.b");
    private static final QueuePath TEST_QUEUE_A = new QueuePath("root.a");
    private static final QueuePath TEST_QUEUE_B = new QueuePath("root.b");
    private static final QueuePath TEST_QUEUE_WILDCARD = new QueuePath("*");
    private static final QueuePath TEST_QUEUE_ROOT_WILDCARD = new QueuePath("root.*");
    private static final QueuePath TEST_QUEUE_TWO_LEVEL_WILDCARDS = new QueuePath("root.*.*");
    private static final QueuePath TEST_QUEUE_A_WILDCARD = new QueuePath("root.a.*");
    private static final QueuePath ROOT = new QueuePath("root");
    private CapacitySchedulerConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new CapacitySchedulerConfiguration();
        this.conf.setQueues(ROOT, new String[]{"a"});
        this.conf.setQueues(TEST_QUEUE_A, new String[]{"b"});
        this.conf.setQueues(TEST_QUEUE_B, new String[]{"c"});
    }

    @Test
    public void testNonWildCardTemplate() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_AB, "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC);
        Assert.assertEquals((String)"weight is not set", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC), (double)1.0E-5);
    }

    @Test
    public void testOneLevelWildcardTemplate() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_A_WILDCARD, "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC);
        Assert.assertEquals((String)"weight is not set", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC), (double)1.0E-5);
    }

    @Test
    public void testTwoLevelWildcardTemplate() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_ROOT_WILDCARD, "capacity"), "6w");
        this.conf.set(this.getTemplateKey(TEST_QUEUE_TWO_LEVEL_WILDCARDS, "capacity"), "5w");
        new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_A).setTemplateEntriesForChild(this.conf, TEST_QUEUE_AB);
        new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB).setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC);
        Assert.assertEquals((String)"weight is not set", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_AB), (double)1.0E-5);
        Assert.assertEquals((String)"weight is not set", (double)5.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC), (double)1.0E-5);
    }

    @Test
    public void testIgnoredWhenRootWildcarded() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_WILDCARD, "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, ROOT);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_A);
        Assert.assertEquals((String)"weight is set", (double)-1.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_A), (double)1.0E-5);
    }

    @Test
    public void testIgnoredWhenNoParent() {
        this.conf.set(this.getTemplateKey(ROOT, "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, ROOT);
        template.setTemplateEntriesForChild(this.conf, ROOT);
        Assert.assertEquals((String)"weight is set", (double)-1.0, (double)this.conf.getNonLabeledQueueWeight(ROOT), (double)1.0E-5);
    }

    @Test
    public void testWildcardAfterRoot() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_ROOT_WILDCARD, "acl_submit_applications"), "user");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_A);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_A);
        Assert.assertEquals((String)"acl_submit_applications is set", (Object)"user", template.getTemplateProperties().get("acl_submit_applications"));
    }

    @Test
    public void testTemplatePrecedence() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_AB, "capacity"), "6w");
        this.conf.set(this.getTemplateKey(TEST_QUEUE_A_WILDCARD, "capacity"), "4w");
        this.conf.set(this.getTemplateKey(TEST_QUEUE_TWO_LEVEL_WILDCARDS, "capacity"), "2w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC);
        Assert.assertEquals((String)"explicit template does not have the highest precedence", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC), (double)1.0E-5);
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration();
        newConf.set(this.getTemplateKey(TEST_QUEUE_A_WILDCARD, "capacity"), "4w");
        template = new AutoCreatedQueueTemplate(newConf, TEST_QUEUE_AB);
        template.setTemplateEntriesForChild(newConf, TEST_QUEUE_ABC);
        Assert.assertEquals((String)"precedence is invalid", (double)4.0, (double)newConf.getNonLabeledQueueWeight(TEST_QUEUE_ABC), (double)1.0E-5);
    }

    @Test
    public void testRootTemplate() {
        this.conf.set(this.getTemplateKey(ROOT, "capacity"), "2w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, ROOT);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_A);
        Assert.assertEquals((String)"root property is not set", (double)2.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_A), (double)1.0E-5);
    }

    @Test
    public void testQueueSpecificTemplates() {
        this.conf.set(this.getTemplateKey(ROOT, "capacity"), "2w");
        this.conf.set(this.getLeafTemplateKey(ROOT, "default-node-label-expression"), "test");
        this.conf.set(this.getLeafTemplateKey(ROOT, "capacity"), "10w");
        this.conf.setBoolean(this.getParentTemplateKey(ROOT, "auto-queue-creation-v2.queue-auto-removal.enable"), false);
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, ROOT);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_A);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_B, true);
        Assert.assertNull((String)"default-node-label-expression is set for parent", (Object)this.conf.getDefaultNodeLabelExpression(TEST_QUEUE_A));
        Assert.assertEquals((String)"default-node-label-expression is not set for leaf", (Object)"test", (Object)this.conf.getDefaultNodeLabelExpression(TEST_QUEUE_B));
        Assert.assertFalse((String)"auto queue removal is not disabled for parent", (boolean)this.conf.isAutoExpiredDeletionEnabled(TEST_QUEUE_A));
        Assert.assertEquals((String)"weight should not be overridden when set by queue type specific template", (double)10.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_B), (double)1.0E-5);
        Assert.assertEquals((String)"weight should be set by common template", (double)2.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_A), (double)1.0E-5);
    }

    @Test
    public void testWildcardTemplateWithLimitedAutoCreatedQueueDepth() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_ROOT_WILDCARD, "capacity"), "6w");
        this.conf.set(this.getTemplateKey(TEST_QUEUE_A_WILDCARD, "capacity"), "5w");
        this.conf.setMaximumAutoCreatedQueueDepth(TEST_QUEUE_A, 1);
        this.conf.setMaximumAutoCreatedQueueDepth(TEST_QUEUE_AB, 1);
        new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_A).setTemplateEntriesForChild(this.conf, TEST_QUEUE_AB);
        new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB).setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC);
        Assert.assertEquals((String)"weight is not set", (double)6.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_AB), (double)1.0E-5);
        Assert.assertEquals((String)"weight is not set", (double)5.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC), (double)1.0E-5);
    }

    @Test
    public void testIgnoredTemplateWithLimitedAutoCreatedQueueDepth() {
        this.conf.set(this.getTemplateKey(TEST_QUEUE_TWO_LEVEL_WILDCARDS, "capacity"), "5w");
        this.conf.setMaximumAutoCreatedQueueDepth(TEST_QUEUE_AB, 1);
        new AutoCreatedQueueTemplate(this.conf, TEST_QUEUE_AB).setTemplateEntriesForChild(this.conf, TEST_QUEUE_ABC);
        Assert.assertEquals((String)"weight is set incorrectly", (double)-1.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_ABC), (double)1.0E-5);
    }

    @Test
    public void testIgnoredTemplateWhenQueuePathIsInvalid() {
        QueuePath invalidPath = new QueuePath("a");
        this.conf.set(this.getTemplateKey(invalidPath, "capacity"), "6w");
        AutoCreatedQueueTemplate template = new AutoCreatedQueueTemplate(this.conf, invalidPath);
        template.setTemplateEntriesForChild(this.conf, TEST_QUEUE_AB);
        Assert.assertEquals((String)"weight is set using invalid queue path", (double)-1.0, (double)this.conf.getNonLabeledQueueWeight(TEST_QUEUE_AB), (double)1.0E-5);
    }

    private String getTemplateKey(QueuePath queuePath, String entryKey) {
        return QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "auto-queue-creation-v2.template." + entryKey;
    }

    private String getParentTemplateKey(QueuePath queuePath, String entryKey) {
        return QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "auto-queue-creation-v2.parent-template." + entryKey;
    }

    private String getLeafTemplateKey(QueuePath queuePath, String entryKey) {
        return QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "auto-queue-creation-v2.leaf-template." + entryKey;
    }
}

