/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueDeletionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAutoCreatedQueueDeletionPolicy
extends TestCapacitySchedulerAutoCreatedQueueBase {
    private CapacitySchedulerConfiguration csConf;
    private CapacityScheduler cs;
    private final AutoCreatedQueueDeletionPolicy policy = new AutoCreatedQueueDeletionPolicy();
    private CapacitySchedulerQueueManager autoQueueHandler;
    public static final QueuePath ROOT = new QueuePath("root");
    public static final QueuePath ROOT_A = new QueuePath("root", "a");
    public static final QueuePath ROOT_A_A1 = QueuePath.createFromQueues((String[])new String[]{"root", "a", "a1"});
    public static final QueuePath ROOT_B = new QueuePath("root", "b");

    @Override
    @Before
    public void setUp() throws Exception {
        this.csConf = new CapacitySchedulerConfiguration();
        this.csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.csConf.setQueues(ROOT, new String[]{"a", "b"});
        this.csConf.setNonLabeledQueueWeight(ROOT, 1.0f);
        this.csConf.setNonLabeledQueueWeight(ROOT_A, 1.0f);
        this.csConf.setNonLabeledQueueWeight(ROOT_B, 1.0f);
        this.csConf.setQueues(ROOT_A, new String[]{"a1"});
        this.csConf.setNonLabeledQueueWeight(ROOT_A_A1, 1.0f);
        this.csConf.setAutoQueueCreationV2Enabled(ROOT, true);
        this.csConf.setAutoQueueCreationV2Enabled(ROOT_A, true);
        this.csConf.setAutoQueueCreationV2Enabled(PARENT_QUEUE_PATH, true);
        this.csConf.setAutoExpiredDeletionTime(1L);
    }

    @Override
    @After
    public void tearDown() {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
    }

    @Test
    public void testEditSchedule() throws Exception {
        this.prepareForSchedule();
        AbstractCSQueue e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.isDynamicQueue());
        AbstractCSQueue e1 = (AbstractCSQueue)this.cs.getQueue("root.e.e1");
        Assert.assertNotNull((Object)e1);
        Assert.assertTrue((boolean)e1.isDynamicQueue());
        e1.setLastSubmittedTimestamp(Time.monotonicNow());
        ApplicationAttemptId user0AppAttemptId = this.submitApp(this.cs, "user_0", "user_0", "root.e");
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e.user_0") != null, (long)100L, (long)2000L);
        AbstractCSQueue user0 = (AbstractCSQueue)this.cs.getQueue("root.e.user_0");
        Assert.assertNotNull((Object)user0);
        Assert.assertTrue((boolean)user0.isDynamicQueue());
        AppAttemptRemovedSchedulerEvent event = new AppAttemptRemovedSchedulerEvent(user0AppAttemptId, RMAppAttemptState.FINISHED, false);
        this.cs.handle((SchedulerEvent)event);
        AppRemovedSchedulerEvent rEvent = new AppRemovedSchedulerEvent(user0AppAttemptId.getApplicationId(), RMAppState.FINISHED);
        this.cs.handle((SchedulerEvent)rEvent);
        Assert.assertEquals((long)user0.getNumApplications(), (long)0L);
        long l1 = user0.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l1) / 1000L;
            return duration > this.cs.getConfiguration().getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        long l2 = e1.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l2) / 1000L;
            return duration > this.cs.getConfiguration().getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        this.policy.editSchedule();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)2L);
        Assert.assertTrue((boolean)this.policy.getMarkedForDeletion().contains("root.e.user_0"));
        Assert.assertTrue((boolean)this.policy.getMarkedForDeletion().contains("root.e.e1"));
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        this.policy.prepareForAutoDeletion();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)2L);
        e1 = (AbstractCSQueue)this.cs.getQueue("root.e.e1");
        Assert.assertNotNull((Object)e1);
        user0 = (AbstractCSQueue)this.cs.getQueue("root.e.user_0");
        Assert.assertNotNull((Object)user0);
        this.policy.triggerAutoDeletionForExpiredQueues();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e.e1") == null, (long)100L, (long)2000L);
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e.user_0") == null, (long)100L, (long)2000L);
        e1 = (AbstractCSQueue)this.cs.getQueue("root.e.e1");
        Assert.assertNull((Object)e1);
        user0 = (AbstractCSQueue)this.cs.getQueue("root.e.user_0");
        Assert.assertNull((Object)user0);
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        long l3 = e.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l3) / 1000L;
            return duration > this.cs.getConfiguration().getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        this.policy.editSchedule();
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)1L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        Assert.assertTrue((boolean)this.policy.getMarkedForDeletion().contains("root.e"));
        this.policy.prepareForAutoDeletion();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)1L);
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        this.policy.triggerAutoDeletionForExpiredQueues();
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e") == null, (long)100L, (long)2000L);
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNull((Object)e);
    }

    public void prepareForSchedule() throws Exception {
        this.startScheduler();
        this.policy.editSchedule();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        this.createQueue("root.e.e1");
    }

    protected void startScheduler() throws Exception {
        try (final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();){
            mgr.init((Configuration)this.csConf);
            this.mockRM = new MockRM((Configuration)this.csConf){

                @Override
                protected RMNodeLabelsManager createNodeLabelManager() {
                    return mgr;
                }
            };
            this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
            this.cs.updatePlacementRules();
            this.policy.init((Configuration)this.cs.getConfiguration(), this.cs.getRMContext(), (ResourceScheduler)this.cs);
            this.mockRM.start();
            this.cs.start();
            this.autoQueueHandler = this.cs.getCapacitySchedulerQueueManager();
            this.mockRM.registerNode("h1:1234", 1228800);
        }
    }

    protected AbstractLeafQueue createQueue(String queuePath) throws YarnException, IOException {
        return this.autoQueueHandler.createQueue(new QueuePath(queuePath));
    }
}

