/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.GuaranteedOrZeroCapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicy;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAbsoluteResourceWithAutoQueue
extends TestCapacitySchedulerAutoCreatedQueueBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestAbsoluteResourceWithAutoQueue.class);
    private static final String QUEUEA = "queueA";
    private static final String QUEUEB = "queueB";
    private static final String QUEUEC = "queueC";
    private static final String QUEUED = "queueD";
    private static final String QUEUEA_FULL = "root.queueA";
    private static final String QUEUEB_FULL = "root.queueB";
    private static final String QUEUEC_FULL = "root.queueC";
    private static final String QUEUED_FULL = "root.queueD";
    private static final QueuePath ROOT_QUEUE_PATH = new QueuePath("root");
    private static final QueuePath A_QUEUE_PATH = new QueuePath("root.queueA");
    private static final QueuePath B_QUEUE_PATH = new QueuePath("root.queueB");
    private static final QueuePath C_QUEUE_PATH = new QueuePath("root.queueC");
    private static final QueuePath D_QUEUE_PATH = new QueuePath("root.queueD");
    private static final Resource QUEUE_A_MINRES = Resource.newInstance((int)102400, (int)10);
    private static final Resource QUEUE_A_MAXRES = Resource.newInstance((int)204800, (int)30);
    private static final Resource QUEUE_B_MINRES = Resource.newInstance((int)51200, (int)10);
    private static final Resource QUEUE_B_MAXRES = Resource.newInstance((int)153600, (int)30);
    private static final Resource QUEUE_C_MINRES = Resource.newInstance((int)25600, (int)5);
    private static final Resource QUEUE_C_MAXRES = Resource.newInstance((int)153600, (int)20);
    private static final Resource QUEUE_D_MINRES = Resource.newInstance((int)25600, (int)5);
    private static final Resource QUEUE_D_MAXRES = Resource.newInstance((int)153600, (int)20);

    @Override
    @Before
    public void setUp() throws Exception {
        accessibleNodeLabelsOnC.add("");
    }

    @Override
    @After
    public void tearDown() {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
    }

    private CapacitySchedulerConfiguration setupMinMaxResourceConfiguration(CapacitySchedulerConfiguration csConf) {
        csConf.setMinimumResourceRequirement("", A_QUEUE_PATH, QUEUE_A_MINRES);
        csConf.setMinimumResourceRequirement("", B_QUEUE_PATH, QUEUE_B_MINRES);
        csConf.setMinimumResourceRequirement("", C_QUEUE_PATH, QUEUE_C_MINRES);
        csConf.setMinimumResourceRequirement("", D_QUEUE_PATH, QUEUE_D_MINRES);
        csConf.setMaximumResourceRequirement("", A_QUEUE_PATH, QUEUE_A_MAXRES);
        csConf.setMaximumResourceRequirement("", B_QUEUE_PATH, QUEUE_B_MAXRES);
        csConf.setMaximumResourceRequirement("", C_QUEUE_PATH, QUEUE_C_MAXRES);
        csConf.setMaximumResourceRequirement("", D_QUEUE_PATH, QUEUE_D_MAXRES);
        return csConf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        return conf;
    }

    private CapacitySchedulerConfiguration setupSimpleQueueConfiguration(boolean isCapacityNeeded) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues(ROOT_QUEUE_PATH, new String[]{QUEUEA, QUEUEB, QUEUEC, QUEUED});
        if (isCapacityNeeded) {
            csConf.setCapacity(A_QUEUE_PATH, 50.0f);
            csConf.setCapacity(B_QUEUE_PATH, 25.0f);
            csConf.setCapacity(C_QUEUE_PATH, 25.0f);
            csConf.setCapacity(D_QUEUE_PATH, 25.0f);
        }
        csConf.setAutoCreateChildQueueEnabled(C_QUEUE_PATH, true);
        csConf.setAutoCreatedLeafQueueTemplateCapacityByLabel(C_QUEUE_PATH, "", QUEUE_C_MINRES);
        csConf.setAutoCreatedLeafQueueTemplateMaxCapacity(C_QUEUE_PATH, "", QUEUE_C_MAXRES);
        csConf.setAutoCreateChildQueueEnabled(D_QUEUE_PATH, true);
        csConf.setAutoCreatedLeafQueueTemplateCapacityByLabel(D_QUEUE_PATH, "", Resource.newInstance((int)10240, (int)2));
        csConf.setAutoCreatedLeafQueueTemplateMaxCapacity(D_QUEUE_PATH, "", QUEUE_D_MAXRES);
        return csConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testAutoCreateLeafQueueCreation() throws Exception {
        try {
            CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
            this.setupMinMaxResourceConfiguration(csConf);
            csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            csConf.setOverrideWithQueueMappings(true);
            this.mockRM = new MockRM((Configuration)csConf);
            this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
            this.mockRM.start();
            this.cs.start();
            this.mockRM.registerNode("127.0.0.1:1234", 256000, 40);
            TestAbsoluteResourceWithAutoQueue.setupGroupQueueMappings(QUEUED, this.cs.getConfiguration(), "%user");
            this.cs.reinitialize((Configuration)this.cs.getConfiguration(), this.mockRM.getRMContext());
            this.submitApp(this.mockRM, this.cs.getQueue(QUEUED), "testuser", "testuser", 1, 1);
            AutoCreatedLeafQueue autoCreatedLeafQueue = (AutoCreatedLeafQueue)this.cs.getQueue("testuser");
            ManagedParentQueue parentQueue = (ManagedParentQueue)this.cs.getQueue(QUEUED);
            Assert.assertEquals((Object)parentQueue, (Object)autoCreatedLeafQueue.getParent());
            this.validateCapacities(autoCreatedLeafQueue, 0.4f, 0.04f, 1.0f, 0.6f);
            this.validateCapacitiesByLabel(parentQueue, autoCreatedLeafQueue, "");
            HashMap<String, Float> expectedChildQueueAbsCapacity = new HashMap<String, Float>(){
                {
                    this.put("", Float.valueOf(0.04f));
                }
            };
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, "testuser", (Map<String, Float>)expectedChildQueueAbsCapacity, (Set<String>)new HashSet<String>(){
                {
                    this.add("");
                }
            });
            this.validateUserAndAppLimits(autoCreatedLeafQueue, 400, 400);
            Assert.assertTrue((boolean)(autoCreatedLeafQueue.getOrderingPolicy() instanceof FifoOrderingPolicy));
            ApplicationId user1AppId = this.submitApp(this.mockRM, this.cs.getQueue(QUEUED), "testuser1", "testuser1", 2, 1);
            AutoCreatedLeafQueue autoCreatedLeafQueue1 = (AutoCreatedLeafQueue)this.cs.getQueue("testuser1");
            this.validateCapacities(autoCreatedLeafQueue1, 0.4f, 0.04f, 1.0f, 0.6f);
            this.validateCapacitiesByLabel(parentQueue, autoCreatedLeafQueue1, "");
            Assert.assertEquals((Object)parentQueue, (Object)autoCreatedLeafQueue1.getParent());
            HashMap<String, Float> expectedChildQueueAbsCapacity1 = new HashMap<String, Float>(){
                {
                    this.put("", Float.valueOf(0.08f));
                }
            };
            this.validateInitialQueueEntitlement((CSQueue)parentQueue, "testuser1", (Map<String, Float>)expectedChildQueueAbsCapacity1, (Set<String>)new HashSet<String>(){
                {
                    this.add("");
                }
            });
            this.submitApp(this.mockRM, this.cs.getQueue(QUEUED), "testuser2", "testuser2", 3, 1);
            CSQueue autoCreatedLeafQueue2 = this.cs.getQueue("testuser2");
            this.validateCapacities((AutoCreatedLeafQueue)autoCreatedLeafQueue2, 0.0f, 0.0f, 1.0f, 0.6f);
            this.validateCapacities(autoCreatedLeafQueue1, 0.4f, 0.04f, 1.0f, 0.6f);
            this.validateCapacities(autoCreatedLeafQueue, 0.4f, 0.04f, 1.0f, 0.6f);
            GuaranteedOrZeroCapacityOverTimePolicy autoCreatedQueueManagementPolicy = (GuaranteedOrZeroCapacityOverTimePolicy)parentQueue.getAutoCreatedQueueManagementPolicy();
            Assert.assertEquals((float)0.08f, (float)autoCreatedQueueManagementPolicy.getAbsoluteActivatedChildQueueCapacity(""), (float)0.001f);
            this.cs.killAllAppsInQueue("testuser1");
            this.mockRM.waitForState(user1AppId, RMAppState.KILLED);
            List queueManagementChanges = autoCreatedQueueManagementPolicy.computeQueueManagementChanges();
            ManagedParentQueue managedParentQueue = parentQueue;
            managedParentQueue.validateAndApplyQueueManagementChanges(queueManagementChanges);
            this.validateDeactivatedQueueEntitlement((CSQueue)parentQueue, "testuser1", (Map<String, Float>)expectedChildQueueAbsCapacity1, queueManagementChanges);
            HashSet<String> expectedNodeLabelsUpdated = new HashSet<String>();
            expectedNodeLabelsUpdated.add("");
            this.validateActivatedQueueEntitlement((CSQueue)parentQueue, "testuser2", (Map<String, Float>)expectedChildQueueAbsCapacity1, queueManagementChanges, expectedNodeLabelsUpdated);
        }
        finally {
            this.cleanupQueue("testuser");
            this.cleanupQueue("testuser1");
            this.cleanupQueue("testuser2");
        }
    }

    @Test(expected=Exception.class)
    public void testValidateLeafQueueTemplateConfigurations() {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(true);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mockRM = new MockRM((Configuration)csConf);
        Assert.fail((String)"Exception should be thrown as leaf queue template configuration is not same as Parent configuration");
    }

    @Test(timeout=20000L)
    public void testApplicationRunningWithDRF() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        csConf.setResourceComparator(DominantResourceCalculator.class);
        TestAbsoluteResourceWithAutoQueue.setupGroupQueueMappings(QUEUED, csConf, "%user");
        this.mockRM = new MockRM((Configuration)csConf);
        this.mockRM.start();
        MockNM nm1 = this.mockRM.registerNode("127.0.0.1:1234", 256000, 40);
        RMApp app1 = MockRMAppSubmitter.submit(this.mockRM, MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.mockRM).withAppName("app1").withUser("testuser").withAcls(null).build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.mockRM, nm1);
        this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        AutoCreatedLeafQueue autoCreatedLeafQueue = (AutoCreatedLeafQueue)this.cs.getQueue("testuser");
        Assert.assertNotNull((String)"Auto Creation of Queue failed", (Object)autoCreatedLeafQueue);
        ManagedParentQueue parentQueue = (ManagedParentQueue)this.cs.getQueue(QUEUED);
        Assert.assertEquals((Object)parentQueue, (Object)autoCreatedLeafQueue.getParent());
    }
}

