/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.junit.Assert;

public final class CapacitySchedulerQueueHelpers {
    public static final String DEFAULT_PATH = "root.default";
    public static final String A_PATH = "root.a";
    public static final String B_PATH = "root.b";
    public static final String A_CHILD_PATH = "root.a.a";
    public static final String A1_PATH = "root.a.a1";
    public static final String A2_PATH = "root.a.a2";
    public static final String A3_PATH = "root.a.a3";
    public static final String B1_PATH = "root.b.b1";
    public static final String B2_PATH = "root.b.b2";
    public static final String B3_PATH = "root.b.b3";
    public static final String A1_B1_PATH = "root.a.a1.b1";
    public static final QueuePath ROOT = new QueuePath("root");
    public static final QueuePath DEFAULT = new QueuePath("root.default");
    public static final QueuePath A = new QueuePath("root.a");
    public static final QueuePath A_CHILD = new QueuePath("root.a.a");
    public static final QueuePath A1 = new QueuePath("root.a.a1");
    public static final QueuePath A2 = new QueuePath("root.a.a2");
    public static final QueuePath A3 = new QueuePath("root.a.a3");
    public static final QueuePath B = new QueuePath("root.b");
    public static final QueuePath B1 = new QueuePath("root.b.b1");
    public static final QueuePath B2 = new QueuePath("root.b.b2");
    public static final QueuePath B3 = new QueuePath("root.b.b3");
    public static final QueuePath A1_B1 = new QueuePath("root.a.a1.b1");
    public static final float A_CAPACITY = 10.5f;
    public static final float B_CAPACITY = 89.5f;
    public static final String P1_PATH = "root.p1";
    public static final String P2_PATH = "root.p2";
    public static final String X1_PATH = "root.p1.x1";
    public static final String X2_PATH = "root.p1.x2";
    public static final String Y1_PATH = "root.p2.y1";
    public static final String Y2_PATH = "root.p2.y2";
    public static final QueuePath P1 = new QueuePath("root.p1");
    public static final QueuePath P2 = new QueuePath("root.p2");
    public static final QueuePath X1 = new QueuePath("root.p1.x1");
    public static final QueuePath X2 = new QueuePath("root.p1.x2");
    public static final QueuePath Y1 = new QueuePath("root.p2.y1");
    public static final QueuePath Y2 = new QueuePath("root.p2.y2");
    public static final float A1_CAPACITY = 30.0f;
    public static final float A2_CAPACITY = 70.0f;
    public static final float B1_CAPACITY = 79.2f;
    public static final float B2_CAPACITY = 0.8f;
    public static final float B3_CAPACITY = 20.0f;

    private CapacitySchedulerQueueHelpers() {
        throw new IllegalStateException("Utility class");
    }

    public static CapacitySchedulerConfiguration setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.5f);
        conf.setCapacity(B, 89.5f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, 79.2f);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, 0.8f);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setUserLimitFactor(B3, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupAdditionalQueues(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.5f);
        conf.setCapacity(B, 89.5f);
        conf.setQueues(A, new String[]{"a1", "a2", "a3"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 30.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setCapacity(A3, 40.0f);
        conf.setUserLimitFactor(A3, 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, 79.2f);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, 0.8f);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setUserLimitFactor(B3, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfAmbiguousQueue(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.5f);
        conf.setCapacity(B, 89.5f);
        conf.setQueues(A, new String[]{"a", "a1"});
        conf.setCapacity(A_CHILD, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A1, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfWithoutChildrenOfB(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.5f);
        conf.setCapacity(B, 89.5f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfigurationWithoutB1(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.5f);
        conf.setCapacity(B, 89.5f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setQueues(B, new String[]{"b2", "b3"});
        conf.setCapacity(B2, 80.0f);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setUserLimitFactor(B3, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfigurationWithB1AsParentQueue(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 10.5f);
        conf.setCapacity(B, 89.5f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, 79.2f);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, 0.8f);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setUserLimitFactor(B3, 100.0f);
        conf.setQueues(B1, new String[]{"b11"});
        String b11Path = B1 + ".b11";
        QueuePath b11 = new QueuePath(b11Path);
        conf.setCapacity(b11, 100.0f);
        conf.setUserLimitFactor(b11, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfigurationWithoutB(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a"});
        conf.setCapacity(A, 100.0f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupBlockedQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"a", "b"});
        conf.setCapacity(A, 80.0f);
        conf.setCapacity(B, 20.0f);
        conf.setUserLimitFactor(A, 100.0f);
        conf.setUserLimitFactor(B, 100.0f);
        conf.setMaximumCapacity(A, 100.0f);
        conf.setMaximumCapacity(B, 100.0f);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupOtherBlockedQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues(ROOT, new String[]{"p1", "p2"});
        conf.setCapacity(P1, 50.0f);
        conf.setMaximumCapacity(P1, 50.0f);
        conf.setCapacity(P2, 50.0f);
        conf.setMaximumCapacity(P2, 100.0f);
        conf.setQueues(P1, new String[]{"x1", "x2"});
        conf.setCapacity(X1, 80.0f);
        conf.setMaximumCapacity(X1, 100.0f);
        conf.setUserLimitFactor(X1, 2.0f);
        conf.setCapacity(X2, 20.0f);
        conf.setMaximumCapacity(X2, 100.0f);
        conf.setUserLimitFactor(X2, 2.0f);
        conf.setQueues(P2, new String[]{"y1", "y2"});
        conf.setCapacity(Y1, 80.0f);
        conf.setUserLimitFactor(Y1, 2.0f);
        conf.setCapacity(Y2, 20.0f);
        conf.setUserLimitFactor(Y2, 2.0f);
        return conf;
    }

    public static Map<String, ExpectedCapacities> getDefaultCapacities(float capA, float capB) {
        HashMap<String, ExpectedCapacities> capacities = new HashMap<String, ExpectedCapacities>();
        capacities.put(A.getFullPath(), new ExpectedCapacities(capA, 1.0f));
        capacities.put(B.getFullPath(), new ExpectedCapacities(capB, 1.0f));
        capacities.put(A1.getFullPath(), new ExpectedCapacities(0.3f, capA));
        capacities.put(A2.getFullPath(), new ExpectedCapacities(0.7f, capA));
        capacities.put(B1.getFullPath(), new ExpectedCapacities(0.792f, capB));
        capacities.put(B2.getFullPath(), new ExpectedCapacities(0.008f, capB));
        capacities.put(B3.getFullPath(), new ExpectedCapacities(0.2f, capB));
        return capacities;
    }

    public static void checkQueueStructureCapacities(CapacityScheduler cs) {
        float capA = 0.105f;
        float capB = 0.895f;
        CapacitySchedulerQueueHelpers.checkQueueStructureCapacities(cs, CapacitySchedulerQueueHelpers.getDefaultCapacities(capA, capB));
    }

    public static void checkQueueStructureCapacities(CapacityScheduler cs, Map<String, ExpectedCapacities> capacities) {
        CSQueue rootQueue = cs.getRootQueue();
        for (Map.Entry<String, ExpectedCapacities> entry : capacities.entrySet()) {
            CSQueue queue = CapacitySchedulerQueueHelpers.findQueue(rootQueue, entry.getKey());
            Assert.assertNotNull((Object)queue);
            CapacitySchedulerQueueHelpers.assertQueueCapacities(queue, entry.getValue());
        }
    }

    public static void assertQueueCapacities(CSQueue q, ExpectedCapacities capacities) {
        float epsilon = 1.0E-4f;
        Assert.assertEquals((String)"capacity", (float)capacities.getCapacity(), (float)q.getCapacity(), (float)1.0E-4f);
        Assert.assertEquals((String)"absolute capacity", (float)capacities.getAbsCapacity(), (float)q.getAbsoluteCapacity(), (float)1.0E-4f);
        Assert.assertEquals((String)"maximum capacity", (float)1.0f, (float)q.getMaximumCapacity(), (float)1.0E-4f);
        Assert.assertEquals((String)"absolute maximum capacity", (float)1.0f, (float)q.getAbsoluteMaximumCapacity(), (float)1.0E-4f);
    }

    public static CSQueue findQueue(CSQueue root, String queuePath) {
        if (root.getQueuePath().equals(queuePath)) {
            return root;
        }
        List childQueues = root.getChildQueues();
        if (childQueues != null) {
            for (CSQueue q : childQueues) {
                CSQueue result;
                if (!queuePath.startsWith(q.getQueuePath()) || (result = CapacitySchedulerQueueHelpers.findQueue(q, queuePath)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static class ExpectedCapacities {
        private final float capacity;
        private final float absCapacity;

        public ExpectedCapacities(float capacity, float parentCapacity) {
            this.capacity = capacity;
            this.absCapacity = this.capacity * parentCapacity;
        }

        public float getCapacity() {
            return this.capacity;
        }

        public float getAbsCapacity() {
            return this.absCapacity;
        }
    }
}

