/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;

public final class CapacitySchedulerConfigGeneratorForTest {
    private CapacitySchedulerConfigGeneratorForTest() {
        throw new IllegalStateException("Utility class");
    }

    public static Configuration createConfiguration(Map<String, String> configs) {
        Configuration config = new Configuration();
        for (Map.Entry<String, String> entry : configs.entrySet()) {
            config.set(entry.getKey(), entry.getValue());
        }
        return config;
    }

    public static Configuration createBasicCSConfiguration() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.root.queues", "test1, test2");
        conf.put("yarn.scheduler.capacity.root.test1.capacity", "50");
        conf.put("yarn.scheduler.capacity.root.test2.capacity", "50");
        conf.put("yarn.scheduler.capacity.root.test1.maximum-capacity", "100");
        conf.put("yarn.scheduler.capacity.root.test1.state", "RUNNING");
        conf.put("yarn.scheduler.capacity.root.test2.state", "RUNNING");
        conf.put("yarn.scheduler.capacity.queue-mappings", "u:test1:root.test1,u:test2:root.test2");
        return CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf);
    }

    public static void setMinAllocMb(Configuration conf, int minAllocMb) {
        conf.setInt("yarn.scheduler.minimum-allocation-mb", minAllocMb);
    }

    public static void setMaxAllocMb(Configuration conf, int maxAllocMb) {
        conf.setInt("yarn.scheduler.maximum-allocation-mb", maxAllocMb);
    }

    public static void setMaxAllocMb(CapacitySchedulerConfiguration conf, QueuePath queuePath, int maxAllocMb) {
        String propName = QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "maximum-allocation-mb";
        conf.setInt(propName, maxAllocMb);
    }

    public static void setMinAllocVcores(Configuration conf, int minAllocVcores) {
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", minAllocVcores);
    }

    public static void setMaxAllocVcores(Configuration conf, int maxAllocVcores) {
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", maxAllocVcores);
    }

    public static void setMaxAllocVcores(CapacitySchedulerConfiguration conf, QueuePath queuePath, int maxAllocVcores) {
        String propName = QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "maximum-allocation-vcores";
        conf.setInt(propName, maxAllocVcores);
    }

    public static void setMaxAllocation(CapacitySchedulerConfiguration conf, QueuePath queuePath, String maxAllocation) {
        String propName = QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "maximum-allocation";
        conf.set(propName, maxAllocation);
    }

    public static void unsetMaxAllocation(CapacitySchedulerConfiguration conf, QueuePath queuePath) {
        String propName = QueuePrefixes.getQueuePrefix((QueuePath)queuePath) + "maximum-allocation";
        conf.unset(propName);
    }
}

