/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbstractYarnScheduler
extends ParameterizedSchedulerTestBase {
    private static long LAST_TIMESTAMP = 0L;

    public TestAbstractYarnScheduler(ParameterizedSchedulerTestBase.SchedulerType type) throws IOException {
        super(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximimumAllocationMemory() throws Exception {
        int node1MaxMemory = 15360;
        int node2MaxMemory = 5120;
        int node3MaxMemory = 6144;
        int configuredMaxMemory = 10240;
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 1000000L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationMemoryHelper((YarnScheduler)rm.getResourceScheduler(), 15360, 5120, 6144, 10240, 10240, 10240, 10240, 10240, 10240);
        }
        finally {
            rm.stop();
        }
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationMemoryHelper((YarnScheduler)rm.getResourceScheduler(), 15360, 5120, 6144, 10240, 10240, 10240, 5120, 6144, 5120);
        }
        finally {
            rm.stop();
        }
    }

    private void testMaximumAllocationMemoryHelper(YarnScheduler scheduler, int node1MaxMemory, int node2MaxMemory, int node3MaxMemory, int ... expectedMaxMemory) throws Exception {
        Assert.assertEquals((long)6L, (long)expectedMaxMemory.length);
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        long maxMemory = scheduler.getMaximumResourceCapability().getMemorySize();
        Assert.assertEquals((long)expectedMaxMemory[0], (long)maxMemory);
        RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((int)node1MaxMemory), 1, "127.0.0.2");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemorySize();
        Assert.assertEquals((long)expectedMaxMemory[1], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node1));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemorySize();
        Assert.assertEquals((long)expectedMaxMemory[2], (long)maxMemory);
        RMNode node2 = MockNodes.newNodeInfo(0, Resources.createResource((int)node2MaxMemory), 2, "127.0.0.3");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemorySize();
        Assert.assertEquals((long)expectedMaxMemory[3], (long)maxMemory);
        RMNode node3 = MockNodes.newNodeInfo(0, Resources.createResource((int)node3MaxMemory), 3, "127.0.0.4");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemorySize();
        Assert.assertEquals((long)expectedMaxMemory[4], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node3));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemorySize();
        Assert.assertEquals((long)expectedMaxMemory[5], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node2));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximimumAllocationVCores() throws Exception {
        int node1MaxVCores = 15;
        int node2MaxVCores = 5;
        int node3MaxVCores = 6;
        int configuredMaxVCores = 10;
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 10);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 1000000L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationVCoresHelper((YarnScheduler)rm.getResourceScheduler(), 15, 5, 6, 10, 10, 10, 10, 10, 10);
        }
        finally {
            rm.stop();
        }
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationVCoresHelper((YarnScheduler)rm.getResourceScheduler(), 15, 5, 6, 10, 10, 10, 5, 6, 5);
        }
        finally {
            rm.stop();
        }
    }

    private void testMaximumAllocationVCoresHelper(YarnScheduler scheduler, int node1MaxVCores, int node2MaxVCores, int node3MaxVCores, int ... expectedMaxVCores) throws Exception {
        Assert.assertEquals((long)6L, (long)expectedMaxVCores.length);
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        int maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[0], (long)maxVCores);
        RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node1MaxVCores), 1, "127.0.0.2");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[1], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node1));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[2], (long)maxVCores);
        RMNode node2 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node2MaxVCores), 2, "127.0.0.3");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[3], (long)maxVCores);
        RMNode node3 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node3MaxVCores), 3, "127.0.0.4");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[4], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node3));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[5], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node2));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
    }

    @Test
    public void testAutoCorrectContainerAllocation() {
        Configuration conf = new Configuration((Configuration)this.getConf());
        conf.setBoolean("yarn.resourcemanager.scheduler.autocorrect.container.allocation", true);
        conf.setBoolean("yarn.scheduler.capacity.root.auto-create-child-queue.enabled", true);
        MockRM rm = new MockRM(conf);
        rm.start();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node));
        ApplicationId appId1 = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId1, (int)1);
        RMAppAttemptMetrics attemptMetric1 = new RMAppAttemptMetrics(appAttemptId, rm.getRMContext());
        RMAppImpl app1 = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app1.getApplicationId()).thenReturn((Object)appId1);
        RMAppAttemptImpl attempt1 = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)attempt1.getMasterContainer()).thenReturn((Object)container);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)attempt1.getSubmissionContext()).thenReturn((Object)submissionContext);
        Mockito.when((Object)attempt1.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)attempt1.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric1);
        Mockito.when((Object)app1.getCurrentAppAttempt()).thenReturn((Object)attempt1);
        rm.getRMContext().getRMApps().put(appId1, app1);
        ApplicationPlacementContext apc = new ApplicationPlacementContext("user", "root");
        AppAddedSchedulerEvent addAppEvent1 = new AppAddedSchedulerEvent(appId1, "user", "user", apc);
        scheduler.handle((Event)addAppEvent1);
        AppAttemptAddedSchedulerEvent addAttemptEvent1 = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        scheduler.handle((Event)addAttemptEvent1);
        SchedulerApplicationAttempt application = scheduler.getApplicationAttempt(appAttemptId);
        SchedulerNode schedulerNode = scheduler.getSchedulerNode(node.getNodeID());
        Priority priority2 = Priority.newInstance((int)0);
        NodeId nodeId = NodeId.newInstance((String)"foo.bar.org", (int)1234);
        this.testContainerAskAndNewlyAllocatedContainerZero(scheduler, application, priority2);
        this.testContainerAskAndNewlyAllocatedContainerOne(scheduler, application, schedulerNode, nodeId, priority2, app1.getCurrentAppAttempt().getAppAttemptId());
        this.testContainerAskZeroAndNewlyAllocatedContainerOne(scheduler, application, schedulerNode, nodeId, priority2, app1.getCurrentAppAttempt().getAppAttemptId());
        this.testContainerAskFourAndNewlyAllocatedContainerEight(scheduler, application, schedulerNode, nodeId, priority2, app1.getCurrentAppAttempt().getAppAttemptId());
        this.testContainerAskFourAndNewlyAllocatedContainerSix(scheduler, application, schedulerNode, nodeId, priority2, app1.getCurrentAppAttempt().getAppAttemptId());
    }

    private RMContainer createMockRMContainer(int containerId, NodeId nodeId, ApplicationAttemptId appAttemptId, long allocationId, int memory, Priority priority2, ExecutionType executionType) {
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getResource()).thenReturn((Object)Resource.newInstance((int)memory, (int)1));
        Mockito.when((Object)container.getPriority()).thenReturn((Object)priority2);
        Mockito.when((Object)container.getId()).thenReturn((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)containerId));
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nodeId);
        Mockito.when((Object)container.getAllocationRequestId()).thenReturn((Object)allocationId);
        Mockito.when((Object)container.getExecutionType()).thenReturn((Object)executionType);
        Mockito.when((Object)container.getContainerToken()).thenReturn((Object)Token.newInstance((byte[])new byte[0], (String)"kind", (byte[])new byte[0], (String)"service"));
        RMContainer rmContainer = (RMContainer)Mockito.mock(RMContainerImpl.class);
        Mockito.when((Object)rmContainer.getContainer()).thenReturn((Object)container);
        Mockito.when((Object)rmContainer.getContainerId()).thenReturn((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)containerId));
        return rmContainer;
    }

    private void testContainerAskAndNewlyAllocatedContainerZero(AbstractYarnScheduler scheduler, SchedulerApplicationAttempt application, Priority priority2) {
        ResourceRequest resourceRequest = TestUtils.createResourceRequest(1024, 1, 1, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), "*");
        ArrayList<ResourceRequest> containerAsk = new ArrayList<ResourceRequest>();
        containerAsk.add(resourceRequest);
        scheduler.autoCorrectContainerAllocation(containerAsk, application);
        Assert.assertEquals((long)1L, (long)((ResourceRequest)containerAsk.get(0)).getNumContainers());
        Assert.assertEquals((long)0L, (long)application.pullNewlyAllocatedContainers().size());
    }

    private void testContainerAskAndNewlyAllocatedContainerOne(AbstractYarnScheduler scheduler, SchedulerApplicationAttempt application, SchedulerNode schedulerNode, NodeId nodeId, Priority priority2, ApplicationAttemptId appAttemptId) {
        ResourceRequest resourceRequest = TestUtils.createResourceRequest(1024, 1, 1, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), "*");
        ArrayList<ResourceRequest> containerAsk = new ArrayList<ResourceRequest>();
        containerAsk.add(resourceRequest);
        RMContainer rmContainer = this.createMockRMContainer(1, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer);
        scheduler.autoCorrectContainerAllocation(containerAsk, application);
        Assert.assertEquals((long)0L, (long)((ResourceRequest)containerAsk.get(0)).getNumContainers());
        Assert.assertEquals((long)1L, (long)application.pullNewlyAllocatedContainers().size());
    }

    private void testContainerAskZeroAndNewlyAllocatedContainerOne(AbstractYarnScheduler scheduler, SchedulerApplicationAttempt application, SchedulerNode schedulerNode, NodeId nodeId, Priority priority2, ApplicationAttemptId appAttemptId) {
        ResourceRequest resourceRequest = TestUtils.createResourceRequest(1024, 1, 0, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), "*");
        ArrayList<ResourceRequest> containerAsk = new ArrayList<ResourceRequest>();
        containerAsk.add(resourceRequest);
        RMContainer rmContainer1 = this.createMockRMContainer(1, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer1);
        scheduler.autoCorrectContainerAllocation(containerAsk, application);
        Assert.assertEquals((long)0L, (long)resourceRequest.getNumContainers());
        Assert.assertEquals((long)0L, (long)application.pullNewlyAllocatedContainers().size());
    }

    private void testContainerAskFourAndNewlyAllocatedContainerEight(AbstractYarnScheduler scheduler, SchedulerApplicationAttempt application, SchedulerNode schedulerNode, NodeId nodeId, Priority priority2, ApplicationAttemptId appAttemptId) {
        ResourceRequest resourceRequest1 = TestUtils.createResourceRequest(1024, 1, 1, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), "*");
        ResourceRequest resourceRequest2 = TestUtils.createResourceRequest(2048, 1, 1, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), "*");
        ResourceRequest resourceRequest3 = TestUtils.createResourceRequest(1024, 1, 1, priority2, 1L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), "*");
        ResourceRequest resourceRequest4 = TestUtils.createResourceRequest(1024, 1, 1, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC), "*");
        ArrayList<ResourceRequest> ask4 = new ArrayList<ResourceRequest>();
        ask4.add(resourceRequest1);
        ask4.add(resourceRequest2);
        ask4.add(resourceRequest3);
        ask4.add(resourceRequest4);
        RMContainer rmContainer1 = this.createMockRMContainer(1, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer2 = this.createMockRMContainer(2, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer3 = this.createMockRMContainer(3, nodeId, appAttemptId, 0L, 2048, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer4 = this.createMockRMContainer(4, nodeId, appAttemptId, 0L, 2048, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer5 = this.createMockRMContainer(5, nodeId, appAttemptId, 1L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer6 = this.createMockRMContainer(6, nodeId, appAttemptId, 1L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer7 = this.createMockRMContainer(7, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.OPPORTUNISTIC);
        RMContainer rmContainer8 = this.createMockRMContainer(8, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.OPPORTUNISTIC);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer1);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer2);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer3);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer4);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer5);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer6);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer7);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer8);
        scheduler.autoCorrectContainerAllocation(ask4, application);
        for (ResourceRequest rr : ask4) {
            Assert.assertEquals((long)0L, (long)rr.getNumContainers());
        }
        Assert.assertEquals((long)4L, (long)application.pullNewlyAllocatedContainers().size());
    }

    private void testContainerAskFourAndNewlyAllocatedContainerSix(AbstractYarnScheduler scheduler, SchedulerApplicationAttempt application, SchedulerNode schedulerNode, NodeId nodeId, Priority priority2, ApplicationAttemptId appAttemptId) {
        ResourceRequest resourceRequest1 = TestUtils.createResourceRequest(1024, 1, 4, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), "*");
        ResourceRequest resourceRequest2 = TestUtils.createResourceRequest(1024, 1, 4, priority2, 0L, ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), nodeId.getHost());
        ArrayList<ResourceRequest> containerAsk = new ArrayList<ResourceRequest>();
        containerAsk.add(resourceRequest1);
        containerAsk.add(resourceRequest2);
        RMContainer rmContainer1 = this.createMockRMContainer(1, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer2 = this.createMockRMContainer(2, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer3 = this.createMockRMContainer(3, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer4 = this.createMockRMContainer(4, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer5 = this.createMockRMContainer(5, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        RMContainer rmContainer6 = this.createMockRMContainer(6, nodeId, appAttemptId, 0L, 1024, priority2, ExecutionType.GUARANTEED);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer1);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer2);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer3);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer4);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer5);
        application.addToNewlyAllocatedContainers(schedulerNode, rmContainer6);
        scheduler.autoCorrectContainerAllocation(containerAsk, application);
        for (ResourceRequest resourceRequest : containerAsk) {
            Assert.assertEquals((long)0L, (long)resourceRequest.getNumContainers());
        }
        Assert.assertEquals((long)4L, (long)application.pullNewlyAllocatedContainers().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateMaxAllocationUsesTotal() throws IOException {
        int configuredMaxVCores = 20;
        int configuredMaxMemory = 10240;
        Resource configuredMaximumResource = Resource.newInstance((int)10240, (int)20);
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 20);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
            Resource emptyResource = Resource.newInstance((int)0, (int)0);
            Resource fullResource1 = Resource.newInstance((int)1024, (int)5);
            Resource fullResource2 = Resource.newInstance((int)2048, (int)10);
            SchedulerNode mockNode1 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
            Mockito.when((Object)mockNode1.getNodeID()).thenReturn((Object)NodeId.newInstance((String)"foo", (int)8080));
            Mockito.when((Object)mockNode1.getUnallocatedResource()).thenReturn((Object)emptyResource);
            Mockito.when((Object)mockNode1.getTotalResource()).thenReturn((Object)fullResource1);
            SchedulerNode mockNode2 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
            Mockito.when((Object)mockNode1.getNodeID()).thenReturn((Object)NodeId.newInstance((String)"bar", (int)8081));
            Mockito.when((Object)mockNode2.getUnallocatedResource()).thenReturn((Object)emptyResource);
            Mockito.when((Object)mockNode2.getTotalResource()).thenReturn((Object)fullResource2);
            this.verifyMaximumResourceCapability(configuredMaximumResource, (YarnScheduler)scheduler);
            scheduler.nodeTracker.addNode(mockNode1);
            this.verifyMaximumResourceCapability(fullResource1, (YarnScheduler)scheduler);
            scheduler.nodeTracker.addNode(mockNode2);
            this.verifyMaximumResourceCapability(fullResource2, (YarnScheduler)scheduler);
            scheduler.nodeTracker.removeNode(mockNode2.getNodeID());
            this.verifyMaximumResourceCapability(fullResource1, (YarnScheduler)scheduler);
            scheduler.nodeTracker.removeNode(mockNode1.getNodeID());
            this.verifyMaximumResourceCapability(configuredMaximumResource, (YarnScheduler)scheduler);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxAllocationAfterUpdateNodeResource() throws IOException {
        int configuredMaxVCores = 20;
        int configuredMaxMemory = 10240;
        Resource configuredMaximumResource = Resource.newInstance((int)10240, (int)20);
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 20);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
            this.verifyMaximumResourceCapability(configuredMaximumResource, (YarnScheduler)scheduler);
            Resource resource1 = Resource.newInstance((int)2048, (int)5);
            Resource resource2 = Resource.newInstance((int)4096, (int)10);
            Resource resource3 = Resource.newInstance((int)512, (int)1);
            Resource resource4 = Resource.newInstance((int)1024, (int)2);
            RMNode node1 = MockNodes.newNodeInfo(0, resource1, 1, "127.0.0.2");
            scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
            RMNode node2 = MockNodes.newNodeInfo(0, resource3, 2, "127.0.0.3");
            scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node1, ResourceOption.newInstance((Resource)resource2, (int)0));
            this.verifyMaximumResourceCapability(resource2, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node1, ResourceOption.newInstance((Resource)resource1, (int)0));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node2, ResourceOption.newInstance((Resource)resource4, (int)0));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node2, ResourceOption.newInstance((Resource)resource3, (int)0));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testReleasedContainerIfAppAttemptisNull() throws Exception {
        YarnConfiguration conf = this.getConf();
        MockRM rm1 = new MockRM((Configuration)conf);
        try {
            rm1.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, rm1.getResourceTrackerService());
            nm1.registerNode();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm1.getResourceScheduler();
            MockRMApp mockAPp = new MockRMApp(125, System.currentTimeMillis(), RMAppState.NEW);
            SchedulerApplication application = new SchedulerApplication(null, mockAPp.getUser(), false);
            RMApp app = MockRMAppSubmitter.submitWithMemory(200L, rm1);
            MockAM am1 = MockRM.launchAndRegisterAM(app, rm1, nm1);
            ContainerId runningContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
            am1.allocate(null, Arrays.asList(runningContainer));
            Map schedulerApplications = scheduler.getSchedulerApplications();
            SchedulerApplication schedulerApp = (SchedulerApplication)scheduler.getSchedulerApplications().get(app.getApplicationId());
            schedulerApplications.put(mockAPp.getApplicationId(), application);
            scheduler.clearPendingContainerCache();
            Assert.assertEquals((String)"Pending containers are not released when one of the application attempt is null !", (long)schedulerApp.getCurrentAppAttempt().getPendingRelease().size(), (long)0L);
        }
        finally {
            if (rm1 != null) {
                rm1.stop();
            }
        }
    }

    @Test(timeout=30000L)
    public void testContainerReleaseWithAllocationTags() throws Exception {
        if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.CAPACITY)) {
            String testTag1 = "some-tag";
            String testTag2 = "some-other-tag";
            YarnConfiguration conf = this.getConf();
            conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
            MockRM rm1 = new MockRM((Configuration)conf);
            rm1.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
            nm1.registerNode();
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("Test").withWaitForAppAcceptedState(false).withKeepContainers(true).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
            SchedulingRequest sr = SchedulingRequest.newInstance((long)1L, (Priority)Priority.newInstance((int)1), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), (Set)Sets.newHashSet((Object[])new String[]{"some-tag"}), (ResourceSizing)ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), null);
            SchedulingRequest sr1 = SchedulingRequest.newInstance((long)2L, (Priority)Priority.newInstance((int)1), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), (Set)Sets.newHashSet((Object[])new String[]{"some-other-tag"}), (ResourceSizing)ResourceSizing.newInstance((int)3, (Resource)Resource.newInstance((int)1024, (int)1)), null);
            AllocateRequest ar = AllocateRequest.newBuilder().schedulingRequests((List)Lists.newArrayList((Object[])new SchedulingRequest[]{sr, sr1})).build();
            am1.allocate(ar);
            nm1.nodeHeartbeat(true);
            ArrayList allocated = new ArrayList();
            while (allocated.size() < 4) {
                AllocateResponse rsp = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
                allocated.addAll(rsp.getAllocatedContainers());
                nm1.nodeHeartbeat(true);
                Thread.sleep(1000L);
            }
            Assert.assertEquals((long)4L, (long)allocated.size());
            Set containers = allocated.stream().filter(container -> container.getAllocationRequestId() == 1L).collect(Collectors.toSet());
            Assert.assertNotNull(containers);
            Assert.assertEquals((long)1L, (long)containers.size());
            ContainerId cid = ((Container)containers.iterator().next()).getId();
            rm1.getRMContext().getScheduler().getSchedulerNode(nm1.getNodeId()).containerStarted(cid);
            Map nodeTags = rm1.getRMContext().getAllocationTagsManager().getAllocationTagsWithCount(nm1.getNodeId());
            Assert.assertNotNull(nodeTags.get("some-tag"));
            Assert.assertEquals((long)1L, (long)((Long)nodeTags.get("some-tag")).intValue());
            am1.allocate(new ArrayList<ResourceRequest>(), Lists.newArrayList((Object[])new ContainerId[]{cid}));
            nodeTags = rm1.getRMContext().getAllocationTagsManager().getAllocationTagsWithCount(nm1.getNodeId());
            Assert.assertNotNull((Object)nodeTags);
            Assert.assertNotNull(nodeTags.get("some-tag"));
            Assert.assertEquals((long)1L, (long)((Long)nodeTags.get("some-tag")).intValue());
            ContainerStatus cs = ContainerStatus.newInstance((ContainerId)cid, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0);
            nm1.nodeHeartbeat(Lists.newArrayList((Object[])new ContainerStatus[]{cs}), true);
            GenericTestUtils.waitFor(() -> {
                Map tags = rm1.getRMContext().getAllocationTagsManager().getAllocationTagsWithCount(nm1.getNodeId());
                return tags.get("some-tag") == null && ((Long)tags.get("some-other-tag")).intValue() == 3;
            }, (long)500L, (long)3000L);
        }
    }

    @Test(timeout=30000L)
    public void testNodeRemovedWithAllocationTags() throws Exception {
        if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.CAPACITY)) {
            String testTag1 = "some-tag";
            YarnConfiguration conf = this.getConf();
            conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
            MockRM rm1 = new MockRM((Configuration)conf);
            rm1.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
            nm1.registerNode();
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("Test").withWaitForAppAcceptedState(false).withKeepContainers(true).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
            SchedulingRequest sr = SchedulingRequest.newInstance((long)1L, (Priority)Priority.newInstance((int)1), (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED), (Set)Sets.newHashSet((Object[])new String[]{"some-tag"}), (ResourceSizing)ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)1024, (int)1)), null);
            AllocateRequest ar = AllocateRequest.newBuilder().schedulingRequests((List)Lists.newArrayList((Object[])new SchedulingRequest[]{sr})).build();
            am1.allocate(ar);
            nm1.nodeHeartbeat(true);
            ArrayList allocated = new ArrayList();
            while (allocated.size() < 1) {
                AllocateResponse rsp = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
                allocated.addAll(rsp.getAllocatedContainers());
                nm1.nodeHeartbeat(true);
                Thread.sleep(1000L);
            }
            Assert.assertEquals((long)1L, (long)allocated.size());
            Set containers = allocated.stream().filter(container -> container.getAllocationRequestId() == 1L).collect(Collectors.toSet());
            Assert.assertNotNull(containers);
            Assert.assertEquals((long)1L, (long)containers.size());
            ContainerId cid = ((Container)containers.iterator().next()).getId();
            rm1.getRMContext().getScheduler().getSchedulerNode(nm1.getNodeId()).containerStarted(cid);
            Map nodeTags = rm1.getRMContext().getAllocationTagsManager().getAllocationTagsWithCount(nm1.getNodeId());
            Assert.assertNotNull(nodeTags.get("some-tag"));
            Assert.assertEquals((long)1L, (long)((Long)nodeTags.get("some-tag")).intValue());
            RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((long)nm1.getMemory()), 1, "127.0.0.1", 1234);
            rm1.getRMContext().getScheduler().handle((Event)new NodeRemovedSchedulerEvent(node1));
            nodeTags = rm1.getRMContext().getAllocationTagsManager().getAllocationTagsWithCount(nm1.getNodeId());
            Assert.assertNull((Object)nodeTags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testContainerReleasedByNode() throws Exception {
        System.out.println("Starting testContainerReleasedByNode");
        YarnConfiguration conf = this.getConf();
        MockRM rm1 = new MockRM((Configuration)conf);
        try {
            rm1.start();
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("Test").withWaitForAppAcceptedState(false).withKeepContainers(true).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
            MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
            nm1.registerNode();
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
            am1.allocate("127.0.0.1", 8192, 1, new ArrayList<ContainerId>());
            nm1.nodeHeartbeat(true);
            List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.isEmpty()) {
                Thread.sleep(10L);
                nm1.nodeHeartbeat(true);
                containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            }
            ContainerId cid = ((Container)containers.get(0)).getId();
            ArrayList<ContainerId> releasedContainers = new ArrayList<ContainerId>(1);
            releasedContainers.add(cid);
            List completedContainers = am1.allocate(new ArrayList<ResourceRequest>(), releasedContainers).getCompletedContainersStatuses();
            while (completedContainers.isEmpty()) {
                Thread.sleep(10L);
                completedContainers = am1.allocate(new ArrayList<ResourceRequest>(), releasedContainers).getCompletedContainersStatuses();
            }
            containers = am1.allocate("127.0.0.1", 8192, 1, new ArrayList<ContainerId>()).getAllocatedContainers();
            nm1.nodeHeartbeat(true);
            while (containers.isEmpty()) {
                Thread.sleep(10L);
                nm1.nodeHeartbeat(true);
                containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            }
            cid = ((Container)containers.get(0)).getId();
            nm1.nodeHeartbeat(cid.getApplicationAttemptId(), cid.getContainerId(), ContainerState.RUNNING);
            rm1.waitForState(nm1, cid, RMContainerState.RUNNING);
            releasedContainers.clear();
            releasedContainers.add(cid);
            completedContainers = am1.allocate(new ArrayList<ResourceRequest>(), releasedContainers).getCompletedContainersStatuses();
            while (completedContainers.isEmpty()) {
                Thread.sleep(10L);
                completedContainers = am1.allocate(new ArrayList<ResourceRequest>(), releasedContainers).getCompletedContainersStatuses();
            }
            containers = am1.allocate("127.0.0.1", 8192, 1, new ArrayList<ContainerId>()).getAllocatedContainers();
            nm1.nodeHeartbeat(true);
            Assert.assertTrue((String)"new container allocated before node freed old", (boolean)containers.isEmpty());
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(10L);
                containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
                nm1.nodeHeartbeat(true);
                Assert.assertTrue((String)"new container allocated before node freed old", (boolean)containers.isEmpty());
            }
            nm1.nodeHeartbeat(cid.getApplicationAttemptId(), cid.getContainerId(), ContainerState.COMPLETE);
            containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.isEmpty()) {
                Thread.sleep(10L);
                nm1.nodeHeartbeat(true);
                containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            }
        }
        finally {
            rm1.stop();
            System.out.println("Stopping testContainerReleasedByNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testResourceRequestRestoreWhenRMContainerIsAtAllocated() throws Exception {
        YarnConfiguration conf = this.getConf();
        MockRM rm1 = new MockRM((Configuration)conf);
        try {
            rm1.start();
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("Test").withWaitForAppAcceptedState(false).withKeepContainers(true).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
            MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
            nm1.registerNode();
            MockNM nm2 = new MockNM("127.0.0.1:2351", 10240, rm1.getResourceTrackerService());
            nm2.registerNode();
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
            int NUM_CONTAINERS = 1;
            am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
            nm1.nodeHeartbeat(true);
            List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != NUM_CONTAINERS) {
                nm1.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
            ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
            rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
            am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
            nm2.nodeHeartbeat(true);
            ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
            rm1.waitForState(nm2, containerId3, RMContainerState.ALLOCATED);
            nm2.registerNode();
            rm1.waitForState(nm2, containerId3, RMContainerState.KILLED);
            containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != NUM_CONTAINERS) {
                nm2.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            nm2.nodeHeartbeat(am1.getApplicationAttemptId(), 4L, ContainerState.RUNNING);
            ContainerId containerId4 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)4L);
            rm1.waitForState(nm2, containerId4, RMContainerState.RUNNING);
        }
        finally {
            rm1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceRequestRecoveryToTheRightAppAttempt() throws Exception {
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("Test").withWaitForAppAcceptedState(false).withKeepContainers(true).build();
            RMApp rmApp = MockRMAppSubmitter.submit(rm, data);
            MockNM node = new MockNM("127.0.0.1:1234", 10240, rm.getResourceTrackerService());
            node.registerNode();
            MockAM am1 = MockRM.launchAndRegisterAM(rmApp, rm, node);
            ApplicationAttemptId applicationAttemptOneID = am1.getApplicationAttemptId();
            ContainerId am1ContainerID = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptOneID, (long)1L);
            am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
            node.nodeHeartbeat(true);
            List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != 1) {
                node.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            node.nodeHeartbeat(applicationAttemptOneID, 2L, ContainerState.RUNNING);
            ContainerId runningContainerID = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptOneID, (long)2L);
            rm.waitForState(node, runningContainerID, RMContainerState.RUNNING);
            int ALLOCATED_CONTAINER_PRIORITY = 1047;
            am1.allocate("127.0.0.1", 1024, 1, ALLOCATED_CONTAINER_PRIORITY, new ArrayList<ContainerId>(), null);
            node.nodeHeartbeat(true);
            ContainerId allocatedContainerID = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptOneID, (long)3L);
            rm.waitForState(node, allocatedContainerID, RMContainerState.ALLOCATED);
            RMContainer allocatedContainer = rm.getResourceScheduler().getRMContainer(allocatedContainerID);
            SchedulerApplicationAttempt firstSchedulerAppAttempt = ((AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(applicationAttemptOneID);
            node.nodeHeartbeat(applicationAttemptOneID, 1L, ContainerState.COMPLETE);
            rm.drainEvents();
            RMAppAttempt rmAppAttempt2 = MockRM.waitForAttemptScheduled(rmApp, rm);
            ApplicationAttemptId applicationAttemptTwoID = rmAppAttempt2.getAppAttemptId();
            Assert.assertEquals((long)2L, (long)applicationAttemptTwoID.getAttemptId());
            Assert.assertEquals((Object)RMContainerState.KILLED, (Object)allocatedContainer.getState());
            for (SchedulerRequestKey key : firstSchedulerAppAttempt.getSchedulerKeys()) {
                if (key.getPriority().getPriority() == 0) {
                    Assert.assertEquals((long)0L, (long)firstSchedulerAppAttempt.getOutstandingAsksCount(key));
                    continue;
                }
                if (key.getPriority().getPriority() != ALLOCATED_CONTAINER_PRIORITY) continue;
                Assert.assertEquals((long)1L, (long)firstSchedulerAppAttempt.getOutstandingAsksCount(key));
            }
            MockRM.launchAM(rmApp, rm, node);
            List transferredContainers = rm.getResourceScheduler().getTransferredContainers(applicationAttemptTwoID);
            Assert.assertEquals((long)1L, (long)transferredContainers.size());
            Assert.assertEquals((Object)runningContainerID, (Object)((Container)transferredContainers.get(0)).getId());
        }
        finally {
            rm.stop();
        }
    }

    private void verifyMaximumResourceCapability(Resource expectedMaximumResource, YarnScheduler scheduler) {
        Resource schedulerMaximumResourceCapability = scheduler.getMaximumResourceCapability();
        Assert.assertEquals((long)expectedMaximumResource.getMemorySize(), (long)schedulerMaximumResourceCapability.getMemorySize());
        Assert.assertEquals((long)expectedMaximumResource.getVirtualCores(), (long)schedulerMaximumResourceCapability.getVirtualCores());
    }

    private ResourceTrackerService getPrivateResourceTrackerService(Dispatcher privateDispatcher, ResourceManager rm, SleepHandler sleepHandler) {
        YarnConfiguration conf = this.getConf();
        RMContextImpl privateContext = new RMContextImpl(privateDispatcher, null, null, null, null, null, null, null, null, null);
        privateContext.setNodeLabelManager((RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class));
        privateDispatcher.register(SchedulerEventType.class, (EventHandler)sleepHandler);
        privateDispatcher.register(SchedulerEventType.class, (EventHandler)rm.getResourceScheduler());
        privateDispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)privateContext));
        ((Service)privateDispatcher).init((Configuration)conf);
        ((Service)privateDispatcher).start();
        NMLivelinessMonitor nmLivelinessMonitor = new NMLivelinessMonitor(privateDispatcher);
        nmLivelinessMonitor.init((Configuration)conf);
        nmLivelinessMonitor.start();
        NodesListManager nodesListManager = new NodesListManager((RMContext)privateContext);
        nodesListManager.init((Configuration)conf);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.start();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM((Configuration)conf);
        nmTokenSecretManager.start();
        ResourceTrackerService privateResourceTrackerService = new ResourceTrackerService((RMContext)privateContext, nodesListManager, nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager);
        privateResourceTrackerService.init((Configuration)conf);
        privateResourceTrackerService.start();
        rm.getResourceScheduler().setRMContext((RMContext)privateContext);
        return privateResourceTrackerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNodemanagerReconnect() throws Exception {
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            DrainDispatcher privateDispatcher = new DrainDispatcher();
            privateDispatcher.disableExitOnDispatchException();
            SleepHandler sleepHandler = new SleepHandler();
            ResourceTrackerService privateResourceTrackerService = this.getPrivateResourceTrackerService((Dispatcher)privateDispatcher, rm, sleepHandler);
            String hostname1 = "localhost1";
            Resource capability = Resources.createResource((int)4096, (int)4);
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
            NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
            NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
            request1.setNodeId(nodeId1);
            request1.setHttpPort(0);
            request1.setResource(capability);
            request1.setNodeStatus(mockNodeStatus);
            privateResourceTrackerService.registerNodeManager(request1);
            privateDispatcher.await();
            Resource clusterResource = rm.getResourceScheduler().getClusterResource();
            Assert.assertEquals((String)"Initial cluster resources don't match", (Object)capability, (Object)clusterResource);
            Resource newCapability = Resources.createResource((int)1024);
            RegisterNodeManagerRequest request2 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
            request2.setNodeId(nodeId1);
            request2.setHttpPort(0);
            request2.setResource(newCapability);
            sleepHandler.sleepFlag = true;
            privateResourceTrackerService.registerNodeManager(request2);
            privateDispatcher.await();
            Assert.assertEquals((String)"Cluster resources don't match", (Object)newCapability, (Object)rm.getResourceScheduler().getClusterResource());
            privateResourceTrackerService.stop();
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testUpdateThreadLifeCycle() throws Exception {
        MockRM rm = new MockRM((Configuration)this.getConf());
        try {
            rm.start();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
            if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.FAIR)) {
                Thread updateThread = scheduler.updateThread;
                Assert.assertTrue((boolean)updateThread.isAlive());
                scheduler.stop();
                int numRetries = 100;
                while (numRetries-- > 0 && updateThread.isAlive()) {
                    Thread.sleep(50L);
                }
                Assert.assertNotEquals((String)"The Update thread is still alive", (long)0L, (long)numRetries);
            } else if (this.getSchedulerType().equals((Object)ParameterizedSchedulerTestBase.SchedulerType.CAPACITY)) {
                Assert.assertNull((String)"updateThread shouldn't have been created", (Object)scheduler.updateThread);
            } else {
                Assert.fail((String)("Unhandled SchedulerType, " + this.getSchedulerType() + ", please update this unit test."));
            }
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testContainerRecoveredByNode() throws Exception {
        System.out.println("Starting testContainerRecoveredByNode");
        int maxMemory = 10240;
        YarnConfiguration conf = this.getConf();
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm1 = new MockRM((Configuration)conf);
        try {
            rm1.start();
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("name").withUser("user").withAcls(new HashMap<ApplicationAccessType, String>()).withUnmanagedAM(false).withQueue("default").withMaxAppAttempts(-1).withCredentials(null).withAppType("Test").withWaitForAppAcceptedState(false).withKeepContainers(true).build();
            RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
            MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
            nm1.registerNode();
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
            am1.allocate("127.0.0.1", 8192, 1, new ArrayList<ContainerId>());
            ResourceScheduler scheduler = rm1.getResourceScheduler();
            RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((int)10240), 1, "127.0.0.2");
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)app1.getCurrentAppAttempt().getAppAttemptId(), (long)2L);
            NMContainerStatus containerReport = NMContainerStatus.newInstance((ContainerId)containerId, (int)0, (ContainerState)ContainerState.RUNNING, (Resource)Resource.newInstance((int)1024, (int)1), (String)"recover container", (int)0, (Priority)Priority.newInstance((int)0), (long)0L);
            ArrayList<NMContainerStatus> containerReports = new ArrayList<NMContainerStatus>();
            containerReports.add(containerReport);
            scheduler.handle((Event)new NodeAddedSchedulerEvent(node1, containerReports));
            RMContainer rmContainer = scheduler.getRMContainer(containerId);
            if (scheduler instanceof CapacityScheduler) {
                Assert.assertEquals((Object)app1.getQueue(), (Object)rmContainer.getQueueName());
            } else {
                Assert.assertEquals((Object)app1.getQueue(), (Object)rmContainer.getQueueName());
            }
        }
        finally {
            rm1.stop();
            System.out.println("Stopping testContainerRecoveredByNode");
        }
    }

    @Test
    public void testGetRunningContainersToKill() {
        MockSchedulerNode node = new MockSchedulerNode();
        Assert.assertEquals(Collections.emptyList(), (Object)node.getContainersToKill());
        RMContainer am0 = TestAbstractYarnScheduler.newMockRMContainer(true, ExecutionType.GUARANTEED, "AM0");
        node.allocateContainer(am0);
        Assert.assertEquals(Arrays.asList(am0), (Object)node.getContainersToKill());
        RMContainer opp0 = TestAbstractYarnScheduler.newMockRMContainer(false, ExecutionType.OPPORTUNISTIC, "OPPORTUNISTIC0");
        node.allocateContainer(opp0);
        Assert.assertEquals(Arrays.asList(opp0, am0), (Object)node.getContainersToKill());
        RMContainer regular0 = TestAbstractYarnScheduler.newMockRMContainer(false, ExecutionType.GUARANTEED, "GUARANTEED0");
        node.allocateContainer(regular0);
        Assert.assertEquals(Arrays.asList(opp0, regular0, am0), (Object)node.getContainersToKill());
        RMContainer opp1 = TestAbstractYarnScheduler.newMockRMContainer(false, ExecutionType.OPPORTUNISTIC, "OPPORTUNISTIC1");
        node.allocateContainer(opp1);
        Assert.assertEquals(Arrays.asList(opp1, opp0, regular0, am0), (Object)node.getContainersToKill());
        RMContainer am1 = TestAbstractYarnScheduler.newMockRMContainer(true, ExecutionType.GUARANTEED, "AM1");
        node.allocateContainer(am1);
        Assert.assertEquals(Arrays.asList(opp1, opp0, regular0, am1, am0), (Object)node.getContainersToKill());
        RMContainer regular1 = TestAbstractYarnScheduler.newMockRMContainer(false, ExecutionType.GUARANTEED, "GUARANTEED1");
        node.allocateContainer(regular1);
        Assert.assertEquals(Arrays.asList(opp1, opp0, regular1, regular0, am1, am0), (Object)node.getContainersToKill());
    }

    private static RMContainer newMockRMContainer(boolean isAMContainer, ExecutionType executionType, String name) {
        long now = Time.now();
        while (now <= LAST_TIMESTAMP) {
            now = Time.now();
        }
        LAST_TIMESTAMP = now;
        RMContainer container = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)container.isAMContainer()).thenReturn((Object)isAMContainer);
        Mockito.when((Object)container.getExecutionType()).thenReturn((Object)executionType);
        Mockito.when((Object)container.getCreationTime()).thenReturn((Object)now);
        Mockito.when((Object)container.toString()).thenReturn((Object)name);
        return container;
    }

    private class SleepHandler
    implements EventHandler<SchedulerEvent> {
        boolean sleepFlag = false;
        int sleepTime = 20;

        private SleepHandler() {
        }

        public void handle(SchedulerEvent event) {
            try {
                if (this.sleepFlag) {
                    Thread.sleep(this.sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class MockSchedulerNode
    extends SchedulerNode {
        private final List<RMContainer> containers = new ArrayList<RMContainer>();

        MockSchedulerNode() {
            super(MockNodes.newNodeInfo(0, Resource.newInstance((int)1, (int)1)), false);
        }

        protected List<RMContainer> getLaunchedContainers() {
            return this.containers;
        }

        public void allocateContainer(RMContainer rmContainer) {
            this.containers.add(rmContainer);
            Collections.shuffle(this.containers);
        }

        public void reserveResource(SchedulerApplicationAttempt attempt, SchedulerRequestKey schedulerKey, RMContainer container) {
        }

        public void unreserveResource(SchedulerApplicationAttempt attempt) {
        }
    }
}

