/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRLESparseResourceAllocation {
    private static final Logger LOG = LoggerFactory.getLogger(TestRLESparseResourceAllocation.class);

    @Test
    public void testMergeAdd() throws PlanningException {
        TreeMap<Long, Resource> a = new TreeMap<Long, Resource>();
        TreeMap<Long, Resource> b = new TreeMap<Long, Resource>();
        this.setupArrays(a, b);
        RLESparseResourceAllocation rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation out = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.add, (long)18L, (long)45L);
        System.out.println(out);
        long[] time = new long[]{18L, 20L, 22L, 30L, 33L, 40L, 43L, 45L};
        int[] alloc = new int[]{10, 15, 20, 25, 30, 40, 30};
        this.validate(out, time, alloc);
    }

    @Test
    public void testMergeMin() throws PlanningException {
        TreeMap<Long, Resource> a = new TreeMap<Long, Resource>();
        TreeMap<Long, Resource> b = new TreeMap<Long, Resource>();
        this.setupArrays(a, b);
        RLESparseResourceAllocation rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation out = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.min, (long)0L, (long)60L);
        System.out.println(out);
        long[] time = new long[]{10L, 22L, 33L, 40L, 43L, 50L, 60L};
        int[] alloc = new int[]{5, 10, 15, 20, 10, 0};
        this.validate(out, time, alloc);
    }

    @Test
    public void testMergeMax() throws PlanningException {
        TreeMap<Long, Resource> a = new TreeMap<Long, Resource>();
        TreeMap<Long, Resource> b = new TreeMap<Long, Resource>();
        this.setupArrays(a, b);
        RLESparseResourceAllocation rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation out = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.max, (long)0L, (long)60L);
        System.out.println(out);
        long[] time = new long[]{10L, 20L, 30L, 40L, 50L, 60L};
        int[] alloc = new int[]{5, 10, 15, 20, 10};
        this.validate(out, time, alloc);
    }

    @Test
    public void testMergeSubtract() throws PlanningException {
        TreeMap<Long, Resource> a = new TreeMap<Long, Resource>();
        TreeMap<Long, Resource> b = new TreeMap<Long, Resource>();
        this.setupArrays(a, b);
        RLESparseResourceAllocation rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation out = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.subtract, (long)0L, (long)60L);
        System.out.println(out);
        long[] time = new long[]{10L, 11L, 20L, 22L, 30L, 33L, 43L, 50L, 60L};
        int[] alloc = new int[]{5, 0, 5, 0, 5, 0, 10, -10};
        this.validate(out, time, alloc);
    }

    @Test
    public void testMergesubtractTestNonNegative() throws PlanningException {
        RLESparseResourceAllocation out2;
        TreeMap<Long, Object> a = new TreeMap<Long, Resource>();
        TreeMap<Long, Object> b = new TreeMap<Long, Resource>();
        this.setupArrays(a, b);
        RLESparseResourceAllocation rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        RLESparseResourceAllocation rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        try {
            out2 = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, (long)0L, (long)60L);
            Assert.fail();
        }
        catch (PlanningException out2) {
            // empty catch block
        }
        a = new TreeMap();
        b = new TreeMap();
        b.put(11L, Resource.newInstance((int)5, (int)6));
        rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        try {
            out2 = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, (long)0L, (long)60L);
            Assert.fail();
        }
        catch (PlanningException out3) {
            // empty catch block
        }
        a.put(10L, Resource.newInstance((int)10, (int)5));
        b.put(11L, Resource.newInstance((int)5, (int)6));
        rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        try {
            out2 = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, (long)0L, (long)60L);
            Assert.fail();
        }
        catch (PlanningException out4) {
            // empty catch block
        }
        a.put(10L, Resource.newInstance((int)5, (int)10));
        b.put(11L, Resource.newInstance((int)6, (int)5));
        rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        try {
            out2 = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, (long)0L, (long)60L);
            Assert.fail();
        }
        catch (PlanningException out5) {
            // empty catch block
        }
        a.put(10L, Resource.newInstance((int)10, (int)6));
        b.put(11L, Resource.newInstance((int)5, (int)6));
        rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
        rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
        out2 = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, (long)0L, (long)60L);
    }

    @Test
    @Ignore
    public void testMergeSpeed() throws PlanningException {
        for (int j = 0; j < 100; ++j) {
            TreeMap<Long, Resource> a = new TreeMap<Long, Resource>();
            TreeMap<Long, Resource> b = new TreeMap<Long, Resource>();
            Random rand = new Random();
            long startA = 0L;
            long startB = 0L;
            for (int i = 0; i < 1000 + rand.nextInt(9000); ++i) {
                a.put(startA += (long)rand.nextInt(100), Resource.newInstance((int)rand.nextInt(10240), (int)rand.nextInt(10)));
                b.put(startB += (long)rand.nextInt(100), Resource.newInstance((int)rand.nextInt(10240), (int)rand.nextInt(10)));
            }
            RLESparseResourceAllocation rleA = new RLESparseResourceAllocation(a, (ResourceCalculator)new DefaultResourceCalculator());
            RLESparseResourceAllocation rleB = new RLESparseResourceAllocation(b, (ResourceCalculator)new DefaultResourceCalculator());
            long start = System.currentTimeMillis();
            RLESparseResourceAllocation out = RLESparseResourceAllocation.merge((ResourceCalculator)new DefaultResourceCalculator(), (Resource)Resource.newInstance((int)0xC80000, (int)3200), (RLESparseResourceAllocation)rleA, (RLESparseResourceAllocation)rleB, (RLESparseResourceAllocation.RLEOperator)RLESparseResourceAllocation.RLEOperator.add, (long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
            long end = System.currentTimeMillis();
            System.out.println(" Took: " + (end - start) + "ms ");
        }
    }

    @Test
    public void testRangeOverlapping() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        RLESparseResourceAllocation r = new RLESparseResourceAllocation((ResourceCalculator)resCalc);
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        Set<Map.Entry<ReservationInterval, Resource>> inputs = this.generateAllocation(start, alloc, false).entrySet();
        for (Map.Entry<ReservationInterval, Resource> ip : inputs) {
            r.addInterval(ip.getKey(), ip.getValue());
        }
        long s = r.getEarliestStartTime();
        long d = r.getLatestNonNullTime();
        r = r.getRangeOverlapping(s, d);
        r = r.getRangeOverlapping(s - 1L, d - 1L);
        r = r.getRangeOverlapping(s + 1L, d + 1L);
    }

    @Test
    public void testBlocks() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc);
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        Set<Map.Entry<ReservationInterval, Resource>> inputs = this.generateAllocation(start, alloc, false).entrySet();
        for (Map.Entry<ReservationInterval, Resource> ip : inputs) {
            rleSparseVector.addInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        Assert.assertFalse((boolean)rleSparseVector.isEmpty());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(99L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 1)));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 2)));
        for (Map.Entry<ReservationInterval, Resource> ip : inputs) {
            rleSparseVector.removeInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    @Test
    public void testPartialRemoval() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc);
        ReservationInterval riAdd = new ReservationInterval(10L, 20L);
        Resource rr = Resource.newInstance((int)102400, (int)100);
        ReservationInterval riAdd2 = new ReservationInterval(20L, 30L);
        Resource rr2 = Resource.newInstance((int)204800, (int)200);
        ReservationInterval riRemove = new ReservationInterval(12L, 25L);
        LOG.info(rleSparseVector.toString());
        rleSparseVector.addInterval(riAdd, rr);
        rleSparseVector.addInterval(riAdd2, rr2);
        LOG.info(rleSparseVector.toString());
        rleSparseVector.removeInterval(riRemove, rr);
        LOG.info(rleSparseVector.toString());
        Assert.assertEquals((long)102400L, (long)rleSparseVector.getCapacityAtTime(10L).getMemorySize());
        Assert.assertEquals((long)0L, (long)rleSparseVector.getCapacityAtTime(13L).getMemorySize());
        Assert.assertEquals((long)0L, (long)rleSparseVector.getCapacityAtTime(19L).getMemorySize());
        Assert.assertEquals((long)102400L, (long)rleSparseVector.getCapacityAtTime(21L).getMemorySize());
        Assert.assertEquals((long)204800L, (long)rleSparseVector.getCapacityAtTime(26L).getMemorySize());
        ReservationInterval riRemove2 = new ReservationInterval(9L, 13L);
        rleSparseVector.removeInterval(riRemove2, rr);
        LOG.info(rleSparseVector.toString());
        Assert.assertEquals((long)0L, (long)rleSparseVector.getCapacityAtTime(11L).getMemorySize());
        Assert.assertEquals((long)-102400L, (long)rleSparseVector.getCapacityAtTime(9L).getMemorySize());
        Assert.assertEquals((long)0L, (long)rleSparseVector.getCapacityAtTime(13L).getMemorySize());
        Assert.assertEquals((long)102400L, (long)rleSparseVector.getCapacityAtTime(20L).getMemorySize());
    }

    @Test
    public void testSteps() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc);
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        Set<Map.Entry<ReservationInterval, Resource>> inputs = this.generateAllocation(start, alloc, true).entrySet();
        for (Map.Entry<ReservationInterval, Resource> ip : inputs) {
            rleSparseVector.addInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        Assert.assertFalse((boolean)rleSparseVector.isEmpty());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(99L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 1)));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 2)));
        for (Map.Entry<ReservationInterval, Resource> ip : inputs) {
            rleSparseVector.removeInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    @Test
    public void testSkyline() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc);
        int[] alloc = new int[]{0, 5, 10, 10, 5, 0};
        int start = 100;
        Set<Map.Entry<ReservationInterval, Resource>> inputs = this.generateAllocation(start, alloc, true).entrySet();
        for (Map.Entry<ReservationInterval, Resource> ip : inputs) {
            rleSparseVector.addInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        Assert.assertFalse((boolean)rleSparseVector.isEmpty());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(99L));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 1)));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + alloc.length + 2)));
        for (Map.Entry<ReservationInterval, Resource> ip : inputs) {
            rleSparseVector.removeInterval(ip.getKey(), ip.getValue());
        }
        LOG.info(rleSparseVector.toString());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime((long)(start + i)));
        }
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    @Test
    public void testZeroAllocation() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc);
        rleSparseVector.addInterval(new ReservationInterval(0L, Long.MAX_VALUE), Resource.newInstance((int)0, (int)0));
        LOG.info(rleSparseVector.toString());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)rleSparseVector.getCapacityAtTime(new Random().nextLong()));
        Assert.assertTrue((boolean)rleSparseVector.isEmpty());
    }

    @Test
    public void testToIntervalMap() {
        DefaultResourceCalculator resCalc = new DefaultResourceCalculator();
        RLESparseResourceAllocation rleSparseVector = new RLESparseResourceAllocation((ResourceCalculator)resCalc);
        Map mapAllocations = rleSparseVector.toIntervalMap();
        Assert.assertTrue((boolean)mapAllocations.isEmpty());
        int[] alloc = new int[]{0, 5, 10, 10, 5, 0, 5, 0};
        int start = 100;
        Set<Map.Entry<ReservationInterval, Resource>> inputs = this.generateAllocation(start, alloc, false).entrySet();
        for (Map.Entry<ReservationInterval, Resource> entry : inputs) {
            rleSparseVector.addInterval(entry.getKey(), entry.getValue());
        }
        mapAllocations = rleSparseVector.toIntervalMap();
        Assert.assertTrue((mapAllocations.size() == 5 ? 1 : 0) != 0);
        for (Map.Entry<Object, Object> entry : mapAllocations.entrySet()) {
            ReservationInterval interval = (ReservationInterval)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            if (interval.getStartTime() == 101L) {
                Assert.assertTrue((interval.getEndTime() == 102L ? 1 : 0) != 0);
                Assert.assertEquals((Object)resource, (Object)Resource.newInstance((int)5120, (int)5));
                continue;
            }
            if (interval.getStartTime() == 102L) {
                Assert.assertTrue((interval.getEndTime() == 104L ? 1 : 0) != 0);
                Assert.assertEquals((Object)resource, (Object)Resource.newInstance((int)10240, (int)10));
                continue;
            }
            if (interval.getStartTime() == 104L) {
                Assert.assertTrue((interval.getEndTime() == 105L ? 1 : 0) != 0);
                Assert.assertEquals((Object)resource, (Object)Resource.newInstance((int)5120, (int)5));
                continue;
            }
            if (interval.getStartTime() == 105L) {
                Assert.assertTrue((interval.getEndTime() == 106L ? 1 : 0) != 0);
                Assert.assertEquals((Object)resource, (Object)Resource.newInstance((int)0, (int)0));
                continue;
            }
            if (interval.getStartTime() == 106L) {
                Assert.assertTrue((interval.getEndTime() == 107L ? 1 : 0) != 0);
                Assert.assertEquals((Object)resource, (Object)Resource.newInstance((int)5120, (int)5));
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    public void testMaxPeriodicCapacity() {
        long[] timeSteps = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L};
        int[] alloc = new int[]{2, 5, 7, 10, 3, 4, 6, 8};
        RLESparseResourceAllocation rleSparseVector = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc, timeSteps);
        LOG.info(rleSparseVector.toString());
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(0L, 1L), (Object)Resource.newInstance((int)10, (int)10));
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(0L, 2L), (Object)Resource.newInstance((int)7, (int)7));
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(0L, 3L), (Object)Resource.newInstance((int)10, (int)10));
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(0L, 4L), (Object)Resource.newInstance((int)3, (int)3));
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(0L, 5L), (Object)Resource.newInstance((int)4, (int)4));
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(0L, 5L), (Object)Resource.newInstance((int)4, (int)4));
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(7L, 5L), (Object)Resource.newInstance((int)8, (int)8));
        Assert.assertEquals((Object)rleSparseVector.getMaximumPeriodicCapacity(10L, 3L), (Object)Resource.newInstance((int)0, (int)0));
    }

    @Test
    public void testGetMinimumCapacityInInterval() {
        long[] timeSteps = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L};
        int[] alloc = new int[]{2, 5, 7, 10, 3, 4, 0, 8};
        RLESparseResourceAllocation rleSparseVector = ReservationSystemTestUtil.generateRLESparseResourceAllocation(alloc, timeSteps);
        LOG.info(rleSparseVector.toString());
        Assert.assertEquals((Object)rleSparseVector.getMinimumCapacityInInterval(new ReservationInterval(1L, 3L)), (Object)Resource.newInstance((int)5, (int)5));
        Assert.assertEquals((Object)rleSparseVector.getMinimumCapacityInInterval(new ReservationInterval(2L, 5L)), (Object)Resource.newInstance((int)3, (int)3));
        Assert.assertEquals((Object)rleSparseVector.getMinimumCapacityInInterval(new ReservationInterval(1L, 7L)), (Object)Resource.newInstance((int)0, (int)0));
    }

    private void setupArrays(TreeMap<Long, Resource> a, TreeMap<Long, Resource> b) {
        a.put(10L, Resource.newInstance((int)5, (int)5));
        a.put(20L, Resource.newInstance((int)10, (int)10));
        a.put(30L, Resource.newInstance((int)15, (int)15));
        a.put(40L, Resource.newInstance((int)20, (int)20));
        a.put(50L, Resource.newInstance((int)0, (int)0));
        b.put(11L, Resource.newInstance((int)5, (int)5));
        b.put(22L, Resource.newInstance((int)10, (int)10));
        b.put(33L, Resource.newInstance((int)15, (int)15));
        b.put(40L, Resource.newInstance((int)20, (int)20));
        b.put(42L, Resource.newInstance((int)20, (int)20));
        b.put(43L, Resource.newInstance((int)10, (int)10));
    }

    private void validate(RLESparseResourceAllocation out, long[] time, int[] alloc) {
        int i = 0;
        for (Map.Entry res : out.getCumulative().entrySet()) {
            Assert.assertEquals((long)time[i], (long)((Long)res.getKey()));
            if (i > alloc.length - 1) {
                Assert.assertNull(res.getValue());
            } else {
                Assert.assertEquals((long)alloc[i], (long)((Resource)res.getValue()).getVirtualCores());
            }
            ++i;
        }
        Assert.assertEquals((long)time.length, (long)i);
    }

    private Map<ReservationInterval, Resource> generateAllocation(int startTime, int[] alloc, boolean isStep) {
        HashMap<ReservationInterval, Resource> req = new HashMap<ReservationInterval, Resource>();
        int numContainers = 0;
        for (int i = 0; i < alloc.length; ++i) {
            numContainers = isStep ? alloc[i] + i : alloc[i];
            req.put(new ReservationInterval((long)(startTime + i), (long)(startTime + i + 1)), ReservationSystemUtil.toResource((ReservationRequest)ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers)));
        }
        return req;
    }
}

