/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCheckRemoveZKNodeRMStateStore
extends RMStateStoreTestBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestCheckRemoveZKNodeRMStateStore.class);
    private TestingServer curatorTestingServer;
    private CuratorFramework curatorFramework;

    public static TestingServer setupCuratorServer() throws Exception {
        TestingServer curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        return curatorTestingServer;
    }

    public static CuratorFramework setupCuratorFramework(TestingServer curatorTestingServer) throws Exception {
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(curatorTestingServer.getConnectString()).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        curatorFramework.start();
        return curatorFramework;
    }

    @Before
    public void setupCurator() throws Exception {
        this.curatorTestingServer = TestCheckRemoveZKNodeRMStateStore.setupCuratorServer();
        this.curatorFramework = TestCheckRemoveZKNodeRMStateStore.setupCuratorFramework(this.curatorTestingServer);
    }

    @After
    public void cleanupCuratorServer() throws IOException {
        this.curatorFramework.close();
        this.curatorTestingServer.stop();
    }

    @Test(timeout=60000L)
    public void testSafeDeleteZKNode() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester();
        this.testRemoveAttempt(zkTester);
        this.testRemoveApplication(zkTester);
        this.testRemoveRMDelegationToken(zkTester);
        this.testRemoveRMDTMasterKeyState(zkTester);
        this.testRemoveReservationState(zkTester);
        this.testTransitionedToStandbyAfterCheckNode(zkTester);
    }

    @Override
    public void testRemoveAttempt(RMStateStoreTestBase.RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        ApplicationId appIdRemoved = ApplicationId.newInstance((long)1708333280L, (int)1);
        this.storeApp(store, appIdRemoved, 123456L, 654321L);
        ApplicationAttemptId attemptIdRemoved = ApplicationAttemptId.newInstance((ApplicationId)appIdRemoved, (int)1);
        this.storeAttempt(store, attemptIdRemoved, ContainerId.newContainerId((ApplicationAttemptId)attemptIdRemoved, (long)1L).toString(), null, null, dispatcher);
        try {
            store.removeApplicationAttemptInternal(attemptIdRemoved);
        }
        catch (KeeperException.NoNodeException nne) {
            Assert.fail((String)"NoNodeException should not happen.");
        }
        ((ZKCuratorManager)Mockito.verify((Object)store.resourceManager.getZKManager(), (VerificationMode)Mockito.times((int)1))).safeDelete(Mockito.anyString(), Mockito.anyList(), Mockito.anyString());
        store.close();
    }

    @Override
    public void testRemoveApplication(RMStateStoreTestBase.RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        ApplicationId appIdRemoved = ApplicationId.newInstance((long)1708334188L, (int)1);
        this.storeApp(store, appIdRemoved, 123456L, 654321L);
        ApplicationAttemptId attemptIdRemoved = ApplicationAttemptId.newInstance((ApplicationId)appIdRemoved, (int)1);
        this.storeAttempt(store, attemptIdRemoved, ContainerId.newContainerId((ApplicationAttemptId)attemptIdRemoved, (long)1L).toString(), null, null, dispatcher);
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appIdRemoved);
        ApplicationStateData appStateRemoved = ApplicationStateData.newInstance((long)123456L, (long)654321L, (ApplicationSubmissionContext)context, (String)"user1");
        appStateRemoved.attempts.put(attemptIdRemoved, null);
        try {
            store.removeApplicationStateInternal(appStateRemoved);
        }
        catch (KeeperException.NoNodeException nne) {
            Assert.fail((String)"NoNodeException should not happen.");
        }
        store.close();
    }

    public void testRemoveRMDelegationToken(RMStateStoreTestBase.RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMDelegationTokenIdentifier tokenIdRemoved = new RMDelegationTokenIdentifier();
        try {
            store.removeRMDelegationTokenState(tokenIdRemoved);
        }
        catch (KeeperException.NoNodeException nne) {
            Assert.fail((String)"NoNodeException should not happen.");
        }
        ((ZKCuratorManager)Mockito.verify((Object)store.resourceManager.getZKManager(), (VerificationMode)Mockito.times((int)1))).safeDelete(Mockito.anyString(), Mockito.anyList(), Mockito.anyString());
        store.close();
    }

    public void testRemoveRMDTMasterKeyState(RMStateStoreTestBase.RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        DelegationKey keyRemoved = new DelegationKey();
        try {
            store.removeRMDTMasterKeyState(keyRemoved);
        }
        catch (KeeperException.NoNodeException nne) {
            Assert.fail((String)"NoNodeException should not happen.");
        }
        ((ZKCuratorManager)Mockito.verify((Object)store.resourceManager.getZKManager(), (VerificationMode)Mockito.times((int)1))).safeDelete(Mockito.anyString(), Mockito.anyList(), Mockito.anyString());
        store.close();
    }

    public void testRemoveReservationState(RMStateStoreTestBase.RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        String planName = "test-reservation";
        ReservationId reservationIdRemoved = ReservationId.newInstance((long)1708414427L, (long)1L);
        try {
            store.removeReservationState(planName, reservationIdRemoved.toString());
        }
        catch (KeeperException.NoNodeException nne) {
            Assert.fail((String)"NoNodeException should not happen.");
        }
        ((ZKCuratorManager)Mockito.verify((Object)store.resourceManager.getZKManager(), (VerificationMode)Mockito.times((int)1))).safeDelete(Mockito.anyString(), Mockito.anyList(), Mockito.anyString());
        store.close();
    }

    public void testTransitionedToStandbyAfterCheckNode(RMStateStoreTestBase.RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM((Configuration)conf, store);
        rm.init((Configuration)conf);
        rm.start();
        rm.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm.getRMContext().getRMAdminService().getServiceStatus().getState());
        ZKRMStateStore zKStore = (ZKRMStateStore)rm.getRMContext().getStateStore();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        zKStore.setRMDispatcher((Dispatcher)dispatcher);
        ApplicationId appIdRemoved = ApplicationId.newInstance((long)1709705779L, (int)1);
        this.storeApp((RMStateStore)zKStore, appIdRemoved, 123456L, 654321L);
        ApplicationAttemptId attemptIdRemoved = ApplicationAttemptId.newInstance((ApplicationId)appIdRemoved, (int)1);
        this.storeAttempt((RMStateStore)zKStore, attemptIdRemoved, ContainerId.newContainerId((ApplicationAttemptId)attemptIdRemoved, (long)1L).toString(), null, null, dispatcher);
        try {
            zKStore.removeApplicationAttemptInternal(attemptIdRemoved);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof KeeperException.NodeExistsException));
        }
        rm.close();
    }

    class TestZKRMStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        private TestZKRMStateStoreInternal store;
        private String workingZnode;

        TestZKRMStateStoreTester() {
        }

        private RMStateStore createStore(Configuration conf) throws Exception {
            this.workingZnode = "/jira/issue/11626/rmstore";
            conf.set("hadoop.zk.address", TestCheckRemoveZKNodeRMStateStore.this.curatorTestingServer.getConnectString());
            conf.set("yarn.resourcemanager.zk-state-store.parent-path", this.workingZnode);
            conf.setLong("yarn.resourcemanager.epoch", 10L);
            conf.setLong("yarn.resourcemanager.epoch.range", TestCheckRemoveZKNodeRMStateStore.this.getEpochRange());
            this.store = new TestZKRMStateStoreInternal(conf, this.workingZnode);
            return this.store;
        }

        public RMStateStore getRMStateStore(Configuration conf) throws Exception {
            return this.createStore(conf);
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            YarnConfiguration conf = new YarnConfiguration();
            return this.createStore((Configuration)conf);
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            return 1 == ((List)TestCheckRemoveZKNodeRMStateStore.this.curatorFramework.getChildren().forPath(this.store.znodeWorkingPath)).size();
        }

        @Override
        public void writeVersion(Version version) throws Exception {
            ((BackgroundPathAndBytesable)TestCheckRemoveZKNodeRMStateStore.this.curatorFramework.setData().withVersion(-1)).forPath(this.store.getVersionNode(), ((VersionPBImpl)version).getProto().toByteArray());
        }

        @Override
        public Version getCurrentVersion() throws Exception {
            return this.store.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws Exception {
            String appIdPath = app.getApplicationId().toString();
            int split = this.store.getConfig().getInt("yarn.resourcemanager.zk-appid-node.split-index", 0);
            return null != TestCheckRemoveZKNodeRMStateStore.this.curatorFramework.checkExists().forPath(this.store.getAppNode(appIdPath, split));
        }

        @Override
        public boolean attemptExists(RMAppAttempt attempt) throws Exception {
            ApplicationAttemptId attemptId = attempt.getAppAttemptId();
            return null != TestCheckRemoveZKNodeRMStateStore.this.curatorFramework.checkExists().forPath(this.store.getAttemptNode(attemptId.getApplicationId().toString(), attemptId.toString()));
        }

        class TestZKRMStateStoreInternal
        extends ZKRMStateStore {
            private ResourceManager resourceManager = (ResourceManager)Mockito.mock(ResourceManager.class);
            private ZKCuratorManager zkCuratorManager = (ZKCuratorManager)Mockito.mock(ZKCuratorManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

            TestZKRMStateStoreInternal(Configuration conf, String workingZnode) throws Exception {
                Mockito.when((Object)this.resourceManager.getZKManager()).thenReturn((Object)this.zkCuratorManager);
                Mockito.when((Object)this.resourceManager.createAndStartZKManager(conf)).thenReturn((Object)this.zkCuratorManager);
                Mockito.when((Object)this.zkCuratorManager.exists(this.getAppNode("application_1708333280_0001"))).thenReturn((Object)true);
                Mockito.when((Object)this.zkCuratorManager.exists(this.getAppNode("application_1708334188_0001"))).thenReturn((Object)true).thenReturn((Object)false);
                Mockito.when((Object)this.zkCuratorManager.exists(this.getDelegationTokenNode(0, 0))).thenReturn((Object)true).thenReturn((Object)false);
                Mockito.when((Object)this.zkCuratorManager.exists(this.getAppNode("application_1709705779_0001"))).thenReturn((Object)true);
                Mockito.when((Object)this.zkCuratorManager.exists(this.getAttemptNode("application_1709705779_0001", "appattempt_1709705779_0001_000001"))).thenReturn((Object)true);
                ((ZKCuratorManager)Mockito.doThrow((Throwable[])new Throwable[]{new KeeperException.NoNodeException()}).when((Object)this.zkCuratorManager)).safeDelete(Mockito.anyString(), Mockito.anyList(), Mockito.anyString());
                this.setResourceManager(this.resourceManager);
                this.init(conf);
                this.dispatcher.disableExitOnDispatchException();
                this.start();
                Assert.assertTrue((boolean)this.znodeWorkingPath.equals(workingZnode));
            }

            private String getVersionNode() {
                return this.znodeWorkingPath + "/ZKRMStateRoot/RMVersionNode";
            }

            public Version getCurrentVersion() {
                return CURRENT_VERSION_INFO;
            }

            private String getAppNode(String appId, int splitIdx) {
                String rootPath = TestZKRMStateStoreTester.this.workingZnode + "/ZKRMStateRoot/RMAppRoot";
                Object appPath = appId;
                if (splitIdx != 0) {
                    int idx = appId.length() - splitIdx;
                    appPath = appId.substring(0, idx) + "/" + appId.substring(idx);
                    return rootPath + "/HIERARCHIES/" + Integer.toString(splitIdx) + "/" + (String)appPath;
                }
                return rootPath + "/" + (String)appPath;
            }

            private String getAppNode(String appId) {
                return this.getAppNode(appId, 0);
            }

            private String getAttemptNode(String appId, String attemptId) {
                return this.getAppNode(appId) + "/" + attemptId;
            }

            private String getDelegationTokenNode(int rmDTSequenceNumber, int splitIdx) {
                String rootPath = TestZKRMStateStoreTester.this.workingZnode + "/ZKRMStateRoot/RMDTSecretManagerRoot/RMDelegationTokensRoot";
                Object nodeName = "RMDelegationToken_";
                nodeName = splitIdx == 0 ? (String)nodeName + rmDTSequenceNumber : (String)nodeName + String.format("%04d", rmDTSequenceNumber);
                Object path = nodeName;
                if (splitIdx != 0) {
                    int idx = ((String)nodeName).length() - splitIdx;
                    path = splitIdx + "/" + ((String)nodeName).substring(0, idx) + "/" + ((String)nodeName).substring(idx);
                }
                return rootPath + "/" + (String)path;
            }
        }
    }
}

