/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.CSMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MockQueueHierarchyBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleAction;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleActions;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatcher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatchers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCSMappingPlacementRule {
    public static final String DOT = ".";
    private static final Logger LOG = LoggerFactory.getLogger(TestCSMappingPlacementRule.class);
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private Map<String, Set<String>> userGroups = ImmutableMap.builder().put((Object)"alice", (Object)ImmutableSet.of((Object)"p_alice", (Object)"unique", (Object)"user")).put((Object)"bob", (Object)ImmutableSet.of((Object)"p_bob", (Object)"user", (Object)"developer")).put((Object)"charlie", (Object)ImmutableSet.of((Object)"p_charlie", (Object)"user", (Object)"tester")).put((Object)"dave", (Object)ImmutableSet.of((Object)"user")).put((Object)"emily", (Object)ImmutableSet.of((Object)"user", (Object)"tester", (Object)"developer")).put((Object)"test.user", (Object)ImmutableSet.of((Object)"main.grp", (Object)"sec.test.grp")).build();

    private void createQueueHierarchy(CapacitySchedulerQueueManager queueManager) {
        MockQueueHierarchyBuilder.create().withQueueManager(queueManager).withQueue("root.unman").withQueue("root.default").withManagedParentQueue("root.man").withQueue("root.user.alice").withQueue("root.user.bob").withQueue("root.user.test_dot_user").withQueue("root.user.testuser").withQueue("root.groups.main_dot_grp").withQueue("root.groups.sec_dot_test_dot_grp").withQueue("root.secondaryTests.unique").withQueue("root.secondaryTests.user").withQueue("root.ambiguous.user.charlie").withQueue("root.ambiguous.user.dave").withQueue("root.ambiguous.user.ambi").withQueue("root.ambiguous.group.tester").withManagedParentQueue("root.ambiguous.managed").withQueue("root.ambiguous.deep.user.charlie").withQueue("root.ambiguous.deep.user.dave").withQueue("root.ambiguous.deep.user.ambi").withQueue("root.ambiguous.deep.group.tester").withManagedParentQueue("root.ambiguous.deep.managed").withQueue("root.disambiguous.deep.disambiuser.emily").withQueue("root.disambiguous.deep.disambiuser.disambi").withManagedParentQueue("root.disambiguous.deep.group.developer").withManagedParentQueue("root.disambiguous.deep.dman").withDynamicParentQueue("root.dynamic").build();
        Mockito.when((Object)queueManager.getQueue((String)ArgumentMatchers.isNull())).thenReturn(null);
    }

    private CSMappingPlacementRule setupEngine(boolean overrideUserMappings, List<MappingRule> mappings) throws IOException {
        return this.setupEngine(overrideUserMappings, mappings, false);
    }

    private CSMappingPlacementRule setupEngine(boolean overrideUserMappings, List<MappingRule> mappings, boolean failOnConfigError) throws IOException {
        CapacitySchedulerConfiguration csConf = (CapacitySchedulerConfiguration)Mockito.mock(CapacitySchedulerConfiguration.class);
        Mockito.when((Object)csConf.getMappingRules()).thenReturn(mappings);
        Mockito.when((Object)csConf.getOverrideWithQueueMappings()).thenReturn((Object)overrideUserMappings);
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        this.createQueueHierarchy(qm);
        CapacityScheduler cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)cs.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)cs.getCapacitySchedulerQueueManager()).thenReturn((Object)qm);
        CSMappingPlacementRule engine = new CSMappingPlacementRule();
        Groups groups = (Groups)Mockito.mock(Groups.class);
        for (String user : this.userGroups.keySet()) {
            Mockito.when((Object)groups.getGroupsSet(user)).thenReturn(this.userGroups.get(user));
        }
        engine.setGroups(groups);
        engine.setFailOnConfigError(failOnConfigError);
        engine.initialize((ResourceScheduler)cs);
        return engine;
    }

    private ApplicationSubmissionContext createApp(String name, String queue) {
        ApplicationSubmissionContext ctx = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        ctx.setApplicationName(name);
        ctx.setQueue(queue);
        return ctx;
    }

    private ApplicationSubmissionContext createApp(String name) {
        return this.createApp(name, "default");
    }

    private void assertReject(String message, CSMappingPlacementRule engine, ApplicationSubmissionContext asc, String user) {
        try {
            ApplicationPlacementContext apc = engine.getPlacementForApp(asc, user);
            TestCase.fail((String)("Unexpected queue result: " + apc.getFullQueuePath() + " - " + message));
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
    }

    private void assertPlace(CSMappingPlacementRule engine, ApplicationSubmissionContext asc, String user, String expectedQueue) {
        this.assertPlace("Placement should not throw exception!", engine, asc, user, expectedQueue);
    }

    private void assertPlace(String message, CSMappingPlacementRule engine, ApplicationSubmissionContext asc, String user, String expectedQueue) {
        try {
            ApplicationPlacementContext apc = engine.getPlacementForApp(asc, user);
            TestCase.assertNotNull((String)message, (Object)apc);
            Object queue = apc.getParentQueue() == null ? "" : apc.getParentQueue() + DOT;
            queue = (String)queue + apc.getQueue();
            TestCase.assertEquals((String)message, (String)expectedQueue, (String)queue);
        }
        catch (YarnException e) {
            LOG.error(message, (Throwable)e);
            TestCase.fail((String)message);
        }
    }

    private void assertNullResult(String message, CSMappingPlacementRule engine, ApplicationSubmissionContext asc, String user) {
        try {
            TestCase.assertNull((String)message, (Object)engine.getPlacementForApp(asc, user));
        }
        catch (YarnException e) {
            LOG.error(message, (Throwable)e);
            TestCase.fail((String)message);
        }
    }

    @Test
    public void testLegacyPlacementToExistingQueue() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"alice", (String)"root.ambiguous.user.ambi"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"bob", (String)"ambi"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"dave", (String)"disambi"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"%user", (String)"disambiuser.%user"));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext asc = this.createApp("Default");
        this.assertPlace(engine, asc, "alice", "root.ambiguous.user.ambi");
        this.assertPlace("Should be placed to default because ambi is ambiguous and legacy fallback is default", engine, asc, "bob", "root.default");
        this.assertPlace(engine, asc, "emily", "root.disambiguous.deep.disambiuser.emily");
        this.assertPlace("Should be placed to default because disambiuser.charlie doesnot exit and legacy fallback is default", engine, asc, "charlie", "root.default");
        this.assertPlace(engine, asc, "dave", "root.disambiguous.deep.disambiuser.disambi");
    }

    @Test
    public void testLegacyPlacementToManagedQueues() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"alice", (String)"root.ambiguous.managed.%user"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"bob", (String)"managed.%user"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"charlie", (String)"root.unman.charlie"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"dave", (String)"non-existent.%user"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"%user", (String)"root.man.%user"));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext asc = this.createApp("Default");
        this.assertPlace(engine, asc, "alice", "root.ambiguous.managed.alice");
        this.assertPlace("Should be placed to default because managed is ambiguous and legacy fallback is default", engine, asc, "bob", "root.default");
        this.assertPlace("Should be placed to default because root.unman is not managed and legacy fallback is default", engine, asc, "charlie", "root.default");
        this.assertPlace("Should be placed to default because parent queue does not exist and legacy fallback is default", engine, asc, "dave", "root.default");
        this.assertPlace(engine, asc, "emily", "root.man.emily");
    }

    @Test
    public void testLegacyPlacementShortReference() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"alice", (String)"non-existent"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"bob", (String)"root"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"charlie", (String)"man"));
        rules.add(MappingRule.createLegacyRule((String)"u", (String)"dave", (String)"ambi"));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext asc = this.createApp("Default");
        this.assertPlace("Should be placed to default: non-existent does not exist and legacy fallback is default", engine, asc, "alice", "root.default");
        this.assertPlace("Should be placed to default: root is never managed and legacy fallback is default", engine, asc, "bob", "root.default");
        this.assertPlace("Should be placed to default: managed parent is not a leaf queue and legacy fallback is default", engine, asc, "charlie", "root.default");
        this.assertPlace("Should be placed to default: ambi is an ambiguous reference and legacy fallback is default", engine, asc, "dave", "root.default");
    }

    @Test
    public void testRuleFallbackHandling() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"alice"), new MappingRuleActions.PlaceToQueueAction("non-existent", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), new MappingRuleActions.PlaceToQueueAction("non-existent", true).setFallbackSkip()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), MappingRuleActions.createUpdateDefaultAction((String)"root.invalid")));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), (MappingRuleAction)new MappingRuleActions.PlaceToQueueAction("%default", true)));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"charlie"), new MappingRuleActions.PlaceToQueueAction("non-existent", true).setFallbackDefaultPlacement()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"emily"), MappingRuleActions.createUpdateDefaultAction((String)"root.invalid")));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"emily"), new MappingRuleActions.PlaceToQueueAction("non-existent", true).setFallbackDefaultPlacement()));
        rules.add(new MappingRule(MappingRuleMatchers.createApplicationNameMatcher((String)"ShouldFail"), (MappingRuleAction)new MappingRuleActions.PlaceToQueueAction("root.default", true)));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext fail = this.createApp("ShouldFail");
        ApplicationSubmissionContext success = this.createApp("ShouldSucceed");
        this.assertReject("Alice has a straight up reject rule, her application should be rejected", engine, fail, "alice");
        this.assertReject("Bob should fail to place to non-existent -> should skip to next rule\nBob should update the %default to root.invalid\nBob should fail to place the app to %default which is root.invalid", engine, fail, "bob");
        this.assertPlace("Charlie should be able to place the app to root.default as thenon-existent queue does not exist, but fallback is place to default", engine, success, "charlie", "root.default");
        this.assertNullResult("Dave with success app has no matching rule, so we expect a null", engine, success, "dave");
        this.assertReject("Emily should update the %default to root.invalid\nBob should fail to place the app to non-existent and since the fallback is placeToDefault, it should also fail, because we have just updated default to an invalid value", engine, fail, "emily");
    }

    @Test
    public void testConfigValidation() {
        ArrayList<MappingRule> nonExistentStatic = new ArrayList<MappingRule>();
        nonExistentStatic.add(MappingRule.createLegacyRule((String)"u", (String)"alice", (String)"non-existent"));
        ArrayList<MappingRule> tokenAsStatic = new ArrayList<MappingRule>();
        tokenAsStatic.add(MappingRule.createLegacyRule((String)"u", (String)"alice", (String)"%token"));
        ArrayList<MappingRule> tokenAsDynamic = new ArrayList<MappingRule>();
        tokenAsDynamic.add(new MappingRule((MappingRuleMatcher)new MappingRuleMatchers.MatchAllMatcher(), (MappingRuleAction)new MappingRuleActions.VariableUpdateAction("%token", "non-existent")));
        tokenAsDynamic.add(MappingRule.createLegacyRule((String)"u", (String)"alice", (String)"%token"));
        try {
            this.setupEngine(true, nonExistentStatic, true);
            TestCase.fail((String)"We expect the setup to fail because we have a static rule referencing a non-existent queue");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.setupEngine(true, tokenAsStatic, true);
            TestCase.fail((String)"We expect the setup to fail because we have a rule containing an unknown token, which is considered a static rule, with a non-existent queue");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.setupEngine(true, tokenAsDynamic, true);
        }
        catch (IOException e) {
            TestCase.fail((String)"We expect the setup to succeed because the %token is a known variable so the rule is considered dynamic without parent, and this always should pass");
        }
    }

    @Test
    public void testAllowCreateFlag() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"alice"), new MappingRuleActions.PlaceToQueueAction("non-existent", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), new MappingRuleActions.PlaceToQueueAction("non-existent", false).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"charlie"), new MappingRuleActions.PlaceToQueueAction("root.man.create", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"emily"), new MappingRuleActions.PlaceToQueueAction("root.man.create", false).setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertReject("Alice should be rejected because the target queue does not exist", engine, app, "alice");
        this.assertReject("Bob should be rejected because the target queue does not exist", engine, app, "bob");
        this.assertReject("Emily should be rejected because auto queue creation is not allowed for this action", engine, app, "emily");
        this.assertPlace("Charlie should be able to place since it is allowed to create", engine, app, "charlie", "root.man.create");
    }

    @Test
    public void testSpecified() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createAllMatcher(), new MappingRuleActions.PlaceToQueueAction("%specified", true).setFallbackSkip()));
        rules.add(new MappingRule(MappingRuleMatchers.createAllMatcher(), new MappingRuleActions.PlaceToQueueAction("root.ambiguous.group.tester", true).setFallbackSkip()));
        rules.add(new MappingRule(MappingRuleMatchers.createAllMatcher(), new MappingRuleActions.RejectAction().setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext appNoQueue = this.createApp("app");
        ApplicationSubmissionContext appDefault = this.createApp("app", "default");
        ApplicationSubmissionContext appRootDefault = this.createApp("app", "root.default");
        ApplicationSubmissionContext appBob = this.createApp("app", "root.user.bob");
        this.assertPlace("App with non specified queue should end up in 'root.ambiguous.group.tester' because no queue was specified and this is the only rule matching the submission", engine, appNoQueue, "alice", "root.ambiguous.group.tester");
        this.assertPlace("App with specified 'default' should end up in 'root.ambiguous.group.tester' because 'default' is the same as no queue being specified and this is the only rule matching the submission ", engine, appDefault, "alice", "root.ambiguous.group.tester");
        this.assertPlace("App with specified root.default should end up in 'root.default' because root.default is specifically provided", engine, appRootDefault, "alice", "root.default");
        this.assertPlace("App with specified queue should end up in the specified queue 'root.user.bob'", engine, appBob, "alice", "root.user.bob");
    }

    @Test
    public void testGroupTargetMatching() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"alice"), new MappingRuleActions.PlaceToQueueAction("root.man.%primary_group", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), new MappingRuleActions.PlaceToQueueAction("root.disambiguous.deep.group.%secondary_group.%user", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"charlie"), new MappingRuleActions.PlaceToQueueAction("root.man.%secondary_group", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"dave"), new MappingRuleActions.PlaceToQueueAction("root.dynamic.%secondary_group.%user", true).setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("Alice should be placed to root.man.p_alice based on her primary group", engine, app, "alice", "root.man.p_alice");
        this.assertPlace("Bob should be placed to root.disambiguous.deep.group.developer.bobbased on his secondary group, since we have a queue named'developer', under the path 'root.disambiguous.deep.group' bob identifies as a user with secondary_group 'developer'", engine, app, "bob", "root.disambiguous.deep.group.developer.bob");
        this.assertReject("Charlie should get rejected because he neither of hisgroups have an ambiguous queue, so effectively he has no secondary group", engine, app, "charlie");
        this.assertReject("Dave should get rejected because he has no secondary group", engine, app, "dave");
    }

    @Test
    public void testSecondaryGroupWithoutParent() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"alice"), new MappingRuleActions.PlaceToQueueAction("%secondary_group", false).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), new MappingRuleActions.PlaceToQueueAction("%secondary_group.%user", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"charlie"), new MappingRuleActions.PlaceToQueueAction("%secondary_group", true).setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("Alice should be placed to root.secondaryTests.unique because 'unique' is a globally unique queue, and she has a matching group", engine, app, "alice", "root.secondaryTests.unique");
        this.assertPlace("Bob should be placed to root.disambiguous.deep.group.developer.bob because 'developer' is a globally unique PARENT queue, and he has a matching group name, and can create a queue with '%user' under it", engine, app, "bob", "root.disambiguous.deep.group.developer.bob");
        this.assertReject("Charlie should get rejected because neither of hisgroups have a disambiguous queue, so effectively he has no secondary group", engine, app, "charlie");
    }

    @Test
    public void testSecondaryGroupWithParent() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"alice"), new MappingRuleActions.PlaceToQueueAction("root.secondaryTests.%secondary_group", false).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), new MappingRuleActions.PlaceToQueueAction("root.secondaryTests.%secondary_group", true).setFallbackReject()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"charlie"), new MappingRuleActions.PlaceToQueueAction("root.%secondary_group", true).setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("Alice should be placed to root.secondaryTests.unique because both her secondary groups 'user' and 'unique' are eligible for being a secondary group under root.secondaryTests, but 'unique' precedes 'user' in the group list.", engine, app, "alice", "root.secondaryTests.unique");
        this.assertPlace("Bob should be placed to root.secondaryTests.user bob is member of group 'user' and while 'user' is globally not unique it is a valid secondary group target under queue root.secondaryTests.", engine, app, "bob", "root.secondaryTests.user");
        this.assertReject("Charlie should get rejected because neither of hisgroups have a matching queue under root.", engine, app, "charlie");
    }

    void assertConfigTestResult(List<MappingRule> rules) {
        TestCase.assertEquals((String)"We only specified one rule", (int)1, (int)rules.size());
        MappingRule rule = rules.get(0);
        String ruleStr = rule.toString();
        TestCase.assertTrue((String)"Rule's matcher variable should be %user", (boolean)ruleStr.contains("variable='%user'"));
        TestCase.assertTrue((String)"Rule's match value should be bob", (boolean)ruleStr.contains("value='bob'"));
        TestCase.assertTrue((String)"Rule's action should be place to queue", (boolean)ruleStr.contains("action=PlaceToQueueAction{queueName='%primary_group'"));
    }

    @Test
    public void testLegacyConfiguration() throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "legacy");
        conf.set("yarn.scheduler.capacity.queue-mappings", "u:bob:%primary_group");
        List rules = conf.getMappingRules();
        this.assertConfigTestResult(rules);
    }

    @Test
    public void testJSONConfiguration() throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        conf.set("yarn.scheduler.capacity.mapping-rule-json", "{\"rules\": [{    \"type\": \"user\",    \"matches\": \"bob\",    \"policy\": \"custom\",    \"customPlacement\": \"%primary_group\",    \"fallbackResult\":\"skip\"}]}");
        List rules = conf.getMappingRules();
        this.assertConfigTestResult(rules);
    }

    @Test
    public void testEmptyJSONConfiguration() throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        conf.set("yarn.scheduler.capacity.mapping-rule-json", "");
        List rules = conf.getMappingRules();
        TestCase.assertEquals((String)"We expect no rules", (int)0, (int)rules.size());
    }

    @Test(expected=IOException.class)
    public void testInvalidJSONConfiguration() throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        conf.set("yarn.scheduler.capacity.mapping-rule-json", "I'm a bad JSON, since I'm not a JSON.");
        List rules = conf.getMappingRules();
    }

    @Test(expected=IOException.class)
    public void testMissingJSONFileConfiguration() throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        conf.set("yarn.scheduler.capacity.mapping-rule-json-file", "/dev/null/nofile");
        List rules = conf.getMappingRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJSONFileConfiguration() throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        File jsonFile = this.folder.newFile("testJSONFileConfiguration.json");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));){
            writer.write("{\"rules\": [{    \"type\": \"user\",    \"matches\": \"bob\",    \"policy\": \"custom\",    \"customPlacement\": \"%primary_group\",    \"fallbackResult\":\"skip\"}]}");
        }
        conf.set("yarn.scheduler.capacity.mapping-rule-json-file", jsonFile.getAbsolutePath());
        List rules = conf.getMappingRules();
        this.assertConfigTestResult(rules);
    }

    @Test
    public void testUserNameCleanup() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createAllMatcher(), new MappingRuleActions.PlaceToQueueAction("%user", true).setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("test.user should be placed to root.users.test_dot_user", engine, app, "test.user", "root.user.test_dot_user");
    }

    @Test
    public void testPrimaryGroupNameCleanup() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createAllMatcher(), new MappingRuleActions.PlaceToQueueAction("%primary_group", true).setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("Application should have been placed to root.groups.main_dot_grp", engine, app, "test.user", "root.groups.main_dot_grp");
    }

    @Test
    public void testSecondaryGroupNameCleanup() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createAllMatcher(), new MappingRuleActions.PlaceToQueueAction("%secondary_group", true).setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("Application should have been placed to root.groups.sec_dot_test_dot_grp", engine, app, "test.user", "root.groups.sec_dot_test_dot_grp");
    }

    @Test
    public void testPlacementEngineSelectsCorrectConfigurationForGroupMapping() throws IOException {
        Groups.reset();
        String user = "testuser";
        Configuration yarnConf = new Configuration();
        yarnConf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        final ArrayList<MappingRule> mappingRules = new ArrayList<MappingRule>();
        mappingRules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"testuser"), new MappingRuleActions.PlaceToQueueAction("root.man.%primary_group", true).setFallbackReject()));
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration(){

            public List<MappingRule> getMappingRules() {
                return mappingRules;
            }
        };
        csConf.setOverrideWithQueueMappings(true);
        csConf.setClass("hadoop.security.group.mapping", String.class, Object.class);
        CapacityScheduler cs = this.createMockCS(yarnConf, csConf);
        CSMappingPlacementRule engine = this.initPlacementEngine(cs);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace(engine, app, "testuser", "root.man.testGroup1");
        yarnConf.setClass("hadoop.security.group.mapping", String.class, Object.class);
        engine.getGroups().refresh();
        engine = this.initPlacementEngine(cs);
        this.assertPlace(engine, app, "testuser", "root.man.testGroup0");
    }

    @Test
    public void testOriginalUserNameWithDotCanBeUsedInMatchExpression() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"test.user"), MappingRuleActions.createUpdateDefaultAction((String)"root.user.testuser").setFallbackSkip()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"test.user"), MappingRuleActions.createPlaceToDefaultAction().setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("test.user should be placed to root.user", engine, app, "test.user", "root.user.testuser");
    }

    @Test
    public void testOriginalGroupNameWithDotCanBeUsedInMatchExpression() throws IOException {
        ArrayList<MappingRule> rules = new ArrayList<MappingRule>();
        rules.add(new MappingRule(MappingRuleMatchers.createUserGroupMatcher((String)"sec.test.grp"), MappingRuleActions.createUpdateDefaultAction((String)"root.user.testuser").setFallbackSkip()));
        rules.add(new MappingRule(MappingRuleMatchers.createUserMatcher((String)"test.user"), MappingRuleActions.createPlaceToDefaultAction().setFallbackReject()));
        CSMappingPlacementRule engine = this.setupEngine(true, rules);
        ApplicationSubmissionContext app = this.createApp("app");
        this.assertPlace("test.user should be placed to root.user", engine, app, "test.user", "root.user.testuser");
    }

    private CSMappingPlacementRule initPlacementEngine(CapacityScheduler cs) throws IOException {
        CSMappingPlacementRule engine = new CSMappingPlacementRule();
        engine.setFailOnConfigError(true);
        engine.initialize((ResourceScheduler)cs);
        return engine;
    }

    private CapacityScheduler createMockCS(Configuration conf, CapacitySchedulerConfiguration csConf) {
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        this.createQueueHierarchy(qm);
        CapacityScheduler cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)cs.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)cs.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)cs.getCapacitySchedulerQueueManager()).thenReturn((Object)qm);
        return cs;
    }

    public static class MockUnixGroupsMapping
    implements GroupMappingServiceProvider {
        private static final List<String> GROUP = new ArrayList<String>();

        public MockUnixGroupsMapping() {
            GROUP.clear();
            GROUP.add("testGroup1");
            GROUP.add("testGroup2");
            GROUP.add("testGroup3");
        }

        public List<String> getGroups(String user) throws IOException {
            return GROUP;
        }

        public void cacheGroupsRefresh() {
            GROUP.add(0, "testGroup0");
        }

        public void cacheGroupsAdd(List<String> groups) {
        }

        public Set<String> getGroupsSet(String user) {
            return ImmutableSet.copyOf(GROUP);
        }
    }
}

