/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreServiceMetrics;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFederationStateStoreServiceMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(TestFederationStateStoreServiceMetrics.class);
    private static FederationStateStoreServiceMetrics metrics = FederationStateStoreServiceMetrics.getMetrics();
    private MockBadFederationStateStoreService badStateStore = new MockBadFederationStateStoreService();
    private MockGoodFederationStateStoreService goodStateStore = new MockGoodFederationStateStoreService();

    @Test
    public void testFederationStateStoreServiceMetricInit() {
        LOG.info("Test: aggregate metrics are initialized correctly");
        Assert.assertEquals((long)0L, (long)FederationStateStoreServiceMetrics.getNumSucceededCalls());
        Assert.assertEquals((long)0L, (long)FederationStateStoreServiceMetrics.getNumFailedCalls());
        LOG.info("Test: aggregate metrics are updated correctly");
    }

    @Test
    public void testRegisterSubClusterSuccessfulCalls() {
        LOG.info("Test: Aggregate and method successful calls updated correctly.");
        long totalGoodBefore = FederationStateStoreServiceMetrics.getNumSucceededCalls();
        long apiGoodBefore = FederationStateStoreServiceMetrics.getNumSucceessfulCallsForMethod((String)"registerSubCluster");
        this.goodStateStore.registerSubCluster(100L);
        Assert.assertEquals((long)(totalGoodBefore + 1L), (long)FederationStateStoreServiceMetrics.getNumSucceededCalls());
        Assert.assertEquals((double)100.0, (double)FederationStateStoreServiceMetrics.getLatencySucceededCalls(), (double)0.0);
        Assert.assertEquals((long)(apiGoodBefore + 1L), (long)FederationStateStoreServiceMetrics.getNumSucceededCalls());
        double latencySucceessfulCalls = FederationStateStoreServiceMetrics.getLatencySucceessfulCallsForMethod((String)"registerSubCluster");
        Assert.assertEquals((double)100.0, (double)latencySucceessfulCalls, (double)0.0);
        LOG.info("Test: Running stats correctly calculated for 2 metrics");
        this.goodStateStore.registerSubCluster(200L);
        Assert.assertEquals((long)(totalGoodBefore + 2L), (long)FederationStateStoreServiceMetrics.getNumSucceededCalls());
        Assert.assertEquals((double)150.0, (double)FederationStateStoreServiceMetrics.getLatencySucceededCalls(), (double)0.0);
        Assert.assertEquals((long)(apiGoodBefore + 2L), (long)FederationStateStoreServiceMetrics.getNumSucceededCalls());
        double latencySucceessfulCalls2 = FederationStateStoreServiceMetrics.getLatencySucceessfulCallsForMethod((String)"registerSubCluster");
        Assert.assertEquals((double)150.0, (double)latencySucceessfulCalls2, (double)0.0);
    }

    private class MockBadFederationStateStoreService {
        private MockBadFederationStateStoreService() {
        }

        public void registerSubCluster() {
            LOG.info("Mocked: failed registerSubCluster call");
            FederationStateStoreServiceMetrics.failedStateStoreServiceCall();
        }
    }

    private class MockGoodFederationStateStoreService {
        private MockGoodFederationStateStoreService() {
        }

        public void registerSubCluster(long duration) {
            LOG.info("Mocked: successful registerSubCluster call with duration {}", (Object)duration);
            FederationStateStoreServiceMetrics.succeededStateStoreServiceCall((long)duration);
        }
    }
}

