/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMHATestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKillApplicationWithRMHA
extends RMHATestBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestKillApplicationWithRMHA.class);

    @Test(timeout=20000L)
    public void testKillAppWhenFailoverHappensAtNewState() throws Exception {
        this.startRMsWithCustomizedRMAppManager();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("").withUser(UserGroupInformation.getCurrentUser().getShortUserName()).withAcls(null).withUnmanagedAM(false).withQueue(null).withMaxAppAttempts(this.configuration.getInt("yarn.resourcemanager.am.max-attempts", 2)).withCredentials(null).withAppType(null).withWaitForAppAcceptedState(false).withKeepContainers(false).build();
        RMApp app0 = MockRMAppSubmitter.submit(rm1, data);
        try {
            this.failOverAndKillApp(app0.getApplicationId(), RMAppState.NEW);
            Assert.fail((String)"Should get an exception here");
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Trying to kill an absent application " + app0.getApplicationId()));
        }
    }

    @Test(timeout=20000L)
    public void testKillAppWhenFailoverHappensAtRunningState() throws Exception {
        this.startRMs();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        this.failOverAndKillApp(app0.getApplicationId(), am0.getApplicationAttemptId(), RMAppState.RUNNING, RMAppAttemptState.RUNNING, RMAppState.ACCEPTED);
    }

    @Test(timeout=20000L)
    public void testKillAppWhenFailoverHappensAtFinalState() throws Exception {
        this.startRMs();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        rm1.killApp(app0.getApplicationId());
        rm1.waitForState(app0.getApplicationId(), RMAppState.KILLED);
        rm1.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.KILLED);
        this.failOverAndKillApp(app0.getApplicationId(), am0.getApplicationAttemptId(), RMAppState.KILLED, RMAppAttemptState.KILLED, RMAppState.KILLED);
    }

    @Test(timeout=20000L)
    public void testKillAppWhenFailOverHappensDuringApplicationKill() throws Exception {
        this.startRMsWithCustomizedClientRMService();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = MockRMAppSubmitter.submitWithMemory(200L, rm1);
        MockAM am0 = this.launchAM(app0, rm1, nm1);
        Assertions.assertThat((Comparable)app0.getState()).isEqualTo((Object)RMAppState.RUNNING);
        rm1.killApp(app0.getApplicationId());
        this.failOverAndKillApp(app0.getApplicationId(), am0.getApplicationAttemptId(), RMAppState.RUNNING, RMAppAttemptState.RUNNING, RMAppState.ACCEPTED);
    }

    private void failOverAndKillApp(ApplicationId appId, ApplicationAttemptId appAttemptId, RMAppState initialRMAppState, RMAppAttemptState initialRMAppAttemptState, RMAppState expectedAppStateBeforeKillApp) throws Exception {
        Assert.assertEquals((Object)initialRMAppState, (Object)((RMApp)rm1.getRMContext().getRMApps().get(appId)).getState());
        Assert.assertEquals((Object)initialRMAppAttemptState, (Object)((RMAppAttempt)((RMApp)rm1.getRMContext().getRMApps().get(appId)).getAppAttempts().get(appAttemptId)).getState());
        this.explicitFailover();
        Assert.assertEquals((Object)expectedAppStateBeforeKillApp, (Object)((RMApp)rm2.getRMContext().getRMApps().get(appId)).getState());
        this.killApplication(rm2, appId, appAttemptId, initialRMAppState);
    }

    private void failOverAndKillApp(ApplicationId appId, RMAppState initialRMAppState) throws Exception {
        Assert.assertEquals((Object)initialRMAppState, (Object)((RMApp)rm1.getRMContext().getRMApps().get(appId)).getState());
        this.explicitFailover();
        Assert.assertTrue((rm2.getRMContext().getRMApps().get(appId) == null ? 1 : 0) != 0);
        this.killApplication(rm2, appId, null, initialRMAppState);
    }

    private void startRMsWithCustomizedClientRMService() throws IOException {
        Configuration conf1 = new Configuration(this.confForRM1);
        rm1 = new MockRM(conf1){

            @Override
            protected ClientRMService createClientRMService() {
                return new MyClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm2 = new MockRM(this.confForRM2);
        this.startRMs(rm1, conf1, rm2, this.confForRM2);
    }

    private void killApplication(MockRM rm, ApplicationId appId, ApplicationAttemptId appAttemptId, RMAppState rmAppState) throws Exception {
        KillApplicationResponse response = rm.killApp(appId);
        Assert.assertTrue((response.getIsKillCompleted() == this.isFinalState(rmAppState) ? 1 : 0) != 0);
        RMApp loadedApp0 = (RMApp)rm.getRMContext().getRMApps().get(appId);
        rm.waitForState(appId, RMAppState.KILLED);
        if (appAttemptId != null) {
            rm.waitForState(appAttemptId, RMAppAttemptState.KILLED);
        }
        Assert.assertEquals((long)1L, (long)loadedApp0.getAppAttempts().size());
    }

    private static class MyClientRMService
    extends ClientRMService {
        private RMContext rmContext;

        public MyClientRMService(RMContext rmContext, YarnScheduler scheduler, RMAppManager rmAppManager, ApplicationACLsManager applicationACLsManager, QueueACLsManager queueACLsManager, RMDelegationTokenSecretManager rmDTSecretManager) {
            super(rmContext, scheduler, rmAppManager, applicationACLsManager, queueACLsManager, rmDTSecretManager);
            this.rmContext = rmContext;
        }

        protected void serviceStart() {
        }

        protected void serviceStop() {
        }

        public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException {
            ApplicationId applicationId = request.getApplicationId();
            RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
            if (application.isAppFinalStateStored()) {
                return KillApplicationResponse.newInstance((boolean)true);
            }
            return KillApplicationResponse.newInstance((boolean)false);
        }
    }
}

