/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.util.resource.Resources;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={FairSchedulerLeafQueueInfo.class})
public class FairSchedulerQueueInfo {
    private int maxApps;
    @XmlTransient
    private float fractionMemUsed;
    @XmlTransient
    private float fractionMemSteadyFairShare;
    @XmlTransient
    private float fractionMemFairShare;
    @XmlTransient
    private float fractionMemMaxShare;
    private ResourceInfo minResources;
    private ResourceInfo maxResources;
    private ResourceInfo usedResources;
    private ResourceInfo amUsedResources;
    private ResourceInfo amMaxResources;
    private ResourceInfo demandResources;
    private ResourceInfo steadyFairResources;
    private ResourceInfo fairResources;
    private ResourceInfo clusterResources;
    private ResourceInfo reservedResources;
    private ResourceInfo maxContainerAllocation;
    private long pendingContainers;
    private long allocatedContainers;
    private long reservedContainers;
    private String queueName;
    private String schedulingPolicy;
    private boolean preemptable;
    private FairSchedulerQueueInfoList childQueues;

    public FairSchedulerQueueInfo() {
    }

    public FairSchedulerQueueInfo(FSQueue queue, FairScheduler scheduler) {
        AllocationConfiguration allocConf = scheduler.getAllocationConfiguration();
        this.queueName = queue.getName();
        this.schedulingPolicy = queue.getPolicy().getName();
        this.clusterResources = new ResourceInfo(scheduler.getClusterResource());
        this.amUsedResources = new ResourceInfo(queue.getMetrics().getAMResourceUsage());
        this.amMaxResources = new ResourceInfo(queue.getMetrics().getMaxAMShare());
        this.usedResources = new ResourceInfo(queue.getResourceUsage());
        this.demandResources = new ResourceInfo(queue.getDemand());
        this.fractionMemUsed = (float)this.usedResources.getMemorySize() / (float)this.clusterResources.getMemorySize();
        this.steadyFairResources = new ResourceInfo(queue.getSteadyFairShare());
        this.fairResources = new ResourceInfo(queue.getFairShare());
        this.minResources = new ResourceInfo(queue.getMinShare());
        this.maxResources = new ResourceInfo(Resources.componentwiseMin((Resource)queue.getMaxShare(), (Resource)scheduler.getClusterResource()));
        this.maxContainerAllocation = new ResourceInfo(scheduler.getMaximumResourceCapability(this.queueName));
        this.reservedResources = new ResourceInfo(queue.getReservedResource());
        this.fractionMemSteadyFairShare = (float)this.steadyFairResources.getMemorySize() / (float)this.clusterResources.getMemorySize();
        this.fractionMemFairShare = (float)this.fairResources.getMemorySize() / (float)this.clusterResources.getMemorySize();
        this.fractionMemMaxShare = (float)this.maxResources.getMemorySize() / (float)this.clusterResources.getMemorySize();
        this.maxApps = queue.getMaxRunningApps();
        this.allocatedContainers = queue.getMetrics().getAllocatedContainers();
        this.reservedContainers = queue.getMetrics().getReservedContainers();
        this.pendingContainers = queue.getMetrics().getPendingContainers();
        QueuePath queuePath = new QueuePath(this.queueName);
        if (allocConf.isReservable(queuePath) && !allocConf.getShowReservationAsQueues(queuePath)) {
            return;
        }
        this.preemptable = queue.isPreemptable();
        this.childQueues = this.getChildQueues(queue, scheduler);
    }

    public long getAllocatedContainers() {
        return this.allocatedContainers;
    }

    public long getPendingContainers() {
        return this.pendingContainers;
    }

    public long getReservedContainers() {
        return this.reservedContainers;
    }

    protected FairSchedulerQueueInfoList getChildQueues(FSQueue queue, FairScheduler scheduler) {
        List<FSQueue> children = queue.getChildQueues();
        if (children.isEmpty()) {
            return null;
        }
        FairSchedulerQueueInfoList list = new FairSchedulerQueueInfoList();
        for (FSQueue child : children) {
            if (child instanceof FSLeafQueue) {
                list.addToQueueInfoList(new FairSchedulerLeafQueueInfo((FSLeafQueue)child, scheduler));
                continue;
            }
            list.addToQueueInfoList(new FairSchedulerQueueInfo(child, scheduler));
        }
        return list;
    }

    public float getSteadyFairShareMemoryFraction() {
        return this.fractionMemSteadyFairShare;
    }

    public float getFairShareMemoryFraction() {
        return this.fractionMemFairShare;
    }

    public ResourceInfo getSteadyFairShare() {
        return this.steadyFairResources;
    }

    public ResourceInfo getFairShare() {
        return this.fairResources;
    }

    public ResourceInfo getMinResources() {
        return this.minResources;
    }

    public ResourceInfo getMaxResources() {
        return this.maxResources;
    }

    public ResourceInfo getMaxContainerAllocation() {
        return this.maxContainerAllocation;
    }

    public ResourceInfo getReservedResources() {
        return this.reservedResources;
    }

    public int getMaxApplications() {
        return this.maxApps;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public ResourceInfo getUsedResources() {
        return this.usedResources;
    }

    public ResourceInfo getAMUsedResources() {
        return this.amUsedResources;
    }

    public ResourceInfo getAMMaxResources() {
        return this.amMaxResources;
    }

    public ResourceInfo getDemandResources() {
        return this.demandResources;
    }

    public float getUsedMemoryFraction() {
        return this.fractionMemUsed;
    }

    public float getMaxResourcesFraction() {
        return this.fractionMemMaxShare;
    }

    public String getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    public Collection<FairSchedulerQueueInfo> getChildQueues() {
        return this.childQueues != null ? this.childQueues.getQueueInfoList() : new ArrayList<FairSchedulerQueueInfo>();
    }

    public boolean isPreemptable() {
        return this.preemptable;
    }
}

