/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;

public class QueueCapacityConfigParser {
    private static final String UNIFORM_REGEX = "^([0-9.]+)(.*)";
    private static final String RESOURCE_REGEX = "^\\[([\\w\\.,\\-_%\\ /]+=[\\w\\.,\\-_%\\ /]+)+\\]$";
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("^\\[([\\w\\.,\\-_%\\ /]+=[\\w\\.,\\-_%\\ /]+)+\\]$");
    private static final Pattern UNIFORM_PATTERN = Pattern.compile("^([0-9.]+)(.*)");
    public static final String FLOAT_DIGIT_REGEX = "[0-9.]";
    private final List<Parser> parsers = new ArrayList<Parser>();

    public QueueCapacityConfigParser() {
        this.parsers.add(new Parser(RESOURCE_PATTERN, this::heterogeneousParser));
        this.parsers.add(new Parser(UNIFORM_PATTERN, this::uniformParser));
    }

    public QueueCapacityVector parse(String capacityString, QueuePath queuePath) {
        if (queuePath.isRoot()) {
            return QueueCapacityVector.of(100.0, QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE);
        }
        if (capacityString == null) {
            return new QueueCapacityVector();
        }
        capacityString = capacityString.replaceAll(" ", "");
        for (Parser parser : this.parsers) {
            Matcher matcher = parser.regex.matcher(capacityString);
            if (!matcher.find()) continue;
            return (QueueCapacityVector)parser.parser.apply(matcher);
        }
        return new QueueCapacityVector();
    }

    private QueueCapacityVector uniformParser(Matcher matcher) {
        QueueCapacityVector.ResourceUnitCapacityType capacityType = null;
        String value = matcher.group(1);
        if (matcher.groupCount() == 2) {
            String matchedSuffix = matcher.group(2);
            for (QueueCapacityVector.ResourceUnitCapacityType suffix : QueueCapacityVector.ResourceUnitCapacityType.values()) {
                String uniformSuffix;
                if (suffix.equals((Object)QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE) || !(uniformSuffix = suffix.getPostfix().replaceAll("%", "")).equals(matchedSuffix)) continue;
                capacityType = suffix;
            }
        }
        if (capacityType == null) {
            return new QueueCapacityVector();
        }
        return QueueCapacityVector.of(Float.parseFloat(value), capacityType);
    }

    private QueueCapacityVector heterogeneousParser(Matcher matcher) {
        QueueCapacityVector capacityVector = QueueCapacityVector.newInstance();
        String bracketedGroup = matcher.group(0);
        bracketedGroup = bracketedGroup.substring(1, bracketedGroup.length() - 1);
        for (String kvPair : bracketedGroup.trim().split(",")) {
            String[] splits = kvPair.split("=");
            if (splits.length <= 1) continue;
            this.setCapacityVector(capacityVector, splits[0], splits[1]);
        }
        return capacityVector;
    }

    private void setCapacityVector(QueueCapacityVector resource, String resourceName, String resourceValue) {
        float parsedResourceValue;
        QueueCapacityVector.ResourceUnitCapacityType capacityType = QueueCapacityVector.ResourceUnitCapacityType.ABSOLUTE;
        String suffix = resourceValue.replaceAll(FLOAT_DIGIT_REGEX, "");
        if (!resourceValue.endsWith(suffix)) {
            return;
        }
        float convertedValue = parsedResourceValue = Float.parseFloat(resourceValue.substring(0, resourceValue.length() - suffix.length()));
        if (!suffix.isEmpty() && UnitsConversionUtil.KNOWN_UNITS.contains(suffix)) {
            convertedValue = UnitsConversionUtil.convert((String)suffix, (String)"Mi", (long)((long)parsedResourceValue));
        } else {
            for (QueueCapacityVector.ResourceUnitCapacityType capacityTypeSuffix : QueueCapacityVector.ResourceUnitCapacityType.values()) {
                if (!capacityTypeSuffix.getPostfix().equals(suffix)) continue;
                capacityType = capacityTypeSuffix;
            }
        }
        resource.setResource(resourceName, convertedValue, capacityType);
    }

    public boolean isCapacityVectorFormat(String configuredCapacity) {
        if (configuredCapacity == null) {
            return false;
        }
        String formattedCapacityString = configuredCapacity.replaceAll(" ", "");
        return RESOURCE_PATTERN.matcher(formattedCapacityString).find();
    }

    private static class Parser {
        private final Pattern regex;
        private final Function<Matcher, QueueCapacityVector> parser;

        Parser(Pattern regex, Function<Matcher, QueueCapacityVector> parser) {
            this.regex = regex;
            this.parser = parser;
        }
    }
}

