/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePrefixes;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;

public final class ConfigurationUpdateAssembler {
    private ConfigurationUpdateAssembler() {
    }

    public static Map<String, String> constructKeyValueConfUpdate(CapacitySchedulerConfiguration proposedConf, SchedConfUpdateInfo mutationInfo) throws IOException {
        HashMap<String, String> confUpdate = new HashMap<String, String>();
        for (String string : mutationInfo.getRemoveQueueInfo()) {
            ConfigurationUpdateAssembler.removeQueue(string, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getAddQueueInfo()) {
            ConfigurationUpdateAssembler.addQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getUpdateQueueInfo()) {
            ConfigurationUpdateAssembler.updateQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (Map.Entry entry : mutationInfo.getGlobalParams().entrySet()) {
            confUpdate.put((String)entry.getKey(), (String)entry.getValue());
        }
        return confUpdate;
    }

    private static void removeQueue(String queueToRemove, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (queueToRemove == null) {
            return;
        }
        QueuePath queuePath = new QueuePath(queueToRemove);
        if (queuePath.isRoot() || queuePath.isInvalid()) {
            throw new IOException("Can't remove queue " + queuePath.getFullPath());
        }
        String queueName = queuePath.getLeafName();
        List<String> siblingQueues = ConfigurationUpdateAssembler.getSiblingQueues(queuePath, proposedConf);
        if (!siblingQueues.contains(queueName)) {
            throw new IOException("Queue " + queuePath.getFullPath() + " not found");
        }
        siblingQueues.remove(queueName);
        QueuePath parentPath = queuePath.getParentObject();
        proposedConf.setQueues(parentPath, siblingQueues.toArray(new String[0]));
        String queuesConfig = ConfigurationUpdateAssembler.getQueuesConfig(parentPath);
        if (siblingQueues.isEmpty()) {
            confUpdate.put(queuesConfig, null);
            String queueOrderingPolicy = ConfigurationUpdateAssembler.getOrderingPolicyConfig(parentPath);
            proposedConf.unset(queueOrderingPolicy);
            confUpdate.put(queueOrderingPolicy, null);
        } else {
            confUpdate.put(queuesConfig, Joiner.on((char)',').join(siblingQueues));
        }
        for (Map.Entry confRemove : proposedConf.getValByRegex(".*" + queuePath.getFullPath() + "\\..*").entrySet()) {
            proposedConf.unset((String)confRemove.getKey());
            confUpdate.put((String)confRemove.getKey(), (String)null);
        }
    }

    private static void addQueue(QueueConfigInfo addInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (addInfo == null) {
            return;
        }
        QueuePath queuePath = new QueuePath(addInfo.getQueue());
        String queueName = queuePath.getLeafName();
        if (queuePath.isRoot() || queuePath.isInvalid()) {
            throw new IOException("Can't add invalid queue " + queuePath);
        }
        if (ConfigurationUpdateAssembler.getSiblingQueues(queuePath, proposedConf).contains(queueName)) {
            throw new IOException("Can't add existing queue " + queuePath);
        }
        QueuePath parentPath = queuePath.getParentObject();
        List<String> siblingQueues = proposedConf.getQueues(parentPath);
        siblingQueues.add(queueName);
        proposedConf.setQueues(parentPath, siblingQueues.toArray(new String[0]));
        confUpdate.put(ConfigurationUpdateAssembler.getQueuesConfig(parentPath), Joiner.on((char)',').join(siblingQueues));
        String keyPrefix = QueuePrefixes.getQueuePrefix(queuePath);
        for (Map.Entry kv : addInfo.getParams().entrySet()) {
            String keyValue = (String)kv.getValue();
            if (keyValue == null || keyValue.isEmpty()) {
                proposedConf.unset(keyPrefix + (String)kv.getKey());
                confUpdate.put(keyPrefix + (String)kv.getKey(), null);
                continue;
            }
            proposedConf.set(keyPrefix + (String)kv.getKey(), keyValue);
            confUpdate.put(keyPrefix + (String)kv.getKey(), keyValue);
        }
        String queueOrderingPolicy = ConfigurationUpdateAssembler.getOrderingPolicyConfig(parentPath);
        if (siblingQueues.size() == 1) {
            proposedConf.unset(queueOrderingPolicy);
            confUpdate.put(queueOrderingPolicy, null);
        }
    }

    private static void updateQueue(QueueConfigInfo updateInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) {
        if (updateInfo == null) {
            return;
        }
        QueuePath queuePath = new QueuePath(updateInfo.getQueue());
        String keyPrefix = QueuePrefixes.getQueuePrefix(queuePath);
        for (Map.Entry kv : updateInfo.getParams().entrySet()) {
            String keyValue = (String)kv.getValue();
            if (keyValue == null || keyValue.isEmpty()) {
                proposedConf.unset(keyPrefix + (String)kv.getKey());
                confUpdate.put(keyPrefix + (String)kv.getKey(), null);
                continue;
            }
            proposedConf.set(keyPrefix + (String)kv.getKey(), keyValue);
            confUpdate.put(keyPrefix + (String)kv.getKey(), keyValue);
        }
    }

    private static List<String> getSiblingQueues(QueuePath queuePath, Configuration conf) {
        String childQueuesKey = ConfigurationUpdateAssembler.getQueuesConfig(queuePath.getParentObject());
        return new ArrayList<String>(conf.getTrimmedStringCollection(childQueuesKey));
    }

    private static String getQueuesConfig(QueuePath queuePath) {
        return QueuePrefixes.getQueuePrefix(queuePath) + "queues";
    }

    private static String getOrderingPolicyConfig(QueuePath queuePath) {
        return QueuePrefixes.getQueuePrefix(queuePath) + "ordering-policy";
    }
}

