/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;

public final class QueuePrefixes {
    private QueuePrefixes() {
    }

    public static String getQueuePrefix(QueuePath queuePath) {
        return "yarn.scheduler.capacity." + queuePath.getFullPath() + ".";
    }

    public static String getNodeLabelPrefix(QueuePath queuePath, String label) {
        if (label.equals("")) {
            return QueuePrefixes.getQueuePrefix(queuePath);
        }
        return QueuePrefixes.getQueuePrefix(queuePath) + "accessible-node-labels" + "." + label + ".";
    }

    public static String getAutoCreatedQueueTemplateConfPrefix(QueuePath queuePath) {
        return queuePath.getFullPath() + "." + "leaf-queue-template";
    }

    public static QueuePath getAutoCreatedQueueObjectTemplateConfPrefix(QueuePath queuePath) {
        return new QueuePath(QueuePrefixes.getAutoCreatedQueueTemplateConfPrefix(queuePath));
    }
}

