/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.InvalidLabelResourceRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.SchedulerInvalidResourceRequestException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerUtils.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final String RELEASED_CONTAINER = "Container released by application";
    public static final String UPDATED_CONTAINER = "Temporary container killed by application for ExeutionType update";
    public static final String LOST_CONTAINER = "Container released on a *lost* node";
    public static final String PREEMPTED_CONTAINER = "Container preempted by scheduler";
    public static final String COMPLETED_APPLICATION = "Container of a completed application";
    public static final String EXPIRED_CONTAINER = "Container expired since it was unused";
    public static final String UNRESERVED_CONTAINER = "Container reservation no longer required.";

    public static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -100, diagnostics);
    }

    public static ContainerStatus createKilledContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -106, diagnostics);
    }

    public static ContainerStatus createPreemptedContainerStatus(ContainerId containerId, String diagnostics) {
        return SchedulerUtils.createAbnormalContainerStatus(containerId, -102, diagnostics);
    }

    private static ContainerStatus createAbnormalContainerStatus(ContainerId containerId, int exitStatus, String diagnostics) {
        ContainerStatus containerStatus = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
        containerStatus.setContainerId(containerId);
        containerStatus.setDiagnostics(diagnostics);
        containerStatus.setExitStatus(exitStatus);
        containerStatus.setState(ContainerState.COMPLETE);
        return containerStatus;
    }

    @VisibleForTesting
    public static void normalizeRequest(ResourceRequest ask, ResourceCalculator resourceCalculator, Resource minimumResource, Resource maximumResource) {
        ask.setCapability(SchedulerUtils.getNormalizedResource(ask.getCapability(), resourceCalculator, minimumResource, maximumResource, minimumResource));
    }

    public static Resource getNormalizedResource(Resource ask, ResourceCalculator resourceCalculator, Resource minimumResource, Resource maximumResource, Resource incrementResource) {
        Resource normalized = Resources.normalize((ResourceCalculator)resourceCalculator, (Resource)ask, (Resource)minimumResource, (Resource)maximumResource, (Resource)incrementResource);
        return normalized;
    }

    private static void normalizeNodeLabelExpressionInRequest(ResourceRequest resReq, QueueInfo queueInfo) {
        String labelExp = resReq.getNodeLabelExpression();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested Node Label Expression : " + labelExp);
            LOG.debug("Queue Info : " + queueInfo);
        }
        if (labelExp == null && queueInfo != null && "*".equals(resReq.getResourceName())) {
            LOG.debug("Setting default node label expression : {}", (Object)queueInfo.getDefaultNodeLabelExpression());
            labelExp = queueInfo.getDefaultNodeLabelExpression();
        }
        if (labelExp == null && queueInfo != null) {
            labelExp = "";
        }
        if (labelExp != null) {
            resReq.setNodeLabelExpression(labelExp);
        }
    }

    public static void normalizeAndValidateRequest(ResourceRequest resReq, Resource maximumAllocation, String queueName, boolean isRecovery, RMContext rmContext, QueueInfo queueInfo, boolean nodeLabelsEnabled) throws InvalidResourceRequestException {
        String labelExp;
        Configuration conf = rmContext.getYarnConfiguration();
        if (null != conf && !nodeLabelsEnabled && !"".equals(labelExp = resReq.getNodeLabelExpression()) && null != labelExp) {
            String message = "NodeLabel is not enabled in cluster, but resource request contains a label expression.";
            LOG.warn(message);
            if (!isRecovery) {
                throw new InvalidLabelResourceRequestException("Invalid resource request, node label not enabled but request contains label expression");
            }
        }
        if (null == queueInfo) {
            try {
                queueInfo = rmContext.getScheduler().getQueueInfo(queueName, false, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SchedulerUtils.normalizeNodeLabelExpressionInRequest(resReq, queueInfo);
        if (!isRecovery) {
            SchedulerUtils.validateResourceRequest(resReq, maximumAllocation, queueInfo, rmContext);
        }
    }

    public static void normalizeAndValidateRequest(ResourceRequest resReq, Resource maximumAllocation, String queueName, RMContext rmContext, QueueInfo queueInfo, boolean nodeLabelsEnabled) throws InvalidResourceRequestException {
        SchedulerUtils.normalizeAndValidateRequest(resReq, maximumAllocation, queueName, false, rmContext, queueInfo, nodeLabelsEnabled);
    }

    public static void enforcePartitionExclusivity(ResourceRequest resReq, Set<String> enforcedPartitions, String appLabel) {
        if (enforcedPartitions == null || enforcedPartitions.isEmpty()) {
            return;
        }
        if (!enforcedPartitions.contains(appLabel) && enforcedPartitions.contains(resReq.getNodeLabelExpression())) {
            resReq.setNodeLabelExpression(appLabel);
        }
        if (enforcedPartitions.contains(appLabel)) {
            resReq.setNodeLabelExpression(appLabel);
        }
    }

    private static void validateResourceRequest(ResourceRequest resReq, Resource maximumAllocation, QueueInfo queueInfo, RMContext rmContext) throws InvalidResourceRequestException {
        Resource requestedResource = resReq.getCapability();
        SchedulerUtils.checkResourceRequestAgainstAvailableResource(requestedResource, maximumAllocation);
        String labelExp = resReq.getNodeLabelExpression();
        if (!"*".equals(resReq.getResourceName()) && labelExp != null && !labelExp.trim().isEmpty()) {
            throw new InvalidLabelResourceRequestException("Invalid resource request, queue=" + queueInfo.getQueueName() + " specified node label expression in a resource request has resource name = " + resReq.getResourceName());
        }
        if (labelExp != null && labelExp.contains("&&")) {
            throw new InvalidLabelResourceRequestException("Invalid resource request, queue=" + queueInfo.getQueueName() + " specified more than one node label in a node label expression, node label expression = " + labelExp);
        }
        if (labelExp != null && !labelExp.trim().isEmpty() && queueInfo != null) {
            if (!SchedulerUtils.checkQueueLabelExpression(queueInfo.getAccessibleNodeLabels(), labelExp, rmContext)) {
                throw new InvalidLabelResourceRequestException("Invalid resource request, queue=" + queueInfo.getQueueName() + " doesn't have permission to access all labels in resource request. labelExpression of resource request=" + labelExp + ". Queue labels=" + (queueInfo.getAccessibleNodeLabels() == null ? "" : StringUtils.join(queueInfo.getAccessibleNodeLabels().iterator(), (char)',')));
            }
            SchedulerUtils.checkQueueLabelInLabelManager(labelExp, rmContext);
        }
    }

    private static Map<String, ResourceInformation> getZeroResources(Resource resource) {
        HashMap resourceInformations = Maps.newHashMap();
        int maxLength = ResourceUtils.getNumberOfCountableResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation resourceInformation = resource.getResourceInformation(i);
            if (resourceInformation.getValue() != 0L) continue;
            resourceInformations.put(resourceInformation.getName(), resourceInformation);
        }
        return resourceInformations;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static void checkResourceRequestAgainstAvailableResource(Resource reqResource, Resource availableResource) throws InvalidResourceRequestException {
        for (int i = 0; i < ResourceUtils.getNumberOfCountableResourceTypes(); ++i) {
            boolean valid;
            ResourceInformation requestedRI = reqResource.getResourceInformation(i);
            String reqResourceName = requestedRI.getName();
            if (requestedRI.getValue() < 0L) {
                SchedulerUtils.throwInvalidResourceException(reqResource, availableResource, reqResourceName, InvalidResourceRequestException.InvalidResourceType.LESS_THAN_ZERO);
            }
            if (valid = SchedulerUtils.checkResource(requestedRI, availableResource)) continue;
            SchedulerUtils.throwInvalidResourceException(reqResource, availableResource, reqResourceName, InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION);
        }
    }

    public static MaxResourceValidationResult validateResourceRequestsAgainstQueueMaxResource(ResourceRequest resReq, Resource availableResource) throws SchedulerInvalidResourceRequestException {
        Resource reqResource = resReq.getCapability();
        Map<String, ResourceInformation> resourcesWithZeroAmount = SchedulerUtils.getZeroResources(availableResource);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resources with zero amount: " + Arrays.toString(resourcesWithZeroAmount.entrySet().toArray()));
        }
        ArrayList invalidResources = Lists.newArrayList();
        for (int i = 0; i < ResourceUtils.getNumberOfCountableResourceTypes(); ++i) {
            ResourceInformation requestedRI = reqResource.getResourceInformation(i);
            String reqResourceName = requestedRI.getName();
            if (!resourcesWithZeroAmount.containsKey(reqResourceName) || requestedRI.getValue() <= 0L) continue;
            invalidResources.add(requestedRI);
        }
        return new MaxResourceValidationResult(resReq, invalidResources);
    }

    private static boolean checkResource(ResourceInformation requestedRI, Resource availableResource) {
        ResourceInformation availableRI = availableResource.getResourceInformation(requestedRI.getName());
        long requestedResourceValue = requestedRI.getValue();
        long availableResourceValue = availableRI.getValue();
        int unitsRelation = UnitsConversionUtil.compareUnits((String)requestedRI.getUnits(), (String)availableRI.getUnits());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested resource information: " + requestedRI);
            LOG.debug("Available resource information: " + availableRI);
            LOG.debug("Relation of units: " + unitsRelation);
        }
        if (unitsRelation < 0) {
            availableResourceValue = UnitsConversionUtil.convert((String)availableRI.getUnits(), (String)requestedRI.getUnits(), (long)availableRI.getValue());
        } else if (unitsRelation > 0) {
            requestedResourceValue = UnitsConversionUtil.convert((String)requestedRI.getUnits(), (String)availableRI.getUnits(), (long)requestedRI.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested resource value after conversion: " + requestedResourceValue);
            LOG.info("Available resource value after conversion: " + availableResourceValue);
        }
        return requestedResourceValue <= availableResourceValue;
    }

    private static void throwInvalidResourceException(Resource reqResource, Resource maxAllowedAllocation, String reqResourceName, InvalidResourceRequestException.InvalidResourceType invalidResourceType) throws InvalidResourceRequestException {
        String message;
        if (invalidResourceType == InvalidResourceRequestException.InvalidResourceType.LESS_THAN_ZERO) {
            message = String.format("Invalid resource request! Cannot allocate containers as requested resource is less than 0! Requested resource type=[%s], Requested resource=%s", reqResourceName, reqResource);
        } else if (invalidResourceType == InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION) {
            message = String.format("Invalid resource request! Cannot allocate containers as requested resource is greater than maximum allowed allocation. Requested resource type=[%s], Requested resource=%s, maximum allowed allocation=%s, please note that maximum allowed allocation is calculated by scheduler based on maximum resource of registered NodeManagers, which might be less than configured maximum allocation=%s", reqResourceName, reqResource, maxAllowedAllocation, ResourceUtils.getResourceTypesMaximumAllocation());
        } else if (invalidResourceType == InvalidResourceRequestException.InvalidResourceType.UNKNOWN) {
            message = String.format("Invalid resource request! Cannot allocate containers for an unknown reason! Requested resource type=[%s], Requested resource=%s", reqResourceName, reqResource);
        } else {
            throw new IllegalArgumentException(String.format("InvalidResourceType argument should be either %s, %s or %s", InvalidResourceRequestException.InvalidResourceType.LESS_THAN_ZERO, InvalidResourceRequestException.InvalidResourceType.GREATER_THEN_MAX_ALLOCATION, InvalidResourceRequestException.InvalidResourceType.UNKNOWN));
        }
        throw new InvalidResourceRequestException(message, invalidResourceType);
    }

    private static void checkQueueLabelInLabelManager(String labelExpression, RMContext rmContext) throws InvalidLabelResourceRequestException {
        RMNodeLabelsManager nlm;
        if (null != rmContext && (nlm = rmContext.getNodeLabelManager()) != null && !nlm.containsNodeLabel(labelExpression)) {
            throw new InvalidLabelResourceRequestException("Invalid label resource request, cluster do not contain , label= " + labelExpression);
        }
    }

    public static boolean checkQueueLabelExpression(Set<String> queueLabels, String labelExpression, RMContext rmContext) {
        if (labelExpression == null) {
            return true;
        }
        for (String str : labelExpression.split("&&")) {
            if ((str = str.trim()).trim().isEmpty()) continue;
            if (queueLabels == null) {
                return false;
            }
            if (queueLabels.contains(str) || queueLabels.contains("*")) continue;
            return false;
        }
        return true;
    }

    public static AccessType toAccessType(QueueACL acl) {
        switch (acl) {
            case ADMINISTER_QUEUE: {
                return AccessType.ADMINISTER_QUEUE;
            }
            case SUBMIT_APPLICATIONS: {
                return AccessType.SUBMIT_APP;
            }
        }
        return null;
    }

    private static boolean hasPendingResourceRequest(ResourceCalculator rc, ResourceUsage usage, String partitionToLookAt, Resource cluster) {
        return Resources.greaterThan((ResourceCalculator)rc, (Resource)cluster, (Resource)usage.getPending(partitionToLookAt), (Resource)Resources.none());
    }

    @InterfaceAudience.Private
    public static boolean hasPendingResourceRequest(ResourceCalculator rc, ResourceUsage usage, String nodePartition, Resource cluster, SchedulingMode schedulingMode) {
        String partitionToLookAt = nodePartition;
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            partitionToLookAt = "";
        }
        return SchedulerUtils.hasPendingResourceRequest(rc, usage, partitionToLookAt, cluster);
    }

    public static RMContainer createOpportunisticRmContainer(RMContext rmContext, Container container, boolean isRemotelyAllocated) {
        SchedulerNode node = ((AbstractYarnScheduler)rmContext.getScheduler()).getNode(container.getNodeId());
        if (node == null) {
            return null;
        }
        Object appAttempt = ((AbstractYarnScheduler)rmContext.getScheduler()).getCurrentAttemptForContainer(container.getId());
        RMContainerImpl rmContainer = new RMContainerImpl(container, SchedulerRequestKey.extractFrom((Container)container), ((SchedulerApplicationAttempt)appAttempt).getApplicationAttemptId(), container.getNodeId(), ((SchedulerApplicationAttempt)appAttempt).getUser(), rmContext, isRemotelyAllocated);
        ((SchedulerApplicationAttempt)appAttempt).addRMContainer(container.getId(), rmContainer);
        node.allocateContainer(rmContainer);
        return rmContainer;
    }

    public static boolean isNodeHeartbeated(SchedulerNode node, long skipNodeInterval) {
        long timeElapsedFromLastHeartbeat = Time.monotonicNow() - node.getLastHeartbeatMonotonicTime();
        return timeElapsedFromLastHeartbeat <= skipNodeInterval;
    }

    public static class MaxResourceValidationResult {
        private ResourceRequest resourceRequest;
        private List<ResourceInformation> invalidResources;

        MaxResourceValidationResult(ResourceRequest resourceRequest, List<ResourceInformation> invalidResources) {
            this.resourceRequest = resourceRequest;
            this.invalidResources = invalidResources;
        }

        public boolean isValid() {
            return this.invalidResources.isEmpty();
        }

        public String toString() {
            return "MaxResourceValidationResult{resourceRequest=" + this.resourceRequest + ", invalidResources=" + this.invalidResources + '}';
        }
    }
}

