/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CapacitySchedulerHealthInfo {
    long lastrun;
    List<OperationInformation> operationsInfo;
    List<LastRunDetails> lastRunDetails;

    CapacitySchedulerHealthInfo() {
    }

    public long getLastrun() {
        return this.lastrun;
    }

    public List<OperationInformation> getOperationsInfo() {
        return this.operationsInfo;
    }

    CapacitySchedulerHealthInfo(CapacityScheduler cs) {
        SchedulerHealth ht = cs.getSchedulerHealth();
        this.lastrun = ht.getLastSchedulerRunTime();
        this.operationsInfo = new ArrayList<OperationInformation>();
        this.operationsInfo.add(new OperationInformation("last-allocation", ht.getLastAllocationDetails()));
        this.operationsInfo.add(new OperationInformation("last-release", ht.getLastReleaseDetails()));
        this.operationsInfo.add(new OperationInformation("last-preemption", ht.getLastPreemptionDetails()));
        this.operationsInfo.add(new OperationInformation("last-reservation", ht.getLastReservationDetails()));
        this.lastRunDetails = new ArrayList<LastRunDetails>();
        this.lastRunDetails.add(new LastRunDetails("releases", ht.getReleaseCount(), ht.getResourcesReleased()));
        this.lastRunDetails.add(new LastRunDetails("allocations", ht.getAllocationCount(), ht.getResourcesAllocated()));
        this.lastRunDetails.add(new LastRunDetails("reservations", ht.getReservationCount(), ht.getResourcesReserved()));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class OperationInformation {
        String operation;
        String nodeId;
        String containerId;
        String queue;

        OperationInformation() {
        }

        OperationInformation(String operation, SchedulerHealth.DetailedInformation di) {
            this.operation = operation;
            this.nodeId = di.getNodeId() == null ? "N/A" : di.getNodeId().toString();
            this.containerId = di.getContainerId() == null ? "N/A" : di.getContainerId().toString();
            this.queue = di.getQueue() == null ? "N/A" : di.getQueue();
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getQueue() {
            return this.queue;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class LastRunDetails {
        String operation;
        long count;
        ResourceInfo resources;

        LastRunDetails() {
        }

        LastRunDetails(String operation, long count, Resource resource) {
            this.operation = operation;
            this.count = count;
            this.resources = new ResourceInfo(resource);
        }

        public String getOperation() {
            return this.operation;
        }

        public long getCount() {
            return this.count;
        }

        public ResourceInfo getResources() {
            return this.resources;
        }
    }
}

