/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.CapacityConverter;

public class WeightToWeightConverter
implements CapacityConverter {
    private static final String ROOT_QUEUE = "root";

    @Override
    public void convertWeightsForChildQueues(FSQueue queue, CapacitySchedulerConfiguration csConfig) {
        List<FSQueue> children = queue.getChildQueues();
        if (queue instanceof FSParentQueue || !children.isEmpty()) {
            QueuePath queuePath = new QueuePath(queue.getName());
            if (queue.getName().equals(ROOT_QUEUE)) {
                csConfig.setNonLabeledQueueWeight(queuePath, queue.getWeight());
            }
            children.forEach(fsQueue -> csConfig.setNonLabeledQueueWeight(new QueuePath(fsQueue.getName()), fsQueue.getWeight()));
            csConfig.setAutoQueueCreationV2Enabled(queuePath, true);
        }
    }
}

