/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverterBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.CapacityConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.CapacityConverterFactory;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FSQueueConverter {
    public static final float QUEUE_MAX_AM_SHARE_DISABLED = -1.0f;
    private static final int MAX_RUNNING_APPS_UNSET = Integer.MAX_VALUE;
    private static final String FAIR_POLICY = "fair";
    private static final String FIFO_POLICY = "fifo";
    private final FSConfigToCSConfigRuleHandler ruleHandler;
    private CapacitySchedulerConfiguration capacitySchedulerConfig;
    private final boolean preemptionEnabled;
    private final boolean sizeBasedWeight;
    private final Resource clusterResource;
    private final float queueMaxAMShareDefault;
    private final int queueMaxAppsDefault;
    private final boolean drfUsed;
    private final boolean usePercentages;
    private ConversionOptions conversionOptions;

    public FSQueueConverter(FSQueueConverterBuilder builder) {
        this.ruleHandler = builder.ruleHandler;
        this.capacitySchedulerConfig = builder.capacitySchedulerConfig;
        this.preemptionEnabled = builder.preemptionEnabled;
        this.sizeBasedWeight = builder.sizeBasedWeight;
        this.clusterResource = builder.clusterResource;
        this.queueMaxAMShareDefault = builder.queueMaxAMShareDefault;
        this.queueMaxAppsDefault = builder.queueMaxAppsDefault;
        this.conversionOptions = builder.conversionOptions;
        this.drfUsed = builder.drfUsed;
        this.usePercentages = builder.usePercentages;
    }

    public void convertQueueHierarchy(FSQueue queue) {
        List<FSQueue> children = queue.getChildQueues();
        String queueName = queue.getName();
        this.emitChildQueues(queueName, children);
        this.emitMaxAMShare(queueName, queue);
        this.emitMaxParallelApps(queueName, queue);
        this.emitMaxAllocations(queueName, queue);
        this.emitPreemptionDisabled(queueName, queue);
        this.emitChildCapacity(queue);
        this.emitMaximumCapacity(queueName, queue);
        this.emitSizeBasedWeight(queueName);
        this.emitOrderingPolicy(queueName, queue);
        this.checkMaxChildCapacitySetting(queue);
        this.emitDefaultUserLimitFactor(queueName, children);
        for (FSQueue childQueue : children) {
            this.convertQueueHierarchy(childQueue);
        }
    }

    private void emitChildQueues(String queueName, List<FSQueue> children) {
        this.ruleHandler.handleChildQueueCount(queueName, children.size());
        if (children.size() > 0) {
            List<String> childQueues = children.stream().map(child -> this.getQueueShortName(child.getName())).collect(Collectors.toList());
            this.capacitySchedulerConfig.setQueues(new QueuePath(queueName), childQueues.toArray(new String[0]));
        }
    }

    private void emitMaxAMShare(String queueName, FSQueue queue) {
        float queueMaxAmShare = queue.getMaxAMShare();
        if (queueMaxAmShare != 0.0f && queueMaxAmShare != this.queueMaxAMShareDefault && queueMaxAmShare != -1.0f) {
            this.capacitySchedulerConfig.setMaximumApplicationMasterResourcePerQueuePercent(new QueuePath(queueName), queueMaxAmShare);
        }
        if (queueMaxAmShare == -1.0f && queueMaxAmShare != this.queueMaxAMShareDefault) {
            this.capacitySchedulerConfig.setMaximumApplicationMasterResourcePerQueuePercent(new QueuePath(queueName), 1.0f);
        }
    }

    private void emitMaxParallelApps(String queueName, FSQueue queue) {
        if (queue.getMaxRunningApps() != Integer.MAX_VALUE && queue.getMaxRunningApps() != this.queueMaxAppsDefault) {
            this.capacitySchedulerConfig.setMaxParallelAppsForQueue(new QueuePath(queueName), String.valueOf(queue.getMaxRunningApps()));
        }
    }

    private void emitMaximumCapacity(String queueName, FSQueue queue) {
        ConfigurableResource rawMaxShare = queue.getRawMaxShare();
        Resource maxResource = rawMaxShare.getResource();
        if (maxResource == null && rawMaxShare.getPercentages() != null || this.isNotUnboundedResource(maxResource)) {
            this.ruleHandler.handleMaxResources();
        }
        this.capacitySchedulerConfig.setMaximumCapacity(new QueuePath(queueName), 100.0f);
    }

    private void emitMaxAllocations(String queueName, FSQueue queue) {
        Resource maxAllocation = queue.getMaximumContainerAllocation();
        if (this.isNotUnboundedResource(maxAllocation)) {
            FSParentQueue parent;
            Resource parentMaxAllocation;
            int parentMaxVcores = Integer.MIN_VALUE;
            long parentMaxMemory = Integer.MIN_VALUE;
            if (queue.getParent() != null && this.isNotUnboundedResource(parentMaxAllocation = ((FSQueue)(parent = queue.getParent())).getMaximumContainerAllocation())) {
                parentMaxVcores = parentMaxAllocation.getVirtualCores();
                parentMaxMemory = parentMaxAllocation.getMemorySize();
            }
            int maxVcores = maxAllocation.getVirtualCores();
            long maxMemory = maxAllocation.getMemorySize();
            if (maxVcores != parentMaxVcores || maxMemory != parentMaxMemory) {
                this.capacitySchedulerConfig.setQueueMaximumAllocationMb(new QueuePath(queueName), (int)maxMemory);
                this.capacitySchedulerConfig.setQueueMaximumAllocationVcores(new QueuePath(queueName), maxVcores);
            }
        }
    }

    private void emitPreemptionDisabled(String queueName, FSQueue queue) {
        if (this.preemptionEnabled && !queue.isPreemptable()) {
            this.capacitySchedulerConfig.setPreemptionDisabled(new QueuePath(queueName), true);
        }
    }

    public void emitDefaultUserLimitFactor(String queueName, List<FSQueue> children) {
        if (children.isEmpty() && !this.capacitySchedulerConfig.isAutoQueueCreationV2Enabled(new QueuePath(queueName))) {
            this.capacitySchedulerConfig.setUserLimitFactor(new QueuePath(queueName), -1.0f);
        }
    }

    private void emitSizeBasedWeight(String queueName) {
        if (this.sizeBasedWeight) {
            this.capacitySchedulerConfig.setBoolean("yarn.scheduler.capacity." + queueName + ".ordering-policy.fair.enable-size-based-weight", true);
        }
    }

    private void emitOrderingPolicy(String queueName, FSQueue queue) {
        if (queue instanceof FSLeafQueue) {
            String policy;
            switch (policy = queue.getPolicy().getName()) {
                case "DRF": {
                    this.capacitySchedulerConfig.setOrderingPolicy(new QueuePath(queueName), FAIR_POLICY);
                    break;
                }
                case "fair": {
                    this.capacitySchedulerConfig.setOrderingPolicy(new QueuePath(queueName), FAIR_POLICY);
                    if (!this.drfUsed) break;
                    this.ruleHandler.handleFairAsDrf(queueName);
                    break;
                }
                case "FIFO": {
                    this.capacitySchedulerConfig.setOrderingPolicy(new QueuePath(queueName), FIFO_POLICY);
                    break;
                }
                default: {
                    String msg = String.format("Unexpected ordering policy on queue %s: %s", queue, policy);
                    this.conversionOptions.handleConversionError(msg);
                }
            }
        }
    }

    private void emitChildCapacity(FSQueue queue) {
        CapacityConverter converter = CapacityConverterFactory.getConverter(this.usePercentages);
        converter.convertWeightsForChildQueues(queue, this.capacitySchedulerConfig);
        if (Resources.none().compareTo(queue.getMinShare()) != 0) {
            this.ruleHandler.handleMinResources();
        }
    }

    private void checkMaxChildCapacitySetting(FSQueue queue) {
        Resource resource;
        if (queue.getMaxChildQueueResource() != null && ((resource = queue.getMaxChildQueueResource().getResource()) != null && this.isNotUnboundedResource(resource) || queue.getMaxChildQueueResource().getPercentages() != null)) {
            this.ruleHandler.handleMaxChildCapacity();
        }
    }

    private String getQueueShortName(String queueName) {
        int lastDot = queueName.lastIndexOf(".");
        return queueName.substring(lastDot + 1);
    }

    private boolean isNotUnboundedResource(Resource res) {
        return Resources.unbounded().compareTo(res) != 0;
    }
}

