/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AssignmentInformation {
    private final int[] operationCounts;
    private final Resource[] operationResources;
    private final List<AssignmentDetails>[] operationDetails;

    public AssignmentInformation() {
        int numOps = Operation.size();
        this.operationCounts = new int[numOps];
        this.operationResources = new Resource[numOps];
        this.operationDetails = new List[numOps];
        for (int i = 0; i < numOps; ++i) {
            this.operationCounts[i] = 0;
            this.operationResources[i] = Resource.newInstance((int)0, (int)0);
            this.operationDetails[i] = new ArrayList<AssignmentDetails>();
        }
    }

    public int getNumAllocations() {
        return this.operationCounts[Operation.ALLOCATION.ordinal()];
    }

    public void incrAllocations() {
        this.increment(Operation.ALLOCATION, 1);
    }

    public void incrAllocations(int by) {
        this.increment(Operation.ALLOCATION, by);
    }

    public int getNumReservations() {
        return this.operationCounts[Operation.RESERVATION.ordinal()];
    }

    public void incrReservations() {
        this.increment(Operation.RESERVATION, 1);
    }

    public void incrReservations(int by) {
        this.increment(Operation.RESERVATION, by);
    }

    private void increment(Operation op, int by) {
        int n = op.ordinal();
        this.operationCounts[n] = this.operationCounts[n] + by;
    }

    public Resource getAllocated() {
        return this.operationResources[Operation.ALLOCATION.ordinal()];
    }

    public Resource getReserved() {
        return this.operationResources[Operation.RESERVATION.ordinal()];
    }

    private void addAssignmentDetails(Operation op, RMContainer rmContainer, String queue) {
        this.getDetails(op).add(new AssignmentDetails(rmContainer, queue));
    }

    public void addAllocationDetails(RMContainer rmContainer, String queue) {
        this.addAssignmentDetails(Operation.ALLOCATION, rmContainer, queue);
    }

    public void addReservationDetails(RMContainer rmContainer, String queue) {
        this.addAssignmentDetails(Operation.RESERVATION, rmContainer, queue);
    }

    private List<AssignmentDetails> getDetails(Operation op) {
        return this.operationDetails[op.ordinal()];
    }

    public List<AssignmentDetails> getAllocationDetails() {
        return this.getDetails(Operation.ALLOCATION);
    }

    public List<AssignmentDetails> getReservationDetails() {
        return this.getDetails(Operation.RESERVATION);
    }

    private RMContainer getFirstRMContainerFromOperation(Operation op) {
        List<AssignmentDetails> assignDetails = this.getDetails(op);
        if (assignDetails != null && !assignDetails.isEmpty()) {
            return assignDetails.get((int)0).rmContainer;
        }
        return null;
    }

    public RMContainer getFirstAllocatedOrReservedRMContainer() {
        RMContainer rmContainer = this.getFirstRMContainerFromOperation(Operation.ALLOCATION);
        if (null != rmContainer) {
            return rmContainer;
        }
        return this.getFirstRMContainerFromOperation(Operation.RESERVATION);
    }

    public ContainerId getFirstAllocatedOrReservedContainerId() {
        RMContainer rmContainer = this.getFirstAllocatedOrReservedRMContainer();
        if (null != rmContainer) {
            return rmContainer.getContainerId();
        }
        return null;
    }

    public static enum Operation {
        ALLOCATION,
        RESERVATION;

        private static int SIZE;

        static int size() {
            return SIZE;
        }

        static {
            SIZE = Operation.values().length;
        }
    }

    public static class AssignmentDetails {
        public RMContainer rmContainer;
        public ContainerId containerId;
        public String queue;

        public AssignmentDetails(RMContainer rmContainer, String queue) {
            this.containerId = rmContainer.getContainerId();
            this.rmContainer = rmContainer;
            this.queue = queue;
        }
    }
}

