/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueManagementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.DeactivatedLeafQueuesByLabel;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.LeafQueueEntitlements;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaranteedOrZeroCapacityOverTimePolicy
implements AutoCreatedQueueManagementPolicy {
    private static final int DEFAULT_QUEUE_PRINT_SIZE_LIMIT = 25;
    private ManagedParentQueue managedParentQueue;
    private static final Logger LOG = LoggerFactory.getLogger(GuaranteedOrZeroCapacityOverTimePolicy.class);
    private ReentrantReadWriteLock.WriteLock writeLock;
    private ReentrantReadWriteLock.ReadLock readLock;
    private ParentQueueState parentQueueState = new ParentQueueState();
    private AutoCreatedLeafQueueConfig leafQueueTemplate;
    private QueueCapacities leafQueueTemplateCapacities;
    private Set<String> leafQueueTemplateNodeLabels;
    private LeafQueueState leafQueueState = new LeafQueueState();
    private Clock clock = new MonotonicClock();

    @Override
    public void init(AbstractParentQueue parentQueue) throws IOException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IllegalArgumentException("Expected instance of type " + ManagedParentQueue.class);
        }
        this.managedParentQueue = (ManagedParentQueue)parentQueue;
        this.initializeLeafQueueTemplate(this.managedParentQueue);
        LOG.info("Initialized queue management policy for parent queue " + parentQueue.getQueuePath() + " with leaf queue template capacities : [" + this.leafQueueTemplate.getQueueCapacities() + "]");
    }

    private void initializeLeafQueueTemplate(ManagedParentQueue parentQueue) throws IOException {
        this.leafQueueTemplate = parentQueue.getLeafQueueTemplate();
        this.leafQueueTemplateCapacities = this.leafQueueTemplate.getQueueCapacities();
        Set<String> parentQueueLabels = parentQueue.getNodeLabelsForQueue();
        for (String nodeLabel : this.leafQueueTemplateCapacities.getExistingNodeLabels()) {
            if (parentQueueLabels.contains(nodeLabel)) continue;
            LOG.error("Invalid node label " + nodeLabel + " on configured leaf template on parent queue " + parentQueue.getQueuePath());
            throw new IOException("Invalid node label " + nodeLabel + " on configured leaf template on parent queue " + parentQueue.getQueuePath());
        }
        this.leafQueueTemplateNodeLabels = this.leafQueueTemplateCapacities.getExistingNodeLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueManagementChange> computeQueueManagementChanges() throws SchedulerDynamicEditException {
        this.updateTemplateAbsoluteCapacities(this.managedParentQueue.getQueueCapacities(), (GuaranteedOrZeroCapacityOverTimePolicy)this.managedParentQueue.getAutoCreatedQueueManagementPolicy());
        this.updateLeafQueueState();
        this.readLock.lock();
        try {
            LeafQueueEntitlements leafQueueEntitlements = new LeafQueueEntitlements();
            for (String nodeLabel : this.leafQueueTemplateNodeLabels) {
                DeactivatedLeafQueuesByLabel deactivatedLeafQueues = this.deactivateLeafQueues(nodeLabel, leafQueueEntitlements);
                deactivatedLeafQueues.printToDebug(LOG);
                if (!deactivatedLeafQueues.canActivateLeafQueues()) continue;
                this.activateLeafQueues(leafQueueEntitlements, nodeLabel, deactivatedLeafQueues);
            }
            List<QueueManagementChange> list = leafQueueEntitlements.mapToQueueManagementChanges((leafQueueName, capacities) -> {
                AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.managedParentQueue.getQueueContext().getQueueManager().getQueue((String)leafQueueName);
                AutoCreatedLeafQueueConfig newTemplate = this.buildTemplate((QueueCapacities)capacities);
                return new QueueManagementChange.UpdateQueue((CSQueue)leafQueue, newTemplate);
            });
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void activateLeafQueues(LeafQueueEntitlements leafQueueEntitlements, String nodeLabel, DeactivatedLeafQueuesByLabel deactivatedLeafQueues) throws SchedulerDynamicEditException {
        List<FiCaSchedulerApp> pendingApps = this.getSortedPendingApplications();
        if (pendingApps.size() > 0) {
            int maxLeafQueuesTobeActivated = deactivatedLeafQueues.getMaxLeavesToBeActivated(pendingApps.size());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parent queue = {}, Found {} leaf queues to be activated with {} aps", new Object[]{this.managedParentQueue.getQueuePath(), maxLeafQueuesTobeActivated, pendingApps.size()});
            }
            LinkedHashSet<String> leafQueuesToBeActivated = this.getSortedLeafQueues(nodeLabel, pendingApps, maxLeafQueuesTobeActivated, deactivatedLeafQueues.getQueues());
            this.updateLeafQueueCapacitiesByLabel(nodeLabel, leafQueuesToBeActivated, leafQueueEntitlements);
            if (LOG.isDebugEnabled() && leafQueuesToBeActivated.size() > 0) {
                LOG.debug("Activated leaf queues : [{}]", this.getListContentsUpToLimit(leafQueuesToBeActivated));
            }
        }
    }

    private Object getListContentsUpToLimit(Set<String> leafQueuesToBeActivated) {
        return leafQueuesToBeActivated.size() < 25 ? leafQueuesToBeActivated : Integer.valueOf(leafQueuesToBeActivated.size());
    }

    private Object getMapUpToLimit(Map<String, QueueCapacities> deactivatedLeafQueues) {
        return deactivatedLeafQueues.size() > 25 ? Integer.valueOf(deactivatedLeafQueues.size()) : deactivatedLeafQueues;
    }

    private DeactivatedLeafQueuesByLabel deactivateLeafQueues(String nodeLabel, LeafQueueEntitlements leafQueueEntitlements) throws SchedulerDynamicEditException {
        float parentAbsoluteCapacity = this.managedParentQueue.getQueueCapacities().getAbsoluteCapacity(nodeLabel);
        float leafQueueTemplateAbsoluteCapacity = this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel);
        Map<String, QueueCapacities> deactivatedLeafQueues = this.deactivateLeafQueuesIfInActive(this.managedParentQueue, nodeLabel, leafQueueEntitlements);
        if (LOG.isDebugEnabled() && deactivatedLeafQueues.size() > 0) {
            LOG.debug("Parent queue = {}, nodeLabel = {}, deactivated leaf queues = [{}] ", new Object[]{this.managedParentQueue.getQueuePath(), nodeLabel, this.getMapUpToLimit(deactivatedLeafQueues)});
        }
        return new DeactivatedLeafQueuesByLabel(deactivatedLeafQueues, this.managedParentQueue.getQueuePath(), nodeLabel, this.parentQueueState.getAbsoluteActivatedChildQueueCapacity(nodeLabel), parentAbsoluteCapacity, leafQueueTemplateAbsoluteCapacity);
    }

    private void updateTemplateAbsoluteCapacities(QueueCapacities parentQueueCapacities, GuaranteedOrZeroCapacityOverTimePolicy policy) {
        this.writeLock.lock();
        try {
            CSQueueUtils.updateAbsoluteCapacitiesByNodeLabels(policy.leafQueueTemplate.getQueueCapacities(), parentQueueCapacities, policy.leafQueueTemplateNodeLabels, this.managedParentQueue.getQueueContext().getConfiguration().isLegacyQueueMode());
            policy.leafQueueTemplateCapacities = policy.leafQueueTemplate.getQueueCapacities();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void updateTemplateAbsoluteCapacities(QueueCapacities queueCapacities) {
        this.updateTemplateAbsoluteCapacities(queueCapacities, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateLeafQueueState() {
        this.writeLock.lock();
        try {
            HashSet<String> newPartitions = new HashSet<String>();
            HashSet<String> newQueues = new HashSet<String>();
            for (CSQueue newQueue : this.managedParentQueue.getChildQueues()) {
                if (!(newQueue instanceof AbstractLeafQueue)) continue;
                for (String nodeLabel : this.leafQueueTemplateNodeLabels) {
                    this.leafQueueState.createLeafQueueStateIfNotExists((AbstractLeafQueue)newQueue, nodeLabel);
                    newPartitions.add(nodeLabel);
                }
                newQueues.add(newQueue.getQueuePath());
            }
            Iterator<Map.Entry<String, Map<String, LeafQueueStatePerPartition>>> itr = this.leafQueueState.getLeafQueueStateMap().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, Map<String, LeafQueueStatePerPartition>> e = itr.next();
                String partition = e.getKey();
                if (!newPartitions.contains(partition)) {
                    itr.remove();
                    LOG.info(this.managedParentQueue.getQueuePath() + " : Removed partition " + partition + " from leaf queue state");
                    continue;
                }
                Map<String, LeafQueueStatePerPartition> queues = e.getValue();
                Iterator<Map.Entry<String, LeafQueueStatePerPartition>> queueItr = queues.entrySet().iterator();
                while (queueItr.hasNext()) {
                    String queue = queueItr.next().getKey();
                    if (newQueues.contains(queue)) continue;
                    queueItr.remove();
                    LOG.info(this.managedParentQueue.getQueuePath() + " : Removed queue" + queue + " from leaf queue state from partition " + partition);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private LinkedHashSet<String> getSortedLeafQueues(String nodeLabel, List<FiCaSchedulerApp> pendingApps, int leafQueuesNeeded, Set<String> deactivatedQueues) throws SchedulerDynamicEditException {
        LinkedHashSet<String> leafQueues = new LinkedHashSet<String>(leafQueuesNeeded);
        int ctr = 0;
        for (FiCaSchedulerApp app : pendingApps) {
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)app.getCSLeafQueue();
            String leafQueueName = leafQueue.getQueuePath();
            if (ctr >= leafQueuesNeeded) break;
            if (this.isActive(leafQueue, nodeLabel) || deactivatedQueues.contains(leafQueueName) || !this.addLeafQueueIfNotExists(leafQueues, leafQueueName)) continue;
            ++ctr;
        }
        return leafQueues;
    }

    private boolean addLeafQueueIfNotExists(Set<String> leafQueues, String leafQueueName) {
        boolean ret = false;
        if (!leafQueues.contains(leafQueueName)) {
            ret = leafQueues.add(leafQueueName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isActive(AutoCreatedLeafQueue leafQueue, String nodeLabel) throws SchedulerDynamicEditException {
        this.readLock.lock();
        try {
            LeafQueueStatePerPartition leafQueueStatus = this.getLeafQueueState(leafQueue, nodeLabel);
            boolean bl = leafQueueStatus.isActive();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private Map<String, QueueCapacities> deactivateLeafQueuesIfInActive(AbstractParentQueue parentQueue, String nodeLabel, LeafQueueEntitlements leafQueueEntitlements) throws SchedulerDynamicEditException {
        HashMap<String, QueueCapacities> deactivatedQueues = new HashMap<String, QueueCapacities>();
        for (CSQueue childQueue : parentQueue.getChildQueues()) {
            AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)childQueue;
            if (leafQueue != null) {
                if (!this.isActive(leafQueue, nodeLabel) || this.hasPendingApps(leafQueue)) continue;
                QueueCapacities capacities = leafQueueEntitlements.getCapacityOfQueue(leafQueue);
                this.updateToZeroCapacity(capacities, nodeLabel, (AbstractLeafQueue)childQueue);
                deactivatedQueues.put(leafQueue.getQueuePath(), this.leafQueueTemplateCapacities);
                continue;
            }
            LOG.warn("Could not find queue in scheduler while trying to deactivate for " + parentQueue);
        }
        return deactivatedQueues;
    }

    private void updateLeafQueueCapacitiesByLabel(String nodeLabel, Set<String> leafQueuesToBeActivated, LeafQueueEntitlements leafQueueEntitlements) {
        for (String leafQueue : leafQueuesToBeActivated) {
            QueueCapacities capacities = leafQueueEntitlements.getCapacityOfQueueByPath(leafQueue);
            this.updateCapacityFromTemplate(capacities, nodeLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitQueueManagementChanges(List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            for (QueueManagementChange queueManagementChange : queueManagementChanges) {
                AutoCreatedLeafQueueConfig updatedQueueTemplate = queueManagementChange.getUpdatedQueueTemplate();
                CSQueue queue = queueManagementChange.getQueue();
                if (!(queue instanceof AutoCreatedLeafQueue)) {
                    throw new SchedulerDynamicEditException("Expected queue management change for AutoCreatedLeafQueue. Found " + queue.getClass().getName());
                }
                AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)queue;
                for (String nodeLabel : updatedQueueTemplate.getQueueCapacities().getExistingNodeLabels()) {
                    if (updatedQueueTemplate.getQueueCapacities().getCapacity(nodeLabel) > 0.0f) {
                        if (this.isActive(leafQueue, nodeLabel)) {
                            LOG.debug("Queue is already active. Skipping activation : {}", (Object)leafQueue.getQueuePath());
                            continue;
                        }
                        this.activate(leafQueue, nodeLabel);
                        continue;
                    }
                    if (!this.isActive(leafQueue, nodeLabel)) {
                        LOG.debug("Queue is already de-activated. Skipping de-activation : {}", (Object)leafQueue.getQueuePath());
                        continue;
                    }
                    leafQueue.mergeCapacities(updatedQueueTemplate.getQueueCapacities(), this.leafQueueTemplate.getResourceQuotas());
                    leafQueue.getQueueResourceQuotas().setConfiguredMinResource(Resources.multiply((Resource)this.managedParentQueue.getQueueContext().getClusterResource(), (double)updatedQueueTemplate.getQueueCapacities().getCapacity(nodeLabel)));
                    this.deactivate(leafQueue, nodeLabel);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void activate(AbstractAutoCreatedLeafQueue leafQueue, String nodeLabel) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            this.getLeafQueueState(leafQueue, nodeLabel).activate();
            this.parentQueueState.incAbsoluteActivatedChildCapacity(nodeLabel, this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void deactivate(AbstractAutoCreatedLeafQueue leafQueue, String nodeLabel) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            this.getLeafQueueState(leafQueue, nodeLabel).deactivate();
            this.parentQueueState.decAbsoluteActivatedChildCapacity(nodeLabel, this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasPendingApps(AutoCreatedLeafQueue leafQueue) {
        return leafQueue.getNumApplications() > 0;
    }

    @Override
    public void reinitialize(AbstractParentQueue parentQueue) throws IOException {
        if (!(parentQueue instanceof ManagedParentQueue)) {
            throw new IllegalStateException("Expected instance of type " + ManagedParentQueue.class + " found   : " + parentQueue.getClass());
        }
        if (this.managedParentQueue != null && !parentQueue.getQueuePath().equals(this.managedParentQueue.getQueuePath())) {
            throw new IllegalStateException("Expected parent queue path to match " + this.managedParentQueue.getQueuePath() + " found : " + parentQueue.getQueuePath());
        }
        this.managedParentQueue = (ManagedParentQueue)parentQueue;
        this.initializeLeafQueueTemplate(this.managedParentQueue);
        this.parentQueueState.clear();
        this.leafQueueState.clear();
        LOG.info("Reinitialized queue management policy for parent queue " + parentQueue.getQueuePath() + " with leaf queue template capacities : [" + this.leafQueueTemplate.getQueueCapacities() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCreatedLeafQueueConfig getInitialLeafQueueConfiguration(AbstractAutoCreatedLeafQueue leafQueue) throws SchedulerDynamicEditException {
        AutoCreatedLeafQueueConfig template;
        if (!(leafQueue instanceof AutoCreatedLeafQueue)) {
            throw new SchedulerDynamicEditException("Not an instance of AutoCreatedLeafQueue : " + leafQueue.getClass());
        }
        this.writeLock.lock();
        try {
            QueueCapacities capacities = new QueueCapacities(false);
            for (String nodeLabel : this.leafQueueTemplateNodeLabels) {
                float availableCapacity;
                if (!this.leafQueueState.createLeafQueueStateIfNotExists(leafQueue, nodeLabel)) {
                    String message = "Leaf queue already exists in state : " + this.getLeafQueueState(leafQueue, nodeLabel);
                    LOG.error(message);
                }
                if ((availableCapacity = this.managedParentQueue.getQueueCapacities().getAbsoluteCapacity(nodeLabel) - this.parentQueueState.getAbsoluteActivatedChildQueueCapacity(nodeLabel) + 0.001f) >= this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel)) {
                    this.updateCapacityFromTemplate(capacities, nodeLabel);
                    this.activate(leafQueue, nodeLabel);
                    continue;
                }
                this.updateToZeroCapacity(capacities, nodeLabel, leafQueue);
            }
            template = this.buildTemplate(capacities);
        }
        finally {
            this.writeLock.unlock();
        }
        return template;
    }

    private void updateToZeroCapacity(QueueCapacities capacities, String nodeLabel, AbstractLeafQueue leafQueue) {
        capacities.setCapacity(nodeLabel, 0.0f);
        capacities.setMaximumCapacity(nodeLabel, this.leafQueueTemplateCapacities.getMaximumCapacity(nodeLabel));
        leafQueue.getQueueResourceQuotas().setConfiguredMinResource(nodeLabel, Resource.newInstance((int)0, (int)0));
    }

    private void updateCapacityFromTemplate(QueueCapacities capacities, String nodeLabel) {
        capacities.setCapacity(nodeLabel, this.leafQueueTemplateCapacities.getCapacity(nodeLabel));
        capacities.setMaximumCapacity(nodeLabel, this.leafQueueTemplateCapacities.getMaximumCapacity(nodeLabel));
        capacities.setAbsoluteCapacity(nodeLabel, this.leafQueueTemplateCapacities.getAbsoluteCapacity(nodeLabel));
        capacities.setAbsoluteMaximumCapacity(nodeLabel, this.leafQueueTemplateCapacities.getAbsoluteMaximumCapacity(nodeLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    LeafQueueStatePerPartition getLeafQueueState(AbstractLeafQueue queue, String partition) throws SchedulerDynamicEditException {
        this.readLock.lock();
        try {
            String queuePath = queue.getQueuePath();
            if (!this.leafQueueState.containsLeafQueue(queuePath, partition)) {
                throw new SchedulerDynamicEditException("Could not find leaf queue in state " + queuePath);
            }
            LeafQueueStatePerPartition leafQueueStatePerPartition = this.leafQueueState.getLeafQueueStatePerPartition(queuePath, partition);
            return leafQueueStatePerPartition;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @VisibleForTesting
    public float getAbsoluteActivatedChildQueueCapacity(String nodeLabel) {
        return this.parentQueueState.getAbsoluteActivatedChildQueueCapacity(nodeLabel);
    }

    private List<FiCaSchedulerApp> getSortedPendingApplications() {
        ArrayList<FiCaSchedulerApp> apps = new ArrayList<FiCaSchedulerApp>(this.managedParentQueue.getAllApplications());
        apps.sort(this.managedParentQueue.getQueueContext().getApplicationComparator());
        return apps;
    }

    private AutoCreatedLeafQueueConfig buildTemplate(QueueCapacities capacities) {
        AutoCreatedLeafQueueConfig.Builder templateBuilder = new AutoCreatedLeafQueueConfig.Builder();
        templateBuilder.capacities(capacities);
        templateBuilder.resourceQuotas(this.managedParentQueue.getLeafQueueTemplate().getResourceQuotas());
        return new AutoCreatedLeafQueueConfig(templateBuilder);
    }

    private class ParentQueueState {
        private Map<String, Float> totalAbsoluteActivatedChildQueueCapacityByLabel = new HashMap<String, Float>();

        private ParentQueueState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private float getAbsoluteActivatedChildQueueCapacity(String nodeLabel) {
            GuaranteedOrZeroCapacityOverTimePolicy.this.readLock.lock();
            try {
                Float totalActivatedCapacity = this.getAbsActivatedChildQueueCapacityByLabel(nodeLabel);
                if (totalActivatedCapacity != null) {
                    float f = totalActivatedCapacity.floatValue();
                    return f;
                }
                float f = 0.0f;
                return f;
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incAbsoluteActivatedChildCapacity(String nodeLabel, float childQueueCapacity) {
            GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.lock();
            try {
                Float activatedChildCapacity = this.getAbsActivatedChildQueueCapacityByLabel(nodeLabel);
                if (activatedChildCapacity != null) {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, activatedChildCapacity.floatValue() + childQueueCapacity);
                } else {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, childQueueCapacity);
                }
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decAbsoluteActivatedChildCapacity(String nodeLabel, float childQueueCapacity) {
            GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.lock();
            try {
                Float activatedChildCapacity = this.getAbsActivatedChildQueueCapacityByLabel(nodeLabel);
                if (activatedChildCapacity != null) {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, activatedChildCapacity.floatValue() - childQueueCapacity);
                } else {
                    this.setAbsActivatedChildQueueCapacityByLabel(nodeLabel, childQueueCapacity);
                }
            }
            finally {
                GuaranteedOrZeroCapacityOverTimePolicy.this.writeLock.unlock();
            }
        }

        Float getAbsActivatedChildQueueCapacityByLabel(String label) {
            return this.totalAbsoluteActivatedChildQueueCapacityByLabel.get(label);
        }

        Float setAbsActivatedChildQueueCapacityByLabel(String label, float val) {
            return this.totalAbsoluteActivatedChildQueueCapacityByLabel.put(label, Float.valueOf(val));
        }

        void clear() {
            this.totalAbsoluteActivatedChildQueueCapacityByLabel.clear();
        }
    }

    private class LeafQueueState {
        private Map<String, Map<String, LeafQueueStatePerPartition>> leafQueueStateMap = new HashMap<String, Map<String, LeafQueueStatePerPartition>>();

        private LeafQueueState() {
        }

        public boolean containsLeafQueue(String leafQueueName, String partition) {
            if (this.leafQueueStateMap.containsKey(partition)) {
                return this.leafQueueStateMap.get(partition).containsKey(leafQueueName);
            }
            return false;
        }

        private boolean containsPartition(String partition) {
            return this.leafQueueStateMap.containsKey(partition);
        }

        private boolean addLeafQueueStateIfNotExists(String leafQueuePath, String partition, LeafQueueStatePerPartition leafQueueState) {
            if (!this.containsPartition(partition)) {
                this.leafQueueStateMap.put(partition, new HashMap());
            }
            if (!this.containsLeafQueue(leafQueuePath, partition)) {
                this.leafQueueStateMap.get(partition).put(leafQueuePath, leafQueueState);
                return true;
            }
            return false;
        }

        public boolean createLeafQueueStateIfNotExists(AbstractLeafQueue leafQueue, String partition) {
            return this.addLeafQueueStateIfNotExists(leafQueue.getQueuePath(), partition, new LeafQueueStatePerPartition());
        }

        public LeafQueueStatePerPartition getLeafQueueStatePerPartition(String leafQueuePath, String partition) {
            if (this.leafQueueStateMap.get(partition) != null) {
                return this.leafQueueStateMap.get(partition).get(leafQueuePath);
            }
            return null;
        }

        public Map<String, Map<String, LeafQueueStatePerPartition>> getLeafQueueStateMap() {
            return this.leafQueueStateMap;
        }

        private void clear() {
            this.leafQueueStateMap.clear();
        }
    }

    private class LeafQueueStatePerPartition {
        private AtomicBoolean isActive = new AtomicBoolean(false);
        private long mostRecentActivationTime;
        private long mostRecentDeactivationTime;

        private LeafQueueStatePerPartition() {
        }

        public long getMostRecentActivationTime() {
            return this.mostRecentActivationTime;
        }

        public long getMostRecentDeactivationTime() {
            return this.mostRecentDeactivationTime;
        }

        public boolean isActive() {
            return this.isActive.get();
        }

        private boolean activate() {
            boolean ret = this.isActive.compareAndSet(false, true);
            this.mostRecentActivationTime = GuaranteedOrZeroCapacityOverTimePolicy.this.clock.getTime();
            return ret;
        }

        private boolean deactivate() {
            boolean ret = this.isActive.compareAndSet(true, false);
            this.mostRecentDeactivationTime = GuaranteedOrZeroCapacityOverTimePolicy.this.clock.getTime();
            return ret;
        }
    }
}

