/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ParentQueue
extends AbstractParentQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ParentQueue.class);

    public ParentQueue(CapacitySchedulerQueueContext queueContext, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this(queueContext, queueName, parent, old, false);
    }

    public ParentQueue(CapacitySchedulerQueueContext queueContext, String queueName, CSQueue parent, CSQueue old, boolean isDynamic) throws IOException {
        super(queueContext, queueName, parent, old, isDynamic);
        super.setupQueueConfigs(queueContext.getClusterResource());
    }

    public ParentQueue addDynamicParentQueue(String queuePath) throws SchedulerDynamicEditException {
        return (ParentQueue)this.addDynamicChildQueue(queuePath, false);
    }

    public LeafQueue addDynamicLeafQueue(String queuePath) throws SchedulerDynamicEditException {
        return (LeafQueue)this.addDynamicChildQueue(queuePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CSQueue addDynamicChildQueue(String childQueuePath, boolean isLeaf) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            CSQueue queue = this.queueContext.getQueueManager().getQueueByFullName(childQueuePath);
            if (queue != null) {
                LOG.warn("This should not happen, trying to create queue=" + childQueuePath + ", however the queue already exists");
                CSQueue cSQueue = queue;
                return cSQueue;
            }
            int maxQueues = this.queueContext.getConfiguration().getAutoCreatedQueuesV2MaxChildQueuesLimit(this.getQueuePathObject());
            if (this.childQueues.size() >= maxQueues) {
                throw new SchedulerDynamicEditException("Cannot auto create queue " + childQueuePath + ". Max Child Queue limit exceeded which is configured as: " + maxQueues + " and number of child queues is: " + this.childQueues.size());
            }
            boolean weightsAreUsed = false;
            try {
                weightsAreUsed = this.getCapacityConfigurationTypeForQueues(this.childQueues) == AbstractParentQueue.QueueCapacityType.WEIGHT;
            }
            catch (IOException e) {
                LOG.warn("Caught Exception during auto queue creation", (Throwable)e);
            }
            if (!weightsAreUsed && this.queueContext.getConfiguration().isLegacyQueueMode()) {
                throw new SchedulerDynamicEditException("Trying to create new queue=" + childQueuePath + " but not all the queues under parent=" + this.getQueuePath() + " are using weight-based capacity. Failed to created queue");
            }
            CSQueue newQueue = this.createNewQueue(childQueuePath, isLeaf);
            this.childQueues.add(newQueue);
            this.updateLastSubmittedTimeStamp();
            this.updateClusterResource(this.queueContext.getClusterResource(), new ResourceLimits(this.queueContext.getClusterResource()));
            CSQueue cSQueue = newQueue;
            return cSQueue;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

