/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.AssignmentInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CSAssignment {
    public static final CSAssignment NULL_ASSIGNMENT = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
    public static final CSAssignment SKIP_ASSIGNMENT = new CSAssignment(SkippedType.OTHER);
    private Resource resource;
    private NodeType type;
    private NodeType requestLocalityType;
    private RMContainer excessReservation;
    private FiCaSchedulerApp application;
    private SkippedType skipped;
    private boolean fulfilledReservation;
    private final AssignmentInformation assignmentInformation;
    private boolean increaseAllocation;
    private List<RMContainer> containersToKill;
    private RMContainer fulfilledReservedContainer;
    private SchedulingMode schedulingMode;

    public CSAssignment(Resource resource, NodeType type) {
        this(resource, type, null, null, SkippedType.NONE, false);
    }

    public CSAssignment(FiCaSchedulerApp application, RMContainer excessReservation) {
        this(excessReservation.getContainer().getResource(), NodeType.NODE_LOCAL, excessReservation, application, SkippedType.NONE, false);
    }

    public CSAssignment(SkippedType skipped) {
        this(Resource.newInstance((int)0, (int)0), NodeType.NODE_LOCAL, null, null, skipped, false);
    }

    public CSAssignment(Resource resource, NodeType type, RMContainer excessReservation, FiCaSchedulerApp application, SkippedType skipped, boolean fulfilledReservation) {
        this.resource = resource;
        this.type = type;
        this.excessReservation = excessReservation;
        this.application = application;
        this.skipped = skipped;
        this.fulfilledReservation = fulfilledReservation;
        this.assignmentInformation = new AssignmentInformation();
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public FiCaSchedulerApp getApplication() {
        return this.application;
    }

    public void setApplication(FiCaSchedulerApp application) {
        this.application = application;
    }

    public RMContainer getExcessReservation() {
        return this.excessReservation;
    }

    public void setExcessReservation(RMContainer rmContainer) {
        this.excessReservation = rmContainer;
    }

    public SkippedType getSkippedType() {
        return this.skipped;
    }

    public void setSkippedType(SkippedType skippedType) {
        this.skipped = skippedType;
    }

    public String toString() {
        String ret = "resource:" + this.resource.toString();
        ret = ret + "; type:" + this.type;
        ret = ret + "; excessReservation:" + this.excessReservation;
        ret = ret + "; applicationid:" + (this.application != null ? this.application.getApplicationId().toString() : "null");
        ret = ret + "; skipped:" + this.skipped;
        ret = ret + "; fulfilled reservation:" + this.fulfilledReservation;
        ret = ret + "; allocations(count/resource):" + this.assignmentInformation.getNumAllocations() + "/" + this.assignmentInformation.getAllocated().toString();
        ret = ret + "; reservations(count/resource):" + this.assignmentInformation.getNumReservations() + "/" + this.assignmentInformation.getReserved().toString();
        return ret;
    }

    public void setFulfilledReservation(boolean fulfilledReservation) {
        this.fulfilledReservation = fulfilledReservation;
    }

    public boolean isFulfilledReservation() {
        return this.fulfilledReservation;
    }

    public AssignmentInformation getAssignmentInformation() {
        return this.assignmentInformation;
    }

    public boolean isIncreasedAllocation() {
        return this.increaseAllocation;
    }

    public void setIncreasedAllocation(boolean flag) {
        this.increaseAllocation = flag;
    }

    public void setContainersToKill(List<RMContainer> containersToKill) {
        this.containersToKill = containersToKill;
    }

    public List<RMContainer> getContainersToKill() {
        return this.containersToKill;
    }

    public RMContainer getFulfilledReservedContainer() {
        return this.fulfilledReservedContainer;
    }

    public void setFulfilledReservedContainer(RMContainer fulfilledReservedContainer) {
        this.fulfilledReservedContainer = fulfilledReservedContainer;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    public NodeType getRequestLocalityType() {
        return this.requestLocalityType;
    }

    public void setRequestLocalityType(NodeType requestLocalityType) {
        this.requestLocalityType = requestLocalityType;
    }

    public static enum SkippedType {
        NONE,
        QUEUE_LIMIT,
        OTHER;

    }
}

