/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;

public class AutoCreatedLeafQueueConfig {
    private QueueCapacities queueCapacities;
    private CapacitySchedulerConfiguration leafQueueConfigs;
    private final QueueResourceQuotas resourceQuotas;

    public AutoCreatedLeafQueueConfig(Builder builder) {
        this.queueCapacities = builder.queueCapacities;
        this.leafQueueConfigs = builder.leafQueueConfigs;
        this.resourceQuotas = builder.queueResourceQuotas;
    }

    public QueueCapacities getQueueCapacities() {
        return this.queueCapacities;
    }

    public CapacitySchedulerConfiguration getLeafQueueConfigs() {
        return this.leafQueueConfigs;
    }

    public QueueResourceQuotas getResourceQuotas() {
        return this.resourceQuotas;
    }

    public String toString() {
        return "AutoCreatedLeafQueueConfig{queueCapacities=" + this.queueCapacities + ", leafQueueConfigs=" + this.leafQueueConfigs + "}";
    }

    public static class Builder {
        private QueueCapacities queueCapacities;
        private CapacitySchedulerConfiguration leafQueueConfigs;
        private QueueResourceQuotas queueResourceQuotas;

        public Builder capacities(QueueCapacities capacities) {
            this.queueCapacities = capacities;
            return this;
        }

        public Builder configuration(CapacitySchedulerConfiguration conf) {
            this.leafQueueConfigs = conf;
            return this;
        }

        public AutoCreatedLeafQueueConfig build() {
            return new AutoCreatedLeafQueueConfig(this);
        }

        public Builder resourceQuotas(QueueResourceQuotas queueResourceQuotas) {
            this.queueResourceQuotas = queueResourceQuotas;
            return this;
        }
    }
}

