/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationAttemptEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.ContainerEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.AbstractSystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineServiceV2Publisher
extends AbstractSystemMetricsPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineServiceV2Publisher.class);
    private RMTimelineCollectorManager rmTimelineCollectorManager;
    private boolean publishContainerEvents;

    public TimelineServiceV2Publisher(RMTimelineCollectorManager timelineCollectorManager) {
        super("TimelineserviceV2Publisher");
        this.rmTimelineCollectorManager = timelineCollectorManager;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.getDispatcher().register(AbstractSystemMetricsPublisher.SystemMetricsEventType.class, (EventHandler)new TimelineV2EventHandler());
        this.publishContainerEvents = this.getConfig().getBoolean("yarn.rm.system-metrics-publisher.emit-container-events", false);
    }

    @VisibleForTesting
    boolean isPublishContainerEvents() {
        return this.publishContainerEvents;
    }

    @Override
    public void appCreated(RMApp app, long createdTime) {
        ApplicationEntity entity = TimelineServiceV2Publisher.createApplicationEntity(app.getApplicationId());
        entity.setQueue(app.getQueue());
        entity.setCreatedTime(Long.valueOf(createdTime));
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_APPLICATION_NAME", app.getName());
        entityInfo.put("YARN_APPLICATION_TYPE", app.getApplicationType());
        entityInfo.put("YARN_APPLICATION_USER", app.getUser());
        entityInfo.put("YARN_APPLICATION_QUEUE", app.getQueue());
        entityInfo.put("YARN_APPLICATION_SUBMITTED_TIME", app.getSubmitTime());
        entityInfo.put("YARN_APPLICATION_TAGS", app.getApplicationTags());
        entityInfo.put("YARN_APPLICATION_UNMANAGED_APPLICATION", app.getApplicationSubmissionContext().getUnmanagedAM());
        entityInfo.put("YARN_APPLICATION_PRIORITY", app.getApplicationPriority().getPriority());
        entity.getConfigs().put("YARN_AM_NODE_LABEL_EXPRESSION", app.getAmNodeLabelExpression());
        entity.getConfigs().put("YARN_APP_NODE_LABEL_EXPRESSION", app.getAppNodeLabelExpression());
        if (app.getCallerContext() != null) {
            if (app.getCallerContext().isContextValid()) {
                entityInfo.put("YARN_APPLICATION_CALLER_CONTEXT", app.getCallerContext().getContext());
            }
            if (app.getCallerContext().getSignature() != null) {
                entityInfo.put("YARN_APPLICATION_CALLER_SIGNATURE", app.getCallerContext().getSignature());
            }
        }
        ContainerLaunchContext amContainerSpec = app.getApplicationSubmissionContext().getAMContainerSpec();
        entityInfo.put("YARN_AM_CONTAINER_LAUNCH_COMMAND", amContainerSpec.getCommands());
        entityInfo.put("YARN_APPLICATION_STATE", RMServerUtils.createApplicationState(app.getState()).toString());
        entity.setInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_APPLICATION_CREATED");
        tEvent.setTimestamp(createdTime);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, app.getApplicationId()));
    }

    @Override
    public void appLaunched(RMApp app, long launchTime) {
        ApplicationEntity entity = TimelineServiceV2Publisher.createApplicationEntity(app.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_APPLICATION_LAUNCHED");
        tEvent.setTimestamp(launchTime);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, app.getApplicationId()));
    }

    @Override
    public void appFinished(RMApp app, RMAppState state, long finishedTime) {
        ApplicationAttemptId appAttemptId;
        ApplicationEntity entity = TimelineServiceV2Publisher.createApplicationEntity(app.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_APPLICATION_FINISHED");
        tEvent.setTimestamp(finishedTime);
        entity.addEvent(tEvent);
        HashMap<String, String> entityInfo = new HashMap<String, String>();
        entityInfo.put("YARN_APPLICATION_DIAGNOSTICS_INFO", app.getDiagnostics().toString());
        entityInfo.put("YARN_APPLICATION_FINAL_STATUS", app.getFinalApplicationStatus().toString());
        entityInfo.put("YARN_APPLICATION_STATE", RMServerUtils.createApplicationState(state).toString());
        ApplicationAttemptId applicationAttemptId = appAttemptId = app.getCurrentAppAttempt() == null ? null : app.getCurrentAppAttempt().getAppAttemptId();
        if (appAttemptId != null) {
            entityInfo.put("YARN_APPLICATION_LATEST_APP_ATTEMPT", appAttemptId.toString());
        }
        entity.setInfo(entityInfo);
        RMAppMetrics appMetrics = app.getRMAppMetrics();
        Set<TimelineMetric> entityMetrics = this.getTimelinelineAppMetrics(appMetrics, finishedTime);
        entity.setMetrics(entityMetrics);
        this.getDispatcher().getEventHandler().handle((Event)new ApplicationFinishPublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_APPLICATION_FINISHED_ENTITY, (TimelineEntity)entity, app));
    }

    private Set<TimelineMetric> getTimelinelineAppMetrics(RMAppMetrics appMetrics, long timestamp) {
        HashSet<TimelineMetric> entityMetrics = new HashSet<TimelineMetric>();
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_CPU", timestamp, appMetrics.getVcoreSeconds()));
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_MEMORY", timestamp, appMetrics.getMemorySeconds()));
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_MEM_PREEMPT_METRIC", timestamp, appMetrics.getPreemptedMemorySeconds()));
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_CPU_PREEMPT_METRIC", timestamp, appMetrics.getPreemptedVcoreSeconds()));
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_RESOURCE_PREEMPTED_CPU", timestamp, appMetrics.getResourcePreempted().getVirtualCores()));
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_RESOURCE_PREEMPTED_MEMORY", timestamp, appMetrics.getResourcePreempted().getMemorySize()));
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_NON_AM_CONTAINER_PREEMPTED", timestamp, appMetrics.getNumNonAMContainersPreempted()));
        entityMetrics.add(this.getTimelineMetric("YARN_APPLICATION_AM_CONTAINER_PREEMPTED", timestamp, appMetrics.getNumAMContainersPreempted()));
        return entityMetrics;
    }

    private TimelineMetric getTimelineMetric(String name, long timestamp, Number value) {
        TimelineMetric metric = new TimelineMetric();
        metric.setId(name);
        metric.addValue(timestamp, value);
        return metric;
    }

    @Override
    public void appStateUpdated(RMApp app, YarnApplicationState appState, long updatedTime) {
        ApplicationEntity entity = TimelineServiceV2Publisher.createApplicationEntity(app.getApplicationId());
        HashMap<String, YarnApplicationState> eventInfo = new HashMap<String, YarnApplicationState>();
        eventInfo.put("YARN_APPLICATION_STATE", appState);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_APPLICATION_STATE_UPDATED");
        tEvent.setTimestamp(updatedTime);
        tEvent.setInfo(eventInfo);
        entity.addEvent(tEvent);
        HashMap<String, YarnApplicationState> entityInfo = new HashMap<String, YarnApplicationState>();
        entityInfo.put("YARN_APPLICATION_STATE", appState);
        entity.setInfo(entityInfo);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, app.getApplicationId()));
    }

    @Override
    public void appACLsUpdated(RMApp app, String appViewACLs, long updatedTime) {
        ApplicationEntity entity = TimelineServiceV2Publisher.createApplicationEntity(app.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        HashMap<String, String> entityInfo = new HashMap<String, String>();
        entityInfo.put("YARN_APPLICATION_VIEW_ACLS", appViewACLs == null ? "" : appViewACLs);
        entity.setInfo(entityInfo);
        tEvent.setId("YARN_APPLICATION_ACLS_UPDATED");
        tEvent.setTimestamp(updatedTime);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, app.getApplicationId()));
    }

    @Override
    public void appUpdated(RMApp app, long currentTimeMillis) {
        ApplicationEntity entity = TimelineServiceV2Publisher.createApplicationEntity(app.getApplicationId());
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_APPLICATION_QUEUE", app.getQueue());
        eventInfo.put("YARN_APPLICATION_PRIORITY", app.getApplicationPriority().getPriority());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_APPLICATION_UPDATED");
        tEvent.setTimestamp(currentTimeMillis);
        tEvent.setInfo(eventInfo);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, app.getApplicationId()));
    }

    private static ApplicationEntity createApplicationEntity(ApplicationId applicationId) {
        ApplicationEntity entity = new ApplicationEntity();
        entity.setId(applicationId.toString());
        return entity;
    }

    @Override
    public void appAttemptRegistered(RMAppAttempt appAttempt, long registeredTime) {
        ApplicationAttemptId attemptId = appAttempt.getAppAttemptId();
        ApplicationAttemptEntity entity = TimelineServiceV2Publisher.createAppAttemptEntity(attemptId);
        entity.setCreatedTime(Long.valueOf(registeredTime));
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_APPLICATION_ATTEMPT_REGISTERED");
        tEvent.setTimestamp(registeredTime);
        entity.addEvent(tEvent);
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_APPLICATION_ATTEMPT_TRACKING_URL", appAttempt.getTrackingUrl());
        entityInfo.put("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL", appAttempt.getOriginalTrackingUrl());
        entityInfo.put("YARN_APPLICATION_ATTEMPT_HOST", appAttempt.getHost());
        entityInfo.put("YARN_APPLICATION_ATTEMPT_RPC_PORT", appAttempt.getRpcPort());
        if (appAttempt.getMasterContainer() != null) {
            entityInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER", appAttempt.getMasterContainer().getId().toString());
            entityInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_NODE_ADDRESS", appAttempt.getMasterContainer().getNodeHttpAddress());
            entityInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_NODE_ID", appAttempt.getMasterContainer().getNodeId().toString());
        }
        entity.setInfo(entityInfo);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)attemptId.getAttemptId()));
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, appAttempt.getAppAttemptId().getApplicationId()));
    }

    @Override
    public void appAttemptFinished(RMAppAttempt appAttempt, RMAppAttemptState appAttemtpState, RMApp app, long finishedTime) {
        ApplicationAttemptId attemptId = appAttempt.getAppAttemptId();
        ApplicationAttemptEntity entity = TimelineServiceV2Publisher.createAppAttemptEntity(appAttempt.getAppAttemptId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId("YARN_APPLICATION_ATTEMPT_FINISHED");
        tEvent.setTimestamp(finishedTime);
        entity.addEvent(tEvent);
        HashMap<String, String> entityInfo = new HashMap<String, String>();
        entityInfo.put("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO", appAttempt.getDiagnostics());
        entityInfo.put("YARN_APPLICATION_ATTEMPT_FINAL_STATUS", app.getFinalApplicationStatus().toString());
        entityInfo.put("YARN_APPLICATION_ATTEMPT_STATE", RMServerUtils.createApplicationAttemptState(appAttemtpState).toString());
        entity.setInfo(entityInfo);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)attemptId.getAttemptId()));
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, appAttempt.getAppAttemptId().getApplicationId()));
    }

    private static ApplicationAttemptEntity createAppAttemptEntity(ApplicationAttemptId appAttemptId) {
        ApplicationAttemptEntity entity = new ApplicationAttemptEntity();
        entity.setId(appAttemptId.toString());
        entity.setParent(new TimelineEntity.Identifier(TimelineEntityType.YARN_APPLICATION.name(), appAttemptId.getApplicationId().toString()));
        return entity;
    }

    @Override
    public void containerCreated(RMContainer container, long createdTime) {
        if (this.publishContainerEvents) {
            ContainerEntity entity = TimelineServiceV2Publisher.createContainerEntity(container.getContainerId());
            entity.setCreatedTime(Long.valueOf(createdTime));
            TimelineEvent tEvent = new TimelineEvent();
            tEvent.setId("YARN_RM_CONTAINER_CREATED");
            tEvent.setTimestamp(createdTime);
            entity.addEvent(tEvent);
            HashMap<String, Object> entityInfo = new HashMap<String, Object>();
            entityInfo.put("YARN_CONTAINER_ALLOCATED_MEMORY", container.getAllocatedResource().getMemorySize());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_VCORE", container.getAllocatedResource().getVirtualCores());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", container.getAllocatedNode().getHost());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", container.getAllocatedNode().getPort());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_PRIORITY", container.getAllocatedPriority().getPriority());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_EXPOSED_PORTS", container.getExposedPorts());
            entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS", container.getNodeHttpAddress());
            entity.setInfo(entityInfo);
            this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, container.getContainerId().getApplicationAttemptId().getApplicationId()));
        }
    }

    @Override
    public void containerFinished(RMContainer container, long finishedTime) {
        if (this.publishContainerEvents) {
            ContainerEntity entity = TimelineServiceV2Publisher.createContainerEntity(container.getContainerId());
            TimelineEvent tEvent = new TimelineEvent();
            tEvent.setId("YARN_RM_CONTAINER_FINISHED");
            tEvent.setTimestamp(finishedTime);
            entity.addEvent(tEvent);
            HashMap<String, Object> entityInfo = new HashMap<String, Object>();
            entityInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", container.getDiagnosticsInfo());
            entityInfo.put("YARN_CONTAINER_EXIT_STATUS", container.getContainerExitStatus());
            entityInfo.put("YARN_CONTAINER_STATE", container.getContainerState().toString());
            entityInfo.put("YARN_CONTAINER_FINISHED_TIME", finishedTime);
            entity.setInfo(entityInfo);
            this.getDispatcher().getEventHandler().handle((Event)new TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, (TimelineEntity)entity, container.getContainerId().getApplicationAttemptId().getApplicationId()));
        }
    }

    private static ContainerEntity createContainerEntity(ContainerId containerId) {
        ContainerEntity entity = new ContainerEntity();
        entity.setId(containerId.toString());
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)containerId.getContainerId()));
        entity.setParent(new TimelineEntity.Identifier(TimelineEntityType.YARN_APPLICATION_ATTEMPT.name(), containerId.getApplicationAttemptId().toString()));
        return entity;
    }

    private void putEntity(TimelineEntity entity, ApplicationId appId) {
        try {
            TimelineCollector timelineCollector;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Publishing the entity " + entity + ", JSON-style content: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            }
            if ((timelineCollector = this.rmTimelineCollectorManager.get(appId)) != null) {
                TimelineEntities entities = new TimelineEntities();
                entities.addEntity(entity);
                timelineCollector.putEntities(entities, UserGroupInformation.getCurrentUser());
            } else {
                LOG.debug("Cannot find active collector while publishing entity " + entity);
            }
        }
        catch (IOException e) {
            LOG.error("Error when publishing entity " + entity);
            LOG.debug("Error when publishing entity {}", (Object)entity, (Object)e);
        }
        catch (Exception e) {
            LOG.error("Unexpected error when publishing entity {}", (Object)entity, (Object)e);
        }
    }

    private class TimelineV2EventHandler
    implements EventHandler<TimelineV2PublishEvent> {
        private TimelineV2EventHandler() {
        }

        public void handle(TimelineV2PublishEvent event) {
            switch ((AbstractSystemMetricsPublisher.SystemMetricsEventType)event.getType()) {
                case PUBLISH_APPLICATION_FINISHED_ENTITY: {
                    TimelineServiceV2Publisher.this.putEntity(event.getEntity(), event.getApplicationId());
                    ((ApplicationFinishPublishEvent)event).getRMAppImpl().stopTimelineCollector();
                    break;
                }
                default: {
                    TimelineServiceV2Publisher.this.putEntity(event.getEntity(), event.getApplicationId());
                }
            }
        }
    }

    private class TimelineV2PublishEvent
    extends AbstractSystemMetricsPublisher.TimelinePublishEvent {
        private TimelineEntity entity;

        public TimelineV2PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType type, TimelineEntity entity, ApplicationId appId) {
            super(type, appId);
            this.entity = entity;
        }

        public TimelineEntity getEntity() {
            return this.entity;
        }
    }

    private class ApplicationFinishPublishEvent
    extends TimelineV2PublishEvent {
        private RMApp app;

        public ApplicationFinishPublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType type, TimelineEntity entity, RMApp app) {
            super(type, entity, app.getApplicationId());
            this.app = app;
        }

        public RMAppImpl getRMAppImpl() {
            return (RMAppImpl)this.app;
        }
    }
}

