/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.glassfish.jersey.jettison.JettisonJaxbContext;
import org.glassfish.jersey.jettison.JettisonMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationStateStoreHeartbeat
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreHeartbeat.class);
    private final SubClusterId subClusterId;
    private final FederationStateStore stateStoreService;
    private final ResourceScheduler rs;
    private String capability;

    public FederationStateStoreHeartbeat(SubClusterId subClusterId, FederationStateStore stateStoreClient, ResourceScheduler scheduler) {
        this.stateStoreService = stateStoreClient;
        this.subClusterId = subClusterId;
        this.rs = scheduler;
        LOG.info("Initialized Federation membership for cluster with timestamp: {}. ", (Object)ResourceManager.getClusterTimeStamp());
    }

    private void updateClusterState() {
        try {
            ClusterMetricsInfo clusterMetricsInfo = new ClusterMetricsInfo(this.rs);
            JettisonJaxbContext jettisonJaxbContext = new JettisonJaxbContext(new Class[]{ClusterMetricsInfo.class});
            JettisonMarshaller jsonMarshaller = jettisonJaxbContext.createJsonMarshaller();
            StringWriter stringWriter = new StringWriter();
            jsonMarshaller.marshallToJSON((Object)clusterMetricsInfo, (Writer)stringWriter);
            this.capability = stringWriter.toString();
        }
        catch (Exception e) {
            LOG.warn("Exception while trying to generate cluster state, so reverting to last know state.", (Throwable)e);
        }
    }

    @Override
    public synchronized void run() {
        try {
            this.updateClusterState();
            SubClusterHeartbeatRequest request = SubClusterHeartbeatRequest.newInstance((SubClusterId)this.subClusterId, (SubClusterState)SubClusterState.SC_RUNNING, (String)this.capability);
            this.stateStoreService.subClusterHeartbeat(request);
            LOG.debug("Sending the heartbeat with capability: {}", (Object)this.capability);
        }
        catch (Exception e) {
            LOG.warn("Exception when trying to heartbeat.", (Throwable)e);
        }
    }
}

