/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMServerUtils {
    private static final Logger LOG_HANDLE = LoggerFactory.getLogger(RMServerUtils.class);
    public static final String UPDATE_OUTSTANDING_ERROR = "UPDATE_OUTSTANDING_ERROR";
    private static final String INCORRECT_CONTAINER_VERSION_ERROR = "INCORRECT_CONTAINER_VERSION_ERROR";
    private static final String INVALID_CONTAINER_ID = "INVALID_CONTAINER_ID";
    public static final String RESOURCE_OUTSIDE_ALLOWED_RANGE = "RESOURCE_OUTSIDE_ALLOWED_RANGE";
    protected static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    private static Clock clock = SystemClock.getInstance();
    public static final ApplicationResourceUsageReport DUMMY_APPLICATION_RESOURCE_USAGE_REPORT = BuilderUtils.newApplicationResourceUsageReport((int)-1, (int)-1, (Resource)Resources.createResource((int)-1, (int)-1), (Resource)Resources.createResource((int)-1, (int)-1), (Resource)Resources.createResource((int)-1, (int)-1), new HashMap(), new HashMap());

    public static List<RMNode> queryRMNodes(RMContext context, EnumSet<NodeState> acceptedStates) {
        ArrayList<RMNode> results = new ArrayList<RMNode>();
        boolean hasActive = false;
        boolean hasInactive = false;
        for (NodeState nodeState : acceptedStates) {
            if (!hasInactive && nodeState.isInactiveState()) {
                hasInactive = true;
            }
            if (!hasActive && nodeState.isActiveState()) {
                hasActive = true;
            }
            if (!hasActive || !hasInactive) continue;
            break;
        }
        if (hasActive) {
            for (RMNode rmNode : context.getRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        if (hasInactive) {
            for (RMNode rmNode : context.getInactiveRMNodes().values()) {
                if (rmNode == null || !acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        return results;
    }

    public static ContainerUpdates validateAndSplitUpdateResourceRequests(RMContext rmContext, AllocateRequest request, Resource maximumAllocation, List<UpdateContainerError> updateErrors) {
        ContainerUpdates updateRequests = new ContainerUpdates();
        HashSet<ContainerId> outstandingUpdate = new HashSet<ContainerId>();
        for (UpdateContainerRequest updateReq : request.getUpdateRequests()) {
            RMContainer rmContainer = rmContext.getScheduler().getRMContainer(updateReq.getContainerId());
            String msg = RMServerUtils.validateContainerIdAndVersion(outstandingUpdate, updateReq, rmContainer);
            ContainerUpdateType updateType = updateReq.getContainerUpdateType();
            if (msg == null) {
                if (updateType != ContainerUpdateType.PROMOTE_EXECUTION_TYPE && updateType != ContainerUpdateType.DEMOTE_EXECUTION_TYPE) {
                    if (RMServerUtils.validateIncreaseDecreaseRequest(rmContext, updateReq, maximumAllocation)) {
                        if (ContainerUpdateType.INCREASE_RESOURCE == updateType) {
                            updateRequests.getIncreaseRequests().add(updateReq);
                        } else {
                            updateRequests.getDecreaseRequests().add(updateReq);
                        }
                        outstandingUpdate.add(updateReq.getContainerId());
                    } else {
                        msg = RESOURCE_OUTSIDE_ALLOWED_RANGE;
                    }
                } else {
                    ExecutionType original = rmContainer.getExecutionType();
                    ExecutionType target = updateReq.getExecutionType();
                    if (target != original) {
                        if (target == ExecutionType.GUARANTEED && original == ExecutionType.OPPORTUNISTIC) {
                            updateRequests.getPromotionRequests().add(updateReq);
                            outstandingUpdate.add(updateReq.getContainerId());
                        } else if (target == ExecutionType.OPPORTUNISTIC && original == ExecutionType.GUARANTEED) {
                            updateRequests.getDemotionRequests().add(updateReq);
                            outstandingUpdate.add(updateReq.getContainerId());
                        }
                    }
                }
            }
            RMServerUtils.checkAndcreateUpdateError(updateErrors, updateReq, rmContainer, msg);
        }
        return updateRequests;
    }

    private static void checkAndcreateUpdateError(List<UpdateContainerError> errors, UpdateContainerRequest updateReq, RMContainer rmContainer, String msg) {
        if (msg != null) {
            UpdateContainerError updateError = (UpdateContainerError)RECORD_FACTORY.newRecordInstance(UpdateContainerError.class);
            updateError.setReason(msg);
            updateError.setUpdateContainerRequest(updateReq);
            if (rmContainer != null) {
                updateError.setCurrentContainerVersion(rmContainer.getContainer().getVersion());
            } else {
                updateError.setCurrentContainerVersion(-1);
            }
            errors.add(updateError);
        }
    }

    private static String validateContainerIdAndVersion(Set<ContainerId> outstandingUpdate, UpdateContainerRequest updateReq, RMContainer rmContainer) {
        String msg = null;
        if (rmContainer == null) {
            msg = INVALID_CONTAINER_ID;
        }
        if (msg == null && updateReq.getContainerVersion() != rmContainer.getContainer().getVersion()) {
            msg = INCORRECT_CONTAINER_VERSION_ERROR;
        }
        if (msg == null && outstandingUpdate.contains(updateReq.getContainerId())) {
            msg = UPDATE_OUTSTANDING_ERROR;
        }
        return msg;
    }

    public static void normalizeAndValidateRequests(List<ResourceRequest> ask, Resource maximumAllocation, String queueName, YarnScheduler scheduler, RMContext rmContext, boolean nodeLabelsEnabled) throws InvalidResourceRequestException {
        QueueInfo queueInfo = null;
        try {
            queueInfo = scheduler.getQueueInfo(queueName, false, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (ResourceRequest resReq : ask) {
            SchedulerUtils.normalizeAndValidateRequest(resReq, maximumAllocation, queueName, rmContext, queueInfo, nodeLabelsEnabled);
        }
    }

    public static void checkSchedContainerChangeRequest(SchedContainerChangeRequest request, boolean increase) throws InvalidResourceRequestException {
        RMContext rmContext = request.getRmContext();
        ContainerId containerId = request.getContainerId();
        RMContainer rmContainer = request.getRMContainer();
        Resource targetResource = request.getTargetCapacity();
        Resource originalResource = rmContainer.getAllocatedResource();
        if (increase) {
            if (originalResource.getMemorySize() > targetResource.getMemorySize() || originalResource.getVirtualCores() > targetResource.getVirtualCores()) {
                String msg = "Trying to increase a container, but target resource has some resource < original resource, target=" + targetResource + " original=" + originalResource + " containerId=" + containerId;
                throw new InvalidResourceRequestException(msg);
            }
        } else if (originalResource.getMemorySize() < targetResource.getMemorySize() || originalResource.getVirtualCores() < targetResource.getVirtualCores()) {
            String msg = "Trying to decrease a container, but target resource has some resource > original resource, target=" + targetResource + " original=" + originalResource + " containerId=" + containerId;
            throw new InvalidResourceRequestException(msg);
        }
        ResourceScheduler scheduler = rmContext.getScheduler();
        RMNode rmNode = request.getSchedulerNode().getRMNode();
        if (!Resources.fitsIn((ResourceCalculator)scheduler.getResourceCalculator(), (Resource)targetResource, (Resource)rmNode.getTotalCapability())) {
            String msg = "Target resource=" + targetResource + " of containerId=" + containerId + " is more than node's total resource=" + rmNode.getTotalCapability();
            throw new InvalidResourceRequestException(msg);
        }
    }

    public static void validateBlacklistRequest(ResourceBlacklistRequest blacklistRequest) throws InvalidResourceBlacklistRequestException {
        List plus;
        if (blacklistRequest != null && (plus = blacklistRequest.getBlacklistAdditions()) != null && plus.contains("*")) {
            throw new InvalidResourceBlacklistRequestException("Cannot add * to the blacklist!");
        }
    }

    private static boolean validateIncreaseDecreaseRequest(RMContext rmContext, UpdateContainerRequest request, Resource maximumAllocation) {
        if (request.getCapability().getMemorySize() < 0L || request.getCapability().getMemorySize() > maximumAllocation.getMemorySize()) {
            return false;
        }
        if (request.getCapability().getVirtualCores() < 0 || request.getCapability().getVirtualCores() > maximumAllocation.getVirtualCores()) {
            return false;
        }
        ResourceScheduler scheduler = rmContext.getScheduler();
        request.setCapability(scheduler.getNormalizedResource(request.getCapability(), maximumAllocation));
        return true;
    }

    public static void validateContainerReleaseRequest(List<ContainerId> containerReleaseList, ApplicationAttemptId appAttemptId) throws InvalidContainerReleaseException {
        for (ContainerId cId : containerReleaseList) {
            if (appAttemptId.equals((Object)cId.getApplicationAttemptId())) continue;
            throw new InvalidContainerReleaseException("Cannot release container : " + cId.toString() + " not belonging to this application attempt : " + appAttemptId);
        }
    }

    public static UserGroupInformation verifyAdminAccess(YarnAuthorizationProvider authorizer, String method, Logger LOG) throws IOException {
        return RMServerUtils.verifyAdminAccess(authorizer, method, "AdminService", LOG);
    }

    public static UserGroupInformation verifyAdminAccess(YarnAuthorizationProvider authorizer, String method, String module, Logger LOG) throws IOException {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            LOG.warn("Couldn't get current user", (Throwable)ioe);
            RMAuditLogger.logFailure("UNKNOWN", method, "", "AdminService", "Couldn't get current user");
            throw ioe;
        }
        if (!authorizer.isAdmin(user)) {
            LOG.warn("User " + user.getShortUserName() + " doesn't have permission to call '" + method + "'");
            RMAuditLogger.logFailure(user.getShortUserName(), method, "", module, "Unauthorized user");
            throw new AccessControlException("User " + user.getShortUserName() + " doesn't have permission to call '" + method + "'");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(method + " invoked by user " + user.getShortUserName());
        }
        return user;
    }

    public static YarnApplicationState createApplicationState(RMAppState rmAppState) {
        switch (rmAppState) {
            case NEW: {
                return YarnApplicationState.NEW;
            }
            case NEW_SAVING: {
                return YarnApplicationState.NEW_SAVING;
            }
            case SUBMITTED: {
                return YarnApplicationState.SUBMITTED;
            }
            case ACCEPTED: {
                return YarnApplicationState.ACCEPTED;
            }
            case RUNNING: {
                return YarnApplicationState.RUNNING;
            }
            case FINISHING: 
            case FINISHED: {
                return YarnApplicationState.FINISHED;
            }
            case KILLING: 
            case KILLED: {
                return YarnApplicationState.KILLED;
            }
            case FAILED: {
                return YarnApplicationState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    public static YarnApplicationAttemptState convertRmAppAttemptStateToYarnApplicationAttemptState(RMAppAttemptState currentState, RMAppAttemptState previousState) {
        return RMServerUtils.createApplicationAttemptState(currentState == RMAppAttemptState.FINAL_SAVING ? previousState : currentState);
    }

    public static YarnApplicationAttemptState createApplicationAttemptState(RMAppAttemptState rmAppAttemptState) {
        switch (rmAppAttemptState) {
            case NEW: {
                return YarnApplicationAttemptState.NEW;
            }
            case SUBMITTED: {
                return YarnApplicationAttemptState.SUBMITTED;
            }
            case SCHEDULED: {
                return YarnApplicationAttemptState.SCHEDULED;
            }
            case ALLOCATED: {
                return YarnApplicationAttemptState.ALLOCATED;
            }
            case LAUNCHED: {
                return YarnApplicationAttemptState.LAUNCHED;
            }
            case ALLOCATED_SAVING: 
            case LAUNCHED_UNMANAGED_SAVING: {
                return YarnApplicationAttemptState.ALLOCATED_SAVING;
            }
            case RUNNING: {
                return YarnApplicationAttemptState.RUNNING;
            }
            case FINISHING: {
                return YarnApplicationAttemptState.FINISHING;
            }
            case FINISHED: {
                return YarnApplicationAttemptState.FINISHED;
            }
            case KILLED: {
                return YarnApplicationAttemptState.KILLED;
            }
            case FAILED: {
                return YarnApplicationAttemptState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    public static void processRMProxyUsersConf(Configuration conf) {
        HashMap<CallSite, String> rmProxyUsers = new HashMap<CallSite, String>();
        for (Map.Entry entry : conf) {
            String propName = (String)entry.getKey();
            if (!propName.startsWith("yarn.resourcemanager.proxyuser.")) continue;
            rmProxyUsers.put((CallSite)((Object)("hadoop.proxyuser." + propName.substring("yarn.resourcemanager.proxyuser.".length()))), (String)entry.getValue());
        }
        for (Map.Entry entry : rmProxyUsers.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void validateApplicationTimeouts(Map<ApplicationTimeoutType, Long> timeouts) throws YarnException {
        if (timeouts != null) {
            for (Map.Entry<ApplicationTimeoutType, Long> timeout : timeouts.entrySet()) {
                if (timeout.getValue() > 0L) continue;
                String message = "Invalid application timeout, value=" + timeout.getValue() + " for type=" + timeout.getKey();
                throw new YarnException(message);
            }
        }
    }

    public static Map<ApplicationTimeoutType, Long> validateISO8601AndConvertToLocalTimeEpoch(Map<ApplicationTimeoutType, String> timeoutsInISO8601) throws YarnException {
        long currentTimeMillis = clock.getTime();
        HashMap<ApplicationTimeoutType, Long> newApplicationTimeout = new HashMap<ApplicationTimeoutType, Long>();
        if (timeoutsInISO8601 != null) {
            for (Map.Entry<ApplicationTimeoutType, String> timeout : timeoutsInISO8601.entrySet()) {
                long expireTime = 0L;
                try {
                    expireTime = Times.parseISO8601ToLocalTimeInMillis((String)timeout.getValue());
                }
                catch (ParseException ex) {
                    String message = "Expire time is not in ISO8601 format. ISO8601 supported format is yyyy-MM-dd'T'HH:mm:ss.SSSZ. Configured timeout value is " + timeout.getValue();
                    throw new YarnException(message, (Throwable)ex);
                }
                if (expireTime < currentTimeMillis) {
                    String message = "Expire time is less than current time, current-time=" + Times.formatISO8601((long)currentTimeMillis) + " expire-time=" + Times.formatISO8601((long)expireTime);
                    throw new YarnException(message);
                }
                newApplicationTimeout.put(timeout.getKey(), expireTime);
            }
        }
        return newApplicationTimeout;
    }

    public static int getApplicableNodeCountForAM(RMContext rmContext, Configuration conf, List<ResourceRequest> amReqs) {
        String amNodeLabelExpression;
        Set<NodeId> nodesForLabels;
        HashSet<NodeId> nodesForReqs = new HashSet<NodeId>();
        for (ResourceRequest amReq : amReqs) {
            if (!amReq.getRelaxLocality() || amReq.getResourceName().equals("*")) continue;
            nodesForReqs.addAll(rmContext.getScheduler().getNodeIds(amReq.getResourceName()));
        }
        if (YarnConfiguration.areNodeLabelsEnabled((Configuration)conf) && (nodesForLabels = RMServerUtils.getNodeIdsForLabel(rmContext, amNodeLabelExpression = amReqs.get(0).getNodeLabelExpression())) != null && !nodesForLabels.isEmpty()) {
            if (nodesForReqs.isEmpty()) {
                Iterator<NodeId> it = nodesForLabels.iterator();
                while (it.hasNext()) {
                    if (it.next().getPort() != 0) continue;
                    it.remove();
                }
                return nodesForLabels.size();
            }
            return Sets.intersection(nodesForReqs, nodesForLabels).size();
        }
        if (nodesForReqs.isEmpty()) {
            return rmContext.getScheduler().getNumClusterNodes();
        }
        return nodesForReqs.size();
    }

    private static Set<NodeId> getNodeIdsForLabel(RMContext rmContext, String label) {
        String string = label = label == null || label.trim().isEmpty() ? "" : label;
        if (label.equals("")) {
            return rmContext.getNodeLabelManager().getNodesWithoutALabel();
        }
        Map labelsToNodes = rmContext.getNodeLabelManager().getLabelsToNodes(Collections.singleton(label));
        return (Set)labelsToNodes.get(label);
    }

    public static Long getOrDefault(Map<String, Long> map, String key, Long defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }
}

