/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.helper;

import com.sun.jersey.api.client.WebResource;
import java.util.function.Consumer;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.helper.BufferedClientResponse;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCustomResourceTypeTestcase {
    private static final Logger LOG = LoggerFactory.getLogger(JsonCustomResourceTypeTestcase.class);
    private final WebResource path;
    private final BufferedClientResponse response;
    private final JSONObject parsedResponse;

    public JsonCustomResourceTypeTestcase(WebResource path, BufferedClientResponse response) {
        this.path = path;
        this.verifyStatus(response);
        this.response = response;
        this.parsedResponse = response.getEntity(JSONObject.class);
    }

    private void verifyStatus(BufferedClientResponse response) {
        String responseStr = response.getEntity(String.class);
        Assert.assertEquals((String)("HTTP status should be 200, status info: " + response.getStatusInfo() + " response as string: " + responseStr), (long)200L, (long)response.getStatus());
    }

    public void verify(Consumer<JSONObject> verifier) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)this.response.getType().toString());
        this.logResponse();
        String responseStr = this.response.getEntity(String.class);
        if (responseStr == null || responseStr.isEmpty()) {
            throw new IllegalStateException("Response is null or empty!");
        }
        verifier.accept(this.parsedResponse);
    }

    private void logResponse() {
        String responseStr = this.response.getEntity(String.class);
        LOG.info("Raw response from service URL {}: {}", (Object)this.path.toString(), (Object)responseStr);
        LOG.info("Parsed response from service URL {}: {}", (Object)this.path.toString(), (Object)this.parsedResponse);
    }
}

