/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodeIDsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntry;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRMWebServicesNodeLabels
extends JerseyTestBase {
    private static final int BAD_REQUEST_CODE = 400;
    private static final Logger LOG = LoggerFactory.getLogger(TestRMWebServicesNodeLabels.class);
    private static final String NODE_0 = "nid:0";
    private static final String NODE_1 = "nid1:0";
    private static final String NODE_2 = "nid2:0";
    private static final String LABEL_A = "a";
    private static final String LABEL_B = "b";
    private static final String LABEL_X = "x";
    private static final String LABEL_Y = "y";
    private static final String LABEL_Z = "z";
    public static final boolean DEFAULT_NL_EXCLUSIVITY = true;
    private static final String PATH_WS = "ws";
    private static final String PATH_V1 = "v1";
    private static final String PATH_NODES = "nodes";
    private static final String PATH_CLUSTER = "cluster";
    private static final String PATH_REPLACE_NODE_TO_LABELS = "replace-node-to-labels";
    private static final String PATH_LABEL_MAPPINGS = "label-mappings";
    private static final String PATH_GET_LABELS = "get-labels";
    private static final String PATH_REPLACE_LABELS = "replace-labels";
    private static final String PATH_REMOVE_LABELS = "remove-node-labels";
    private static final String PATH_GET_NODE_LABELS = "get-node-labels";
    private static final String PATH_GET_NODE_TO_LABELS = "get-node-to-labels";
    private static final String QUERY_USER_NAME = "user.name";
    private static final String PATH_ADD_NODE_LABELS = "add-node-labels";
    private static MockRM rm;
    private static YarnConfiguration conf;
    private static String userName;
    private static String notUserName;
    private static RMWebServices rmWebService;
    private WebResource resource;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
        this.resource = this.resource();
    }

    public TestRMWebServicesNodeLabels() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    private WebResource getClusterWebResource() {
        return this.resource.path(PATH_WS).path(PATH_V1).path(PATH_CLUSTER);
    }

    private ClientResponse get(String path) {
        return (ClientResponse)this.getClusterWebResource().path(path).queryParam(QUERY_USER_NAME, userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    private ClientResponse get(String path, MultivaluedMapImpl queryParams) {
        return (ClientResponse)this.getClusterWebResource().path(path).queryParam(QUERY_USER_NAME, userName).queryParams((MultivaluedMap)queryParams).accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    private ClientResponse post(String path, String userName, Object payload, Class<?> payloadClass) throws Exception {
        return (ClientResponse)((WebResource.Builder)this.getClusterWebResource().path(path).queryParam(QUERY_USER_NAME, userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(payload, payloadClass), "application/json")).post(ClientResponse.class);
    }

    private ClientResponse post(String path, String userName, Object payload, Class<?> payloadClass, MultivaluedMapImpl queryParams) throws Exception {
        WebResource.Builder builder = this.getClusterWebResource().path(path).queryParam(QUERY_USER_NAME, userName).queryParams((MultivaluedMap)queryParams).accept(new String[]{"application/json"});
        if (payload != null && payloadClass != null) {
            builder.entity((Object)this.toJson(payload, payloadClass), "application/json");
        }
        return (ClientResponse)builder.post(ClientResponse.class);
    }

    @Test
    public void testNodeLabels() throws Exception {
        ClientResponse response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_A, (Object)true)}));
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfo((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_A, (Object)true)}));
        response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_B, (Object)false)}));
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfo((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_A, (Object)true), Pair.of((Object)LABEL_B, (Object)false)}));
        response = this.replaceLabelsOnNode(NODE_0, LABEL_A);
        this.assertHttp200(response);
        response = this.replaceLabelsOnNode(NODE_1, LABEL_B);
        this.assertHttp200(response);
        response = this.replaceLabelsOnNode(NODE_2, LABEL_B);
        this.assertHttp200(response);
        response = this.getNodeLabelMappings();
        this.assertApplicationJsonUtf8Response(response);
        LabelsToNodesInfo labelsToNodesInfo = (LabelsToNodesInfo)response.getEntity(LabelsToNodesInfo.class);
        this.assertLabelsToNodesInfo(labelsToNodesInfo, 2, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Pair.of((Object)LABEL_B, (Object)false), (Object)Lists.newArrayList((Object[])new String[]{NODE_1, NODE_2})), Pair.of((Object)Pair.of((Object)LABEL_A, (Object)true), (Object)Lists.newArrayList((Object[])new String[]{NODE_0}))}));
        response = this.getNodeLabelMappingsByLabels(LABEL_A);
        this.assertApplicationJsonUtf8Response(response);
        labelsToNodesInfo = (LabelsToNodesInfo)response.getEntity(LabelsToNodesInfo.class);
        this.assertLabelsToNodesInfo(labelsToNodesInfo, 1, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Pair.of((Object)LABEL_A, (Object)true), (Object)Lists.newArrayList((Object[])new String[]{NODE_0}))}));
        response = this.getLabelsOfNode(NODE_0);
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfoContains((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), (Pair<String, Boolean>)Pair.of((Object)LABEL_A, (Object)true));
        response = this.replaceLabelsOnNode(NODE_0, LABEL_B);
        this.assertHttp200(response);
        response = this.getLabelsOfNode(NODE_0);
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfoContains((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), (Pair<String, Boolean>)Pair.of((Object)LABEL_B, (Object)false));
        response = this.replaceNodeToLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)NODE_0, (Object)Lists.newArrayList((Object[])new String[]{LABEL_A}))}));
        this.assertHttp200(response);
        response = this.getNodeToLabels();
        this.assertApplicationJsonUtf8Response(response);
        NodeToLabelsInfo nodeToLabelsInfo = (NodeToLabelsInfo)response.getEntity(NodeToLabelsInfo.class);
        NodeLabelsInfo nodeLabelsInfo = (NodeLabelsInfo)nodeToLabelsInfo.getNodeToLabels().get(NODE_0);
        this.assertNodeLabelsSize(nodeLabelsInfo, 1);
        this.assertNodeLabelsInfoContains(nodeLabelsInfo, (Pair<String, Boolean>)Pair.of((Object)LABEL_A, (Object)true));
        response = this.replaceLabelsOnNode(NODE_0, "");
        this.assertHttp200(response);
        response = this.getLabelsOfNode(NODE_0);
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsSize((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), 0);
        response = this.replaceLabelsOnNode(NODE_0, LABEL_A);
        this.assertHttp200(response);
        response = this.getLabelsOfNode(NODE_0);
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfoContains((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), (Pair<String, Boolean>)Pair.of((Object)LABEL_A, (Object)true));
        response = this.replaceLabelsOnNodeWithUserName(NODE_0, notUserName, LABEL_B);
        this.assertHttp401(response);
        response = this.getLabelsOfNode(NODE_0);
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfoContains((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), (Pair<String, Boolean>)Pair.of((Object)LABEL_A, (Object)true));
        response = this.addNodeLabelsWithUser(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"c", (Object)true)}), notUserName);
        this.assertHttp401(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsSize((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), 2);
        response = this.removeNodeLabel(LABEL_B);
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfo((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_A, (Object)true)}));
        response = this.removeNodeLabel(LABEL_A);
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        nodeLabelsInfo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)0L, (long)nodeLabelsInfo.getNodeLabels().size());
        response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_X, (Object)false), Pair.of((Object)LABEL_Y, (Object)false)}));
        this.assertHttp200(response);
        response = this.replaceLabelsOnNode(NODE_0, LABEL_Y);
        this.assertHttp200(response);
        TestRMWebServicesNodeLabels.rmWebService.isCentralizedNodeLabelConfiguration = false;
        response = this.replaceNodeToLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)NODE_0, (Object)Lists.newArrayList((Object[])new String[]{LABEL_X}))}));
        this.assertHttp404(response);
        response = this.getNodeToLabels();
        this.assertApplicationJsonUtf8Response(response);
        nodeToLabelsInfo = (NodeToLabelsInfo)response.getEntity(NodeToLabelsInfo.class);
        nodeLabelsInfo = (NodeLabelsInfo)nodeToLabelsInfo.getNodeToLabels().get(NODE_0);
        this.assertNodeLabelsSize(nodeLabelsInfo, 1);
        this.assertNodeLabelsInfoDoesNotContain(nodeLabelsInfo, (Pair<String, Boolean>)Pair.of((Object)LABEL_X, (Object)false));
        response = this.replaceLabelsOnNode(NODE_0, LABEL_X);
        this.assertHttp404(response);
        response = this.getNodeToLabels();
        this.assertApplicationJsonUtf8Response(response);
        nodeToLabelsInfo = (NodeToLabelsInfo)response.getEntity(NodeToLabelsInfo.class);
        nodeLabelsInfo = (NodeLabelsInfo)nodeToLabelsInfo.getNodeToLabels().get(NODE_0);
        this.assertNodeLabelsSize(nodeLabelsInfo, 1);
        this.assertNodeLabelsInfoDoesNotContain(nodeLabelsInfo, (Pair<String, Boolean>)Pair.of((Object)LABEL_X, (Object)false));
        response = this.removeNodeLabel(LABEL_X);
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfoAtPosition((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), (Pair<String, Boolean>)Pair.of((Object)LABEL_Y, (Object)false), 0);
        response = this.removeNodeLabel(LABEL_Y);
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsSize((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), 0);
        response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_Z, (Object)false)}));
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        this.assertNodeLabelsInfoAtPosition((NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class), (Pair<String, Boolean>)Pair.of((Object)LABEL_Z, (Object)false), 0);
        this.assertNodeLabelsSize(nodeLabelsInfo, 1);
    }

    private void assertLabelsToNodesInfo(LabelsToNodesInfo labelsToNodesInfo, int size, List<Pair<Pair<String, Boolean>, List<String>>> nodeLabelsToNodesList) {
        Map labelsToNodes = labelsToNodesInfo.getLabelsToNodes();
        Assert.assertNotNull((String)"Labels to nodes mapping should not be null.", (Object)labelsToNodes);
        Assert.assertEquals((String)"Size of label to nodes mapping is not the expected.", (long)size, (long)labelsToNodes.size());
        for (Pair<Pair<String, Boolean>, List<String>> nodeLabelToNodes : nodeLabelsToNodesList) {
            Pair expectedNLData = (Pair)nodeLabelToNodes.getLeft();
            List expectedNodes = (List)nodeLabelToNodes.getRight();
            NodeLabelInfo expectedNLInfo = new NodeLabelInfo((String)expectedNLData.getLeft(), ((Boolean)expectedNLData.getRight()).booleanValue());
            NodeIDsInfo actualNodes = (NodeIDsInfo)labelsToNodes.get(expectedNLInfo);
            Assert.assertNotNull((String)String.format("Node info not found. Expected NodeLabel data: %s", expectedNLData), (Object)actualNodes);
            for (String expectedNode : expectedNodes) {
                Assert.assertTrue((String)String.format("Can't find node ID in actual Node IDs list: %s", actualNodes.getNodeIDs()), (boolean)actualNodes.getNodeIDs().contains(expectedNode));
            }
        }
    }

    private void assertNodeLabelsInfo(NodeLabelsInfo nodeLabelsInfo, List<Pair<String, Boolean>> nlInfos) {
        Assert.assertEquals((long)nlInfos.size(), (long)nodeLabelsInfo.getNodeLabels().size());
        for (int i = 0; i < nodeLabelsInfo.getNodeLabelsInfo().size(); ++i) {
            Pair<String, Boolean> expected = nlInfos.get(i);
            NodeLabelInfo actual = (NodeLabelInfo)nodeLabelsInfo.getNodeLabelsInfo().get(i);
            LOG.debug("Checking NodeLabelInfo: {}", (Object)actual);
            Assert.assertEquals((Object)expected.getLeft(), (Object)actual.getName());
            Assert.assertEquals((Object)expected.getRight(), (Object)actual.getExclusivity());
        }
    }

    private void assertNodeLabelsInfoAtPosition(NodeLabelsInfo nodeLabelsInfo, Pair<String, Boolean> nlInfo, int pos) {
        NodeLabelInfo actual = (NodeLabelInfo)nodeLabelsInfo.getNodeLabelsInfo().get(pos);
        LOG.debug("Checking NodeLabelInfo: {}", (Object)actual);
        Assert.assertEquals((Object)nlInfo.getLeft(), (Object)actual.getName());
        Assert.assertEquals((Object)nlInfo.getRight(), (Object)actual.getExclusivity());
    }

    private void assertNodeLabelsInfoContains(NodeLabelsInfo nodeLabelsInfo, Pair<String, Boolean> nlInfo) {
        NodeLabelInfo nodeLabelInfo = new NodeLabelInfo((String)nlInfo.getLeft(), ((Boolean)nlInfo.getRight()).booleanValue());
        Assert.assertTrue((String)String.format("Cannot find nodeLabelInfo '%s' among items of node label info list: %s", nodeLabelInfo, nodeLabelsInfo.getNodeLabelsInfo()), (boolean)nodeLabelsInfo.getNodeLabelsInfo().contains(nodeLabelInfo));
    }

    private void assertNodeLabelsInfoDoesNotContain(NodeLabelsInfo nodeLabelsInfo, Pair<String, Boolean> nlInfo) {
        NodeLabelInfo nodeLabelInfo = new NodeLabelInfo((String)nlInfo.getLeft(), ((Boolean)nlInfo.getRight()).booleanValue());
        Assert.assertFalse((String)String.format("Should have not found nodeLabelInfo '%s' among items of node label info list: %s", nodeLabelInfo, nodeLabelsInfo.getNodeLabelsInfo()), (boolean)nodeLabelsInfo.getNodeLabelsInfo().contains(nodeLabelInfo));
    }

    private void assertNodeLabelsSize(NodeLabelsInfo nodeLabelsInfo, int expectedSize) {
        Assert.assertEquals((long)expectedSize, (long)nodeLabelsInfo.getNodeLabelsInfo().size());
    }

    private ClientResponse replaceNodeToLabels(List<Pair<String, List<String>>> nodeToLabelInfos) throws Exception {
        NodeToLabelsEntryList nodeToLabelsEntries = new NodeToLabelsEntryList();
        for (Pair<String, List<String>> nodeToLabelInfo : nodeToLabelInfos) {
            ArrayList labelList = new ArrayList((Collection)nodeToLabelInfo.getRight());
            String nodeId = (String)nodeToLabelInfo.getLeft();
            NodeToLabelsEntry nli = new NodeToLabelsEntry(nodeId, labelList);
            nodeToLabelsEntries.getNodeToLabels().add(nli);
        }
        return this.post(PATH_REPLACE_NODE_TO_LABELS, userName, nodeToLabelsEntries, NodeToLabelsEntryList.class);
    }

    private ClientResponse getNodeLabelMappings() {
        return this.get(PATH_LABEL_MAPPINGS);
    }

    private ClientResponse getNodeLabelMappingsByLabels(String ... labelNames) {
        MultivaluedMapImpl params = TestRMWebServicesNodeLabels.createMultiValuedMap(labelNames);
        return this.get(PATH_LABEL_MAPPINGS, params);
    }

    private ClientResponse replaceLabelsOnNode(String node, String ... labelNames) throws Exception {
        return this.replaceLabelsOnNodeWithUserName(node, userName, labelNames);
    }

    private ClientResponse replaceLabelsOnNodeWithUserName(String node, String userName, String ... labelNames) throws Exception {
        LOG.info("Replacing labels on node '{}', label(s): {}", (Object)node, (Object)labelNames);
        MultivaluedMapImpl params = TestRMWebServicesNodeLabels.createMultiValuedMap(labelNames);
        String path = UriBuilder.fromPath((String)PATH_NODES).path(node).path(PATH_REPLACE_LABELS).build(new Object[0]).toString();
        return this.post(path, userName, null, null, params);
    }

    private static MultivaluedMapImpl createMultiValuedMap(String[] labelNames) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        for (String labelName : labelNames) {
            params.add("labels", labelName);
        }
        return params;
    }

    private ClientResponse removeNodeLabel(String ... labelNames) throws Exception {
        MultivaluedMapImpl params = TestRMWebServicesNodeLabels.createMultiValuedMap(labelNames);
        return this.post(PATH_REMOVE_LABELS, userName, null, null, params);
    }

    private ClientResponse getLabelsOfNode(String node) {
        String path = UriBuilder.fromPath((String)PATH_NODES).path(node).path(PATH_GET_LABELS).build(new Object[0]).toString();
        return this.get(path);
    }

    private ClientResponse getNodeLabels() {
        return this.get(PATH_GET_NODE_LABELS);
    }

    private ClientResponse getNodeToLabels() {
        return this.get(PATH_GET_NODE_TO_LABELS);
    }

    private ClientResponse addNodeLabels(List<Pair<String, Boolean>> nlInfos) throws Exception {
        return this.addNodeLabelsInternal(nlInfos, userName);
    }

    private ClientResponse addNodeLabelsWithUser(List<Pair<String, Boolean>> nlInfos, String userName) throws Exception {
        return this.addNodeLabelsInternal(nlInfos, userName);
    }

    private ClientResponse addNodeLabelsInternal(List<Pair<String, Boolean>> nlInfos, String userName) throws Exception {
        NodeLabelsInfo nodeLabelsInfo = new NodeLabelsInfo();
        for (Pair<String, Boolean> nlInfo : nlInfos) {
            NodeLabelInfo nodeLabelInfo = new NodeLabelInfo((String)nlInfo.getLeft(), ((Boolean)nlInfo.getRight()).booleanValue());
            nodeLabelsInfo.getNodeLabelsInfo().add(nodeLabelInfo);
        }
        return this.post(PATH_ADD_NODE_LABELS, userName, nodeLabelsInfo, NodeLabelsInfo.class);
    }

    private void assertApplicationJsonUtf8Response(ClientResponse response) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
    }

    private void assertHttp200(ClientResponse response) {
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    private void assertHttp401(ClientResponse response) {
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    private void assertHttp404(ClientResponse response) {
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testLabelInvalidAddition() throws Exception {
        ClientResponse response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"a&", (Object)true)}));
        String expectedMessage = "java.io.IOException: label name should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is= a&";
        this.validateJsonExceptionContent(response, expectedMessage);
    }

    @Test
    public void testLabelChangeExclusivity() throws Exception {
        ClientResponse response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"newLabel", (Object)true)}));
        this.assertHttp200(response);
        response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"newLabel", (Object)false)}));
        String expectedMessage = "java.io.IOException: Exclusivity cannot be modified for an existing label with : <newLabel:exclusivity=false>";
        this.validateJsonExceptionContent(response, expectedMessage);
    }

    private void validateJsonExceptionContent(ClientResponse response, String expectedMessage) throws JSONException {
        Assert.assertEquals((long)400L, (long)response.getStatus());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        String message = exception.getString("message");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        WebServicesTestUtils.checkStringContains((String)"exception message", (String)expectedMessage, (String)message);
    }

    @Test
    public void testLabelInvalidReplace() throws Exception {
        ClientResponse response = this.replaceLabelsOnNode(NODE_0, "idontexist");
        String expectedMessage = "Not all labels being replaced contained by known label collections, please check, new labels=[idontexist]";
        this.validateJsonExceptionContent(response, expectedMessage);
    }

    @Test
    public void testLabelInvalidRemove() throws Exception {
        ClientResponse response = this.removeNodeLabel("ireallydontexist");
        String expectedMessage = "java.io.IOException: Node label=ireallydontexist to be removed doesn't existed in cluster node labels collection.";
        this.validateJsonExceptionContent(response, expectedMessage);
    }

    @Test
    public void testNodeLabelPartitionInfo() throws Exception {
        ClientResponse response = this.addNodeLabels(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)LABEL_A, (Object)true)}));
        this.assertHttp200(response);
        response = this.getNodeLabels();
        this.assertApplicationJsonUtf8Response(response);
        NodeLabelsInfo nodeLabelsInfo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        this.assertNodeLabelsSize(nodeLabelsInfo, 1);
        for (NodeLabelInfo nl : nodeLabelsInfo.getNodeLabelsInfo()) {
            Assert.assertEquals((Object)LABEL_A, (Object)nl.getName());
            Assert.assertTrue((boolean)nl.getExclusivity());
            Assert.assertNotNull((Object)nl.getPartitionInfo());
            Assert.assertNotNull((Object)nl.getPartitionInfo().getResourceAvailable());
        }
        response = this.replaceLabelsOnNode("nodeId:0", LABEL_A);
        this.assertHttp200(response);
        response = this.getNodeLabelMappings();
        this.assertApplicationJsonUtf8Response(response);
        LabelsToNodesInfo labelsToNodesInfo = (LabelsToNodesInfo)response.getEntity(LabelsToNodesInfo.class);
        this.assertLabelsToNodesInfo(labelsToNodesInfo, 1, Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)Pair.of((Object)LABEL_A, (Object)true), (Object)Lists.newArrayList((Object[])new String[]{"nodeId:0"}))}));
        NodeIDsInfo nodes = (NodeIDsInfo)labelsToNodesInfo.getLabelsToNodes().get(new NodeLabelInfo(LABEL_A));
        Assert.assertNotNull((Object)nodes.getPartitionInfo());
        Assert.assertNotNull((Object)nodes.getPartitionInfo().getResourceAvailable());
    }

    private String toJson(Object obj, Class klass) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{klass});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON(obj, (Writer)sw);
        return sw.toString();
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            try {
                userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            notUserName = userName + "abc123";
            conf = new YarnConfiguration();
            conf.set("yarn.admin.acl", userName);
            rm = new MockRM((Configuration)conf);
            rmWebService = new RMWebServices((ResourceManager)rm, (Configuration)conf);
            this.bind(RMWebServices.class).toInstance((Object)rmWebService);
            this.bind(GenericExceptionHandler.class);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.filter("/*", new String[0]).through(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

