/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesDelegationTokenAuthentication;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.codehaus.jettison.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRMWebServicesHttpStaticUserPermissions {
    private static final File testRootDir = new File("target", TestRMWebServicesHttpStaticUserPermissions.class.getName() + "-root");
    private static File spnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String spnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static MiniKdc testMiniKDC;
    private static MockRM rm;

    @BeforeClass
    public static void setUp() {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            TestRMWebServicesHttpStaticUserPermissions.setupKDC();
            TestRMWebServicesHttpStaticUserPermissions.setupAndStartRM();
        }
        catch (Exception e) {
            Assert.fail((String)"Couldn't create MiniKDC");
        }
    }

    @AfterClass
    public static void tearDown() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
        if (rm != null) {
            rm.stop();
        }
    }

    private static void setupAndStartRM() throws Exception {
        Configuration rmconf = new Configuration();
        rmconf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        rmconf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        rmconf.setBoolean("yarn.acl.enable", true);
        rmconf.set("hadoop.security.authentication", "kerberos");
        rmconf.set("yarn.resourcemanager.principal", spnegoPrincipal);
        rmconf.set("yarn.resourcemanager.keytab", spnegoKeytabFile.getAbsolutePath());
        rmconf.setBoolean("mockrm.webapp.enabled", true);
        UserGroupInformation.setConfiguration((Configuration)rmconf);
        rm = new MockRM(rmconf);
        rm.start();
    }

    private static void setupKDC() throws Exception {
        testMiniKDC.start();
        testMiniKDC.createPrincipal(spnegoKeytabFile, new String[]{"HTTP/localhost", "client", UserGroupInformation.getLoginUser().getShortUserName(), "client2"});
    }

    @Test
    public void testWebServiceAccess() throws Exception {
        ApplicationSubmissionContextInfo app = new ApplicationSubmissionContextInfo();
        String appid = "application_123_0";
        app.setApplicationId(appid);
        String submitAppRequestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo(app);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/apps");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, "GET", "", "");
        try {
            conn.getInputStream();
            Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)conn.getResponseCode());
        }
        catch (IOException e) {
            Assert.fail((String)("Got " + conn.getResponseCode() + " instead of 200 accessing " + url.toString()));
        }
        conn.disconnect();
        HashMap<String, Helper> urlRequestMap = new HashMap<String, Helper>();
        String killAppRequestBody = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<appstate>\n  <state>KILLED</state>\n</appstate>";
        urlRequestMap.put("http://localhost:8088/ws/v1/cluster/apps", new Helper("POST", submitAppRequestBody));
        urlRequestMap.put("http://localhost:8088/ws/v1/cluster/apps/new-application", new Helper("POST", ""));
        urlRequestMap.put("http://localhost:8088/ws/v1/cluster/apps/app_123_1/state", new Helper("PUT", killAppRequestBody));
        for (Map.Entry entry : urlRequestMap.entrySet()) {
            URL reqURL = new URL((String)entry.getKey());
            conn = (HttpURLConnection)reqURL.openConnection();
            String method = ((Helper)entry.getValue()).method;
            String body = ((Helper)entry.getValue()).requestBody;
            TestRMWebServicesDelegationTokenAuthentication.setupConn(conn, method, "application/xml", body);
            try {
                conn.getInputStream();
                Assert.fail((String)("Request " + (String)entry.getKey() + "succeeded but should have failed"));
            }
            catch (IOException e) {
                String line;
                Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
                InputStream errorStream = conn.getErrorStream();
                Object error = "";
                BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, "UTF8"));
                while ((line = reader.readLine()) != null) {
                    error = (String)error + line;
                }
                reader.close();
                errorStream.close();
                JSONObject errResponse = new JSONObject((String)error);
                JSONObject remoteException = errResponse.getJSONObject("RemoteException");
                Assert.assertEquals((Object)"java.lang.Exception: The default static user cannot carry out this operation.", (Object)remoteException.getString("message"));
            }
            conn.disconnect();
        }
    }

    static class Helper {
        String method;
        String requestBody;

        Helper(String method, String requestBody) {
            this.method = method;
            this.requestBody = requestBody;
        }
    }
}

