/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.IOException;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMWebServicesContainers
extends JerseyTestBase {
    private static MockRM rm;
    private static String userName;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestRMWebServicesContainers() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testSignalContainer() throws Exception {
        rm.start();
        MockNM nm = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).build());
        nm.nodeHeartbeat(true);
        MockRM.waitForState(app.getCurrentAppAttempt(), RMAppAttemptState.ALLOCATED);
        rm.sendAMLaunched(app.getCurrentAppAttempt().getAppAttemptId());
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("containers").path(app.getCurrentAppAttempt().getMasterContainer().getId().toString()).path("signal").path("not-exist-signal").queryParam("user.name", userName).accept(new String[]{"application/json"}).post(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.getEntity(String.class)).contains("Invalid command: NOT-EXIST-SIGNAL"));
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("containers").path("XXX").path("signal").path(SignalContainerCommand.OUTPUT_THREAD_DUMP.name()).queryParam("user.name", userName).accept(new String[]{"application/json"}).post(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertTrue((boolean)((String)response.getEntity(String.class)).contains("Invalid ContainerId"));
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("containers").path(app.getCurrentAppAttempt().getMasterContainer().getId().toString()).path("signal").path(SignalContainerCommand.OUTPUT_THREAD_DUMP.name()).queryParam("user.name", userName).accept(new String[]{"application/json"}).post(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("containers").path(app.getCurrentAppAttempt().getMasterContainer().getId().toString()).path("signal").path(SignalContainerCommand.OUTPUT_THREAD_DUMP.name()).queryParam("user.name", "admin").accept(new String[]{"application/json"}).post(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        rm.stop();
    }

    static {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            try {
                userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            Configuration conf = new Configuration();
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            conf.set("yarn.admin.acl", "admin");
            rm = new MockRM(conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
            this.filter("/*", new String[0]).through(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
        }
    }
}

