/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServicesAppAttempts
extends JerseyTestBase {
    private static MockRM rm;
    private static final int CONTAINER_MB = 1024;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestRMWebServicesAppAttempts() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testAppAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString(), app1, "application/json");
        rm.stop();
    }

    @Test(timeout=20000L)
    public void testCompletedAppAttempt() throws Exception {
        Configuration conf = rm.getConfig();
        String logServerUrl = "http://localhost:19888/jobhistory/logs";
        conf.set("yarn.log.server.url", logServerUrl);
        conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 8192);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        amNodeManager.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        rm.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(app1.getApplicationId().toString()).path("appattempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject jsonAppAttempts = json.getJSONObject("appAttempts");
        JSONArray jsonArray = jsonAppAttempts.getJSONArray("appAttempt");
        JSONObject info = jsonArray.getJSONObject(0);
        String logsLink = info.getString("logsLink");
        String containerId = app1.getCurrentAppAttempt().getMasterContainer().getId().toString();
        Assertions.assertThat((String)logsLink).isEqualTo((Object)(logServerUrl + "/127.0.0.1:1234/" + containerId + "/" + containerId + "/user1"));
        rm.stop();
    }

    @Test(timeout=20000L)
    public void testMultipleAppAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 8192);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        MockAM am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        int maxAppAttempts = rm.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2);
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        int numAttempt = 1;
        while (true) {
            amNodeManager.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
            rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FAILED);
            if (numAttempt == maxAppAttempts) break;
            rm.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
            am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
            ++numAttempt;
        }
        rm.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((String)"incorrect number of attempts", (long)maxAppAttempts, (long)app1.getAppAttempts().values().size());
        this.testAppAttemptsHelper(app1.getApplicationId().toString(), app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppAttemptsSlash() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString() + "/", app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppAttemptsDefault() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString() + "/", app1, "");
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAppIdGetAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path("application_invalid_12").path("appattempts").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appAttempt");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.IllegalArgumentException: Invalid ApplicationId: application_invalid_12", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAppAttemptId() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path(app.getApplicationId().toString()).path("appattempts").path("appattempt_invalid_12_000001").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appAttempt");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.IllegalArgumentException: Invalid AppAttemptId: appattempt_invalid_12_000001", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonexistAppAttempts() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser("user1").build();
        MockRMAppSubmitter.submit(rm, data);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path("application_00000_0099").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: app with id: application_00000_0099 not found", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    private void testAppAttemptsHelper(String path, RMApp app, String media) throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(path).path("appattempts").accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jsonAppAttempts = json.getJSONObject("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)jsonAppAttempts.length());
        JSONArray jsonArray = jsonAppAttempts.getJSONArray("appAttempt");
        Collection attempts = app.getAppAttempts().values();
        Assert.assertEquals((String)"incorrect number of elements", (long)attempts.size(), (long)jsonArray.length());
        int i = 0;
        for (RMAppAttempt attempt : attempts) {
            this.verifyAppAttemptsInfo(jsonArray.getJSONObject(i), attempt, app.getUser());
            ++i;
        }
    }

    @Test
    public void testAppAttemptsXML() throws Exception {
        rm.start();
        String user = "user1";
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("testwordcount").withUser(user).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(app1.getApplicationId().toString()).path("appattempts").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        NodeList attempt = dom.getElementsByTagName("appAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)attempt.getLength());
        this.verifyAppAttemptsXML(attempt, app1.getCurrentAppAttempt(), user);
        rm.stop();
    }

    private void verifyAppAttemptsXML(NodeList nodes, RMAppAttempt appAttempt, String user) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyAppAttemptInfoGeneric(appAttempt, WebServicesTestUtils.getXmlInt((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlString((Element)element, (String)"containerId"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeId"), WebServicesTestUtils.getXmlString((Element)element, (String)"logsLink"), user, WebServicesTestUtils.getXmlString((Element)element, (String)"exportPorts"), WebServicesTestUtils.getXmlString((Element)element, (String)"appAttemptState"));
        }
    }

    private void verifyAppAttemptsInfo(JSONObject info, RMAppAttempt appAttempt, String user) throws Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)12L, (long)info.length());
        this.verifyAppAttemptInfoGeneric(appAttempt, info.getInt("id"), info.getLong("startTime"), info.getString("containerId"), info.getString("nodeHttpAddress"), info.getString("nodeId"), info.getString("logsLink"), user, info.getString("exportPorts"), info.getString("appAttemptState"));
    }

    private void verifyAppAttemptInfoGeneric(RMAppAttempt appAttempt, int id, long startTime, String containerId, String nodeHttpAddress, String nodeId, String logsLink, String user, String exportPorts, String appAttemptState) {
        Assert.assertEquals((String)"id doesn't match", (long)appAttempt.getAppAttemptId().getAttemptId(), (long)id);
        Assert.assertEquals((String)"startedTime doesn't match", (long)appAttempt.getStartTime(), (long)startTime);
        WebServicesTestUtils.checkStringMatch((String)"containerId", (String)appAttempt.getMasterContainer().getId().toString(), (String)containerId);
        WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)appAttempt.getMasterContainer().getNodeHttpAddress(), (String)nodeHttpAddress);
        WebServicesTestUtils.checkStringMatch((String)"nodeId", (String)appAttempt.getMasterContainer().getNodeId().toString(), (String)nodeId);
        Assert.assertTrue((String)"logsLink doesn't match ", (boolean)logsLink.startsWith("http://"));
        Assert.assertTrue((String)"logsLink doesn't contain user info", (boolean)logsLink.endsWith("/" + user));
        Assert.assertEquals((String)"appAttemptState doesn't match", (Object)appAttemptState, (Object)appAttempt.getAppAttemptState().toString());
    }

    static {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            Configuration conf = new Configuration();
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            rm = new MockRM(conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

