/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigConverterTestCommons;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterMain;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSConfigToCSConfigConverterMain {
    private FSConfigConverterTestCommons converterTestCommons;
    private ExitFunc exitFunc;

    @Before
    public void setUp() throws Exception {
        this.exitFunc = new ExitFunc();
        this.converterTestCommons = new FSConfigConverterTestCommons();
        this.converterTestCommons.setUp();
        FSConfigToCSConfigConverterMain.setExit((Consumer)this.exitFunc);
    }

    @After
    public void tearDown() throws Exception {
        QueueMetrics.clearQueueMetrics();
        FSConfigToCSConfigConverterMain.setExit(System::exit);
        this.converterTestCommons.tearDown();
    }

    @Test
    public void testConvertFSConfigurationDefaultsWeightMode() throws Exception {
        this.testConvertFSConfigurationDefaults(false);
    }

    @Test
    public void testConvertFSConfigurationDefaultsPercentageMode() throws IOException {
        this.testConvertFSConfigurationDefaults(true);
    }

    private void testConvertFSConfigurationDefaults(boolean percentage) throws IOException {
        FSConfigConverterTestCommons.setupFSConfigConversionFiles();
        String[] args = new String[]{"-o", FSConfigConverterTestCommons.OUTPUT_DIR, "-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE};
        if (percentage) {
            args = Arrays.copyOf(args, args.length + 1);
            args[args.length - 1] = "-pc";
        }
        FSConfigToCSConfigConverterMain.main((String[])args);
        boolean csConfigExists = new File(FSConfigConverterTestCommons.OUTPUT_DIR, "capacity-scheduler.xml").exists();
        boolean yarnSiteConfigExists = new File(FSConfigConverterTestCommons.OUTPUT_DIR, "yarn-site.xml").exists();
        Assert.assertTrue((String)"capacity-scheduler.xml was not generated", (boolean)csConfigExists);
        Assert.assertTrue((String)"yarn-site.xml was not generated", (boolean)yarnSiteConfigExists);
        Assert.assertEquals((String)"Exit code", (long)0L, (long)this.exitFunc.exitCode);
    }

    @Test
    public void testConvertFSConfigurationWithConsoleParam() throws Exception {
        FSConfigConverterTestCommons.setupFSConfigConversionFiles();
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"-p", "-e", "-y", FSConfigConverterTestCommons.YARN_SITE_XML, "-f", FSConfigConverterTestCommons.FS_ALLOC_FILE, "-r", FSConfigConverterTestCommons.CONVERSION_RULES_FILE});
        String stdout = this.converterTestCommons.getStdOutContent().toString();
        Assert.assertTrue((String)"Stdout doesn't contain yarn-site.xml", (boolean)stdout.contains("======= yarn-site.xml ======="));
        Assert.assertTrue((String)"Stdout doesn't contain capacity-scheduler.xml", (boolean)stdout.contains("======= capacity-scheduler.xml ======="));
        Assert.assertTrue((String)"Stdout doesn't contain mapping-rules.json", (boolean)stdout.contains("======= mapping-rules.json ======="));
        Assert.assertEquals((String)"Exit code", (long)0L, (long)this.exitFunc.exitCode);
    }

    @Test
    public void testShortHelpSwitch() {
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"-h"});
        this.verifyHelpText();
        Assert.assertEquals((String)"Exit code", (long)0L, (long)this.exitFunc.exitCode);
    }

    @Test
    public void testLongHelpSwitch() {
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"--help"});
        this.verifyHelpText();
        Assert.assertEquals((String)"Exit code", (long)0L, (long)this.exitFunc.exitCode);
    }

    @Test
    public void testHelpDisplayedWithoutArgs() {
        FSConfigToCSConfigConverterMain.main((String[])new String[0]);
        this.verifyHelpText();
        Assert.assertEquals((String)"Exit code", (long)0L, (long)this.exitFunc.exitCode);
    }

    @Test
    public void testConvertFSConfigurationWithLongSwitches() throws IOException {
        FSConfigConverterTestCommons.setupFSConfigConversionFiles();
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"--print", "--rules-to-file", "--percentage", "--yarnsiteconfig", FSConfigConverterTestCommons.YARN_SITE_XML, "--fsconfig", FSConfigConverterTestCommons.FS_ALLOC_FILE, "--rulesconfig", FSConfigConverterTestCommons.CONVERSION_RULES_FILE});
        String stdout = this.converterTestCommons.getStdOutContent().toString();
        Assert.assertTrue((String)"Stdout doesn't contain yarn-site.xml", (boolean)stdout.contains("======= yarn-site.xml ======="));
        Assert.assertTrue((String)"Stdout doesn't contain capacity-scheduler.xml", (boolean)stdout.contains("======= capacity-scheduler.xml ======="));
        Assert.assertTrue((String)"Stdout doesn't contain mapping-rules.json", (boolean)stdout.contains("======= mapping-rules.json ======="));
        Assert.assertEquals((String)"Exit code", (long)0L, (long)this.exitFunc.exitCode);
    }

    @Test
    public void testNegativeReturnValueOnError() {
        FSConfigToCSConfigConverterMain.main((String[])new String[]{"--print", "--yarnsiteconfig"});
        Assert.assertEquals((String)"Exit code", (long)-1L, (long)this.exitFunc.exitCode);
    }

    private void verifyHelpText() {
        String stdout = this.converterTestCommons.getStdOutContent().toString();
        Assert.assertTrue((String)"Help was not displayed", (boolean)stdout.contains("General options are:"));
    }

    class ExitFunc
    implements Consumer<Integer> {
        int exitCode;

        ExitFunc() {
        }

        @Override
        public void accept(Integer t) {
            this.exitCode = t;
        }
    }
}

