/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.resourcetypes.ResourceTypesTestHelper;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCapacitySchedulerWithMultiResourceTypes {
    private static String RESOURCE_1 = "res1";
    private static final String A_QUEUE = "root.a";
    private static final String B_QUEUE = "root.b";
    private static float A_CAPACITY = 50.0f;
    private static float B_CAPACITY = 50.0f;

    private void setupResources(boolean withGpu) {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        if (withGpu) {
            riMap.put("yarn.io/gpu", ResourceInformation.newInstance((String)"yarn.io/gpu", (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)3333L));
        } else {
            riMap.put(RESOURCE_1, ResourceInformation.newInstance((String)RESOURCE_1, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)3333L));
        }
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
    }

    @Test
    public void testMaximumAllocationRefreshWithMultipleResourceTypes() throws Exception {
        this.setupResources(false);
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setMaximumApplicationMasterResourcePerQueuePercent("root", 100.0f);
        csconf.setMaximumAMResourcePercentPerPartition("root", "", 100.0f);
        csconf.setMaximumApplicationMasterResourcePerQueuePercent("root.default", 100.0f);
        csconf.setMaximumAMResourcePercentPerPartition("root.default", "", 100.0f);
        csconf.setResourceComparator(DominantResourceCalculator.class);
        csconf.set("yarn.resource-types", RESOURCE_1);
        csconf.setInt("yarn.resource-types." + RESOURCE_1 + ".maximum-allocation", 3333);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        conf.setBoolean("yarn.test.reset-resource-types", false);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((long)3333L, (long)cs.getMaximumResourceCapability().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)3333L, (long)cs.getMaximumAllocation().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumResourceCapability().getResourceValue("memory-mb"));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumAllocation().getResourceValue("memory-mb"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumResourceCapability().getResourceValue("vcores"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumAllocation().getResourceValue("vcores"));
        csconf.set("yarn.resource-types", RESOURCE_1);
        csconf.setInt("yarn.resource-types." + RESOURCE_1 + ".maximum-allocation", 3332);
        boolean exception = false;
        try {
            cs.reinitialize((Configuration)csconf, rm.getRMContext());
        }
        catch (IOException e) {
            exception = true;
        }
        Assert.assertTrue((String)"Should have exception in CS", (boolean)exception);
        Assert.assertEquals((long)3333L, (long)cs.getMaximumResourceCapability().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)3333L, (long)cs.getMaximumAllocation().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumResourceCapability().getResourceValue("memory-mb"));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumAllocation().getResourceValue("memory-mb"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumResourceCapability().getResourceValue("vcores"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumAllocation().getResourceValue("vcores"));
        csconf.set("yarn.resource-types", RESOURCE_1);
        csconf.setInt("yarn.resource-types." + RESOURCE_1 + ".maximum-allocation", 3334);
        cs.reinitialize((Configuration)csconf, rm.getRMContext());
        Assert.assertEquals((long)3334L, (long)cs.getMaximumResourceCapability().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)3333L, (long)cs.getMaximumAllocation().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumResourceCapability().getResourceValue("memory-mb"));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumAllocation().getResourceValue("memory-mb"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumResourceCapability().getResourceValue("vcores"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumAllocation().getResourceValue("vcores"));
        rm.close();
    }

    @Test
    public void testDefaultResourceCalculatorWithThirdResourceTypes() throws Exception {
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DefaultResourceCalculator.class);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        String[] res1 = new String[]{"resource1", "M"};
        String[] res2 = new String[]{"resource2", "G"};
        String[] res3 = new String[]{"resource3", "H"};
        String[][] test = new String[][]{res1, res2, res3};
        Object resSt = "";
        for (String[] resources : test) {
            resSt = (String)resSt + resources[0] + ",";
        }
        resSt = ((String)resSt).substring(0, ((String)resSt).length() - 1);
        conf.set("yarn.resource-types", (String)resSt);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        boolean exception = false;
        try {
            MockRM mockRM = new MockRM((Configuration)conf);
        }
        catch (YarnRuntimeException e) {
            exception = true;
        }
        Assert.assertTrue((String)"Should have exception in CS", (boolean)exception);
    }

    @Test
    public void testMaxLimitsOfQueueWithMultipleResources() throws Exception {
        this.setupResources(true);
        int GB = 1024;
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setMaximumApplicationMasterResourcePerQueuePercent("root", 100.0f);
        csConf.setMaximumAMResourcePercentPerPartition("root", "", 100.0f);
        csConf.setMaximumApplicationMasterResourcePerQueuePercent("root.default", 100.0f);
        csConf.setMaximumAMResourcePercentPerPartition("root.default", "", 100.0f);
        csConf.setResourceComparator(DominantResourceCalculator.class);
        csConf.set("yarn.resource-types", "yarn.io/gpu");
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacity(A_QUEUE, A_CAPACITY);
        csConf.setCapacity(B_QUEUE, B_CAPACITY);
        csConf.setMaximumCapacity(A_QUEUE, 100.0f);
        csConf.setUserLimitFactor(A_QUEUE, 2.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setBoolean("yarn.test.reset-resource-types", false);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        HashMap<String, String> nameToValues = new HashMap<String, String>();
        nameToValues.put("yarn.io/gpu", "4");
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", ResourceTypesTestHelper.newResource((long)(10 * GB), (int)4, nameToValues));
        nameToValues.clear();
        rm.registerNode("127.0.0.1:1235", ResourceTypesTestHelper.newResource((long)(10 * GB), (int)4, nameToValues));
        RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app-1").withUser("user1").withAcls(null).withQueue("a").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)(1 * GB), (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)(9 * GB), (long)report_nm1.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)report_nm1.getUsedResource().getResourceInformation("yarn.io/gpu").getValue());
        Assert.assertEquals((long)4L, (long)report_nm1.getAvailableResource().getResourceInformation("yarn.io/gpu").getValue());
        nameToValues.put("yarn.io/gpu", "4");
        Resource containerGpuResource = ResourceTypesTestHelper.newResource((long)(1 * GB), (int)1, nameToValues);
        am1.allocate(Collections.singletonList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)containerGpuResource, (int)1)), null);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId2, RMContainerState.ALLOCATED));
        am1.allocate(null, null);
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)(2 * GB), (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4L, (long)report_nm1.getUsedResource().getResourceInformation("yarn.io/gpu").getValue());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getResourceInformation("yarn.io/gpu").getValue());
        nameToValues.clear();
        Resource containerResource = ResourceTypesTestHelper.newResource((long)(1 * GB), (int)1, nameToValues);
        am1.allocate(Collections.singletonList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)containerResource, (int)1)), null);
        ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm.waitForState(nm1, containerId3, RMContainerState.ALLOCATED));
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)(3 * GB), (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4L, (long)report_nm1.getUsedResource().getResourceInformation("yarn.io/gpu").getValue());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getResourceInformation("yarn.io/gpu").getValue());
    }

    @Test(timeout=300000L)
    public void testConsumeAllExtendedResourcesWithSmallMinUserLimitPct() throws Exception {
        int GB = 1024;
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        ResourceInformation res1 = ResourceInformation.newInstance((String)"res_1", (String)"", (long)0L, (long)10L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        riMap.put("res_1", res1);
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.set("yarn.resource-types", "res_1");
        csconf.set("yarn.resource-types.res_1.minimum-allocation", "0");
        csconf.set("yarn.resource-types.res_1.maximum-allocation", "10");
        csconf.setResourceComparator(DominantResourceCalculator.class);
        csconf.setQueues("root", new String[]{"a", "b"});
        csconf.setCapacity(A_QUEUE, A_CAPACITY);
        csconf.setCapacity(B_QUEUE, B_CAPACITY);
        csconf.setMaximumCapacity(A_QUEUE, 100.0f);
        csconf.setUserLimitFactor(A_QUEUE, 2.0f);
        YarnConfiguration yarnConf = new YarnConfiguration((Configuration)csconf);
        yarnConf.setBoolean("yarn.test.reset-resource-types", false);
        yarnConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)yarnConf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qb = (LeafQueue)cs.getQueue("a");
        qb.setUserLimit(25.0f);
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        RMAppAttemptMetrics attemptMetric = new RMAppAttemptMetrics(appAttemptId, rm.getRMContext());
        RMAppImpl app = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        RMAppAttemptImpl attempt = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)attempt.getMasterContainer()).thenReturn((Object)container);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)attempt.getSubmissionContext()).thenReturn((Object)submissionContext);
        Mockito.when((Object)attempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)attempt.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)attempt);
        rm.getRMContext().getRMApps().put(appId, app);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, "a", "user1");
        cs.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        cs.handle((SchedulerEvent)addAttemptEvent);
        HashMap<String, Long> resMap = new HashMap<String, Long>();
        resMap.put("res_1", 80L);
        Resource newResource = Resource.newInstance((long)(2048 * GB), (int)100, resMap);
        RMNode node = MockNodes.newNodeInfo(0, newResource, 1, "127.0.0.1");
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        FiCaSchedulerApp fiCaApp1 = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app.getApplicationId())).getCurrentAppAttempt();
        for (int i = 0; i < 8; ++i) {
            fiCaApp1.updateResourceRequests(Collections.singletonList(ResourceRequest.newBuilder().capability(ResourceTypesTestHelper.newResource((long)(1 * GB), (int)1, (Map)ImmutableMap.of((Object)"res_1", (Object)"10"))).numContainers(1).resourceName("*").build()));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node));
        }
        Assert.assertEquals((long)(8 * GB), (long)fiCaApp1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)80L, (long)fiCaApp1.getCurrentConsumption().getResourceInformation("res_1").getValue());
        rm.close();
    }
}

