/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.LightWeightResource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigValidator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCapacitySchedulerConfigValidator {
    public static final int NODE_MEMORY = 16;
    public static final int NODE1_VCORES = 8;
    public static final int NODE2_VCORES = 10;
    public static final int NODE3_VCORES = 12;
    public static final Map<String, Long> NODE_GPU = ImmutableMap.of((Object)"yarn.io/gpu", (Object)2L);
    public static final int GB = 1024;
    private static final String PARENT_A = "parentA";
    private static final String PARENT_B = "parentB";
    private static final String LEAF_A = "leafA";
    private static final String LEAF_B = "leafB";
    private static final QueuePath PARENT_A_FULL_PATH = new QueuePath("root.parentA");
    private static final QueuePath LEAF_A_FULL_PATH = new QueuePath(PARENT_A_FULL_PATH + ".leafA");
    private static final QueuePath PARENT_B_FULL_PATH = new QueuePath("root.parentB");
    private static final QueuePath LEAF_B_FULL_PATH = new QueuePath(PARENT_B_FULL_PATH + ".leafB");
    private final Resource A_MINRES = Resource.newInstance((int)16384, (int)10);
    private final Resource B_MINRES = Resource.newInstance((int)32768, (int)5);
    private final Resource FULL_MAXRES = Resource.newInstance((int)49152, (int)30);
    private final Resource PARTIAL_MAXRES = Resource.newInstance((int)16384, (int)10);
    private final Resource VCORE_EXCEEDED_MAXRES = Resource.newInstance((int)16384, (int)50);
    private Resource A_MINRES_GPU;
    private Resource B_MINRES_GPU;
    private Resource FULL_MAXRES_GPU;
    private Resource PARTIAL_MAXRES_GPU;
    private Resource GPU_EXCEEDED_MAXRES_GPU;
    protected MockRM mockRM = null;
    protected MockNM nm1 = null;
    protected MockNM nm2 = null;
    protected MockNM nm3 = null;
    protected CapacityScheduler cs;

    public static void setupResources(boolean useGpu) {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        if (useGpu) {
            riMap.put("yarn.io/gpu", ResourceInformation.newInstance((String)"yarn.io/gpu", (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)10L));
        }
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
    }

    @Test(expected=YarnRuntimeException.class)
    public void testValidateMemoryAllocationInvalidMinMem() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("yarn.scheduler.minimum-allocation-mb", "0");
        Configuration config = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configs);
        CapacitySchedulerConfigValidator.validateMemoryAllocation((Configuration)config);
        Assert.fail((String)"yarn.scheduler.minimum-allocation-mb should be > 0");
    }

    @Test(expected=YarnRuntimeException.class)
    public void testValidateMemoryAllocationHIgherMinThanMaxMem() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("yarn.scheduler.minimum-allocation-mb", "8192");
        configs.put("yarn.scheduler.maximum-allocation-mb", "1024");
        Configuration config = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configs);
        CapacitySchedulerConfigValidator.validateMemoryAllocation((Configuration)config);
        Assert.fail((String)"yarn.scheduler.minimum-allocation-mb should be > yarn.scheduler.maximum-allocation-mb");
    }

    @Test
    public void testValidateMemoryAllocation() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("yarn.scheduler.minimum-allocation-mb", "1024");
        configs.put("yarn.scheduler.maximum-allocation-mb", "8192");
        Configuration config = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configs);
        CapacitySchedulerConfigValidator.validateMemoryAllocation((Configuration)config);
    }

    @Test(expected=YarnRuntimeException.class)
    public void testValidateVCoresInvalidMinVCore() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("yarn.scheduler.minimum-allocation-vcores", "0");
        Configuration config = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configs);
        CapacitySchedulerConfigValidator.validateVCores((Configuration)config);
        Assert.fail((String)"yarn.scheduler.minimum-allocation-vcores should be > 0");
    }

    @Test(expected=YarnRuntimeException.class)
    public void testValidateVCoresHigherMinThanMaxVCore() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("yarn.scheduler.minimum-allocation-vcores", "4");
        configs.put("yarn.scheduler.maximum-allocation-vcores", "1");
        Configuration config = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configs);
        CapacitySchedulerConfigValidator.validateVCores((Configuration)config);
        Assert.fail((String)"yarn.scheduler.minimum-allocation-vcores should be > yarn.scheduler.maximum-allocation-mb");
    }

    @Test
    public void testValidateVCores() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("yarn.scheduler.minimum-allocation-vcores", "1");
        configs.put("yarn.scheduler.maximum-allocation-vcores", "4");
        Configuration config = CapacitySchedulerConfigGeneratorForTest.createConfiguration(configs);
        CapacitySchedulerConfigValidator.validateVCores((Configuration)config);
    }

    @Test
    public void testValidateCSConfigInvalidCapacity() {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.test1.capacity", "500");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
            Assert.fail((String)"Invalid capacity");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Illegal capacity"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateCSConfigDefaultRCAbsoluteModeParentMaxMemoryExceeded() throws Exception {
        this.setUpMockRM(false);
        RMContext rmContext = this.mockRM.getRMContext();
        CapacitySchedulerConfiguration oldConfiguration = this.cs.getConfiguration();
        CapacitySchedulerConfiguration newConfiguration = new CapacitySchedulerConfiguration((Configuration)this.cs.getConfiguration());
        newConfiguration.setMaximumResourceRequirement("", LEAF_A_FULL_PATH, this.FULL_MAXRES);
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfiguration, (Configuration)newConfiguration, (RMContext)rmContext);
            Assert.fail((String)"Parent maximum capacity exceeded");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Max resource configuration"));
        }
        finally {
            this.mockRM.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateCSConfigDefaultRCAbsoluteModeParentMaxVcoreExceeded() throws Exception {
        this.setUpMockRM(false);
        RMContext rmContext = this.mockRM.getRMContext();
        CapacitySchedulerConfiguration oldConfiguration = this.cs.getConfiguration();
        CapacitySchedulerConfiguration newConfiguration = new CapacitySchedulerConfiguration((Configuration)this.cs.getConfiguration());
        newConfiguration.setMaximumResourceRequirement("", LEAF_A_FULL_PATH, this.VCORE_EXCEEDED_MAXRES);
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfiguration, (Configuration)newConfiguration, (RMContext)rmContext);
        }
        catch (IOException e) {
            Assert.fail((String)"In DefaultResourceCalculator vcore limits are not enforced");
        }
        finally {
            this.mockRM.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateCSConfigDominantRCAbsoluteModeParentMaxMemoryExceeded() throws Exception {
        this.setUpMockRM(true);
        RMContext rmContext = this.mockRM.getRMContext();
        CapacitySchedulerConfiguration oldConfiguration = this.cs.getConfiguration();
        CapacitySchedulerConfiguration newConfiguration = new CapacitySchedulerConfiguration((Configuration)this.cs.getConfiguration());
        newConfiguration.setMaximumResourceRequirement("", LEAF_A_FULL_PATH, this.FULL_MAXRES);
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfiguration, (Configuration)newConfiguration, (RMContext)rmContext);
            Assert.fail((String)"Parent maximum capacity exceeded");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Max resource configuration"));
        }
        finally {
            this.mockRM.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateCSConfigDominantRCAbsoluteModeParentMaxVcoreExceeded() throws Exception {
        this.setUpMockRM(true);
        RMContext rmContext = this.mockRM.getRMContext();
        CapacitySchedulerConfiguration oldConfiguration = this.cs.getConfiguration();
        CapacitySchedulerConfiguration newConfiguration = new CapacitySchedulerConfiguration((Configuration)this.cs.getConfiguration());
        newConfiguration.setMaximumResourceRequirement("", LEAF_A_FULL_PATH, this.VCORE_EXCEEDED_MAXRES);
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfiguration, (Configuration)newConfiguration, (RMContext)rmContext);
            Assert.fail((String)"Parent maximum capacity exceeded");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Max resource configuration"));
        }
        finally {
            this.mockRM.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateCSConfigDominantRCAbsoluteModeParentMaxGPUExceeded() throws Exception {
        this.setUpMockRM(true);
        RMContext rmContext = this.mockRM.getRMContext();
        CapacitySchedulerConfiguration oldConfiguration = this.cs.getConfiguration();
        CapacitySchedulerConfiguration newConfiguration = new CapacitySchedulerConfiguration((Configuration)this.cs.getConfiguration());
        newConfiguration.setMaximumResourceRequirement("", LEAF_A_FULL_PATH, this.GPU_EXCEEDED_MAXRES_GPU);
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfiguration, (Configuration)newConfiguration, (RMContext)rmContext);
            Assert.fail((String)"Parent maximum capacity exceeded");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Max resource configuration"));
        }
        finally {
            this.mockRM.stop();
        }
    }

    @Test
    public void testValidateCSConfigStopALeafQueue() throws IOException {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.test1.state", "STOPPED");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        boolean isValidConfig = CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
        Assert.assertTrue((boolean)isValidConfig);
    }

    @Test
    public void testValidateCSConfigStopANonLeafQueueInvalid() {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.state", "STOPPED");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
            Assert.fail((String)"There are child queues in running state");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("The parent queue:root cannot be STOPPED"));
        }
    }

    @Test
    public void testValidateCSConfigStopANonLeafQueue() throws IOException {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.state", "STOPPED");
        newConfig.set("yarn.scheduler.capacity.root.test1.state", "STOPPED");
        newConfig.set("yarn.scheduler.capacity.root.test2.state", "STOPPED");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        Boolean isValidConfig = CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
        Assert.assertTrue((boolean)isValidConfig);
    }

    @Test
    public void testValidateCSConfigAddALeafQueueInvalid() {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        CapacitySchedulerConfiguration newConfig = new CapacitySchedulerConfiguration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.queues", "test1, test2, test3");
        newConfig.set("yarn.scheduler.capacity.root.test3.state", "RUNNING");
        newConfig.set("yarn.scheduler.capacity.root.test3.capacity", "30");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
            if (newConfig.isLegacyQueueMode()) {
                Assert.fail((String)"Invalid capacity for children of queue root");
            }
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Illegal capacity"));
        }
    }

    @Test
    public void testValidateCSConfigAddALeafQueueValid() throws IOException {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.queues", "test1, test2, test3");
        newConfig.set("yarn.scheduler.capacity.root.test3.state", "RUNNING");
        newConfig.set("yarn.scheduler.capacity.root.test3.capacity", "30");
        newConfig.set("yarn.scheduler.capacity.root.test1.capacity", "20");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        Boolean isValidConfig = CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
        Assert.assertTrue((boolean)isValidConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidateDoesNotModifyTheDefaultMetricsSystem() throws Exception {
        try {
            YarnConfiguration conf = new YarnConfiguration(CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration());
            conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            this.mockRM = new MockRM((Configuration)conf);
            this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
            this.mockRM.start();
            this.cs.start();
            RMContext rmContext = this.mockRM.getRMContext();
            Configuration oldConfig = this.cs.getConfig();
            Map cache = QueueMetrics.getQueueMetrics();
            MetricsSystem ms = DefaultMetricsSystem.instance();
            QueueMetrics origQM1 = (QueueMetrics)cache.get("root.test1");
            QueueMetrics origQM2 = (QueueMetrics)cache.get("root.test2");
            Assert.assertNotNull((String)"Original queues should be found in the cache", (Object)origQM1);
            Assert.assertNotNull((String)"Original queues should be found in the cache", (Object)origQM2);
            QueueMetrics origPQM1 = (QueueMetrics)cache.get("default.root.test1");
            QueueMetrics origPQM2 = (QueueMetrics)cache.get("default.root.test2");
            Assert.assertNotNull((String)"Original queues should be found in the cache (PartitionQueueMetrics)", (Object)origPQM1);
            Assert.assertNotNull((String)"Original queues should be found in the cache (PartitionQueueMetrics)", (Object)origPQM2);
            MetricsSource origMS1 = ms.getSource("QueueMetrics,q0=root,q1=test1");
            MetricsSource origMS2 = ms.getSource("QueueMetrics,q0=root,q1=test2");
            Assert.assertNotNull((String)"Original queues should be found in the Metrics System", (Object)origMS1);
            Assert.assertNotNull((String)"Original queues should be found in the Metrics System", (Object)origMS2);
            MetricsSource origPMS1 = ms.getSource("PartitionQueueMetrics,partition=,q0=root,q1=test1");
            MetricsSource origPMS2 = ms.getSource("PartitionQueueMetrics,partition=,q0=root,q1=test2");
            Assert.assertNotNull((String)"Original queues should be found in Metrics System (PartitionQueueMetrics)", (Object)origPMS1);
            Assert.assertNotNull((String)"Original queues should be found in Metrics System (PartitionQueueMetrics)", (Object)origPMS2);
            Configuration newConfig = new Configuration(oldConfig);
            newConfig.set("yarn.scheduler.capacity.root.queues", "test1, test2, test3");
            newConfig.set("yarn.scheduler.capacity.root.test3.state", "RUNNING");
            newConfig.set("yarn.scheduler.capacity.root.test3.capacity", "30");
            newConfig.set("yarn.scheduler.capacity.root.test1.capacity", "20");
            boolean isValidConfig = CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
            Assert.assertTrue((boolean)isValidConfig);
            Assert.assertFalse((String)"Validated new queue should not be in the cache", (boolean)cache.containsKey("root.test3"));
            Assert.assertFalse((String)"Validated new queue should not be in the cache (PartitionQueueMetrics)", (boolean)cache.containsKey("default.root.test3"));
            Assert.assertNull((String)"Validated new queue should not be in the Metrics System", (Object)ms.getSource("QueueMetrics,q0=root,q1=test3"));
            Assert.assertNull((String)"Validated new queue should not be in Metrics System (PartitionQueueMetrics)", (Object)ms.getSource("PartitionQueueMetrics,partition=,q0=root,q1=test3"));
            Assert.assertEquals((Object)origQM1, cache.get("root.test1"));
            Assert.assertEquals((Object)origQM2, cache.get("root.test2"));
            Assert.assertEquals((Object)origPQM1, cache.get("default.root.test1"));
            Assert.assertEquals((Object)origPQM1, cache.get("default.root.test1"));
            Assert.assertEquals((Object)origMS1, (Object)ms.getSource("QueueMetrics,q0=root,q1=test1"));
            Assert.assertEquals((Object)origMS2, (Object)ms.getSource("QueueMetrics,q0=root,q1=test2"));
            Assert.assertEquals((Object)origPMS1, (Object)ms.getSource("PartitionQueueMetrics,partition=,q0=root,q1=test1"));
            Assert.assertEquals((Object)origPMS2, (Object)ms.getSource("PartitionQueueMetrics,partition=,q0=root,q1=test2"));
        }
        finally {
            this.mockRM.stop();
        }
    }

    @Test
    public void testValidateCSConfigInvalidQueueDeletion() {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.queues", "test1");
        newConfig.set("yarn.scheduler.capacity.root.test1.capacity", "100");
        newConfig.unset("yarn.scheduler.capacity.root.test2.maximum-capacity");
        newConfig.unset("yarn.scheduler.capacity.root.test2.state");
        newConfig.set("yarn.scheduler.capacity.queue-mappings", "u:test1:test1");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
            Assert.fail((String)"Invalid capacity for children of queue root");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("root.test2 cannot be deleted"));
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("the queue is not yet in stopped state"));
        }
    }

    @Test
    public void testValidateCSConfigInvalidQueueDeletion2() {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        oldConfig.set("yarn.scheduler.capacity.root.test2.state", "STOPPED");
        CapacitySchedulerConfiguration newConfig = new CapacitySchedulerConfiguration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.queues", "test1");
        newConfig.unset("yarn.scheduler.capacity.root.test2.maximum-capacity");
        newConfig.unset("yarn.scheduler.capacity.root.test2.state");
        newConfig.set("yarn.scheduler.capacity.queue-mappings", "u:test1:test1");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        try {
            CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
            if (newConfig.isLegacyQueueMode()) {
                Assert.fail((String)"Invalid capacity for children of queue root");
            }
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Illegal capacity"));
        }
    }

    @Test
    public void testValidateCSConfigValidQueueDeletion() throws IOException {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        oldConfig.set("yarn.scheduler.capacity.root.test2.state", "STOPPED");
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.queues", "test1");
        newConfig.set("yarn.scheduler.capacity.root.test1.capacity", "100");
        newConfig.unset("yarn.scheduler.capacity.root.test2.maximum-capacity");
        newConfig.unset("yarn.scheduler.capacity.root.test2.state");
        newConfig.set("yarn.scheduler.capacity.queue-mappings", "u:test1:test1");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        boolean isValidConfig = CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
        Assert.assertTrue((boolean)isValidConfig);
    }

    @Test
    public void testAddQueueToALeafQueue() throws IOException {
        Configuration oldConfig = CapacitySchedulerConfigGeneratorForTest.createBasicCSConfiguration();
        oldConfig.set("yarn.scheduler.capacity.root.test1.state", "STOPPED");
        Configuration newConfig = new Configuration(oldConfig);
        newConfig.set("yarn.scheduler.capacity.root.test1.queues", "newQueue");
        newConfig.set("yarn.scheduler.capacity.root.test1.newQueue.capacity", "100");
        newConfig.set("yarn.scheduler.capacity.queue-mappings", "u:test1:test2");
        RMContext rmContext = TestCapacitySchedulerConfigValidator.prepareRMContext();
        boolean isValidConfig = CapacitySchedulerConfigValidator.validateCSConfiguration((Configuration)oldConfig, (Configuration)newConfig, (RMContext)rmContext);
        Assert.assertTrue((boolean)isValidConfig);
    }

    public static RMContext prepareRMContext() {
        TestCapacitySchedulerConfigValidator.setupResources(false);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        CapacityScheduler mockCs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)mockCs);
        LocalConfigurationProvider configProvider = (LocalConfigurationProvider)Mockito.mock(LocalConfigurationProvider.class);
        Mockito.when((Object)rmContext.getConfigurationProvider()).thenReturn((Object)configProvider);
        RMNodeLabelsManager nodeLabelsManager = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)rmContext.getNodeLabelManager()).thenReturn((Object)nodeLabelsManager);
        LightWeightResource partitionResource = (LightWeightResource)Mockito.mock(LightWeightResource.class);
        Mockito.when((Object)nodeLabelsManager.getResourceByLabel((String)Mockito.any(), (Resource)Mockito.any())).thenReturn((Object)partitionResource);
        PlacementManager queuePlacementManager = (PlacementManager)Mockito.mock(PlacementManager.class);
        Mockito.when((Object)rmContext.getQueuePlacementManager()).thenReturn((Object)queuePlacementManager);
        return rmContext;
    }

    private void setUpMockRM(boolean useDominantRC) throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestCapacitySchedulerConfigValidator.setupResources(useDominantRC);
        CapacitySchedulerConfiguration csConf = this.setupCSConfiguration(conf, useDominantRC);
        this.mockRM = new MockRM((Configuration)csConf);
        this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.mockRM.start();
        this.cs.start();
        this.setupNodes(this.mockRM);
    }

    private void setupNodes(MockRM newMockRM) throws Exception {
        this.nm1 = new MockNM("h1:1234", Resource.newInstance((long)16384L, (int)8, NODE_GPU), newMockRM.getResourceTrackerService(), YarnVersionInfo.getVersion());
        this.nm1.registerNode();
        this.nm2 = new MockNM("h2:1234", Resource.newInstance((long)16384L, (int)10, NODE_GPU), newMockRM.getResourceTrackerService(), YarnVersionInfo.getVersion());
        this.nm2.registerNode();
        this.nm3 = new MockNM("h3:1234", Resource.newInstance((long)16384L, (int)12, NODE_GPU), newMockRM.getResourceTrackerService(), YarnVersionInfo.getVersion());
        this.nm3.registerNode();
    }

    private void setupGpuResourceValues() {
        this.A_MINRES_GPU = Resource.newInstance((long)this.A_MINRES.getMemorySize(), (int)this.A_MINRES.getVirtualCores(), (Map)ImmutableMap.of((Object)"yarn.io/gpu", (Object)2L));
        this.B_MINRES_GPU = Resource.newInstance((long)this.B_MINRES.getMemorySize(), (int)this.B_MINRES.getVirtualCores(), (Map)ImmutableMap.of((Object)"yarn.io/gpu", (Object)2L));
        this.FULL_MAXRES_GPU = Resource.newInstance((long)this.FULL_MAXRES.getMemorySize(), (int)this.FULL_MAXRES.getVirtualCores(), (Map)ImmutableMap.of((Object)"yarn.io/gpu", (Object)6L));
        this.PARTIAL_MAXRES_GPU = Resource.newInstance((long)this.PARTIAL_MAXRES.getMemorySize(), (int)this.PARTIAL_MAXRES.getVirtualCores(), (Map)ImmutableMap.of((Object)"yarn.io/gpu", (Object)4L));
        this.GPU_EXCEEDED_MAXRES_GPU = Resource.newInstance((long)this.PARTIAL_MAXRES.getMemorySize(), (int)this.PARTIAL_MAXRES.getVirtualCores(), (Map)ImmutableMap.of((Object)"yarn.io/gpu", (Object)50L));
    }

    private CapacitySchedulerConfiguration setupCSConfiguration(YarnConfiguration configuration, boolean useDominantRC) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)configuration);
        if (useDominantRC) {
            csConf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
            csConf.set("yarn.resource-types", "yarn.io/gpu");
        }
        csConf.setQueues("root", new String[]{PARENT_A, PARENT_B});
        csConf.setQueues(PARENT_A_FULL_PATH.getFullPath(), new String[]{LEAF_A});
        csConf.setQueues(PARENT_B_FULL_PATH.getFullPath(), new String[]{LEAF_B});
        if (useDominantRC) {
            this.setupGpuResourceValues();
            csConf.setMinimumResourceRequirement("", PARENT_A_FULL_PATH, this.A_MINRES_GPU);
            csConf.setMinimumResourceRequirement("", PARENT_B_FULL_PATH, this.B_MINRES_GPU);
            csConf.setMinimumResourceRequirement("", LEAF_A_FULL_PATH, this.A_MINRES_GPU);
            csConf.setMinimumResourceRequirement("", LEAF_B_FULL_PATH, this.B_MINRES_GPU);
            csConf.setMaximumResourceRequirement("", PARENT_A_FULL_PATH, this.PARTIAL_MAXRES_GPU);
            csConf.setMaximumResourceRequirement("", PARENT_B_FULL_PATH, this.FULL_MAXRES_GPU);
            csConf.setMaximumResourceRequirement("", LEAF_A_FULL_PATH, this.PARTIAL_MAXRES_GPU);
            csConf.setMaximumResourceRequirement("", LEAF_B_FULL_PATH, this.FULL_MAXRES_GPU);
        } else {
            csConf.setMinimumResourceRequirement("", PARENT_A_FULL_PATH, this.A_MINRES);
            csConf.setMinimumResourceRequirement("", PARENT_B_FULL_PATH, this.B_MINRES);
            csConf.setMinimumResourceRequirement("", LEAF_A_FULL_PATH, this.A_MINRES);
            csConf.setMinimumResourceRequirement("", LEAF_B_FULL_PATH, this.B_MINRES);
            csConf.setMaximumResourceRequirement("", PARENT_A_FULL_PATH, this.PARTIAL_MAXRES);
            csConf.setMaximumResourceRequirement("", PARENT_B_FULL_PATH, this.FULL_MAXRES);
            csConf.setMaximumResourceRequirement("", LEAF_A_FULL_PATH, this.PARTIAL_MAXRES);
            csConf.setMaximumResourceRequirement("", LEAF_B_FULL_PATH, this.FULL_MAXRES);
        }
        return csConf;
    }
}

