/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public class TestAbsoluteResourceConfiguration {
    private static final int GB = 1024;
    private static final float DELTA = 0.001f;
    private static final String QUEUEA = "queueA";
    private static final String QUEUEB = "queueB";
    private static final String QUEUEC = "queueC";
    private static final String QUEUED = "queueD";
    private static final String QUEUEA1 = "queueA1";
    private static final String QUEUEA2 = "queueA2";
    private static final String QUEUEB1 = "queueB1";
    private static final QueuePath QUEUEA_FULL = new QueuePath("root", "queueA");
    private static final QueuePath QUEUEB_FULL = new QueuePath("root", "queueB");
    private static final QueuePath QUEUEC_FULL = new QueuePath("root", "queueC");
    private static final QueuePath QUEUED_FULL = new QueuePath("root", "queueD");
    private static final QueuePath QUEUEA1_FULL = new QueuePath(QUEUEA_FULL.getFullPath() + ".queueA1");
    private static final QueuePath QUEUEA2_FULL = new QueuePath(QUEUEA_FULL.getFullPath() + ".queueA2");
    private static final QueuePath QUEUEB1_FULL = new QueuePath(QUEUEB_FULL.getFullPath() + ".queueB1");
    private static final Resource QUEUE_A_MINRES = Resource.newInstance((int)102400, (int)10);
    private static final Resource QUEUE_A_MAXRES = Resource.newInstance((int)204800, (int)30);
    private static final Resource QUEUE_A1_MINRES = Resource.newInstance((int)51200, (int)5);
    private static final Resource QUEUE_A2_MINRES = Resource.newInstance((int)51200, (int)5);
    private static final Resource QUEUE_B_MINRES = Resource.newInstance((int)51200, (int)10);
    private static final Resource QUEUE_B1_MINRES = Resource.newInstance((int)40960, (int)10);
    private static final Resource QUEUE_B_MAXRES = Resource.newInstance((int)153600, (int)30);
    private static final Resource QUEUE_C_MINRES = Resource.newInstance((int)25600, (int)5);
    private static final Resource QUEUE_C_MAXRES = Resource.newInstance((int)153600, (int)20);
    private static final Resource QUEUE_D_MINRES = Resource.newInstance((int)25600, (int)5);
    private static final Resource QUEUE_D_MAXRES = Resource.newInstance((int)153600, (int)20);
    private static final Resource QUEUEA_REDUCED = Resource.newInstance((int)64000, (int)6);
    private static final Resource QUEUEB_REDUCED = Resource.newInstance((int)32000, (int)6);
    private static final Resource QUEUEC_REDUCED = Resource.newInstance((int)16000, (int)3);
    private static final Resource QUEUEMAX_REDUCED = Resource.newInstance((int)128000, (int)20);
    private static final Resource QUEUE_D_TEMPL_MINRES = Resource.newInstance((int)25600, (int)5);
    private static final Resource QUEUE_D_TEMPL_MAXRES = Resource.newInstance((int)153600, (int)20);
    public static final String X_LABEL = "X";
    public static final String Y_LABEL = "Y";
    private static Set<String> resourceTypes = new HashSet<String>(Arrays.asList("memory", "vcores"));

    private CapacitySchedulerConfiguration setupNormalizationConfiguration() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB});
        csConf.setQueues(QUEUEA_FULL.getFullPath(), new String[]{QUEUEA1, QUEUEA2});
        csConf.setMinimumResourceRequirement("", QUEUEA_FULL, Resource.newInstance((int)51200, (int)20));
        csConf.setMinimumResourceRequirement("", QUEUEA1_FULL, Resource.newInstance((int)30720, (int)15));
        csConf.setMinimumResourceRequirement("", QUEUEA2_FULL, Resource.newInstance((int)20480, (int)5));
        csConf.setMinimumResourceRequirement("", QUEUEB_FULL, Resource.newInstance((int)10240, (int)8));
        return csConf;
    }

    private CapacitySchedulerConfiguration setupSimpleQueueConfiguration(boolean isCapacityNeeded) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB, QUEUEC, QUEUED});
        if (isCapacityNeeded) {
            csConf.setCapacity(QUEUEA_FULL.getFullPath(), 50.0f);
            csConf.setCapacity(QUEUEB_FULL.getFullPath(), 25.0f);
            csConf.setCapacity(QUEUEC_FULL.getFullPath(), 25.0f);
            csConf.setCapacity(QUEUED_FULL.getFullPath(), 25.0f);
        }
        csConf.setAutoCreateChildQueueEnabled(QUEUED_FULL.getFullPath(), true);
        csConf.setAutoCreatedLeafQueueTemplateCapacityByLabel(QUEUED_FULL.getFullPath(), "", QUEUE_D_TEMPL_MINRES);
        csConf.setAutoCreatedLeafQueueTemplateMaxCapacity(QUEUED_FULL.getFullPath(), "", QUEUE_D_TEMPL_MAXRES);
        return csConf;
    }

    private CapacitySchedulerConfiguration setupComplexQueueConfiguration(boolean isCapacityNeeded) {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB, QUEUEC});
        csConf.setQueues(QUEUEA_FULL.getFullPath(), new String[]{QUEUEA1, QUEUEA2});
        csConf.setQueues(QUEUEB_FULL.getFullPath(), new String[]{QUEUEB1});
        if (isCapacityNeeded) {
            csConf.setCapacity(QUEUEA_FULL.getFullPath(), 50.0f);
            csConf.setCapacity(QUEUEB_FULL.getFullPath(), 25.0f);
            csConf.setCapacity(QUEUEC_FULL.getFullPath(), 25.0f);
            csConf.setCapacity(QUEUEA1_FULL.getFullPath(), 50.0f);
            csConf.setCapacity(QUEUEA2_FULL.getFullPath(), 50.0f);
            csConf.setCapacity(QUEUEB1_FULL.getFullPath(), 100.0f);
        }
        return csConf;
    }

    private CapacitySchedulerConfiguration setupLabeledConfiguration(CapacitySchedulerConfiguration csConf) {
        csConf.setMinimumResourceRequirement("", QUEUEA_FULL, Resource.newInstance((int)20480, (int)8));
        csConf.setMinimumResourceRequirement("", QUEUEB_FULL, Resource.newInstance((int)10240, (int)3));
        csConf.setMinimumResourceRequirement("", QUEUEC_FULL, Resource.newInstance((int)10240, (int)2));
        csConf.setMinimumResourceRequirement("", QUEUED_FULL, Resource.newInstance((int)10240, (int)2));
        csConf.setMinimumResourceRequirement(X_LABEL, QUEUEA_FULL, Resource.newInstance((int)20480, (int)8));
        csConf.setMinimumResourceRequirement(X_LABEL, QUEUEB_FULL, Resource.newInstance((int)10240, (int)3));
        csConf.setMinimumResourceRequirement(X_LABEL, QUEUEC_FULL, Resource.newInstance((int)10240, (int)2));
        csConf.setMinimumResourceRequirement(X_LABEL, QUEUED_FULL, Resource.newInstance((int)10240, (int)2));
        csConf.setMinimumResourceRequirement(Y_LABEL, QUEUEA_FULL, Resource.newInstance((int)2048, (int)1));
        csConf.setMinimumResourceRequirement(Y_LABEL, QUEUEB_FULL, Resource.newInstance((int)2048, (int)1));
        csConf.setMinimumResourceRequirement(Y_LABEL, QUEUEC_FULL, Resource.newInstance((int)2048, (int)1));
        csConf.setMinimumResourceRequirement(Y_LABEL, QUEUED_FULL, Resource.newInstance((int)2048, (int)2));
        return csConf;
    }

    private CapacitySchedulerConfiguration setupMinMaxResourceConfiguration(CapacitySchedulerConfiguration csConf) {
        csConf.setMinimumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUED_FULL, QUEUE_D_MINRES);
        csConf.setMaximumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUED_FULL, QUEUE_D_MAXRES);
        return csConf;
    }

    private CapacitySchedulerConfiguration setupComplexMinMaxResourceConfig(CapacitySchedulerConfiguration csConf) {
        csConf.setMinimumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEA1_FULL, QUEUE_A1_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEA2_FULL, QUEUE_A2_MINRES);
        csConf.setMinimumResourceRequirement("", QUEUEB1_FULL, QUEUE_B1_MINRES);
        csConf.setMaximumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEB_FULL, QUEUE_B_MAXRES);
        csConf.setMaximumResourceRequirement("", QUEUEC_FULL, QUEUE_C_MAXRES);
        return csConf;
    }

    @Test
    public void testSimpleMinMaxResourceConfigurartionPerQueue() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)csConf.getMinimumResourceRequirement("", QUEUEA_FULL.getFullPath(), resourceTypes));
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)csConf.getMaximumResourceRequirement("", QUEUEA_FULL.getFullPath(), resourceTypes));
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)csConf.getMinimumResourceRequirement("", QUEUEB_FULL.getFullPath(), resourceTypes));
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)csConf.getMaximumResourceRequirement("", QUEUEB_FULL.getFullPath(), resourceTypes));
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)csConf.getMinimumResourceRequirement("", QUEUEC_FULL.getFullPath(), resourceTypes));
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)csConf.getMaximumResourceRequirement("", QUEUEC_FULL.getFullPath(), resourceTypes));
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        ManagedParentQueue parentQueue = (ManagedParentQueue)cs.getQueue(QUEUED);
        AutoCreatedLeafQueue d1 = new AutoCreatedLeafQueue(cs.getQueueContext(), "d1", parentQueue);
        cs.addQueue((Queue)d1);
        cs.getRootQueue().updateClusterResource(cs.getClusterResource(), new ResourceLimits(cs.getClusterResource()));
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MINRES, (Object)d1.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MINRES, (Object)d1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MAXRES, (Object)d1.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MAXRES, (Object)d1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        AutoCreatedLeafQueue d2 = new AutoCreatedLeafQueue(cs.getQueueContext(), "d2", parentQueue);
        cs.addQueue((Queue)d2);
        cs.getRootQueue().updateClusterResource(cs.getClusterResource(), new ResourceLimits(cs.getClusterResource()));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)d2.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)d2.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MAXRES, (Object)d2.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MAXRES, (Object)d2.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MINRES, (Object)d1.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MINRES, (Object)d1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MAXRES, (Object)d1.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((Object)QUEUE_D_TEMPL_MAXRES, (Object)d1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        rm.close();
    }

    @Test
    public void testNormalizationAfterNodeRemoval() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupNormalizationConfiguration();
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("h1:1234", 8192, 4);
        rm.registerNode("h2:1234", 8192, 4);
        rm.registerNode("h3:1234", 8192, 4);
        MockNM nm = rm.registerNode("h4:1234", 8192, 4);
        rm.registerNode("h5:1234", 28672, 12);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm.getNodeId())));
        Resource res = Resources.add((Resource)cs.getQueue(QUEUEA1_FULL.getFullPath()).getEffectiveCapacity(""), (Resource)cs.getQueue(QUEUEA2_FULL.getFullPath()).getEffectiveCapacity(""));
        Resource resParent = cs.getQueue(QUEUEA_FULL.getFullPath()).getEffectiveCapacity("");
        Assert.assertTrue((String)String.format("Summarized resource %s of all children is greater than their parent's %s", res, resParent), (boolean)Resources.lessThan((ResourceCalculator)cs.getResourceCalculator(), (Resource)cs.getClusterResource(), (Resource)res, (Resource)resParent));
        rm.stop();
    }

    @Test
    public void testEffectiveMinMaxResourceConfigurartionPerQueue() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qA = (LeafQueue)cs.getQueue(QUEUEA);
        Assert.assertNotNull((Object)qA);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        LeafQueue qB = (LeafQueue)cs.getQueue(QUEUEB);
        Assert.assertNotNull((Object)qB);
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        rm.stop();
    }

    @Test
    public void testSimpleValidateAbsoluteResourceConfig() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CapacitySchedulerConfiguration csConf1 = this.setupSimpleQueueConfiguration(true);
        this.setupMinMaxResourceConfiguration(csConf1);
        try {
            cs.reinitialize((Configuration)csConf1, rm.getRMContext());
        }
        catch (IOException e) {
            Assert.fail();
        }
        rm.stop();
        CapacitySchedulerConfiguration csConf2 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf2);
        rm = new MockRM((Configuration)csConf2);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qA1 = (LeafQueue)cs.getQueue(QUEUEA1);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA1 is not correct", (Object)QUEUE_A1_MINRES, (Object)qA1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA1 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        LeafQueue qA2 = (LeafQueue)cs.getQueue(QUEUEA2);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA2 is not correct", (Object)QUEUE_A2_MINRES, (Object)qA2.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA2 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA2.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        LeafQueue qB1 = (LeafQueue)cs.getQueue(QUEUEB1);
        Assert.assertNotNull((Object)qB1);
        Assert.assertEquals((String)"Min resource configured for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        CapacitySchedulerConfiguration csConf3 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf3);
        csConf3.setMinimumResourceRequirement("", QUEUEB1_FULL, QUEUE_B_MAXRES);
        csConf3.setMaximumResourceRequirement("", QUEUEB1_FULL, QUEUE_B1_MINRES);
        try {
            cs.reinitialize((Configuration)csConf3, rm.getRMContext());
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            Assert.assertEquals((Object)"Failed to re-init queues : Min resource configuration <memory:153600, vCores:30> is greater than its max value:<memory:40960, vCores:10> in queue:root.queueB.queueB1", (Object)e.getMessage());
        }
        CapacitySchedulerConfiguration csConf4 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf4);
        csConf4.setMaximumResourceRequirement("", QUEUEB1_FULL, QUEUE_A_MAXRES);
        try {
            cs.reinitialize((Configuration)csConf4, rm.getRMContext());
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            Assert.assertEquals((Object)"Failed to re-init queues : Max resource configuration <memory:204800, vCores:30> is greater than parents max value:<memory:153600, vCores:30> in queue:root.queueB.queueB1", (Object)e.getMessage());
        }
        rm.stop();
    }

    @Test
    public void testComplexValidateAbsoluteResourceConfig() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 256000, 40);
        csConf.setCapacity(QUEUEA_FULL.getFullPath(), 50.0f);
        csConf.setCapacity(QUEUEB_FULL.getFullPath(), 25.0f);
        csConf.setCapacity(QUEUEC_FULL.getFullPath(), 25.0f);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        try {
            cs.reinitialize((Configuration)csConf, rm.getRMContext());
            if (csConf.isLegacyQueueMode()) {
                Assert.fail((String)"legacy queue mode does not support mixed queue modes");
            }
        }
        catch (IOException e) {
            if (!csConf.isLegacyQueueMode()) {
                Assert.fail((String)"new queue mode supports mixed queue modes");
            }
            Assert.assertTrue((boolean)e.getMessage().contains("Failed to re-init queues"));
        }
        CapacitySchedulerConfiguration csConf1 = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf1);
        csConf1.setMinimumResourceRequirement("", QUEUEA_FULL, QUEUE_A1_MINRES);
        try {
            cs.reinitialize((Configuration)csConf1, rm.getRMContext());
            if (csConf.isLegacyQueueMode()) {
                Assert.fail((String)"legacy queue mode enforces that parent.capacity >= sum(children.capacity)");
            }
        }
        catch (IOException e) {
            if (!csConf.isLegacyQueueMode()) {
                Assert.fail((String)"new queue mode allows that parent.capacity >= sum(children.capacity)");
            }
            Assert.assertEquals((Object)"Failed to re-init queues : Parent Queues capacity: <memory:51200, vCores:5> is less than to its children:<memory:102400, vCores:10> for queue:queueA", (Object)e.getMessage());
        }
        rm.stop();
    }

    @Test
    public void testValidateAbsoluteResourceConfig() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{QUEUEA, QUEUEB});
        csConf.setQueues(QUEUEA_FULL.getFullPath(), new String[]{QUEUEA1, QUEUEA2});
        csConf.setCapacity(QUEUEA_FULL.getFullPath(), "[memory=125]");
        csConf.setCapacity(QUEUEB_FULL.getFullPath(), "[memory=0]");
        csConf.setCapacity(QUEUEA1_FULL.getFullPath(), "[memory=100]");
        csConf.setCapacity(QUEUEA2_FULL.getFullPath(), "[memory=25]");
        csConf.setMinimumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MINRES);
        csConf.setMaximumResourceRequirement("", QUEUEA_FULL, QUEUE_A_MAXRES);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 128000, 20);
        csConf.setCapacity(QUEUEA1_FULL.getFullPath(), "[memory=125]");
        csConf.setCapacity(QUEUEA2_FULL.getFullPath(), "[memory=0]");
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        try {
            cs.reinitialize((Configuration)csConf, rm.getRMContext());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        rm.stop();
    }

    @Test
    public void testDownscalingForLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupLabeledConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 8192, 5);
        MockNM nm2 = rm.registerNode("127.0.0.2:1234", 8192, 5);
        MockNM nm3 = rm.registerNode("127.0.0.3:1234", 8192, 5);
        MockNM nm4 = rm.registerNode("127.0.0.4:1234", 8192, 5);
        rm.getRMContext().getNodeLabelManager().addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)X_LABEL, (Object)Y_LABEL));
        rm.getRMContext().getNodeLabelManager().addLabelsToNode((Map)ImmutableMap.of((Object)nm1.getNodeId(), (Object)ImmutableSet.of((Object)X_LABEL), (Object)nm2.getNodeId(), (Object)ImmutableSet.of((Object)X_LABEL), (Object)nm3.getNodeId(), (Object)ImmutableSet.of((Object)X_LABEL), (Object)nm4.getNodeId(), (Object)ImmutableSet.of((Object)Y_LABEL)));
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue root = cs.getRootQueue();
        root.updateClusterResource(cs.getClusterResource(), new ResourceLimits(cs.getClusterResource()));
        Resource childrenResource = root.getChildQueues().stream().map(q -> q.getEffectiveCapacity(X_LABEL)).reduce(Resources::add).orElse(Resource.newInstance((int)0, (int)0));
        Assert.assertTrue((String)"Children of root have more resource than overall cluster resource", (boolean)Resources.greaterThan((ResourceCalculator)cs.getResourceCalculator(), (Resource)cs.getClusterResource(), (Resource)root.getEffectiveCapacity(X_LABEL), (Resource)childrenResource));
        rm.stop();
    }

    @Test
    public void testEffectiveResourceAfterReducingClusterResource() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupSimpleQueueConfiguration(false);
        this.setupMinMaxResourceConfiguration(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 128000, 20);
        rm.registerNode("127.0.0.2:1234", 128000, 20);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qA = (LeafQueue)cs.getQueue(QUEUEA);
        Assert.assertNotNull((Object)qA);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        LeafQueue qB = (LeafQueue)cs.getQueue(QUEUEB);
        Assert.assertNotNull((Object)qB);
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        rm.unRegisterNode(nm1);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUEA_REDUCED, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUEMAX_REDUCED, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUEB_REDUCED, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUEMAX_REDUCED, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUEC_REDUCED, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUEMAX_REDUCED, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        rm.stop();
    }

    @Test
    public void testEffectiveResourceAfterIncreasingClusterResource() throws Exception {
        CapacitySchedulerConfiguration csConf = this.setupComplexQueueConfiguration(false);
        this.setupComplexMinMaxResourceConfig(csConf);
        csConf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)csConf);
        rm.start();
        rm.registerNode("127.0.0.1:1234", 128000, 20);
        rm.registerNode("127.0.0.2:1234", 128000, 20);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        ParentQueue qA = (ParentQueue)cs.getQueue(QUEUEA);
        Assert.assertNotNull((Object)qA);
        Assert.assertEquals((String)"Min resource configured for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA is not correct", (double)0.4, (double)qA.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA is not correct", (double)0.8, (double)qA.getAbsoluteMaximumCapacity(), (double)0.001f);
        ParentQueue qB = (ParentQueue)cs.getQueue(QUEUEB);
        Assert.assertNotNull((Object)qB);
        Assert.assertEquals((String)"Min resource configured for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB is not correct", (double)0.2, (double)qB.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB is not correct", (double)0.6, (double)qB.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qC = (LeafQueue)cs.getQueue(QUEUEC);
        Assert.assertNotNull((Object)qC);
        Assert.assertEquals((String)"Min resource configured for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEC is not correct", (double)0.1, (double)qC.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEC is not correct", (double)0.6, (double)qC.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qA1 = (LeafQueue)cs.getQueue(QUEUEA1);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA1 is not correct", (Object)QUEUE_A1_MINRES, (Object)qA1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA1 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA1 is not correct", (double)0.2, (double)qA1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA1 is not correct", (double)0.8, (double)qA1.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qA2 = (LeafQueue)cs.getQueue(QUEUEA2);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA2 is not correct", (Object)QUEUE_A2_MINRES, (Object)qA2.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA2 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA2.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA2 is not correct", (double)0.2, (double)qA2.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA2 is not correct", (double)0.8, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001f);
        LeafQueue qB1 = (LeafQueue)cs.getQueue(QUEUEB1);
        Assert.assertEquals((String)"Min resource configured for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((String)"Max resource configured for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getConfiguredMaxResource());
        Assert.assertEquals((String)"Effective Min resource for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB1 is not correct", (double)0.16, (double)qB1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB1 is not correct", (double)0.6, (double)qB1.getAbsoluteMaximumCapacity(), (double)0.001f);
        rm.registerNode("127.0.0.3:1234", 128000, 20);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA is not correct", (Object)QUEUE_A_MINRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA is not correct", (Object)QUEUE_A_MAXRES, (Object)qA.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA is not correct", (double)0.266, (double)qA.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA is not correct", (double)0.533, (double)qA.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEB is not correct", (Object)QUEUE_B_MINRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB is not correct", (Object)QUEUE_B_MAXRES, (Object)qB.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB is not correct", (double)0.133, (double)qB.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB is not correct", (double)0.4, (double)qB.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEC is not correct", (Object)QUEUE_C_MINRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEC is not correct", (Object)QUEUE_C_MAXRES, (Object)qC.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEC is not correct", (double)0.066, (double)qC.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEC is not correct", (double)0.4, (double)qC.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEB1 is not correct", (Object)QUEUE_B1_MINRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEB1 is not correct", (Object)QUEUE_B_MAXRES, (Object)qB1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEB1 is not correct", (double)0.106, (double)qB1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEB1 is not correct", (double)0.4, (double)qB1.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA1 is not correct", (Object)QUEUE_A1_MINRES, (Object)qA1.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA1 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA1.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA1 is not correct", (double)0.133, (double)qA1.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA1 is not correct", (double)0.533, (double)qA1.getAbsoluteMaximumCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Effective Min resource for QUEUEA2 is not correct", (Object)QUEUE_A2_MINRES, (Object)qA2.usageTracker.getQueueResourceQuotas().getEffectiveMinResource());
        Assert.assertEquals((String)"Effective Max resource for QUEUEA2 is not correct", (Object)QUEUE_A_MAXRES, (Object)qA2.usageTracker.getQueueResourceQuotas().getEffectiveMaxResource());
        Assert.assertEquals((String)"Absolute capacity for QUEUEA2 is not correct", (double)0.133, (double)qA2.getAbsoluteCapacity(), (double)0.001f);
        Assert.assertEquals((String)"Absolute Max capacity for QUEUEA2 is not correct", (double)0.533, (double)qA2.getAbsoluteMaximumCapacity(), (double)0.001f);
        rm.stop();
    }
}

